/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSContentHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CallbackTokenHandler;
import io.sf.carte.doc.style.css.parser.GenericFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;

class URLTokenHandler
extends CallbackTokenHandler {
    private String url = null;
    private boolean allowModifiers;
    private LexicalUnitImpl urlUnit = null;
    private LexicalUnitImpl modifier = null;
    private boolean legacySyntax = false;

    URLTokenHandler(CSSContentHandler caller) {
        super(caller);
        this.parendepth = 1;
        this.allowModifiers = false;
    }

    URLTokenHandler(LexicalProvider caller) {
        super(caller);
        this.parendepth = 1;
        this.urlUnit = caller.getCurrentLexicalUnit();
        this.allowModifiers = this.urlUnit != null;
    }

    @Override
    protected void initializeBuffer() {
        this.buffer = new StringBuilder(256);
    }

    @Override
    public void word(int index, CharSequence word) {
        if (this.url == null || this.allowModifiers) {
            super.word(index, word);
        } else {
            this.unexpectedTokenError(index, word);
        }
    }

    @Override
    public void leftCurlyBracket(int index) {
        if (this.url == null || this.allowModifiers) {
            this.buffer.append('{');
        } else {
            this.unexpectedLeftCurlyBracketError(index);
        }
    }

    @Override
    public void rightCurlyBracket(int index) {
        if (this.url == null || this.allowModifiers) {
            this.buffer.append('}');
        } else {
            this.unexpectedRightCurlyBracketError(index);
        }
    }

    @Override
    public void leftSquareBracket(int index) {
        if (this.url == null || this.allowModifiers) {
            this.buffer.append('[');
        } else {
            this.unexpectedLeftSquareBracketError(index);
        }
    }

    @Override
    public void rightSquareBracket(int index) {
        if (this.url == null || this.allowModifiers) {
            this.buffer.append(']');
        } else {
            this.unexpectedRightSquareBracketError(index);
        }
    }

    @Override
    void processBuffer(int index, int triggerCp) {
        if (this.buffer.length() > 0) {
            if (this.url == null) {
                this.legacySyntax = true;
                this.allowModifiers = false;
                this.url = this.rawBuffer();
                if (this.urlUnit != null) {
                    this.urlUnit.value = this.url;
                }
            } else if (this.allowModifiers) {
                String mod = this.unescapeBuffer(index);
                LexicalUnitImpl lu = new LexicalUnitImpl(LexicalUnit.LexicalType.IDENT);
                lu.value = mod;
                this.addModifier(lu);
            } else {
                this.unexpectedTokenError(index, this.buffer);
            }
        }
    }

    private void addModifier(LexicalUnitImpl lu) {
        if (this.modifier == null) {
            this.modifier = lu;
            if (this.urlUnit != null) {
                this.urlUnit.parameters = lu;
            }
        } else {
            this.modifier.nextLexicalUnit = lu;
            lu.previousLexicalUnit = this.modifier;
            this.modifier = lu;
        }
        lu.ownerLexicalUnit = this.urlUnit;
    }

    @Override
    public void separator(int index, int codepoint) {
        if (this.isEscapedIdent() && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer)) {
            this.buffer.append(' ');
        } else if (this.url == null) {
            this.processBuffer(index, codepoint);
        } else if (this.legacySyntax) {
            this.unexpectedCharError(index, codepoint);
        }
    }

    @Override
    public void quoted(int index, CharSequence quoted, int quote) {
        if (this.url == null && this.buffer.length() == 0) {
            String escaped = quoted.toString();
            this.url = CSSParser.safeUnescapeIdentifier(escaped);
            if (this.urlUnit != null) {
                this.urlUnit.value = this.url;
                StringBuilder buf = new StringBuilder(escaped.length() + 2);
                char c = (char)quote;
                buf.append(c);
                buf.append(escaped);
                buf.append(c);
                this.urlUnit.identCssText = buf.toString();
            }
        } else {
            this.unexpectedTokenError(index + this.buffer.length(), quoted);
        }
    }

    @Override
    public void character(int index, int codePoint) {
        if (this.url == null || this.allowModifiers && (codePoint == 45 || codePoint == 95 && this.buffer.length() > 0)) {
            this.bufferAppend(codePoint);
        } else {
            this.unexpectedCharError(index, codePoint);
        }
    }

    @Override
    public void escaped(int index, int codePoint) {
        if (this.url != null && !this.allowModifiers) {
            this.unexpectedCharError(index, codePoint);
        } else {
            if (this.isEscapedCodepoint(codePoint)) {
                this.setEscapedTokenStart(index);
                this.buffer.append('\\');
            }
            this.bufferAppend(codePoint);
        }
    }

    @Override
    public void leftParenthesis(int index) {
        this.parendepth = (short)(this.parendepth + 1);
        if (this.url != null && this.buffer.length() > 0 && this.allowModifiers) {
            String mod = this.unescapeBuffer(index);
            GenericFunctionUnitImpl lu = new GenericFunctionUnitImpl();
            lu.value = mod;
            this.addModifier(lu);
            this.yieldHandling(new ModifierValueTokenHandler());
        } else {
            this.unexpectedCharError(index, 40);
        }
    }

    @Override
    public void rightParenthesis(int index) {
        this.parendepth = (short)(this.parendepth - 1);
        if (this.parendepth == 0) {
            this.processBuffer(index, 41);
            this.caller.decrParenDepth();
            this.endFunctionArgument(index);
        }
    }

    void endFunctionArgument(int index) {
        this.yieldBack();
        this.setURL(this.url, this.urlUnit);
    }

    protected void setURL(String url, LexicalUnitImpl urlUnit) {
        if (urlUnit != null && this.caller instanceof LexicalProvider) {
            ((LexicalProvider)this.caller).setCurrentLexicalUnit(urlUnit);
        }
    }

    @Override
    public void endOfStream(int len) {
        this.processBuffer(len, 0);
        if (!this.isInError()) {
            this.getRootHandler().unexpectedEOFError(len);
        } else {
            this.getRootHandler().setParseError();
        }
        this.getRootHandler().endOfStream(len);
    }

    @Override
    public void resetHandler() {
        super.resetHandler();
        this.url = null;
        this.urlUnit = null;
        this.modifier = null;
    }

    class ModifierValueTokenHandler
    extends CallbackTokenHandler.CallbackValueTokenHandler {
        ModifierValueTokenHandler() {
            this.currentlu = URLTokenHandler.this.modifier;
            this.functionToken = true;
        }

        @Override
        public void endFunctionArgument(int index) {
            this.getCommentStore().setTrailingComments();
            LexicalUnitImpl owner = this.currentlu.ownerLexicalUnit;
            if (owner != null && owner != URLTokenHandler.this.urlUnit) {
                this.currentlu = owner;
            } else {
                this.functionToken = false;
                if (!this.isInError()) {
                    URLTokenHandler.this.decrParenDepth();
                    this.yieldHandling(URLTokenHandler.this);
                }
            }
        }
    }
}

