/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.parser.BufferTokenHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentStore;
import io.sf.carte.doc.style.css.parser.DefaultCommentStore;
import io.sf.carte.doc.style.css.parser.EmptyUnitImpl;
import io.sf.carte.doc.style.css.parser.FunctionFactories;
import io.sf.carte.doc.style.css.parser.GenericFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.HexColorTH;
import io.sf.carte.doc.style.css.parser.ImageFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitFactory;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.OperatorUnitImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.PrefixedFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SubExpressionUnitImpl;
import io.sf.carte.doc.style.css.parser.UnicodeRangeTH;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import java.util.Locale;

abstract class ValueTokenHandler
extends BufferTokenHandler
implements LexicalProvider {
    private static final FunctionFactories functionFactories = new FunctionFactories();
    private LexicalUnitImpl lunit = null;
    LexicalUnitImpl currentlu = null;
    private final CommentStore commentStore = this.createCommentStore();
    private final ShorthandDatabase propertyDatabase;
    private int squareBracketDepth;
    boolean functionToken = false;
    private final boolean flagIEValues;
    private final boolean skipValidation;

    ValueTokenHandler() {
        this.flagIEValues = this.hasParserFlag(Parser.Flag.IEVALUES);
        this.skipValidation = this.hasParserFlag(Parser.Flag.DISABLE_VALUE_VALIDATION);
        this.propertyDatabase = ShorthandDatabase.getInstance();
    }

    ValueTokenHandler(LexicalProvider parent) {
        this.lunit = this.currentlu = parent.getCurrentLexicalUnit();
        this.flagIEValues = parent.hasParserFlag(Parser.Flag.IEVALUES);
        this.skipValidation = this.hasParserFlag(Parser.Flag.DISABLE_VALUE_VALIDATION);
        this.propertyDatabase = ShorthandDatabase.getInstance();
    }

    @Override
    protected void initializeBuffer() {
        this.buffer = new StringBuilder(128);
    }

    protected CommentStore createCommentStore() {
        return new DefaultCommentStore(this);
    }

    @Override
    public boolean hasParserFlag(Parser.Flag flag) {
        return false;
    }

    LexicalUnitImpl getLexicalUnit() {
        return this.parseError ? null : this.lunit;
    }

    @Override
    public LexicalUnitImpl getCurrentLexicalUnit() {
        return this.currentlu;
    }

    @Override
    public boolean isFunctionOrExpressionContext() {
        return this.functionToken;
    }

    @Override
    public void setCurrentLexicalUnit(LexicalUnitImpl currentlu) {
        this.currentlu = currentlu;
        if (currentlu != null && this.lunit == null) {
            this.lunit = currentlu;
            LexicalUnitImpl prevlu = currentlu;
            while ((prevlu = prevlu.previousLexicalUnit) != null) {
                this.lunit = prevlu;
            }
        }
    }

    @Override
    public void addEmptyLexicalUnit() {
        EmptyUnitImpl empty = new EmptyUnitImpl();
        this.addPlainLexicalUnit(empty);
    }

    int getSquareBracketDepth() {
        return this.squareBracketDepth;
    }

    boolean allowSemicolonArgument() {
        return "if".equalsIgnoreCase(this.currentlu.value) || "switch".equalsIgnoreCase(this.currentlu.value);
    }

    @Override
    public void leftParenthesis(int index) {
        this.parendepth = (short)(this.parendepth + 1);
        if (this.prevcp != 65) {
            if (this.buffer.length() == 0) {
                if (this.isFunctionOrExpressionContext() || this.isCustomProperty()) {
                    this.addFunctionOrExpressionUnit(new SubExpressionUnitImpl());
                    this.functionToken = true;
                } else {
                    this.unexpectedCharError(index, 40);
                }
            } else {
                this.handleError(index, (byte)9, "Unexpected token before '(': " + this.buffer);
                this.buffer.setLength(0);
            }
            this.prevcp = 40;
        } else {
            this.prevcp = 32;
            this.newFunction(index);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void newFunction(int index) {
        String name = this.unescapeStringValue(index);
        String lcName = name.toLowerCase(Locale.ROOT);
        LexicalUnitFactory factory = functionFactories.getFactory(lcName);
        if (factory == null) {
            LexicalUnitImpl lu;
            if (name.isEmpty()) {
                this.handleError(index, (byte)5, "Unexpected character '('.");
                this.buffer.setLength(0);
                this.resetEscapedTokenIndex();
                return;
            }
            String raw = this.buffer.toString();
            if (!CSSParser.isNotForbiddenIdentStart(raw)) {
                this.handleError(index, (byte)5, "Unexpected: " + raw);
                this.buffer.setLength(0);
                this.resetEscapedTokenIndex();
                return;
            }
            if (name.charAt(0) == '-' && name.length() > 3) {
                lu = this.addFunctionOrExpressionUnit(new PrefixedFunctionUnitImpl());
            } else if (lcName.endsWith("-gradient")) {
                name = lcName;
                lu = this.addFunctionOrExpressionUnit(new ImageFunctionUnitImpl(LexicalUnit.LexicalType.GRADIENT));
            } else {
                lu = this.addFunctionOrExpressionUnit(new GenericFunctionUnitImpl());
            }
            lu.value = name;
            this.functionToken = true;
        } else {
            LexicalUnitImpl lu = factory.createUnit();
            if (this.isFunctionOrExpressionContext()) {
                this.currentlu.addFunctionParameter(lu);
                this.currentlu = lu;
            } else {
                if (this.currentlu != null) {
                    this.currentlu.nextLexicalUnit = lu;
                    lu.previousLexicalUnit = this.currentlu;
                }
                this.currentlu = lu;
                if (this.lunit == null) {
                    this.lunit = lu;
                }
                this.commentStore.setPrecedingComments(lu);
                this.functionToken = true;
            }
            lu.value = factory.canonicalName(lcName);
            factory.handle(this, index);
        }
        this.buffer.setLength(0);
        this.resetEscapedTokenIndex();
    }

    @Override
    public void leftSquareBracket(int index) {
        ++this.squareBracketDepth;
        this.processBuffer(index, 91);
        this.commentStore.setTrailingComments();
        this.newLexicalUnit(LexicalUnit.LexicalType.LEFT_BRACKET);
        this.prevcp = 32;
    }

    @Override
    public void rightParenthesis(int index) {
        this.processBuffer(index, 41);
        this.decrParenDepth(index);
        if (this.isFunctionOrExpressionContext() && !this.isInError()) {
            this.checkFunction(index);
            this.endFunctionArgument(index);
        }
        this.commentStore.reset();
        this.prevcp = 41;
    }

    @Override
    public void endFunctionArgument(int index) {
        this.commentStore.setTrailingComments();
        if (this.currentlu.ownerLexicalUnit != null) {
            this.currentlu = this.currentlu.ownerLexicalUnit;
        } else {
            this.functionToken = false;
        }
    }

    private LexicalUnitImpl newLexicalUnit(LexicalUnit.LexicalType unitType) {
        LexicalUnitImpl lu = new LexicalUnitImpl(unitType);
        return this.addPlainLexicalUnit(lu);
    }

    @Override
    public LexicalUnitImpl addPlainLexicalUnit(LexicalUnitImpl lu) {
        this.commentStore.setPrecedingComments(lu);
        if (this.isFunctionOrExpressionContext()) {
            LexicalUnitImpl param = this.currentlu.parameters;
            if (param != null) {
                this.commentStore.setLastParameterTrailingComments(param);
                this.commentStore.setPrecedingComments(lu);
            }
            this.currentlu.addFunctionParameter(lu);
        } else {
            if (this.currentlu != null) {
                this.currentlu.nextLexicalUnit = lu;
                lu.previousLexicalUnit = this.currentlu;
                this.commentStore.setTrailingComments(this.currentlu);
            }
            this.currentlu = lu;
            if (this.lunit == null) {
                this.lunit = lu;
            }
        }
        return lu;
    }

    private LexicalUnitImpl addFunctionOrExpressionUnit(LexicalUnitImpl lu) {
        this.commentStore.setPrecedingComments(lu);
        if (this.isFunctionOrExpressionContext()) {
            LexicalUnitImpl param = this.currentlu.parameters;
            if (param != null) {
                this.commentStore.setLastParameterTrailingComments(param);
                this.commentStore.setPrecedingComments(lu);
            }
            this.currentlu.addFunctionParameter(lu);
        } else {
            if (this.currentlu != null) {
                this.currentlu.nextLexicalUnit = lu;
                lu.previousLexicalUnit = this.currentlu;
                this.commentStore.setTrailingComments(this.currentlu);
                this.commentStore.setPrecedingComments(lu);
            }
            if (this.lunit == null) {
                this.lunit = lu;
            }
        }
        this.currentlu = lu;
        return lu;
    }

    private void checkFunction(int index) {
        String s;
        LexicalUnitFactory factory;
        LexicalUnit.LexicalType type = this.currentlu.getLexicalUnitType();
        if (this.currentlu.parameters == null) {
            switch (type) {
                case URI: {
                    if (this.currentlu.isParameter() || this.parendepth == 0) break;
                    this.unexpectedCharError(index, 41);
                    break;
                }
                case FUNCTION: {
                    break;
                }
                case ELEMENT_REFERENCE: {
                    if (this.currentlu.value != null) break;
                }
                default: {
                    this.unexpectedCharError(index, 41);
                }
            }
            return;
        }
        if (this.skipValidation || (factory = functionFactories.getFactory(this.currentlu.getFunctionName())) == null || factory.validate(this, index, this.currentlu)) {
            return;
        }
        try {
            s = "Wrong value: " + this.currentlu.toString();
        }
        catch (Exception e) {
            s = "Wrong value.";
        }
        this.handleError(index, (byte)5, s);
    }

    private boolean isVarOrLastParamIsOperand() {
        if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
            return true;
        }
        LexicalUnit.LexicalType type = CSSParser.findLastValue(this.currentlu.parameters).getLexicalUnitType();
        return type != LexicalUnit.LexicalType.OPERATOR_COMMA && !CSSParser.typeIsAlgebraicOperator(type);
    }

    private boolean lastParamIsAlgebraicOperator() {
        LexicalUnit.LexicalType type = CSSParser.findLastValue(this.currentlu.parameters).getLexicalUnitType();
        return CSSParser.typeIsAlgebraicOperator(type);
    }

    private boolean lastParamIsMultOrSlashOperator() {
        LexicalUnit.LexicalType type = CSSParser.findLastValue(this.currentlu.parameters).getLexicalUnitType();
        return type == LexicalUnit.LexicalType.OPERATOR_MULTIPLY || type == LexicalUnit.LexicalType.OPERATOR_SLASH;
    }

    @Override
    public void rightCurlyBracket(int index) {
        if (this.parendepth != 0 || this.squareBracketDepth != 0) {
            this.setParseError();
            this.parendepth = 0;
            this.squareBracketDepth = 0;
        } else {
            this.processBuffer(index, 125);
        }
        this.commentStore.setTrailingComments();
        this.endOfPropertyDeclaration(index);
        this.getManager().rightCurlyBracket(index);
        this.prevcp = 125;
    }

    @Override
    public void rightSquareBracket(int index) {
        --this.squareBracketDepth;
        this.processBuffer(index, 93);
        this.commentStore.setTrailingComments();
        this.newLexicalUnit(LexicalUnit.LexicalType.RIGHT_BRACKET);
        this.prevcp = 93;
    }

    public void character(int index, int codepoint) {
        if (codepoint == 59) {
            this.handleSemicolon(index);
        } else if (!this.isInError()) {
            if (codepoint == 44) {
                if (!this.functionToken || this.currentlu.parameters == null || !this.addToIdentCompat()) {
                    this.processBuffer(index, codepoint);
                }
                this.newOperator(LexicalUnit.LexicalType.OPERATOR_COMMA);
            } else if (codepoint == 33) {
                if (!this.functionToken) {
                    this.processBuffer(index, codepoint);
                    if (!this.isInError()) {
                        this.setPriorityHandler(index);
                    }
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            } else if (codepoint == 45) {
                if (this.prevcp != 65) {
                    this.processBuffer(index, codepoint);
                }
                this.buffer.append('-');
                codepoint = 65;
            } else if (codepoint == 95) {
                this.buffer.append('_');
                codepoint = 65;
            } else if (codepoint == 46) {
                this.handleFullStop(index);
            } else if (codepoint == 37) {
                if (this.prevcp == 65 && CSSParser.isDigit(this.buffer.charAt(this.buffer.length() - 1))) {
                    this.buffer.append('%');
                } else {
                    this.processBuffer(index, codepoint);
                    this.newOperator(LexicalUnit.LexicalType.OPERATOR_MOD);
                }
            } else if (codepoint == 35) {
                if (this.buffer.length() == 0) {
                    this.yieldHandling(new HexColorTH(this));
                    this.prevcp = 65;
                    return;
                }
                this.unexpectedCharError(index, codepoint);
            } else if (codepoint == 58) {
                this.handleColon(index);
            } else if (codepoint == 43) {
                char c;
                if (this.buffer.length() == 1 && ((c = this.buffer.charAt(0)) == 'U' || c == 'u')) {
                    assert (this.prevcp == 65);
                    this.buffer.setLength(0);
                    this.handleUnicodeRange();
                    this.prevcp = 32;
                    return;
                }
                if (this.buffer.length() == 0 || (c = this.buffer.charAt(this.buffer.length() - 1)) != 'E' && c != 'e') {
                    if (this.functionToken) {
                        this.processBuffer(index, codepoint);
                        boolean prevCpWS = this.isPrevCpWhitespace();
                        if ((prevCpWS && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.CALC || this.flagIEValues) && this.currentlu.parameters != null && !this.lastParamIsAlgebraicOperator()) {
                            this.newOperator(LexicalUnit.LexicalType.OPERATOR_PLUS);
                        } else if (prevCpWS || this.currentlu.parameters == null || this.lastParamIsMultOrSlashOperator()) {
                            this.buffer.append('+');
                            codepoint = 65;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (this.isPrevCpWhitespace()) {
                        this.buffer.append('+');
                        codepoint = 65;
                    } else if (this.isCustomProperty()) {
                        this.processBuffer(index, codepoint);
                        this.newCustomPropertyOperator(index, codepoint, LexicalUnit.LexicalType.OPERATOR_PLUS);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else {
                    this.buffer.append('+');
                    codepoint = 65;
                }
            } else if (codepoint == 47) {
                this.processBuffer(index, codepoint);
                if (!this.functionToken || this.currentlu.parameters != null && (this.isVarOrLastParamIsOperand() || this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR)) {
                    this.newOperator(LexicalUnit.LexicalType.OPERATOR_SLASH);
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            } else if (this.functionToken) {
                if (codepoint == 42) {
                    this.processBuffer(index, codepoint);
                    if (this.currentlu.parameters != null && this.isVarOrLastParamIsOperand()) {
                        this.newOperator(LexicalUnit.LexicalType.OPERATOR_MULTIPLY);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 61 && this.handleEqualsSignInsideFunction(index)) {
                    codepoint = 65;
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            } else if (this.isCustomProperty()) {
                if (codepoint == 42) {
                    this.processBuffer(index, codepoint);
                    this.newCustomPropertyOperator(index, codepoint, LexicalUnit.LexicalType.OPERATOR_MULTIPLY);
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            } else if (codepoint != 64 && codepoint != 63 && codepoint != 42) {
                this.bufferAppend(codepoint);
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }
        this.prevcp = codepoint;
    }

    private void handleSemicolon(int index) {
        if (this.squareBracketDepth == 0 && this.parendepth >= 0) {
            if (!this.isInError()) {
                this.processBuffer(index, 59);
                this.commentStore.setTrailingComments();
            }
            if (this.parendepth > 0) {
                if (!this.isInError()) {
                    if (this.isFunctionOrExpressionContext() && this.allowSemicolonArgument()) {
                        this.newOperator(LexicalUnit.LexicalType.OPERATOR_SEMICOLON);
                    } else {
                        this.unexpectedCharError(index, 59);
                    }
                }
            } else if (!this.isInError()) {
                this.endOfValue(index);
            } else {
                this.resetHandler();
                this.resetParseError();
                this.getManager().restoreInitialHandler();
            }
        } else {
            this.unexpectedCharError(index, 59);
        }
    }

    protected void setPriorityHandler(int index) {
        this.unexpectedCharError(index, 33);
    }

    protected void endOfValue(int index) {
        this.endOfPropertyDeclaration(index);
    }

    protected void endOfPropertyDeclaration(int index) {
    }

    private void newCustomPropertyOperator(int index, int codepoint, LexicalUnit.LexicalType operator) {
        if (this.currentlu == null) {
            this.newOperator(operator);
            return;
        }
        assert (this.currentlu.parameters == null);
        LexicalUnit.LexicalType type = this.currentlu.getLexicalUnitType();
        if (!CSSParser.typeIsAlgebraicOperator(type) && type != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            this.newOperator(operator);
            return;
        }
        this.unexpectedCharError(index, codepoint);
    }

    private boolean handleEqualsSignInsideFunction(int index) {
        if (this.flagIEValues && (this.getPropertyName().isEmpty() || this.getPropertyName().endsWith("filter") || "expression".equalsIgnoreCase(this.currentlu.getFunctionName())) && (this.prevcp == 65 || this.isPrevCpWhitespace() || this.prevcp == 93)) {
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (!this.isEscapedIdent()) {
                    String s;
                    this.buffer.append('=');
                    this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT).value = s = this.buffer.toString();
                    this.buffer.setLength(0);
                    this.warnIdentCompat(index - buflen, s);
                    return true;
                }
            } else {
                LexicalUnitImpl lu = this.currentlu.parameters;
                if (lu != null) {
                    LexicalUnit.LexicalType lutype = (lu = CSSParser.findLastValue(lu)).getLexicalUnitType();
                    if (lutype == LexicalUnit.LexicalType.IDENT) {
                        lu.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                        String s = lu.getStringValue();
                        lu.value = lu.value + '=';
                        this.warnIdentCompat(index - s.length(), s);
                        return true;
                    }
                    if (lutype == LexicalUnit.LexicalType.COMPAT_IDENT) {
                        lu.value = lu.value + '=';
                        return true;
                    }
                    if (lutype == LexicalUnit.LexicalType.RIGHT_BRACKET) {
                        this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT).value = "=";
                        this.warnIdentCompat(index, "=");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean addToIdentCompat() {
        LexicalUnitImpl lu;
        LexicalUnit.LexicalType lutype;
        if (!this.isEscapedIdent() && (lutype = (lu = CSSParser.findLastValue(this.currentlu.parameters)).getLexicalUnitType()) == LexicalUnit.LexicalType.COMPAT_IDENT) {
            if (this.buffer.length() != 0) {
                lu.value = lu.value + this.buffer;
                this.buffer.setLength(0);
            }
            this.prevcp = 65;
            return true;
        }
        return false;
    }

    private boolean checkLastIdentCompat() {
        LexicalUnitImpl lu = this.currentlu.parameters;
        if (lu != null && (lu = CSSParser.findLastValue(lu)).getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
            lu.value = lu.value + this.buffer;
            this.buffer.setLength(0);
            return true;
        }
        return false;
    }

    private void handleFullStop(int index) {
        if (this.prevcp == 65) {
            this.buffer.append('.');
        } else if (this.buffer.length() == 0) {
            LexicalUnitImpl lastValue;
            if (this.prevcp == 45 && this.isFunctionOrExpressionContext() && !this.isEscapedIdent() && this.currentlu.parameters != null && (lastValue = CSSParser.findLastValue(this.currentlu.parameters)).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_MINUS) {
                LexicalUnitImpl prev = lastValue.previousLexicalUnit;
                if (prev != null) {
                    prev.nextLexicalUnit = null;
                } else {
                    this.currentlu.parameters = null;
                }
                this.buffer.append('-');
            }
            this.buffer.append('0').append('.');
        } else {
            this.handleError(index, (byte)4, "Unexpected '.'");
        }
    }

    private void handleColon(int index) {
        int buflen = this.buffer.length();
        if (this.flagIEValues && buflen == 6 && ParseHelper.equalsIgnoreCase(this.buffer, "progid")) {
            this.buffer.append(':');
            this.handleWarning(index, (byte)-3, "Progid hack applied");
        } else if (this.functionToken) {
            String s = this.currentlu.value;
            if (s != null && ("if".equals(s = s.toLowerCase(Locale.ROOT)) || "media".equals(s) || "style".equals(s) || "supports".equals(s))) {
                this.processBuffer(index, 58);
                this.newOperator(LexicalUnit.LexicalType.OPERATOR_COLON);
            } else {
                this.unexpectedCharError(index, 58);
            }
        } else {
            this.handlePseudo(index);
        }
    }

    protected void handlePseudo(int index) {
        this.unexpectedCharError(index, 58);
    }

    protected BufferTokenHandler nestedSelectorHandler(int index) {
        return null;
    }

    private void handleUnicodeRange() {
        this.yieldHandling(new UnicodeRangeTH(this));
    }

    @Override
    protected void processBuffer(int index, int triggerCp) {
        if (this.parseError) {
            this.buffer.setLength(0);
            return;
        }
        int buflen = this.buffer.length();
        if (!(buflen == 0 || this.isFunctionOrExpressionContext() && !this.isEscapedIdent() && this.checkLastIdentCompat())) {
            this.parseNonHexcolorValue(index);
        }
    }

    private void parseNonHexcolorValue(int index) {
        String raw = this.buffer.toString();
        int buflen = raw.length();
        if (this.isEscapedIdent()) {
            String cssText;
            String str;
            int escsz = index - this.getEscapedTokenIndex();
            int nonescLen = buflen - escsz;
            if (nonescLen <= 0) {
                try {
                    str = ValueTokenHandler.unescapeIdentifier(index, raw);
                    cssText = ParseHelper.safeEscape(str, true, true);
                }
                catch (DOMNullCharacterException e) {
                    if (this.flagIEValues) {
                        this.setIdentCompat(index - buflen, raw);
                        this.resetEscapedTokenIndex();
                        this.buffer.setLength(0);
                        return;
                    }
                    str = CSSParser.safeUnescapeIdentifier(raw);
                    cssText = this.safeNullEscape(raw);
                }
            } else {
                CharSequence rawPart = this.buffer.subSequence(0, nonescLen);
                cssText = this.buffer.substring(nonescLen);
                try {
                    str = ValueTokenHandler.unescapeIdentifier(index, cssText);
                    cssText = ParseHelper.safeEscape(str, true, true);
                }
                catch (DOMNullCharacterException e) {
                    if (this.flagIEValues) {
                        this.setIdentCompat(index - buflen, raw);
                        this.resetEscapedTokenIndex();
                        this.buffer.setLength(0);
                        return;
                    }
                    str = CSSParser.safeUnescapeIdentifier(cssText);
                    cssText = this.safeNullEscape(cssText);
                }
                str = rawPart + str;
                rawPart = ParseHelper.escapeAllBackslash(rawPart);
                cssText = ParseHelper.escapeCssCharsAndFirstChar(rawPart) + cssText;
            }
            this.resetEscapedTokenIndex();
            if (!this.createIdentifierOrKeyword(index, raw, str, cssText)) {
                this.checkForIEValue(index, raw);
            }
        } else {
            String str = this.buffer.toString();
            String cssText = ParseHelper.escapeCssCharsAndFirstChar(raw).toString();
            this.createIdentifierOrNumberOrKeyword(index, raw, str, cssText);
        }
        this.buffer.setLength(0);
    }

    private static String unescapeIdentifier(int index, String inputString) throws DOMNullCharacterException {
        return ParseHelper.unescapeStringValue(inputString, true, false);
    }

    private void createIdentifierOrNumberOrKeyword(int index, String raw, String ident, String cssText) {
        int cp = ident.codePointAt(0);
        if (cp != 32) {
            int i;
            int len = ident.length();
            for (i = len - 1; i >= 0; --i) {
                cp = ident.codePointAt(i);
                if (Character.isLetter(cp) || cp == 37) continue;
                if (cp >= 48 && cp <= 57 && this.parseNumber(index, ident, i + 1) || this.newIdentifier(raw, ident, cssText)) break;
                if (raw.length() == 1) {
                    char c = raw.charAt(0);
                    if (c == '+') {
                        this.newOperator(index, 43, LexicalUnit.LexicalType.OPERATOR_PLUS);
                        return;
                    }
                    if (c != '-') break;
                    this.newOperator(index, 45, LexicalUnit.LexicalType.OPERATOR_MINUS);
                    return;
                }
                this.checkForIEValue(index, raw);
                break;
            }
            if (i != -1) {
                return;
            }
        }
        if (!this.createIdentifierOrKeyword(index, raw, ident, cssText)) {
            this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
        }
    }

    private boolean parseNumber(int index, String s, int i) {
        String unit = null;
        if (i != s.length()) {
            float flval;
            String strnum = s.substring(0, i);
            try {
                flval = Float.parseFloat(strnum);
            }
            catch (NumberFormatException e) {
                return false;
            }
            unit = s.substring(i);
            unit = unit.trim().toLowerCase(Locale.ROOT);
            short cssUnit = UnitStringToId.unitFromString(unit);
            LexicalUnit.LexicalType unitType = cssUnit == 2 ? LexicalUnit.LexicalType.PERCENTAGE : LexicalUnit.LexicalType.DIMENSION;
            LexicalUnitImpl lu = this.newLexicalUnit(unitType);
            lu.floatValue = flval;
            lu.dimensionUnitText = unit;
            lu.setCssUnit(cssUnit);
        } else if (s.lastIndexOf(46, i) == -1) {
            int intval;
            try {
                intval = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                float flval;
                try {
                    flval = Float.parseFloat(s);
                }
                catch (NumberFormatException e1) {
                    return false;
                }
                LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.REAL);
                lu.floatValue = flval;
                return true;
            }
            LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.INTEGER);
            lu.intValue = intval;
        } else {
            float flval;
            try {
                flval = Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (flval == 0.0f) {
                LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.INTEGER);
                lu.intValue = (int)flval;
            } else {
                LexicalUnitImpl lu = this.newNumberUnit(LexicalUnit.LexicalType.REAL);
                lu.floatValue = flval;
            }
        }
        return true;
    }

    private void newOperator(int index, int codePoint, LexicalUnit.LexicalType operator) {
        LexicalUnit.LexicalType type;
        if (this.currentlu == null) {
            if (this.isCustomProperty()) {
                this.newOperator(operator);
                return;
            }
        } else if (this.currentlu.parameters != null) {
            if (this.isVarOrLastParamIsOperand()) {
                this.newOperator(operator);
                return;
            }
        } else if (this.isCustomProperty() && !CSSParser.typeIsAlgebraicOperator(type = this.currentlu.getLexicalUnitType()) && type != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            this.newOperator(operator);
            return;
        }
        this.unexpectedCharError(index, codePoint);
    }

    private LexicalUnitImpl newOperator(LexicalUnit.LexicalType operator) {
        OperatorUnitImpl lu = new OperatorUnitImpl(operator);
        return this.addPlainLexicalUnit(lu);
    }

    protected boolean isCustomProperty() {
        return false;
    }

    private boolean createIdentifierOrKeyword(int index, String raw, String ident, String cssText) {
        if (ident.equalsIgnoreCase("inherit")) {
            this.newLexicalUnit(LexicalUnit.LexicalType.INHERIT);
        } else if (ident.equalsIgnoreCase("initial")) {
            this.newLexicalUnit(LexicalUnit.LexicalType.INITIAL);
        } else if (ident.equalsIgnoreCase("unset")) {
            this.newLexicalUnit(LexicalUnit.LexicalType.UNSET);
        } else if (ident.equalsIgnoreCase("revert")) {
            this.newLexicalUnit(LexicalUnit.LexicalType.REVERT);
        } else {
            return this.newIdentifier(raw, ident, cssText);
        }
        return true;
    }

    private boolean newIdentifier(String raw, String ident, String cssText) {
        if (CSSParser.isNotForbiddenIdentStart(raw)) {
            String lcident;
            if (this.propertyDatabase != null && (lcident = ident.toLowerCase(Locale.ROOT)) != ident) {
                if (this.propertyDatabase.isShorthand(this.getPropertyName())) {
                    if (!this.isPreviousValueCustomIdent()) {
                        String[] longhands;
                        for (String longhand : longhands = this.propertyDatabase.getLonghandProperties(this.getPropertyName())) {
                            if (!this.isIdentifierValueOf(longhand, lcident)) continue;
                            ident = lcident;
                        }
                    }
                } else if (this.isIdentifierValueOf(this.getPropertyName(), lcident)) {
                    ident = lcident;
                }
            }
            LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.IDENT);
            lu.value = ident;
            lu.identCssText = cssText;
            return true;
        }
        return false;
    }

    private boolean isIdentifierValueOf(String propertyName, String lcident) {
        return this.propertyDatabase.isIdentifierValue(propertyName, lcident) || "none".equals(lcident);
    }

    private boolean isPreviousValueCustomIdent() {
        String s;
        return this.currentlu != null && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && (s = this.currentlu.getStringValue()) != s.toLowerCase(Locale.ROOT);
    }

    private String safeNullEscape(String raw) {
        String cssText;
        int seqlen;
        CharSequence seq = ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(raw));
        if (seq.charAt((seqlen = seq.length()) - 1) == '0') {
            StringBuilder sb = new StringBuilder(seqlen + 1);
            sb.append(seq).append(' ');
            cssText = sb.toString();
        } else {
            cssText = seq.toString();
        }
        return cssText;
    }

    private void checkForIEValue(int index, String raw) {
        int rawlen = raw.length();
        if (!(this.flagIEValues && rawlen > 2 && raw.charAt(rawlen - 2) == '\\' && this.isIEHackSuffix(raw.codePointAt(rawlen - 1)) && this.setIdentCompat(index - rawlen, raw))) {
            this.handleError(index - rawlen, (byte)7, "Invalid identifier: " + raw);
        }
    }

    private boolean isIEHackSuffix(int codepoint) {
        return codepoint == 57 || codepoint == 48;
    }

    private boolean setIdentCompat(int index, String lastvalue) {
        if (this.currentlu != null) {
            String prev;
            try {
                prev = this.currentlu.toString();
            }
            catch (RuntimeException e) {
                this.lunit.reset();
                return false;
            }
            StringList preceding = this.currentlu.getPrecedingComments();
            this.currentlu.reset();
            LexicalUnitImpl lu = new LexicalUnitImpl(LexicalUnit.LexicalType.COMPAT_IDENT);
            lu.value = prev + ' ' + lastvalue;
            if (this.currentlu == this.lunit) {
                this.lunit = lu;
            } else {
                this.currentlu.replaceBy(lu);
            }
            this.currentlu = lu;
            lu.addPrecedingComments(preceding);
        } else {
            this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT).value = lastvalue;
        }
        this.warnIdentCompat(index, lastvalue);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String setFullIdentCompat(String rawBuffer) {
        String newval = rawBuffer;
        if (this.lunit != null) {
            StringList preceding = this.lunit.getPrecedingComments();
            try {
                newval = this.lunit.toString() + newval;
            }
            catch (RuntimeException e) {
                String string = null;
                return string;
            }
            finally {
                this.lunit.reset();
            }
            this.lunit = new LexicalUnitImpl(LexicalUnit.LexicalType.COMPAT_IDENT);
            this.lunit.value = newval;
            this.lunit.addPrecedingComments(preceding);
        } else {
            this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT).value = newval;
        }
        return newval;
    }

    void warnIdentCompat(int index, String ident) {
        this.handleWarning(index, (byte)-2, "Found compat ident: " + ident);
    }

    private LexicalUnitImpl newNumberUnit(LexicalUnit.LexicalType sacType) {
        LexicalUnitImpl lu = this.newLexicalUnit(sacType);
        lu.setCssUnit((short)0);
        return lu;
    }

    @Override
    public void quoted(int index, CharSequence quoted, int quoteChar) {
        this.processBuffer(index, quoteChar);
        if (!this.isInError()) {
            String s = quoted.toString();
            LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.STRING);
            if (lu.value != null) {
                this.handleError(index, (byte)5, "Unexpected string: " + quoteChar + quoted + quoteChar);
            }
            lu.value = CSSParser.safeUnescapeIdentifier(s);
            char c = (char)quoteChar;
            StringBuilder buf = new StringBuilder(s.length() + 2);
            buf.append(c).append(s).append(c);
            lu.identCssText = buf.toString();
            this.prevcp = 65;
        }
    }

    @Override
    public void quotedWithControl(int index, CharSequence quoted, int quoteChar) {
        this.processBuffer(index, quoteChar);
        if (!this.isInError()) {
            String s = quoted.toString();
            LexicalUnitImpl lu = this.newLexicalUnit(LexicalUnit.LexicalType.STRING);
            if (lu.value != null) {
                this.handleError(index, (byte)5, "Unexpected string: " + quoteChar + quoted + quoteChar);
            }
            lu.value = CSSParser.safeUnescapeIdentifier(s);
            char c = (char)quoteChar;
            StringBuilder buf = new StringBuilder(s.length() + 2);
            buf.append(c).append(ParseHelper.escapeControl(s)).append(c);
            lu.identCssText = buf.toString();
            this.prevcp = 65;
        }
    }

    @Override
    public void escaped(int index, int codepoint) {
        if (this.isEscapedContentError(index, codepoint)) {
            this.unexpectedCharError(index, codepoint);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEscapedContentError(int index, int codepoint) {
        if (this.isEscapedContext(this.prevcp) && !this.isLastValueHexColor()) {
            if (this.isEscapedCodepoint(codepoint)) {
                this.setEscapedTokenStart(index);
                this.buffer.append('\\');
            }
            this.prevcp = 65;
            this.bufferAppend(codepoint);
            return false;
        } else {
            if (!this.flagIEValues || !this.isIEHackSuffix(codepoint) || this.lunit == null && this.buffer.length() == 0) return true;
            this.buffer.append('\\');
            this.bufferAppend(codepoint);
            String compatText = this.setFullIdentCompat(this.rawBuffer());
            this.resetEscapedTokenIndex();
            if (compatText == null) return true;
            this.warnIdentCompat(index, compatText);
            this.prevcp = codepoint;
        }
        return false;
    }

    private boolean isEscapedContext(int prevcp) {
        return prevcp == 65 || this.isPrevCpWhitespace() || prevcp == 58 || prevcp == 44 || prevcp == 59 || prevcp == 123;
    }

    private boolean isLastValueHexColor() {
        return this.currentlu != null && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.RGBCOLOR && this.currentlu.identCssText != null;
    }

    @Override
    public void separator(int index, int codepoint) {
        if (this.getEscapedTokenIndex() != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
            this.buffer.append(' ');
            return;
        }
        this.processBuffer(index, codepoint);
        this.setWhitespacePrevCp();
    }

    @Override
    public void commented(int index, int commentType, String comment) {
        if (this.buffer.length() != 0) {
            this.processBuffer(index, 12);
            if (commentType == 0) {
                this.commentStore.addTrailingComment(comment);
                this.commentStore.setTrailingComments();
            }
        } else if (commentType == 0) {
            if (!this.isPrevCpWhitespace() && (this.prevcp != 12 || this.commentStore.haveTrailingComments())) {
                this.commentStore.addTrailingComment(comment);
            } else {
                this.commentStore.addPrecedingComment(comment);
                this.commentStore.resetTrailingComments();
            }
        }
        this.prevcp = 12;
    }

    CommentStore getCommentStore() {
        return this.commentStore;
    }

    @Override
    public StringList getPrecedingCommentsAndClear() {
        return this.commentStore.getPrecedingCommentsAndClear();
    }

    @Override
    public StringList getTrailingCommentsAndClear() {
        return this.commentStore.getTrailingCommentsAndClear();
    }

    @Override
    public void endOfStream(int len) {
        if (this.parendepth != 0) {
            this.handleError(len, (byte)6, "Unmatched parenthesis");
        } else {
            if (!this.isInError()) {
                this.processBuffer(len, 0);
                this.commentStore.setTrailingComments();
            }
            this.endOfPropertyDeclaration(len);
        }
        this.getManager().endOfStream(len);
    }

    @Override
    public void error(int index, byte errCode, CharSequence context) {
        super.error(index, errCode, context);
        this.resetHandler();
    }

    String getPropertyName() {
        return "";
    }

    @Override
    public void resetHandler() {
        super.resetHandler();
        this.lunit = null;
        this.currentlu = null;
        this.commentStore.reset();
        this.functionToken = false;
        this.buffer.setLength(0);
    }
}

