/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class SystemDefaultValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private static final SystemDefaultValue strictmode = new SystemDefaultValue();

    protected SystemDefaultValue() {
        super(CSSValue.Type.UNKNOWN);
    }

    public static SystemDefaultValue getInstance() {
        return strictmode;
    }

    @Override
    public String getCssText() {
        return "initial";
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getCssText());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(13, "Attempt to modify a system-default value.");
    }

    @Override
    public boolean isSubproperty() {
        return true;
    }

    @Override
    public boolean isSystemDefault() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StyleValue)) {
            return false;
        }
        StyleValue other = (StyleValue)obj;
        return other.isSystemDefault() || other.getPrimitiveType() == CSSValue.Type.INITIAL;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return null;
    }

    @Override
    public SystemDefaultValue clone() {
        return this;
    }
}

