/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.LengthListHandler;
import io.sf.carte.echosvg.parser.LengthParser;
import io.sf.carte.echosvg.parser.ParseException;
import java.io.IOException;

public class LengthListParser
extends LengthParser {
    boolean lengthStarted = false;

    public LengthListParser(LengthListHandler handler) {
        super(handler);
    }

    public void setLengthListHandler(LengthListHandler handler) {
        this.lengthHandler = handler;
    }

    public LengthListHandler getLengthListHandler() {
        return (LengthListHandler)this.lengthHandler;
    }

    @Override
    protected void doParse() throws ParseException, IOException {
        ((LengthListHandler)this.lengthHandler).startLengthList();
        this.current = this.reader.read();
        this.skipSpaces();
        try {
            do {
                this.lengthHandler.startLength();
                this.lengthStarted = true;
                this.parseLength();
                this.lengthHandler.endLength();
                this.lengthStarted = false;
                this.skipCommaSpaces();
            } while (this.current != -1);
        }
        catch (CalcParseException e) {
            this.cssParse();
        }
        catch (NumberFormatException e) {
            this.reportUnexpectedCharacterError(this.current);
        }
        ((LengthListHandler)this.lengthHandler).endLengthList();
    }

    @Override
    protected void handleNumber(short unitType, float floatValue) throws ParseException {
        if (!this.lengthStarted) {
            this.lengthHandler.startLength();
        }
        super.handleNumber(unitType, floatValue);
        this.lengthHandler.endLength();
        this.lengthStarted = false;
    }

    @Override
    protected void handleMathExpression(CSSExpressionValue value) throws ParseException {
        if (!this.lengthStarted) {
            this.lengthHandler.startLength();
        }
        super.handleMathExpression(value);
        this.lengthHandler.endLength();
        this.lengthStarted = false;
    }

    @Override
    protected void handleMathFunction(CSSMathFunctionValue value) throws ParseException {
        if (!this.lengthStarted) {
            this.lengthHandler.startLength();
        }
        super.handleMathFunction(value);
        this.lengthHandler.endLength();
        this.lengthStarted = false;
    }
}

