/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.impl;

import io.sf.carte.echosvg.ext.awt.color.StandardColorSpaces;
import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.color.ColorSpace;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class Any2RGBRed
extends AbstractRed {
    public Any2RGBRed(CachableRed src, ColorSpace colorSpace) {
        super(src, src.getBounds(), Any2RGBRed.mergeColorModel(src, colorSpace), Any2RGBRed.fixSampleModel(src), src.getTileGridXOffset(), src.getTileGridYOffset(), null);
    }

    private static boolean is_INT_PACK_COMP(SampleModel sm) {
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sm.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
        int[] masks = sppsm.getBitMasks();
        if (masks.length != 3 && masks.length != 4) {
            return false;
        }
        if (masks[0] != 0xFF0000) {
            return false;
        }
        if (masks[1] != 65280) {
            return false;
        }
        if (masks[2] != 255) {
            return false;
        }
        return masks.length != 4 || masks[3] == -16777216;
    }

    @Override
    public WritableRaster copyData(WritableRaster wr) {
        CachableRed src = (CachableRed)this.getSources().get(0);
        ColorModel srcCM = src.getColorModel();
        SampleModel srcSM = src.getSampleModel();
        if (srcCM == null) {
            float[][] matrix = null;
            switch (srcSM.getNumBands()) {
                case 1: {
                    matrix = new float[3][1];
                    matrix[0][0] = 1.0f;
                    matrix[1][0] = 1.0f;
                    matrix[2][0] = 1.0f;
                    break;
                }
                case 2: {
                    matrix = new float[4][2];
                    matrix[0][0] = 1.0f;
                    matrix[1][0] = 1.0f;
                    matrix[2][0] = 1.0f;
                    matrix[3][1] = 1.0f;
                    break;
                }
                case 3: {
                    matrix = new float[3][3];
                    matrix[0][0] = 1.0f;
                    matrix[1][1] = 1.0f;
                    matrix[2][2] = 1.0f;
                    break;
                }
                default: {
                    matrix = new float[4][srcSM.getNumBands()];
                    matrix[0][0] = 1.0f;
                    matrix[1][1] = 1.0f;
                    matrix[2][2] = 1.0f;
                    matrix[3][3] = 1.0f;
                }
            }
            Raster srcRas = src.getData(wr.getBounds());
            BandCombineOp op = new BandCombineOp(matrix, null);
            op.filter(srcRas, wr);
            return wr;
        }
        if (srcCM.getColorSpace() == ColorSpace.getInstance(1003)) {
            try {
                float[][] matrix = null;
                switch (srcSM.getNumBands()) {
                    case 1: {
                        matrix = new float[3][1];
                        matrix[0][0] = 1.0f;
                        matrix[1][0] = 1.0f;
                        matrix[2][0] = 1.0f;
                        break;
                    }
                    default: {
                        matrix = new float[4][2];
                        matrix[0][0] = 1.0f;
                        matrix[1][0] = 1.0f;
                        matrix[2][0] = 1.0f;
                        matrix[3][1] = 1.0f;
                    }
                }
                Raster srcRas = src.getData(wr.getBounds());
                BandCombineOp op = new BandCombineOp(matrix, null);
                op.filter(srcRas, wr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return wr;
        }
        ColorModel dstCM = this.getColorModel();
        if (srcCM.getColorSpace() == dstCM.getColorSpace()) {
            if (Any2RGBRed.is_INT_PACK_COMP(srcSM)) {
                src.copyData(wr);
            } else {
                GraphicsUtil.copyData(src.getData(wr.getBounds()), wr);
            }
            return wr;
        }
        Raster srcRas = src.getData(wr.getBounds());
        WritableRaster srcWr = (WritableRaster)srcRas;
        ColorModel srcBICM = srcCM;
        if (srcCM.hasAlpha()) {
            srcBICM = GraphicsUtil.coerceData(srcWr, srcCM, false);
        }
        BufferedImage srcBI = new BufferedImage(srcBICM, srcWr.createWritableTranslatedChild(0, 0), false, null);
        ColorConvertOp op = new ColorConvertOp(srcBICM.getColorSpace(), dstCM.getColorSpace(), null);
        BufferedImage dstBI = op.filter(srcBI, null);
        WritableRaster wr00 = wr.createWritableTranslatedChild(0, 0);
        for (int i = 0; i < dstCM.getColorSpace().getNumComponents(); ++i) {
            Any2RGBRed.copyBand(dstBI.getRaster(), i, wr00, i);
        }
        if (dstCM.hasAlpha()) {
            Any2RGBRed.copyBand(srcWr, srcSM.getNumBands() - 1, wr, this.getSampleModel().getNumBands() - 1);
        }
        return wr;
    }

    private static ColorModel mergeColorModel(CachableRed src, ColorSpace colorSpace) {
        ColorModel cm = src.getColorModel();
        if (cm != null) {
            ColorSpace cs = cm.getColorSpace();
            cm = cs.getType() != 5 ? (cm.hasAlpha() ? GraphicsUtil.sRGB_Unpre : GraphicsUtil.sRGB) : ((cs = StandardColorSpaces.mergeColorSpace(colorSpace, cs)) == null || cs.isCS_sRGB() ? (cm.hasAlpha() ? GraphicsUtil.sRGB_Unpre : GraphicsUtil.sRGB) : (cm.hasAlpha() ? new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, 3) : new DirectColorModel(cs, 24, 0xFF0000, 65280, 255, -16777216, false, 3)));
        } else {
            int numbands = src.getSampleModel().getNumBands();
            if (colorSpace == null || colorSpace.isCS_sRGB()) {
                switch (numbands) {
                    case 1: 
                    case 3: {
                        cm = GraphicsUtil.sRGB;
                        break;
                    }
                    default: {
                        cm = GraphicsUtil.sRGB_Unpre;
                        break;
                    }
                }
            } else {
                switch (numbands) {
                    case 1: 
                    case 3: {
                        cm = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
                        break;
                    }
                    default: {
                        cm = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                    }
                }
            }
        }
        return cm;
    }

    private static SampleModel fixSampleModel(CachableRed src) {
        SampleModel sm = src.getSampleModel();
        ColorModel cm = src.getColorModel();
        boolean alpha = false;
        if (cm != null) {
            alpha = cm.hasAlpha();
        } else {
            switch (sm.getNumBands()) {
                case 1: 
                case 3: {
                    alpha = false;
                    break;
                }
                default: {
                    alpha = true;
                }
            }
        }
        sm = alpha ? new SinglePixelPackedSampleModel(3, sm.getWidth(), sm.getHeight(), new int[]{0xFF0000, 65280, 255, -16777216}) : new SinglePixelPackedSampleModel(3, sm.getWidth(), sm.getHeight(), new int[]{0xFF0000, 65280, 255});
        return sm;
    }
}

