/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.Messages;

public class PNGImageWriterParams
extends ImageWriterParams {
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    private float[] chromaticity = null;
    private float gamma;
    private boolean gammaSet = false;
    private int sRGBIntent = -1;
    private String[] text = null;
    private boolean textSet = false;
    private String[] iText = null;
    private boolean iTextSet = false;
    private String[] zText = null;
    private boolean zTextSet = false;

    public void setChromaticity(float[] chromaticity) {
        if (chromaticity.length != 8) {
            throw new IllegalArgumentException();
        }
        this.chromaticity = (float[])chromaticity.clone();
    }

    public void setChromaticity(float whitePointX, float whitePointY, float redX, float redY, float greenX, float greenY, float blueX, float blueY) {
        float[] chroma = new float[]{whitePointX, whitePointY, redX, redY, greenX, greenY, blueX, blueY};
        this.chromaticity = chroma;
    }

    public float[] getChromaticity() {
        if (this.chromaticity == null) {
            throw new IllegalStateException("chromaticity not set");
        }
        return (float[])this.chromaticity.clone();
    }

    public boolean isChromaticitySet() {
        return this.chromaticity != null;
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        this.gammaSet = true;
    }

    public float getGamma() {
        if (!this.gammaSet) {
            throw new IllegalStateException("Gamma not set.");
        }
        return this.gamma;
    }

    public void unsetGamma() {
        this.gammaSet = false;
    }

    public boolean isGammaSet() {
        return this.gammaSet;
    }

    public void setSRGBIntent(int sRGBIntent) throws IllegalArgumentException {
        if (sRGBIntent < 0 || sRGBIntent > 3) {
            throw new IllegalArgumentException("Unsupported sRGB intent: " + sRGBIntent);
        }
        this.sRGBIntent = sRGBIntent;
    }

    public int getSRGBIntent() throws IllegalStateException {
        if (this.sRGBIntent < 0) {
            throw new IllegalStateException();
        }
        return this.sRGBIntent;
    }

    public void unsetSRGBIntent() {
        this.sRGBIntent = -1;
    }

    public boolean isSRGBIntentSet() {
        return this.sRGBIntent >= 0;
    }

    public void setText(String[] text) {
        this.text = text;
        this.textSet = true;
    }

    public String[] getText() {
        if (!this.textSet) {
            throw new IllegalStateException(Messages.getString("PNG.tEXt.not.set"));
        }
        return this.text;
    }

    public void unsetText() {
        this.text = null;
        this.textSet = false;
    }

    public boolean isTextSet() {
        return this.textSet;
    }

    public void setInternationalText(String[] text) {
        this.iText = text;
        this.iTextSet = true;
    }

    public String[] getInternationalText() {
        if (!this.iTextSet) {
            throw new IllegalStateException(Messages.getString("PNG.iTXt.not.set"));
        }
        return this.iText;
    }

    public void unsetInternationalText() {
        this.iText = null;
        this.iTextSet = false;
    }

    public boolean isInternationalTextSet() {
        return this.iTextSet;
    }

    public void setCompressedText(String[] text) {
        this.zText = text;
        this.zTextSet = true;
    }

    public String[] getCompressedText() {
        if (!this.zTextSet) {
            throw new IllegalStateException(Messages.getString("PNG.zTXt.not.set"));
        }
        return this.zText;
    }

    public void unsetCompressedText() {
        this.zText = null;
        this.zTextSet = false;
    }

    public boolean isCompressedTextSet() {
        return this.zTextSet;
    }
}

