/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.ui.shapes.BaseButton;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import jogamp.graph.ui.shapes.Label0;

public class Button
extends BaseButton {
    public static final float DEFAULT_SPACING_X = 0.2f;
    public static final float DEFAULT_SPACING_Y = 0.46f;
    public static final float DEFAULT_LABEL_ZOFFSET = 1.53E-4f;
    private float labelZOffset;
    private final Label0 labelOff;
    private final Label0 labelOn;
    private volatile Label0 labelNow;
    private final Vec2f spacing = new Vec2f(0.2f, 0.46f);
    private final Vec2f fixedLabelSize = new Vec2f(0.0f, 0.0f);

    public Button(int n, Font font, CharSequence charSequence, float f, float f2) {
        this(n, font, charSequence, null, f, f2, 1.53E-4f);
    }

    public Button(int n, Font font, CharSequence charSequence, float f, float f2, float f3) {
        this(n, font, charSequence, null, f, f2, f3);
    }

    public Button(int n, Font font, CharSequence charSequence, CharSequence charSequence2, float f, float f2, float f3) {
        super(n | 0x200, f, f2);
        this.labelZOffset = f3;
        this.labelNow = this.labelOff = new Label0(font, charSequence, new Vec4f(1.66f, 1.66f, 1.66f, 1.0f));
        if (null != charSequence2) {
            this.labelOn = new Label0(font, charSequence2, new Vec4f(1.66f, 1.66f, 1.66f, 1.0f));
            this.setToggleable(true);
        } else {
            this.labelOn = null;
        }
    }

    @Override
    protected void toggleNotify(boolean bl) {
        if (null != this.labelOn) {
            this.labelNow = bl ? this.labelOn : this.labelOff;
            this.markShapeDirty();
        }
    }

    public Font getFont() {
        return this.labelNow.getFont();
    }

    public CharSequence getText() {
        return this.labelNow.getText();
    }

    @Override
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        super.draw(gL2ES2, regionRenderer);
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        AffineTransform affineTransform3 = new AffineTransform();
        OutlineShape outlineShape = this.createBaseShape(FloatUtil.isZero(this.labelZOffset) ? 0.0f : -this.labelZOffset);
        this.box.resize(outlineShape.getBounds());
        this.setRotationPivot(this.box.getCenter());
        int[] nArray = Region.countOutlineShape(outlineShape, new int[2]);
        TextRegionUtil.countStringRegion(this.labelNow.getFont(), this.labelNow.getText(), nArray);
        this.resetGLRegion(gLProfile, gL2ES2, null, nArray[0], nArray[1]);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        AABBox aABBox = this.labelNow.getFont().getGlyphBounds(this.labelNow.getText(), affineTransform, affineTransform2);
        float f = this.box.getWidth() * (1.0f - this.spacing.x());
        float f2 = f / Math.max(this.fixedLabelSize.x(), aABBox.getWidth());
        float f3 = this.box.getHeight() * (1.0f - this.spacing.y());
        float f4 = f3 / Math.max(this.fixedLabelSize.y(), aABBox.getHeight());
        float f5 = f2 < f4 ? f2 : f4;
        AABBox aABBox2 = new AABBox(aABBox).scale2(f5);
        Vec3f vec3f = aABBox2.getCenter();
        Vec3f vec3f2 = this.box.getCenter();
        Vec2f vec2f = new Vec2f(vec3f2.x() - vec3f.x(), vec3f2.y() - vec3f.y());
        AABBox aABBox3 = this.labelNow.addShapeToRegion(f5, this.region, vec2f, affineTransform, affineTransform2, affineTransform3);
        this.box.resize(aABBox3);
    }

    public float getLabelZOffset() {
        return this.labelZOffset;
    }

    public Button setLabelZOffset(float f) {
        this.labelZOffset = f;
        this.markShapeDirty();
        return this;
    }

    public Button setLabelZOffset(int n, float f, float f2) {
        return this.setLabelZOffset(FloatUtil.getZBufferEpsilon(n, f, f2));
    }

    public final Vec2f getFixedLabelSize() {
        return this.fixedLabelSize;
    }

    public final Button setFixedLabelSize(float f, float f2) {
        this.fixedLabelSize.set(Math.max(0.0f, Math.min(1.0f, f)), Math.max(0.0f, Math.min(1.0f, f2)));
        this.markShapeDirty();
        return this;
    }

    public final Button setFixedLabelSize(Vec2f vec2f) {
        return this.setFixedLabelSize(vec2f.x(), vec2f.y());
    }

    public final Vec2f getSpacing() {
        return this.spacing;
    }

    public final Button setSpacing(float f, float f2) {
        this.spacing.set(Math.max(0.0f, Math.min(1.0f, f)), Math.max(0.0f, Math.min(1.0f, f2)));
        this.markShapeDirty();
        return this;
    }

    public final Button setSpacing(Vec2f vec2f) {
        return this.setSpacing(vec2f.x(), vec2f.y());
    }

    public final Button setSpacing(Vec2f vec2f, Vec2f vec2f2) {
        this.setSpacing(vec2f.x(), vec2f.y());
        this.setFixedLabelSize(vec2f2.x(), vec2f2.y());
        return this;
    }

    public final Vec4f getLabelColor() {
        return this.labelNow.getColor();
    }

    public final Button setLabelColor(Vec4f vec4f) {
        this.labelOff.setColor(vec4f);
        if (null != this.labelOn) {
            this.labelOn.setColor(vec4f);
        }
        this.markShapeDirty();
        return this;
    }

    public final Button setLabelColor(float f, float f2, float f3, float f4) {
        this.labelOff.setColor(f, f2, f3, f4);
        if (null != this.labelOn) {
            this.labelOn.setColor(f, f2, f3, f4);
        }
        this.markShapeDirty();
        return this;
    }

    public final Button setFont(Font font) {
        if (!this.labelOff.getFont().equals(font)) {
            this.labelOff.setFont(font);
            this.markShapeDirty();
        }
        if (null != this.labelOn && !this.labelOn.getFont().equals(font)) {
            this.labelOn.setFont(font);
            this.markShapeDirty();
        }
        return this;
    }

    public final Button setText(CharSequence charSequence) {
        if (!this.labelNow.getText().equals(charSequence)) {
            this.labelNow.setText(charSequence);
            this.markShapeDirty();
        }
        return this;
    }

    public final Button setText(Font font, CharSequence charSequence) {
        if (!this.labelNow.getText().equals(charSequence) || !this.labelNow.getFont().equals(font)) {
            this.labelNow.setFont(font);
            this.labelNow.setText(charSequence);
            this.markShapeDirty();
        }
        return this;
    }

    @Override
    public String getSubString() {
        String string = null != this.labelOn ? this.labelOn + (this.labelNow == this.labelOn ? "*" : "") + ", " : "";
        String string2 = this.labelOff + (this.labelNow == this.labelOff ? "*" : "") + ", ";
        String string3 = this.fixedLabelSize.isZero() ? "" : "fixedLabelSize[" + this.fixedLabelSize + "], ";
        return super.getSubString() + ", " + string2 + string + "spacing[" + this.spacing + "], " + string3 + "zOff " + this.labelZOffset;
    }
}

