/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

public final class DoubleUtil {
    private static volatile boolean machEpsilonAvail = false;
    private static double machEpsilon = 0.0;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double SQUARED_PI = Math.PI * Math.PI;
    public static final double EPSILON = 2.220446049250313E-16;
    public static final double INV_DEVIANCE = (double)1.0E-8f;

    private static void calculateMachineEpsilonDouble() {
        double d = 1.0;
        int n = 0;
        do {
            ++n;
        } while (1.0 + (d /= 2.0) / 2.0 != 1.0);
        machEpsilon = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getMachineEpsilon() {
        if (machEpsilonAvail) return machEpsilon;
        Class<DoubleUtil> clazz = DoubleUtil.class;
        synchronized (DoubleUtil.class) {
            if (machEpsilonAvail) return machEpsilon;
            machEpsilonAvail = true;
            DoubleUtil.calculateMachineEpsilonDouble();
            // ** MonitorExit[var0] (shouldn't be in output)
            return machEpsilon;
        }
    }

    public static double adegToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double radToADeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static boolean isEqualRaw(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean isEqual(double d, double d2, double d3) {
        if (0.0 == d3 && Math.abs(d - d2) == 0.0 || 0.0 != d3 && Math.abs(d - d2) < d3) {
            return true;
        }
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean isEqual(double d, double d2) {
        if (Math.abs(d - d2) < 2.220446049250313E-16) {
            return true;
        }
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean isEqual2(double d, double d2) {
        return Math.abs(d - d2) < 2.220446049250313E-16;
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        if (l2 == (l = Double.doubleToLongBits(d2))) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    public static int compare(double d, double d2, double d3) {
        if (0.0 == d3 && Math.abs(d - d2) == 0.0 || 0.0 != d3 && Math.abs(d - d2) < d3) {
            return 0;
        }
        return DoubleUtil.compare(d, d2);
    }

    public static boolean isZero(double d, double d2) {
        return 0.0 == d2 && d == 0.0 || 0.0 != d2 && Math.abs(d) < d2;
    }

    public static boolean isZero(double d) {
        return Math.abs(d) < 2.220446049250313E-16;
    }
}

