/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import jogamp.opengl.Debug;

public class GLBufferStateTracker {
    protected static final boolean DEBUG;
    private final IntIntHashMap bindingMap;
    private static final int bindingNotFound = -1;
    private final int[] bufTmp = new int[1];

    public GLBufferStateTracker() {
        this.bindingMap = new IntIntHashMap();
        this.bindingMap.setKeyNotFoundValue(-1);
        this.setBoundBufferObject(34962, 0);
        this.setBoundBufferObject(36671, 0);
        this.setBoundBufferObject(34963, 0);
        this.setBoundBufferObject(35051, 0);
        this.setBoundBufferObject(35052, 0);
    }

    private static final int getQueryName(int n) {
        switch (n) {
            case 34962: {
                return 34964;
            }
            case 37568: {
                return 37569;
            }
            case 36662: {
                return 36662;
            }
            case 36663: {
                return 36663;
            }
            case 36671: {
                return 36675;
            }
            case 37102: {
                return 37103;
            }
            case 34963: {
                return 34965;
            }
            case 35051: {
                return 35053;
            }
            case 35052: {
                return 35055;
            }
            case 37266: {
                return 37267;
            }
            case 33006: {
                return 33007;
            }
            case 37074: {
                return 37075;
            }
            case 35882: {
                return 35884;
            }
            case 35982: {
                return 35983;
            }
            case 35345: {
                return 35368;
            }
            case 34229: {
                return 34229;
            }
        }
        throw new GLException(String.format("GL_INVALID_ENUM: Invalid binding target 0x%X", n));
    }

    private static final void checkTargetName(int n) {
        switch (n) {
            case 33006: 
            case 34229: 
            case 34962: 
            case 34963: 
            case 35051: 
            case 35052: 
            case 35345: 
            case 35882: 
            case 35982: 
            case 36662: 
            case 36663: 
            case 36671: 
            case 37074: 
            case 37102: 
            case 37266: 
            case 37568: {
                return;
            }
        }
        throw new GLException(String.format("GL_INVALID_ENUM: Invalid binding target 0x%X", n));
    }

    public final void setBoundBufferObject(int n, int n2) {
        GLBufferStateTracker.checkTargetName(n);
        int n3 = this.bindingMap.put(n, n2);
        if (DEBUG) {
            System.err.println("GLBufferStateTracker.setBoundBufferObject() target " + this.toHexString(n) + ": " + this.toHexString(n3) + " -> " + this.toHexString(n2));
        }
    }

    public final int getBoundBufferObject(int n, GL gL) {
        int n2 = this.bindingMap.get(n);
        if (-1 == n2) {
            int n3 = GLBufferStateTracker.getQueryName(n);
            if (0 != n3) {
                int n4 = gL.glGetError();
                gL.glGetIntegerv(n3, this.bufTmp, 0);
                int n5 = gL.glGetError();
                n2 = 0 == n5 ? this.bufTmp[0] : 0;
                if (DEBUG) {
                    System.err.println("GLBufferStateTracker.getBoundBufferObject() glerr[pre " + this.toHexString(n4) + ", post " + this.toHexString(n5) + "], [queried value]: target " + this.toHexString(n) + " / query " + this.toHexString(n3) + " -> mapped bound buffer " + this.toHexString(n2));
                }
                this.setBoundBufferObject(n, n2);
                return n2;
            }
            return 0;
        }
        if (DEBUG) {
            System.err.println("GLBufferStateTracker.getBoundBufferObject() [mapped value]: target 0x" + Integer.toHexString(n) + " -> mapped bound buffer 0x" + Integer.toHexString(n2));
        }
        return n2;
    }

    public final void clear() {
        if (DEBUG) {
            System.err.println("GLBufferStateTracker.clear() - Thread " + Thread.currentThread().getName());
        }
        this.bindingMap.clear();
    }

    private final String toHexString(int n) {
        return Integer.toHexString(n);
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined((String)"jogl.debug.GLBufferStateTracker", (boolean)true);
    }
}

