/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl.awt;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.util.ArrayList;
import java.util.HashMap;
import jogamp.nativewindow.jawt.windows.Win32SunJDKReflection;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsAWTWGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, GLCapabilitiesImmutable.class, new WindowsAWTWGLGraphicsConfigurationFactory());
    }

    private WindowsAWTWGLGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        GraphicsDevice graphicsDevice = null;
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createDefault();
            if (DEBUG) {
                System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: creating default device: " + abstractGraphicsScreen);
            }
        }
        AWTGraphicsScreen aWTGraphicsScreen = (AWTGraphicsScreen)abstractGraphicsScreen;
        graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilitiesChooser objects");
        }
        if (DEBUG) {
            System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: got " + abstractGraphicsScreen);
        }
        WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(0);
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, aWTGraphicsScreen.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(windowsGraphicsDevice, capabilitiesImmutable);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, defaultGraphicsScreen, n);
        if (windowsWGLGraphicsConfiguration == null) {
            throw new GLException("Unable to choose a GraphicsConfiguration: " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + defaultGraphicsScreen);
        }
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(((GLCapabilitiesImmutable)capabilitiesImmutable).getGLProfile());
        GraphicsConfiguration graphicsConfiguration = null;
        if (gLDrawableFactory instanceof WindowsWGLDrawableFactory) {
            block23: {
                try {
                    windowsWGLGraphicsConfiguration.preselectGraphicsConfiguration(gLDrawableFactory, null);
                    if (1 <= windowsWGLGraphicsConfiguration.getPixelFormatID()) {
                        graphicsConfiguration = Win32SunJDKReflection.graphicsConfigurationGet(graphicsDevice, windowsWGLGraphicsConfiguration.getPixelFormatID());
                        if (DEBUG) {
                            System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: Found new AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + ", hasGC " + (null != graphicsConfiguration) + " -> " + windowsWGLGraphicsConfiguration);
                        }
                    }
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block23;
                    gLException.printStackTrace();
                }
            }
            if (null == graphicsConfiguration) {
                GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                HashMap<Integer, GraphicsConfiguration> hashMap = new HashMap<Integer, GraphicsConfiguration>();
                for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                    GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[i];
                    int n2 = Win32SunJDKReflection.graphicsConfigurationGetPixelFormatID(graphicsConfiguration2);
                    if (n2 >= 1) {
                        if (!hashMap.containsKey(n2)) {
                            arrayList.add(n2);
                            hashMap.put(n2, graphicsConfiguration2);
                            if (!DEBUG) continue;
                            System.err.println("- AWT gc[" + i + "] -> pfd " + n2 + ": Mapped");
                            continue;
                        }
                        if (!DEBUG) continue;
                        System.err.println("- AWT gc[" + i + "] -> pfd " + n2 + ": Duplicate pfd skipped");
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.err.println("- AWT gc[" + i + "] -> pfd unresolved");
                }
                if (DEBUG) {
                    System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: GCs " + graphicsConfigurationArray.length + ", PFDs: " + arrayList.size() + ", mapped: " + hashMap.size());
                }
                windowsWGLGraphicsConfiguration.preselectGraphicsConfiguration2(gLDrawableFactory, arrayList);
                graphicsConfiguration = (GraphicsConfiguration)hashMap.get(windowsWGLGraphicsConfiguration.getPixelFormatID());
                if (DEBUG) {
                    if (null != graphicsConfiguration) {
                        System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: Found GC for AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + windowsWGLGraphicsConfiguration);
                    } else {
                        System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: GC not found for AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + windowsWGLGraphicsConfiguration);
                    }
                }
            }
        } else {
            graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        }
        if (null == graphicsConfiguration) {
            throw new GLException("Unable to determine GraphicsConfiguration: " + windowsWGLGraphicsConfiguration);
        }
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, windowsWGLGraphicsConfiguration.getChosenCapabilities(), windowsWGLGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, windowsWGLGraphicsConfiguration);
    }
}

