/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt;

import io.sf.carte.echosvg.ext.awt.color.ColorContext;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.color.ColorSpace;

abstract class PaintShapePainter
implements ShapePainter {
    protected Shape shape;
    protected Paint paint;
    private ColorContext context;

    protected PaintShapePainter(Shape shape, ColorContext ctx) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape can not be null!");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("Color context can not be null!");
        }
        this.shape = shape;
        this.context = ctx;
    }

    public void setPaint(Paint newPaint) {
        this.paint = newPaint;
    }

    public Paint getPaint() {
        if (this.paint instanceof Color) {
            Color color = (Color)this.paint;
            ColorSpace space = color.getColorSpace();
            ColorSpace targetSpace = this.context.getColorSpace();
            if (targetSpace == null) {
                if (!space.isCS_sRGB()) {
                    float[] comp = color.getRGBComponents(null);
                    color = new Color(comp[0], comp[1], comp[2], comp[3]);
                }
            } else {
                color = new Color(targetSpace, color.getColorComponents(targetSpace, null), (float)color.getAlpha() / 255.0f);
            }
            return color;
        }
        return this.paint;
    }

    @Override
    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }
}

