/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DebugAttachDetectorArgs {
    private static final Logger LOG = Logger.getInstance(DebugAttachDetectorArgs.class);
    @Nullable
    private static final String DEBUG_ARGS = DebugAttachDetectorArgs.findDebugArgs();
    @Nullable
    private static final Properties AGENT_PROPERTIES = DebugAttachDetectorArgs.findAgentProperties();

    public static boolean isDebugEnabled() {
        return DEBUG_ARGS != null;
    }

    public static boolean isAttached() {
        if (!DebugAttachDetectorArgs.isDebugEnabled()) {
            return false;
        }
        if (!DebugAttachDetectorArgs.isDebugServer()) {
            return true;
        }
        Properties properties = AGENT_PROPERTIES;
        if (properties == null) {
            return true;
        }
        return DebugAttachDetectorArgs.isAttached(properties);
    }

    public static boolean canDetectAttach() {
        return AGENT_PROPERTIES != null;
    }

    private static boolean isAttached(@NotNull Properties properties) {
        String property;
        if (properties == null) {
            DebugAttachDetectorArgs.$$$reportNull$$$0(0);
        }
        return (property = properties.getProperty("sun.jdwp.listenerAddress")) != null && property.isEmpty();
    }

    private static boolean isDebugServer() {
        String args = DEBUG_ARGS;
        return args != null && args.contains("server=y");
    }

    @Nullable
    private static String findDebugArgs() {
        try {
            for (String value : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!value.contains("-agentlib:jdwp")) continue;
                return value;
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return null;
    }

    @Nullable
    private static Properties findAgentProperties() {
        Class<?> vmSupportClass;
        try {
            vmSupportClass = Class.forName("jdk.internal.vm.VMSupport");
        }
        catch (Exception e) {
            try {
                vmSupportClass = Class.forName("sun.misc.VMSupport");
            }
            catch (Exception ignored) {
                LOG.warn("Unable to init DebugAttachDetector, VMSupport class not found");
                return null;
            }
        }
        try {
            return (Properties)vmSupportClass.getMethod("getAgentProperties", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(ex);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/util/DebugAttachDetectorArgs", "isAttached"));
    }
}

