/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ActivityId;
import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.CommonActivity;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 62\u00020\u0001:\u00043456B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u001f\u0010\r\u001a\u00020\f2\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u00020\fH\u0002J!\u0010\u0014\u001a\u00020\f2\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0016\u0010*\u001a\u00020\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0,H\u0002J\u0016\u0010-\u001a\u00020\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0,H\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/history/integration/LocalHistoryEventDispatcher;", "", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "<init>", "(Lcom/intellij/history/core/LocalHistoryFacade;Lcom/intellij/history/integration/IdeaGateway;)V", "vfsEventListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "startAction", "", "finishAction", "name", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "beginChangeSet", "endChangeSet", "fileCreated", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createRecursivelyUsingWorkspaceTraversal", "", "dir", "createRecursively", "f", "beforeContentsChange", "e", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "handleBeforeEvent", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "fileMoved", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "beforeFileDeletion", "Lcom/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent;", "isVersioned", "handleBeforeEvents", "events", "", "handleAfterEvents", "handleAfterEvent", "addVirtualFileListener", "virtualFileListener", "disposable", "Lcom/intellij/openapi/Disposable;", "LocalHistoryFileManagerListener", "LocalHistoryCommandListener", "LocalHistoryBulkFileListener", "Companion", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nLocalHistoryEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalHistoryEventDispatcher.kt\ncom/intellij/history/integration/LocalHistoryEventDispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
public final class LocalHistoryEventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalHistoryFacade facade;
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final DisposableWrapperList<BulkFileListener> vfsEventListeners;
    @NotNull
    private static final Key<Boolean> WAS_VERSIONED_KEY;
    private static final boolean USE_WORKSPACE_TRAVERSAL;

    public LocalHistoryEventDispatcher(@NotNull LocalHistoryFacade facade, @NotNull IdeaGateway gateway) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        this.facade = facade;
        this.gateway = gateway;
        this.vfsEventListeners = new DisposableWrapperList();
    }

    public final void startAction() {
        this.gateway.registerUnsavedDocuments(this.facade);
        this.facade.forceBeginChangeSet();
    }

    public final void finishAction(@Nullable String name, @Nullable ActivityId activityId) {
        this.gateway.registerUnsavedDocuments(this.facade);
        this.endChangeSet(name, activityId);
    }

    private final void beginChangeSet() {
        this.facade.beginChangeSet();
    }

    private final void endChangeSet(String name, ActivityId activityId) {
        this.facade.endChangeSet(name, activityId);
    }

    private final void fileCreated(VirtualFile file) {
        if (file == null) {
            return;
        }
        this.beginChangeSet();
        this.createRecursively(file);
        this.endChangeSet(null, null);
    }

    private final boolean createRecursivelyUsingWorkspaceTraversal(VirtualFile dir) {
        List<ProjectFileIndex> projectIndexes = IdeaGateway.getVersionedFilterData().myProjectFileIndices;
        ProjectFileIndex containingProjectIndex = null;
        for (ProjectFileIndex projectIndex : projectIndexes) {
            if (!projectIndex.isInProjectOrExcluded(dir)) continue;
            if (containingProjectIndex != null) {
                return false;
            }
            containingProjectIndex = projectIndex;
        }
        if (containingProjectIndex == null) {
            return false;
        }
        containingProjectIndex.iterateContentUnderDirectory(dir, arg_0 -> LocalHistoryEventDispatcher.createRecursivelyUsingWorkspaceTraversal$lambda$0(this, arg_0), arg_0 -> LocalHistoryEventDispatcher.createRecursivelyUsingWorkspaceTraversal$lambda$1(this, arg_0));
        return true;
    }

    private final void createRecursively(VirtualFile f) {
        if (USE_WORKSPACE_TRAVERSAL && this.createRecursivelyUsingWorkspaceTraversal(f)) {
            return;
        }
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(this, optionArray){
            final /* synthetic */ LocalHistoryEventDispatcher this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (LocalHistoryEventDispatcher.access$isVersioned(this.this$0, f)) {
                    LocalHistoryFacade localHistoryFacade = LocalHistoryEventDispatcher.access$getFacade$p(this.this$0);
                    String string = LocalHistoryEventDispatcher.access$getGateway$p(this.this$0).getPathOrUrl(f);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
                    localHistoryFacade.created(string, f.isDirectory());
                }
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(VirtualFile f) {
                Iterable<VirtualFile> iterable;
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (LocalHistoryEventDispatcher.access$getGateway$p(this.this$0).isVersioned(f, true)) {
                    Iterable<VirtualFile> iterable2 = IdeaGateway.loadAndIterateChildren(f);
                    iterable = iterable2;
                    Intrinsics.checkNotNullExpressionValue(iterable2, (String)"loadAndIterateChildren(...)");
                } else {
                    Iterable<VirtualFile> iterable3 = IdeaGateway.iterateDBChildren(f);
                    iterable = iterable3;
                    Intrinsics.checkNotNullExpressionValue(iterable3, (String)"iterateDBChildren(...)");
                }
                return iterable;
            }
        }));
    }

    private final void beforeContentsChange(VFileContentChangeEvent e) {
        Object object;
        VirtualFile virtualFile = e.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile f = virtualFile;
        if (!this.gateway.areContentChangesVersioned(f)) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(f);
        if (document != null) {
            Document document2;
            Document it = document2 = document;
            boolean bl = false;
            object = it.getModificationStamp() == e.getModificationStamp() ? document2 : null;
        } else {
            object = null;
        }
        Document cachedDocument = object;
        Pair<StoredContent, Long> pair = this.gateway.acquireActualContentAndForgetSavedContent(f, cachedDocument);
        if (pair == null) {
            return;
        }
        Pair<StoredContent, Long> content = pair;
        String string = this.gateway.getPathOrUrl(f);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        Object object2 = content.first;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
        Content content2 = (Content)object2;
        Object object3 = content.second;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
        this.facade.contentChanged(string, content2, ((Number)object3).longValue());
    }

    private final void handleBeforeEvent(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            this.beforeContentsChange((VFileContentChangeEvent)event);
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename() || event instanceof VFileMoveEvent) {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile f = virtualFile;
            f.putUserData(WAS_VERSIONED_KEY, (Object)this.gateway.isVersioned(f));
        } else if (event instanceof VFileDeleteEvent) {
            this.beforeFileDeletion((VFileDeleteEvent)event);
        }
    }

    private final void propertyChanged(VFilePropertyChangeEvent e) {
        if (e.isRename()) {
            VirtualFile virtualFile = e.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile f = virtualFile;
            boolean isVersioned = this.gateway.isVersioned(f);
            Boolean bl = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
            if (bl == null) {
                return;
            }
            boolean wasVersioned = bl;
            f.putUserData(WAS_VERSIONED_KEY, null);
            if (!wasVersioned && !isVersioned) {
                return;
            }
            Object object = e.getOldValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String oldName = (String)object;
            String string = this.gateway.getPathOrUrl(f);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
            this.facade.renamed(string, oldName);
        } else if (Intrinsics.areEqual((Object)"writable", (Object)e.getPropertyName())) {
            VirtualFile virtualFile = e.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            if (!this.isVersioned(virtualFile)) {
                return;
            }
            VirtualFile virtualFile2 = e.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            VirtualFile f = virtualFile2;
            if (!f.isDirectory()) {
                Object object = e.getOldValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean oldWritableValue = (Boolean)object;
                String string = this.gateway.getPathOrUrl(f);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
                this.facade.readOnlyStatusChanged(string, !oldWritableValue);
            }
        }
    }

    private final void fileMoved(VFileMoveEvent e) {
        VirtualFile virtualFile = e.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile f = virtualFile;
        boolean isVersioned = this.gateway.isVersioned(f);
        Boolean bl = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
        if (bl == null) {
            return;
        }
        boolean wasVersioned = bl;
        f.putUserData(WAS_VERSIONED_KEY, null);
        if (!wasVersioned && !isVersioned) {
            return;
        }
        String string = this.gateway.getPathOrUrl(f);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        String string2 = this.gateway.getPathOrUrl(e.getOldParent());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPathOrUrl(...)");
        this.facade.moved(string, string2);
    }

    private final void beforeFileDeletion(VFileDeleteEvent e) {
        VirtualFile virtualFile = e.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile f = virtualFile;
        Entry entry = this.gateway.createEntryForDeletion(f);
        if (entry == null) {
            return;
        }
        Entry entry2 = entry;
        String string = this.gateway.getPathOrUrl(f);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        this.facade.deleted(string, entry2);
    }

    private final boolean isVersioned(VirtualFile f) {
        return this.gateway.isVersioned(f);
    }

    private final void handleBeforeEvents(List<? extends VFileEvent> events) {
        this.gateway.runWithVfsEventsDispatchContext(events, true, () -> LocalHistoryEventDispatcher.handleBeforeEvents$lambda$3(events, this));
    }

    private final void handleAfterEvents(List<? extends VFileEvent> events) {
        this.gateway.runWithVfsEventsDispatchContext(events, false, () -> LocalHistoryEventDispatcher.handleAfterEvents$lambda$4(events, this));
    }

    private final void handleAfterEvent(VFileEvent event) {
        VFileEvent vFileEvent = event;
        if (vFileEvent instanceof VFileCreateEvent) {
            this.fileCreated(((VFileCreateEvent)event).getFile());
        } else if (vFileEvent instanceof VFileCopyEvent) {
            this.fileCreated(((VFileCopyEvent)event).findCreatedFile());
        } else if (vFileEvent instanceof VFilePropertyChangeEvent) {
            this.propertyChanged((VFilePropertyChangeEvent)event);
        } else if (vFileEvent instanceof VFileMoveEvent) {
            this.fileMoved((VFileMoveEvent)event);
        }
    }

    public final void addVirtualFileListener(@NotNull BulkFileListener virtualFileListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)virtualFileListener, (String)"virtualFileListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.vfsEventListeners.add((Object)virtualFileListener, disposable);
    }

    private static final boolean createRecursivelyUsingWorkspaceTraversal$lambda$0(LocalHistoryEventDispatcher this$0, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        if (this$0.isVersioned(fileOrDir)) {
            LocalHistoryFacade localHistoryFacade = this$0.facade;
            String string = this$0.gateway.getPathOrUrl(fileOrDir);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
            localHistoryFacade.created(string, fileOrDir.isDirectory());
        }
        return true;
    }

    private static final boolean createRecursivelyUsingWorkspaceTraversal$lambda$1(LocalHistoryEventDispatcher this$0, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this$0.isVersioned(file);
    }

    private static final void handleBeforeEvents$lambda$3(List $events, LocalHistoryEventDispatcher this$0) {
        for (VFileEvent event : $events) {
            this$0.handleBeforeEvent(event);
        }
        Iterator iterator = this$0.vfsEventListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            BulkFileListener listener = (BulkFileListener)iterator2.next();
            listener.before($events);
        }
    }

    private static final void handleAfterEvents$lambda$4(List $events, LocalHistoryEventDispatcher this$0) {
        for (VFileEvent event : $events) {
            this$0.handleAfterEvent(event);
        }
        Iterator iterator = this$0.vfsEventListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            BulkFileListener listener = (BulkFileListener)iterator2.next();
            listener.after($events);
        }
    }

    public static final /* synthetic */ boolean access$isVersioned(LocalHistoryEventDispatcher $this, VirtualFile f) {
        return $this.isVersioned(f);
    }

    public static final /* synthetic */ LocalHistoryFacade access$getFacade$p(LocalHistoryEventDispatcher $this) {
        return $this.facade;
    }

    public static final /* synthetic */ IdeaGateway access$getGateway$p(LocalHistoryEventDispatcher $this) {
        return $this.gateway;
    }

    static {
        Key key = Key.create((String)(LocalHistoryEventDispatcher.class.getSimpleName() + ".WAS_VERSIONED_KEY"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        WAS_VERSIONED_KEY = key;
        USE_WORKSPACE_TRAVERSAL = SystemProperties.getBooleanProperty((String)"lvcs.use-workspace-traversal", (boolean)true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/history/integration/LocalHistoryEventDispatcher$Companion;", "", "<init>", "()V", "WAS_VERSIONED_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "USE_WORKSPACE_TRAVERSAL", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/history/integration/LocalHistoryEventDispatcher$LocalHistoryBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "<init>", "()V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "intellij.platform.lvcs.impl"})
    public static final class LocalHistoryBulkFileListener
    implements BulkFileListener {
        public void before(@NotNull List<? extends VFileEvent> events) {
            block0: {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                LocalHistoryEventDispatcher localHistoryEventDispatcher = LocalHistoryImpl.Companion.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
                if (localHistoryEventDispatcher == null) break block0;
                localHistoryEventDispatcher.handleBeforeEvents(events);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            block0: {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                LocalHistoryEventDispatcher localHistoryEventDispatcher = LocalHistoryImpl.Companion.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
                if (localHistoryEventDispatcher == null) break block0;
                localHistoryEventDispatcher.handleAfterEvents(events);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/history/integration/LocalHistoryEventDispatcher$LocalHistoryCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "<init>", "()V", "commandStarted", "", "e", "Lcom/intellij/openapi/command/CommandEvent;", "commandFinished", "intellij.platform.lvcs.impl"})
    public static final class LocalHistoryCommandListener
    implements CommandListener {
        public void commandStarted(@NotNull CommandEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LocalHistoryEventDispatcher localHistoryEventDispatcher = LocalHistoryImpl.Companion.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
                if (localHistoryEventDispatcher == null) break block0;
                localHistoryEventDispatcher.beginChangeSet();
            }
        }

        public void commandFinished(@NotNull CommandEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LocalHistoryEventDispatcher localHistoryEventDispatcher = LocalHistoryImpl.Companion.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
                if (localHistoryEventDispatcher == null) break block0;
                localHistoryEventDispatcher.endChangeSet(e.getCommandName(), CommonActivity.Command);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/history/integration/LocalHistoryEventDispatcher$LocalHistoryFileManagerListener;", "Lcom/intellij/openapi/vfs/VirtualFileManagerListener;", "<init>", "()V", "beforeRefreshStart", "", "asynchronous", "", "afterRefreshFinish", "intellij.platform.lvcs.impl"})
    public static final class LocalHistoryFileManagerListener
    implements VirtualFileManagerListener {
        public void beforeRefreshStart(boolean asynchronous) {
            block0: {
                LocalHistoryEventDispatcher localHistoryEventDispatcher = LocalHistoryImpl.Companion.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
                if (localHistoryEventDispatcher == null) break block0;
                localHistoryEventDispatcher.beginChangeSet();
            }
        }

        public void afterRefreshFinish(boolean asynchronous) {
            block0: {
                LocalHistoryEventDispatcher localHistoryEventDispatcher = LocalHistoryImpl.Companion.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
                if (localHistoryEventDispatcher == null) break block0;
                localHistoryEventDispatcher.endChangeSet(LocalHistoryBundle.message("activity.name.external.change", new Object[0]), CommonActivity.ExternalChange);
            }
        }
    }
}

