/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.ParallelWays;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class ParallelWayAction
extends MapMode
implements ModifierExListener {
    private static final CachingProperty<BasicStroke> HELPER_LINE_STROKE = new StrokeProperty(ParallelWayAction.prefKey("stroke.hepler-line"), "1").cached();
    private static final CachingProperty<BasicStroke> REF_LINE_STROKE = new StrokeProperty(ParallelWayAction.prefKey("stroke.ref-line"), "2 2 3").cached();
    private static final CachingProperty<Double> SNAP_THRESHOLD = new DoubleProperty(ParallelWayAction.prefKey("snap-threshold-percent"), 0.7).cached();
    private static final CachingProperty<Boolean> SNAP_DEFAULT = new BooleanProperty(ParallelWayAction.prefKey("snap-default"), true).cached();
    private static final CachingProperty<Boolean> COPY_TAGS_DEFAULT = new BooleanProperty(ParallelWayAction.prefKey("copy-tags-default"), true).cached();
    private static final CachingProperty<Integer> INITIAL_MOVE_DELAY = new IntegerProperty(ParallelWayAction.prefKey("initial-move-delay"), 200).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_METRIC = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-metric"), 0.5).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_IMPERIAL = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-imperial"), 1.0).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_CHINESE = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-chinese"), 1.0).cached();
    private static final CachingProperty<Double> SNAP_DISTANCE_NAUTICAL = new DoubleProperty(ParallelWayAction.prefKey("snap-distance-nautical"), 0.1).cached();
    private static final CachingProperty<Color> MAIN_COLOR = new NamedColorProperty(I18n.marktr("make parallel helper line"), Color.RED).cached();
    private static final CachingProperty<Map<Modifier, Boolean>> SNAP_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("snap-modifier-combo"), "?sC").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> COPY_TAGS_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("copy-tags-modifier-combo"), "As?").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> ADD_TO_SELECTION_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("add-to-selection-modifier-combo"), "aSc").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> TOGGLE_SELECTED_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("toggle-selection-modifier-combo"), "asC").cached();
    private static final CachingProperty<Map<Modifier, Boolean>> SET_SELECTED_MODIFIER_COMBO = new KeyboardModifiersProperty(ParallelWayAction.prefKey("set-selection-modifier-combo"), "asc").cached();
    private Mode mode;
    private boolean copyTags;
    private boolean snap;
    private final MapView mv;
    private Point mousePressedPos;
    private boolean mouseIsDown;
    private long mousePressedTime;
    private boolean mouseHasBeenDragged;
    private transient WaySegment referenceSegment;
    private transient ParallelWays pWays;
    private transient Set<Way> sourceWays;
    private EastNorth helperLineStart;
    private EastNorth helperLineEnd;
    private final ParallelWayLayer temporaryLayer = new ParallelWayLayer();

    public ParallelWayAction(MapFrame mapFrame) {
        super(I18n.tr("Parallel", new Object[0]), "parallel", I18n.tr("Make parallel copies of ways", new Object[0]), Shortcut.registerShortcut("mapmode:parallel", I18n.tr("Mode: {0}", I18n.tr("Parallel", new Object[0])), 80, 5005), ImageProvider.getCursor("normal", "parallel"));
        this.setHelpId(HelpUtil.ht("/Action/Parallel"));
        this.mv = mapFrame.mapView;
    }

    @Override
    public void enterMode() {
        this.setMode(Mode.NORMAL);
        this.pWays = null;
        super.enterMode();
        MainApplication.getMap().statusLine.setAutoLength(false);
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.addTemporaryLayer(this.temporaryLayer);
        MainApplication.getMap().keyDetector.addModifierExListener(this);
        this.sourceWays = new LinkedHashSet(this.getLayerManager().getEditDataSet().getSelectedWays());
        for (Way w : this.sourceWays) {
            w.setHighlighted(true);
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.removeTemporaryLayer(this.temporaryLayer);
        MapFrame map = MainApplication.getMap();
        map.statusLine.setDist(-1.0);
        map.keyDetector.removeModifierExListener(this);
        ParallelWayAction.removeWayHighlighting(this.sourceWays);
        this.pWays = null;
        this.sourceWays = null;
        this.referenceSegment = null;
    }

    @Override
    public String getModeHelpText() {
        if (this.mode == Mode.NORMAL) {
            return I18n.tr("Select ways as in Select mode. Drag selected ways or a single way to create a parallel copy (Alt toggles tag preservation)", new Object[0]);
        }
        return I18n.tr("Hold Ctrl to toggle snapping", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    @Override
    public void modifiersExChanged(int modifiers) {
        if (MainApplication.getMap() == null || this.mv == null || !this.mv.isActiveLayerDrawable()) {
            return;
        }
        if (this.updateModifiersState(modifiers)) {
            this.updateStatusLine();
            this.updateCursor();
        }
    }

    private boolean updateModifiersState(int modifiers) {
        boolean oldAlt = this.alt;
        boolean oldShift = this.shift;
        boolean oldCtrl = this.ctrl;
        this.updateKeyModifiersEx(modifiers);
        return oldAlt != this.alt || oldShift != this.shift || oldCtrl != this.ctrl;
    }

    private void updateCursor() {
        Cursor newCursor = null;
        switch (this.mode) {
            case NORMAL: {
                if (this.matchesCurrentModifiers(SET_SELECTED_MODIFIER_COMBO)) {
                    newCursor = ImageProvider.getCursor("normal", "parallel");
                    break;
                }
                if (this.matchesCurrentModifiers(ADD_TO_SELECTION_MODIFIER_COMBO)) {
                    newCursor = ImageProvider.getCursor("normal", "parallel_add");
                    break;
                }
                if (!this.matchesCurrentModifiers(TOGGLE_SELECTED_MODIFIER_COMBO)) break;
                newCursor = ImageProvider.getCursor("normal", "parallel_remove");
                break;
            }
            case DRAGGING: {
                newCursor = Cursor.getPredefinedCursor(13);
            }
        }
        if (newCursor != null) {
            this.mv.setNewCursor(newCursor, (Object)this);
        }
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        this.updateCursor();
        this.updateStatusLine();
    }

    private boolean sanityCheck() {
        boolean areWeSane;
        boolean bl = areWeSane = this.mv.isActiveLayerVisible() && this.mv.isActiveLayerDrawable() && (Boolean)this.getValue("active") != false;
        assert (areWeSane);
        return areWeSane;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInMapView();
        this.updateModifiersState(e.getModifiersEx());
        if (e.getButton() != 1) {
            return;
        }
        if (!this.sanityCheck()) {
            return;
        }
        this.updateFlagsOnlyChangeableOnPress();
        this.updateFlagsChangeableAlways();
        if (this.pWays != null && this.pWays.getWays() != null) {
            ArrayList<Way> ways = new ArrayList<Way>(this.pWays.getWays());
            ways.removeIf(w -> w.getDataSet() == null);
            this.getLayerManager().getEditDataSet().clearSelection(ways);
            this.pWays = null;
        }
        this.mouseIsDown = true;
        this.mousePressedPos = e.getPoint();
        this.mousePressedTime = System.currentTimeMillis();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateModifiersState(e.getModifiersEx());
        if (e.getButton() != 1) {
            return;
        }
        if (!this.mouseHasBeenDragged) {
            Way nearestWay = this.mv.getNearestWay(e.getPoint(), OsmPrimitive::isSelectable);
            if (nearestWay == null) {
                if (this.matchesCurrentModifiers(SET_SELECTED_MODIFIER_COMBO)) {
                    this.clearSourceWays();
                }
                this.resetMouseTrackingState();
                return;
            }
            boolean isSelected = nearestWay.isSelected();
            if (this.matchesCurrentModifiers(ADD_TO_SELECTION_MODIFIER_COMBO)) {
                if (!isSelected) {
                    this.addSourceWay(nearestWay);
                }
            } else if (this.matchesCurrentModifiers(TOGGLE_SELECTED_MODIFIER_COMBO)) {
                if (isSelected) {
                    this.removeSourceWay(nearestWay);
                } else {
                    this.addSourceWay(nearestWay);
                }
            } else if (this.matchesCurrentModifiers(SET_SELECTED_MODIFIER_COMBO)) {
                this.clearSourceWays();
                this.addSourceWay(nearestWay);
            }
        } else if (this.mode == Mode.DRAGGING) {
            this.clearSourceWays();
            MainApplication.getMap().statusLine.setDist(this.pWays.getWays());
        }
        this.setMode(Mode.NORMAL);
        this.resetMouseTrackingState();
        this.temporaryLayer.invalidate();
    }

    private static void removeWayHighlighting(Collection<Way> ways) {
        if (ways == null) {
            return;
        }
        for (Way w : ways) {
            w.setHighlighted(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double realD;
        if (!this.mouseIsDown) {
            return;
        }
        boolean modifiersChanged = this.updateModifiersState(e.getModifiersEx());
        this.updateFlagsChangeableAlways();
        if (modifiersChanged) {
            this.updateStatusLine();
            this.updateCursor();
        }
        if (System.currentTimeMillis() - this.mousePressedTime < (long)INITIAL_MOVE_DELAY.get().intValue()) {
            return;
        }
        this.mouseHasBeenDragged = true;
        if (this.mode == Mode.NORMAL) {
            if (!this.isModifiersValidForDragMode()) {
                return;
            }
            if (!this.initParallelWays(this.mousePressedPos, this.copyTags)) {
                return;
            }
            this.setMode(Mode.DRAGGING);
        }
        Point p = e.getPoint();
        EastNorth enp = this.mv.getEastNorth((int)p.getX(), (int)p.getY());
        EastNorth nearestPointOnRefLine = Geometry.closestPointToLine(((Node)this.referenceSegment.getFirstNode()).getEastNorth(), ((Node)this.referenceSegment.getSecondNode()).getEastNorth(), enp);
        double d = enp.distance(nearestPointOnRefLine);
        double snappedRealD = realD = this.mv.getProjection().eastNorth2latlon(enp).greatCircleDistance(this.mv.getProjection().eastNorth2latlon(nearestPointOnRefLine));
        boolean toTheRight = Geometry.angleIsClockwise((Node)this.referenceSegment.getFirstNode(), (Node)this.referenceSegment.getSecondNode(), new Node(enp));
        if (this.snap) {
            SystemOfMeasurement som = SystemOfMeasurement.getSystemOfMeasurement();
            double snapDistance = som.equals(SystemOfMeasurement.CHINESE) ? SNAP_DISTANCE_CHINESE.get() * SystemOfMeasurement.CHINESE.aValue : (som.equals(SystemOfMeasurement.IMPERIAL) ? SNAP_DISTANCE_IMPERIAL.get() * SystemOfMeasurement.IMPERIAL.aValue : (som.equals(SystemOfMeasurement.NAUTICAL_MILE) ? SNAP_DISTANCE_NAUTICAL.get() * SystemOfMeasurement.NAUTICAL_MILE.aValue : SNAP_DISTANCE_METRIC.get()));
            double modulo = realD % snapDistance;
            double closestWholeUnit = modulo < snapDistance / 2.0 ? realD - modulo : realD + (snapDistance - modulo);
            snappedRealD = Math.abs(closestWholeUnit - realD) < SNAP_THRESHOLD.get() * snapDistance ? closestWholeUnit : closestWholeUnit + Math.signum(realD - closestWholeUnit) * snapDistance;
        }
        d = snappedRealD * (d / realD);
        this.helperLineStart = nearestPointOnRefLine;
        this.helperLineEnd = enp;
        if (toTheRight) {
            d = -d;
        }
        this.pWays.changeOffset(d);
        MapFrame map = MainApplication.getMap();
        map.statusLine.setDist(Math.abs(snappedRealD));
        map.statusLine.repaint();
        this.temporaryLayer.invalidate();
    }

    private boolean matchesCurrentModifiers(CachingProperty<Map<Modifier, Boolean>> spec) {
        return this.matchesCurrentModifiers(spec.get());
    }

    private boolean matchesCurrentModifiers(Map<Modifier, Boolean> spec) {
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (this.ctrl) {
            modifiers.add(Modifier.CTRL);
        }
        if (this.alt) {
            modifiers.add(Modifier.ALT);
        }
        if (this.shift) {
            modifiers.add(Modifier.SHIFT);
        }
        return spec.entrySet().stream().allMatch(entry -> modifiers.contains(entry.getKey()) == ((Boolean)entry.getValue()).booleanValue());
    }

    private boolean isModifiersValidForDragMode() {
        return !this.alt && !this.shift && !this.ctrl || this.matchesCurrentModifiers(SNAP_MODIFIER_COMBO) || this.matchesCurrentModifiers(COPY_TAGS_MODIFIER_COMBO);
    }

    private void updateFlagsOnlyChangeableOnPress() {
        this.copyTags = COPY_TAGS_DEFAULT.get().booleanValue() != this.matchesCurrentModifiers(COPY_TAGS_MODIFIER_COMBO);
    }

    private void updateFlagsChangeableAlways() {
        this.snap = SNAP_DEFAULT.get().booleanValue() != this.matchesCurrentModifiers(SNAP_MODIFIER_COMBO);
    }

    private void addSourceWay(Way w) {
        assert (this.sourceWays != null);
        this.getLayerManager().getEditDataSet().addSelected(w);
        w.setHighlighted(true);
        this.sourceWays.add(w);
    }

    private void removeSourceWay(Way w) {
        assert (this.sourceWays != null);
        this.getLayerManager().getEditDataSet().clearSelection(w);
        w.setHighlighted(false);
        this.sourceWays.remove(w);
    }

    private void clearSourceWays() {
        assert (this.sourceWays != null);
        this.getLayerManager().getEditDataSet().clearSelection(this.sourceWays);
        for (Way w : this.sourceWays) {
            w.setHighlighted(false);
        }
        this.sourceWays.clear();
    }

    private void resetMouseTrackingState() {
        this.mouseIsDown = false;
        this.mousePressedPos = null;
        this.mouseHasBeenDragged = false;
    }

    private boolean initParallelWays(Point p, boolean copyTags) {
        this.referenceSegment = this.mv.getNearestWaySegment(p, AbstractPrimitive::isUsable, true);
        if (this.referenceSegment == null) {
            return false;
        }
        this.sourceWays.removeIf(w -> w.isIncomplete() || w.isEmpty());
        if (!this.sourceWays.contains(this.referenceSegment.getWay())) {
            this.clearSourceWays();
            this.addSourceWay((Way)this.referenceSegment.getWay());
        }
        try {
            int referenceWayIndex = -1;
            int i = 0;
            for (Way w2 : this.sourceWays) {
                if (w2 == this.referenceSegment.getWay()) {
                    referenceWayIndex = i;
                    break;
                }
                ++i;
            }
            this.pWays = new ParallelWays(this.sourceWays, copyTags, referenceWayIndex);
            this.pWays.commit();
            this.getLayerManager().getEditDataSet().setSelected(this.pWays.getWays());
            return true;
        }
        catch (IllegalArgumentException e) {
            Logging.debug(e);
            new Notification(I18n.tr("ParallelWayAction\nThe ways selected must form a simple branchless path", new Object[0])).setIcon(1).show();
            this.resetMouseTrackingState();
            this.pWays = null;
            return false;
        }
    }

    private static String prefKey(String subKey) {
        return "edit.make-parallel-way-action." + subKey;
    }

    private final class ParallelWayLayer
    extends AbstractMapViewPaintable {
        private ParallelWayLayer() {
        }

        @Override
        public void paint(Graphics2D g, MapView mv, Bounds bbox) {
            if (ParallelWayAction.this.mode == Mode.DRAGGING) {
                CheckParameterUtil.ensureParameterNotNull(mv, "mv");
                Color mainColor = MAIN_COLOR.get();
                g.setStroke(REF_LINE_STROKE.get());
                g.setColor(mainColor);
                MapViewPath line = new MapViewPath(mv);
                line.moveTo((ILatLon)ParallelWayAction.this.referenceSegment.getFirstNode());
                line.lineTo((ILatLon)ParallelWayAction.this.referenceSegment.getSecondNode());
                g.draw(line.computeClippedLine(g.getStroke()));
                g.setStroke(HELPER_LINE_STROKE.get());
                g.setColor(mainColor);
                line = new MapViewPath(mv);
                line.moveTo(ParallelWayAction.this.helperLineStart);
                line.lineTo(ParallelWayAction.this.helperLineEnd);
                g.draw(line.computeClippedLine(g.getStroke()));
            }
        }
    }

    static enum Modifier {
        CTRL('c'),
        ALT('a'),
        SHIFT('s');

        private final char shortChar;

        private Modifier(char shortChar) {
            this.shortChar = Character.toLowerCase(shortChar);
        }

        public static Optional<Modifier> findWithShortCode(int charCode) {
            return Stream.of(Modifier.values()).filter(m -> m.shortChar == Character.toLowerCase(charCode)).findAny();
        }
    }

    private static class KeyboardModifiersProperty
    extends AbstractToStringProperty<Map<Modifier, Boolean>> {
        KeyboardModifiersProperty(String key, String defaultValue) {
            this(key, KeyboardModifiersProperty.createFromString(defaultValue));
        }

        KeyboardModifiersProperty(String key, Map<Modifier, Boolean> defaultValue) {
            super(key, defaultValue);
        }

        @Override
        protected String toString(Map<Modifier, Boolean> t) {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : Modifier.values()) {
                Boolean val = t.get((Object)mod);
                if (val == null) {
                    sb.append('?');
                    continue;
                }
                if (val.booleanValue()) {
                    sb.append(Character.toUpperCase(mod.shortChar));
                    continue;
                }
                sb.append(mod.shortChar);
            }
            return sb.toString();
        }

        @Override
        protected Map<Modifier, Boolean> fromString(String string) {
            return KeyboardModifiersProperty.createFromString(string);
        }

        private static Map<Modifier, Boolean> createFromString(String string) {
            EnumMap<Modifier, Boolean> ret = new EnumMap<Modifier, Boolean>(Modifier.class);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '?') continue;
                Optional<Modifier> mod = Modifier.findWithShortCode(c);
                if (mod.isPresent()) {
                    ret.put(mod.get(), Character.isUpperCase(c));
                    continue;
                }
                Logging.debug("Ignoring unknown modifier {0}", Character.valueOf(c));
            }
            return Collections.unmodifiableMap(ret);
        }
    }

    static enum Mode {
        DRAGGING,
        NORMAL;

    }
}

