/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Objects;

public class KeyValue<K, V> {
    public final K key;
    public final V value;

    public KeyValue(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> KeyValue<K, V> pair(K key, V value) {
        return new KeyValue<K, V>(key, value);
    }

    public String toString() {
        return "KeyValue(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        KeyValue other = (KeyValue)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

