/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;

public class ChangeLoggingVersionedKeyValueBytesStore
extends ChangeLoggingKeyValueBytesStore
implements VersionedBytesStore {
    private final VersionedBytesStore inner;

    ChangeLoggingVersionedKeyValueBytesStore(KeyValueStore<Bytes, byte[]> inner) {
        super(inner);
        if (!(inner instanceof VersionedBytesStore)) {
            throw new IllegalArgumentException("inner store must be versioned");
        }
        this.inner = (VersionedBytesStore)inner;
    }

    @Override
    public long put(Bytes key, byte[] value, long timestamp) {
        long validTo = this.inner.put(key, value, timestamp);
        this.log(key, value, timestamp);
        return validTo;
    }

    @Override
    public byte[] get(Bytes key, long asOfTimestamp) {
        return this.inner.get(key, asOfTimestamp);
    }

    @Override
    public byte[] delete(Bytes key, long timestamp) {
        byte[] oldValue = this.inner.delete(key, timestamp);
        this.log(key, null, timestamp);
        return oldValue;
    }

    @Override
    public void log(Bytes key, byte[] value, long timestamp) {
        this.internalContext.logChange(this.name(), key, value, timestamp, ((KeyValueStore)this.wrapped()).getPosition());
    }
}

