/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.LogManager;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.XMLWatchdog;
import org.apache.log4j.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.w3c.dom.Element;

public class DOMConfigurator {
    private static boolean isFullCompatibilityEnabled() {
        return PropertiesUtil.getProperties().getBooleanProperty("log4j1.compatibility");
    }

    private static void warnFullCompatibilityDisabled() {
        LogLog.warn("Ignoring `DOMConfigurator` call, since `log4j1.compatibility` is not enabled.\nSee https://logging.staged.apache.org/log4j/2.x/migrate-from-log4j1.html#log4j1.compatibility for details.");
    }

    public static void configure(Element element) {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The filename comes from a system property.")
    public static void configure(String fileName) throws FactoryConfigurationError {
        block9: {
            if (DOMConfigurator.isFullCompatibilityEnabled()) {
                Path path = Paths.get(fileName, new String[0]);
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    ConfigurationSource source = new ConfigurationSource(inputStream, path);
                    LoggerContext context = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
                    Configuration configuration = new XmlConfigurationFactory().getConfiguration(context, source);
                    LogManager.getRootLogger().removeAllAppenders();
                    Configurator.reconfigure((Configuration)configuration);
                    break block9;
                }
                catch (IOException e) {
                    throw new FactoryConfigurationError(e);
                }
            }
            DOMConfigurator.warnFullCompatibilityDisabled();
        }
    }

    public static void configure(URL url) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(url, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String fileName) {
        DOMConfigurator.configure(fileName);
    }

    public static void configureAndWatch(String fileName, long delay) {
        if (DOMConfigurator.isFullCompatibilityEnabled()) {
            XMLWatchdog xdog = new XMLWatchdog(fileName);
            xdog.setDelay(delay);
            xdog.start();
        } else {
            DOMConfigurator.warnFullCompatibilityDisabled();
        }
    }

    public static Object parseElement(Element element, Properties props, Class expectedClass) {
        return null;
    }

    public static void setParameter(Element elem, PropertySetter propSetter, Properties props) {
    }

    public static String subst(String value, Properties props) {
        return OptionConverter.substVars(value, props);
    }

    private void doConfigure(ConfigurationSource source) {
        LoggerContext context = (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
        Configuration configuration = new XmlConfigurationFactory().getConfiguration(context, source);
        Configurator.reconfigure((Configuration)configuration);
    }

    public void doConfigure(Element element, LoggerRepository repository) {
    }

    public void doConfigure(InputStream inputStream, LoggerRepository repository) throws FactoryConfigurationError {
        if (DOMConfigurator.isFullCompatibilityEnabled()) {
            try {
                this.doConfigure(new ConfigurationSource(inputStream));
            }
            catch (IOException e) {
                throw new FactoryConfigurationError(e);
            }
        } else {
            DOMConfigurator.warnFullCompatibilityDisabled();
        }
    }

    public void doConfigure(Reader reader, LoggerRepository repository) throws FactoryConfigurationError {
        if (DOMConfigurator.isFullCompatibilityEnabled()) {
            try {
                StringWriter sw = new StringWriter();
                IOUtils.copy((Reader)reader, (Writer)sw);
                this.doConfigure(new ConfigurationSource((InputStream)new ByteArrayInputStream(sw.toString().getBytes(StandardCharsets.UTF_8))));
            }
            catch (IOException e) {
                throw new FactoryConfigurationError(e);
            }
        } else {
            DOMConfigurator.warnFullCompatibilityDisabled();
        }
    }

    public void doConfigure(String fileName, LoggerRepository repository) {
        DOMConfigurator.configure(fileName);
    }

    public void doConfigure(URL url, LoggerRepository repository) {
        block9: {
            if (DOMConfigurator.isFullCompatibilityEnabled()) {
                try {
                    URLConnection connection = UrlConnectionFactory.createConnection((URL)url);
                    try (InputStream inputStream = connection.getInputStream();){
                        this.doConfigure(new ConfigurationSource(inputStream, url));
                        break block9;
                    }
                }
                catch (IOException e) {
                    throw new FactoryConfigurationError(e);
                }
            }
            DOMConfigurator.warnFullCompatibilityDisabled();
        }
    }
}

