/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.argparse4j.helper.ASCIITextWidthCounter;
import net.sourceforge.argparse4j.helper.CJKTextWidthCounter;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.internal.ArgumentParserImpl;
import net.sourceforge.argparse4j.internal.TerminalWidth;

public final class ArgumentParsers {
    public static final String DEFAULT_PREFIX_CHARS = "-";
    private static final String[] cjkWidthLangsSrc_ = new String[]{"ja", "zh", "ko"};
    private static List<String> cjkWidthLangs_ = Arrays.asList(cjkWidthLangsSrc_);
    private static boolean cjkWidthHack_ = true;
    private static boolean terminalWidthDetection_ = true;
    public static final int DEFAULT_FORMAT_WIDTH = 75;
    private static boolean singleMetavar_ = false;
    private static boolean noDestConversionForPositionalArgs_ = false;

    private ArgumentParsers() {
    }

    public static ArgumentParser newArgumentParser(String prog) {
        return ArgumentParsers.newArgumentParser(prog, true, DEFAULT_PREFIX_CHARS, null);
    }

    public static ArgumentParser newArgumentParser(String prog, boolean addHelp) {
        return ArgumentParsers.newArgumentParser(prog, addHelp, DEFAULT_PREFIX_CHARS, null);
    }

    public static ArgumentParser newArgumentParser(String prog, boolean addHelp, String prefixChars) {
        return ArgumentParsers.newArgumentParser(prog, addHelp, prefixChars, null);
    }

    public static ArgumentParser newArgumentParser(String prog, boolean addHelp, String prefixChars, String fromFilePrefix) {
        return new ArgumentParserImpl(prog, addHelp, prefixChars, fromFilePrefix, cjkWidthHack_ && cjkWidthLangs_.contains(Locale.getDefault().getLanguage()) ? new CJKTextWidthCounter() : new ASCIITextWidthCounter());
    }

    public static void setCJKWidthHack(boolean flag) {
        cjkWidthHack_ = flag;
    }

    public static boolean getCjkWidthHack() {
        return cjkWidthHack_;
    }

    public static void setTerminalWidthDetection(boolean flag) {
        terminalWidthDetection_ = flag;
    }

    public static boolean getTerminalWidthDetection() {
        return terminalWidthDetection_;
    }

    public static int getFormatWidth() {
        if (terminalWidthDetection_) {
            int w = new TerminalWidth().getTerminalWidth() - 5;
            return w <= 0 ? 75 : w;
        }
        return 75;
    }

    public static void setSingleMetavar(boolean singleMetavar) {
        singleMetavar_ = singleMetavar;
    }

    public static boolean isSingleMetavar() {
        return singleMetavar_;
    }

    public static void setNoDestConversionForPositionalArgs(boolean flag) {
        noDestConversionForPositionalArgs_ = flag;
    }

    public static boolean getNoDestConversionForPositionalArgs() {
        return noDestConversionForPositionalArgs_;
    }
}

