/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogCleanerManager;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.UnifiedLog;

public final class LogToClean
implements Comparable<LogToClean> {
    private final TopicPartition topicPartition;
    private final UnifiedLog log;
    private final long firstDirtyOffset;
    private final boolean needCompactionNow;
    private final long cleanBytes;
    private final long firstUncleanableOffset;
    private final long cleanableBytes;
    private final long totalBytes;
    private final double cleanableRatio;

    public LogToClean(UnifiedLog log, long firstDirtyOffset, long uncleanableOffset, boolean needCompactionNow) {
        this.log = log;
        this.topicPartition = log.topicPartition();
        this.firstDirtyOffset = firstDirtyOffset;
        this.needCompactionNow = needCompactionNow;
        this.cleanBytes = log.logSegments(-1L, firstDirtyOffset).stream().mapToLong(LogSegment::size).sum();
        Map.Entry<Long, Long> cleanableBytesResult = LogCleanerManager.calculateCleanableBytes(log, firstDirtyOffset, uncleanableOffset);
        this.firstUncleanableOffset = cleanableBytesResult.getKey();
        this.cleanableBytes = cleanableBytesResult.getValue();
        this.totalBytes = this.cleanBytes + this.cleanableBytes;
        this.cleanableRatio = (double)this.cleanableBytes / (double)this.totalBytes;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public long firstDirtyOffset() {
        return this.firstDirtyOffset;
    }

    boolean needCompactionNow() {
        return this.needCompactionNow;
    }

    public long cleanBytes() {
        return this.cleanBytes;
    }

    public long firstUncleanableOffset() {
        return this.firstUncleanableOffset;
    }

    public long cleanableBytes() {
        return this.cleanableBytes;
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public double cleanableRatio() {
        return this.cleanableRatio;
    }

    @Override
    public int compareTo(LogToClean that) {
        return Double.compare(this.cleanableRatio, that.cleanableRatio);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogToClean that = (LogToClean)o;
        return this.firstDirtyOffset == that.firstDirtyOffset && this.needCompactionNow == that.needCompactionNow && this.cleanBytes == that.cleanBytes && this.firstUncleanableOffset == that.firstUncleanableOffset && this.cleanableBytes == that.cleanableBytes && this.totalBytes == that.totalBytes && Double.compare(that.cleanableRatio, this.cleanableRatio) == 0 && this.topicPartition.equals((Object)that.topicPartition) && this.log.equals(that.log);
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition, this.log, this.firstDirtyOffset, this.needCompactionNow, this.cleanBytes, this.firstUncleanableOffset, this.cleanableBytes, this.totalBytes, this.cleanableRatio);
    }

    public String toString() {
        return "LogToClean{topicPartition=" + String.valueOf(this.topicPartition) + ", log=" + String.valueOf(this.log) + ", firstDirtyOffset=" + this.firstDirtyOffset + ", needCompactionNow=" + this.needCompactionNow + ", cleanBytes=" + this.cleanBytes + ", firstUncleanableOffset=" + this.firstUncleanableOffset + ", cleanableBytes=" + this.cleanableBytes + ", totalBytes=" + this.totalBytes + ", cleanableRatio=" + this.cleanableRatio + "}";
    }
}

