/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.util;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class RSIManifestReader {
    public static void main(String[] stringArray) {
        try {
            System.out.println(RSIManifestReader.formatRSIVersionDetails(new JarFile(RSIManifestReader.findRSIPath(RSIManifestReader.readClassPath())).getManifest().getMainAttributes()));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    static List<String> readClassPath() {
        final ArrayList<String> arrayList = new ArrayList<String>();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String[] stringArray;
                for (String string : stringArray = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
                    arrayList.add(string);
                }
                return null;
            }
        });
        return arrayList;
    }

    static File findRSIPath(List<String> list) {
        File file = new File("rsi.jar");
        for (String string : list) {
            File file2 = new File(string);
            if (!file2.getName().equalsIgnoreCase("rsi.jar")) continue;
            file = file2;
            break;
        }
        return file;
    }

    static String formatRSIVersionDetails(Attributes attributes) {
        String string = attributes.getValue("Implementation-Title");
        String string2 = attributes.getValue("Implementation-Version");
        String string3 = attributes.getValue("JDK-Version");
        String string4 = attributes.getValue("Build-Info");
        return new StringBuffer().append(string).append(" ").append(string2).append(" compiled with javac ").append(string3 == null ? "N/A" : string3).append(" on ").append(string4 == null ? "N/A" : string4).toString();
    }
}

