/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.actors;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class RestartableExecutor
implements Executor {
    private final ReentrantLock startStopLock = new ReentrantLock();
    private volatile ThreadPoolExecutor threadPoolExecutor = null;

    public void start() {
        try {
            this.startStopLock.lock();
            if (null == this.threadPoolExecutor) {
                this.threadPoolExecutor = new ThreadPoolExecutor(0, 8, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new ThreadPoolExecutor.CallerRunsPolicy());
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void stop() {
        try {
            this.startStopLock.lock();
            if (null != this.threadPoolExecutor) {
                this.threadPoolExecutor.shutdown();
                this.threadPoolExecutor = null;
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        ThreadPoolExecutor tpe = this.threadPoolExecutor;
        if (null == tpe) {
            throw new IllegalStateException("thread pool executor not started");
        }
        tpe.execute(runnable);
    }
}

