/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.script.expression.ReplaceableConstDoubleValues;

final class PerThreadReplaceableConstDoubleValueSource
extends DoubleValuesSource {
    final Map<Long, ReplaceableConstDoubleValues> perThreadDoubleValues = new ConcurrentHashMap<Long, ReplaceableConstDoubleValues>();

    PerThreadReplaceableConstDoubleValueSource() {
    }

    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        return this.perThreadDoubleValues.computeIfAbsent(Thread.currentThread().threadId(), threadId -> new ReplaceableConstDoubleValues());
    }

    public boolean needsScores() {
        return false;
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        ReplaceableConstDoubleValues currentFv = this.perThreadDoubleValues.computeIfAbsent(Thread.currentThread().threadId(), threadId -> new ReplaceableConstDoubleValues());
        if (currentFv.advanceExact(docId)) {
            return Explanation.match((Number)Float.valueOf((float)currentFv.doubleValue()), (String)"ReplaceableConstDoubleValues", (Explanation[])new Explanation[0]);
        }
        return Explanation.noMatch((String)"ReplaceableConstDoubleValues", (Explanation[])new Explanation[0]);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public void setValue(double v) {
        ReplaceableConstDoubleValues currentFv = this.perThreadDoubleValues.computeIfAbsent(Thread.currentThread().threadId(), threadId -> new ReplaceableConstDoubleValues());
        currentFv.setValue(v);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public DoubleValuesSource rewrite(IndexSearcher reader) {
        return this;
    }
}

