/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BitUtil;

public final class GroupVIntUtil {
    public static final int MAX_LENGTH_PER_GROUP = 17;
    private static final int[] INT_MASKS = new int[]{255, 65535, 0xFFFFFF, -1};

    public static void readGroupVInts(DataInput in, int[] dst, int limit) throws IOException {
        int i;
        for (i = 0; i <= limit - 4; i += 4) {
            GroupVIntUtil.readGroupVInt(in, dst, i);
        }
        while (i < limit) {
            dst[i] = in.readVInt();
            ++i;
        }
    }

    @Deprecated
    public static void readGroupVInt(DataInput in, int[] dst, int offset) throws IOException {
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        if (in instanceof RandomAccessInput) {
            RandomAccessInput rin = (RandomAccessInput)((Object)in);
            if (in instanceof IndexInput) {
                IndexInput iin = (IndexInput)in;
                long pos = iin.getFilePointer();
                if (iin.length() - pos >= 16L) {
                    dst[offset] = rin.readInt(pos) & INT_MASKS[n1Minus1];
                    dst[offset + 1] = rin.readInt(pos += (long)(1 + n1Minus1)) & INT_MASKS[n2Minus1];
                    dst[offset + 2] = rin.readInt(pos += (long)(1 + n2Minus1)) & INT_MASKS[n3Minus1];
                    dst[offset + 3] = rin.readInt(pos += (long)(1 + n3Minus1)) & INT_MASKS[n4Minus1];
                    iin.seek(pos += (long)(1 + n4Minus1));
                    return;
                }
            }
        }
        dst[offset] = GroupVIntUtil.readIntInGroup(in, n1Minus1);
        dst[offset + 1] = GroupVIntUtil.readIntInGroup(in, n2Minus1);
        dst[offset + 2] = GroupVIntUtil.readIntInGroup(in, n3Minus1);
        dst[offset + 3] = GroupVIntUtil.readIntInGroup(in, n4Minus1);
    }

    public static void readGroupVInts$Baseline(DataInput in, int[] dst, int limit) throws IOException {
        int i;
        for (i = 0; i <= limit - 4; i += 4) {
            GroupVIntUtil.readGroupVInt$Baseline(in, dst, i);
        }
        while (i < limit) {
            dst[i] = in.readVInt();
            ++i;
        }
    }

    private static void readGroupVInt$Baseline(DataInput in, int[] dst, int offset) throws IOException {
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = GroupVIntUtil.readIntInGroup(in, n1Minus1);
        dst[offset + 1] = GroupVIntUtil.readIntInGroup(in, n2Minus1);
        dst[offset + 2] = GroupVIntUtil.readIntInGroup(in, n3Minus1);
        dst[offset + 3] = GroupVIntUtil.readIntInGroup(in, n4Minus1);
    }

    private static int readIntInGroup(DataInput in, int numBytesMinus1) throws IOException {
        switch (numBytesMinus1) {
            case 0: {
                return in.readByte() & 0xFF;
            }
            case 1: {
                return in.readShort() & 0xFFFF;
            }
            case 2: {
                return in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
            }
        }
        return in.readInt();
    }

    @Deprecated
    public static int readGroupVInt(DataInput in, long remaining, IntReader reader, long pos, int[] dst, int offset) throws IOException {
        throw new UnsupportedOperationException("No longer implemented.");
    }

    private static int numBytes(int v) {
        return 4 - (Integer.numberOfLeadingZeros(v | 1) >> 3);
    }

    private static int toInt(long value) {
        if (Long.compareUnsigned(value, 0xFFFFFFFFL) > 0) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static void writeGroupVInts(DataOutput out, byte[] scratch, int[] values, int limit) throws IOException {
        int readPos = 0;
        while (limit - readPos >= 4) {
            int writePos = 0;
            int n1Minus1 = GroupVIntUtil.numBytes(values[readPos]) - 1;
            int n2Minus1 = GroupVIntUtil.numBytes(values[readPos + 1]) - 1;
            int n3Minus1 = GroupVIntUtil.numBytes(values[readPos + 2]) - 1;
            int n4Minus1 = GroupVIntUtil.numBytes(values[readPos + 3]) - 1;
            int flag = n1Minus1 << 6 | n2Minus1 << 4 | n3Minus1 << 2 | n4Minus1;
            scratch[writePos++] = (byte)flag;
            BitUtil.VH_LE_INT.set(scratch, writePos, values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n1Minus1 + 1, values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n2Minus1 + 1, values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n3Minus1 + 1, values[readPos++]);
            out.writeBytes(scratch, writePos += n4Minus1 + 1);
        }
        while (readPos < limit) {
            out.writeVInt(values[readPos]);
            ++readPos;
        }
    }

    @Deprecated
    public static void readGroupVInts(DataInput in, long[] dst, int limit) throws IOException {
        int i;
        for (i = 0; i <= limit - 4; i += 4) {
            GroupVIntUtil.readGroupVInt(in, dst, i);
        }
        while (i < limit) {
            dst[i] = (long)in.readVInt() & 0xFFFFFFFFL;
            ++i;
        }
    }

    @Deprecated
    public static void readGroupVInt(DataInput in, long[] dst, int offset) throws IOException {
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = (long)GroupVIntUtil.readIntInGroup(in, n1Minus1) & 0xFFFFFFFFL;
        dst[offset + 1] = (long)GroupVIntUtil.readIntInGroup(in, n2Minus1) & 0xFFFFFFFFL;
        dst[offset + 2] = (long)GroupVIntUtil.readIntInGroup(in, n3Minus1) & 0xFFFFFFFFL;
        dst[offset + 3] = (long)GroupVIntUtil.readIntInGroup(in, n4Minus1) & 0xFFFFFFFFL;
    }

    @Deprecated
    public static void writeGroupVInts(DataOutput out, byte[] scratch, long[] values, int limit) throws IOException {
        int readPos = 0;
        while (limit - readPos >= 4) {
            int writePos = 0;
            int n1Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos])) - 1;
            int n2Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos + 1])) - 1;
            int n3Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos + 2])) - 1;
            int n4Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos + 3])) - 1;
            int flag = n1Minus1 << 6 | n2Minus1 << 4 | n3Minus1 << 2 | n4Minus1;
            scratch[writePos++] = (byte)flag;
            BitUtil.VH_LE_INT.set(scratch, writePos, (int)values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n1Minus1 + 1, (int)values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n2Minus1 + 1, (int)values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n3Minus1 + 1, (int)values[readPos++]);
            out.writeBytes(scratch, writePos += n4Minus1 + 1);
        }
        while (readPos < limit) {
            out.writeVInt(GroupVIntUtil.toInt(values[readPos]));
            ++readPos;
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface IntReader {
        public int read(long var1);
    }
}

