/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.general.DRBG;
import org.bouncycastle.crypto.util.EntropyUtil;

public final class GeneralSecureRandom
extends SecureRandom {
    private final SecureRandom randomSource;
    private final String algorithmName;
    private final DRBG drbg;
    private final EntropySource entropySource;
    private final boolean predictionResistant;

    GeneralSecureRandom(SecureRandom secureRandom, String string, DRBG dRBG, EntropySource entropySource, boolean bl) {
        this.randomSource = secureRandom;
        this.algorithmName = string;
        this.drbg = dRBG;
        this.entropySource = entropySource;
        this.predictionResistant = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeed(byte[] byArray) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeed(long l) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(l);
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithmName;
    }

    @Override
    public void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] byArray, byte[] byArray2) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (byArray == null) {
                throw new NullPointerException("bytes cannot be null");
            }
            if (byArray.length != 0 && this.drbg.generate(byArray, byArray2, this.predictionResistant) < 0) {
                this.drbg.reseed(null);
                this.drbg.generate(byArray, byArray2, this.predictionResistant);
            }
        }
    }

    @Override
    public byte[] generateSeed(int n) {
        return EntropyUtil.generateSeed(this.entropySource, n);
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    @Override
    public void reseed() {
        this.drbg.reseed(null);
    }

    public void reseed(byte[] byArray) {
        this.drbg.reseed(byArray);
    }
}

