/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.tasks.list;

import java.util.List;
import java.util.function.Consumer;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.TaskOperationFailure;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.tasks.TransportTasksAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskInfo;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.transport.TransportService;

public class TransportListTasksAction
extends TransportTasksAction<Task, ListTasksRequest, ListTasksResponse, TaskInfo> {
    private static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    private final TaskResourceTrackingService taskResourceTrackingService;

    public static long waitForCompletionTimeout(TimeValue timeout) {
        if (timeout == null) {
            timeout = DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
        }
        return System.nanoTime() + timeout.nanos();
    }

    @Inject
    public TransportListTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, TaskResourceTrackingService taskResourceTrackingService) {
        super("cluster:monitor/tasks/lists", clusterService, transportService, actionFilters, ListTasksRequest::new, ListTasksResponse::new, TaskInfo::new, "management");
        this.taskResourceTrackingService = taskResourceTrackingService;
    }

    @Override
    protected ListTasksResponse newResponse(ListTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected void taskOperation(ListTasksRequest request, Task task, ActionListener<TaskInfo> listener) {
        listener.onResponse((Object)task.taskInfo(this.clusterService.localNode().getId(), request.getDetailed()));
    }

    @Override
    protected void processTasks(ListTasksRequest request, Consumer<Task> operation) {
        if (request.getWaitForCompletion()) {
            long timeoutNanos = TransportListTasksAction.waitForCompletionTimeout(request.getTimeout());
            operation = operation.andThen(task -> {
                if (task.getAction().startsWith("cluster:monitor/tasks/lists")) {
                    return;
                }
                this.taskManager.waitForTaskCompletion((Task)task, timeoutNanos);
            });
        } else {
            operation = operation.andThen(xva$0 -> this.taskResourceTrackingService.refreshResourceStats(new Task[]{xva$0}));
        }
        super.processTasks(request, operation);
    }
}

