/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.pagination;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.admin.cluster.wlm.WlmStatsResponse;
import org.opensearch.action.pagination.PageToken;
import org.opensearch.action.pagination.PaginationStrategy;
import org.opensearch.common.hash.MessageDigests;
import org.opensearch.wlm.stats.SortBy;
import org.opensearch.wlm.stats.SortOrder;
import org.opensearch.wlm.stats.WlmStats;
import org.opensearch.wlm.stats.WorkloadGroupStats;

public class WlmPaginationStrategy
implements PaginationStrategy<WlmStats> {
    private static final String DEFAULT_PAGINATED_ENTITY = "wlm_stats";
    private final int pageSize;
    private final String nextToken;
    private final SortBy sortBy;
    private final SortOrder sortOrder;
    private final List<WlmStats> paginatedStats;
    private final int snapshotWorkloadGroupCount;
    private PageToken responseToken;
    private static final String HASH_ALGORITHM = "SHA-256";

    public WlmPaginationStrategy(int pageSize, String nextToken, SortBy sortBy, SortOrder sortOrder, WlmStatsResponse response) {
        this.pageSize = pageSize;
        this.nextToken = nextToken;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.snapshotWorkloadGroupCount = response.getNodes().stream().mapToInt(stat -> stat.getWorkloadGroupStats().getStats().size()).sum();
        String currentHash = this.computeWorkloadGroupHash(response.getNodes());
        WlmStrategyToken requestedToken = nextToken == null || nextToken.isEmpty() ? null : new WlmStrategyToken(nextToken);
        this.paginatedStats = this.applyPagination(response.getNodes(), requestedToken, currentHash);
    }

    private String computeWorkloadGroupHash(List<WlmStats> stats) {
        return stats.stream().flatMap(stat -> stat.getWorkloadGroupStats().getStats().keySet().stream().map(WorkloadGroupId -> stat.getNode().getId() + "|" + WorkloadGroupId)).sorted().collect(Collectors.collectingAndThen(Collectors.joining(","), this::sha256Hex));
    }

    private String sha256Hex(String input) {
        return MessageDigests.toHexString(MessageDigests.sha256().digest(input.getBytes(StandardCharsets.UTF_8)));
    }

    private List<WlmStats> applyPagination(List<WlmStats> rawStats, WlmStrategyToken requestedToken, String currentHash) {
        if (rawStats.isEmpty()) {
            this.responseToken = null;
            return Collections.emptyList();
        }
        List<WlmStats> perWorkloadGroupStats = this.extractWorkloadGroupStats(rawStats);
        perWorkloadGroupStats = perWorkloadGroupStats.stream().sorted(this.sortOrder.apply(this.sortBy.getComparator())).collect(Collectors.toList());
        int startIndex = this.getStartIndex(perWorkloadGroupStats, requestedToken);
        List<WlmStats> page = this.getPage(perWorkloadGroupStats, startIndex);
        this.setResponseToken(perWorkloadGroupStats, startIndex + page.size(), currentHash);
        return page;
    }

    private List<WlmStats> extractWorkloadGroupStats(List<WlmStats> rawStats) {
        ArrayList<WlmStats> result = new ArrayList<WlmStats>();
        for (WlmStats stat : rawStats) {
            Map<String, WorkloadGroupStats.WorkloadGroupStatsHolder> WorkloadGroups = stat.getWorkloadGroupStats().getStats();
            for (Map.Entry<String, WorkloadGroupStats.WorkloadGroupStatsHolder> entry : WorkloadGroups.entrySet()) {
                String workloadGroupId = entry.getKey();
                WorkloadGroupStats singleWorkloadGroupStats = new WorkloadGroupStats(Map.of(workloadGroupId, entry.getValue()));
                result.add(new WlmStats(stat.getNode(), singleWorkloadGroupStats));
            }
        }
        return result;
    }

    protected int getStartIndex(List<WlmStats> sortedStats, WlmStrategyToken token) {
        if (token == null) {
            return 0;
        }
        OptionalInt index = this.findIndex(sortedStats, token.getNodeId(), token.getWorkloadGroupId());
        if (index.isEmpty()) {
            throw new OpenSearchParseException("Invalid or outdated token: " + this.nextToken, new Object[0]);
        }
        return index.getAsInt();
    }

    private List<WlmStats> getPage(List<WlmStats> stats, int startIndex) {
        int endIndex = Math.min(startIndex + this.pageSize, stats.size());
        return stats.subList(startIndex, endIndex);
    }

    private void setResponseToken(List<WlmStats> stats, int nextIndex, String currentHash) {
        if (nextIndex < stats.size()) {
            WlmStats lastEntry = stats.get(nextIndex - 1);
            String nodeId = lastEntry.getNode().getId();
            String workloadGroupId = lastEntry.getWorkloadGroupStats().getStats().keySet().iterator().next();
            this.responseToken = new PageToken(WlmStrategyToken.generateEncryptedToken(nodeId, workloadGroupId, this.snapshotWorkloadGroupCount, currentHash, this.sortOrder.name(), this.sortBy.name()), DEFAULT_PAGINATED_ENTITY);
        } else {
            this.responseToken = null;
        }
    }

    protected OptionalInt findIndex(List<WlmStats> stats, String nodeId, String workloadGroupId) {
        for (int i = 0; i < stats.size(); ++i) {
            WlmStats stat = stats.get(i);
            if (!stat.getNode().getId().equals(nodeId) || !stat.getWorkloadGroupStats().getStats().containsKey(workloadGroupId)) continue;
            return OptionalInt.of(i + 1);
        }
        return OptionalInt.empty();
    }

    @Override
    public PageToken getResponseToken() {
        return this.responseToken;
    }

    @Override
    public List<WlmStats> getRequestedEntities() {
        return this.paginatedStats;
    }

    public static class WlmStrategyToken {
        private static final String JOIN_DELIMITER = "|";
        private static final String SPLIT_REGEX = "\\|";
        private static final int NODE_ID_POS = 0;
        private static final int WORKLOAD_GROUP_ID_POS = 1;
        private static final int WORKLOAD_GROUP_COUNT_POS = 2;
        private static final int HASH_POS = 3;
        private static final int SORT_ORDER_POS = 4;
        private static final int SORT_BY_POS = 5;
        private final String nodeId;
        private final String workloadGroupId;
        private final int workloadGroupCount;
        private final String hash;
        private final String sortOrder;
        private final String sortBy;

        public WlmStrategyToken(String requestedTokenString) {
            String[] parts = WlmStrategyToken.validateToken(requestedTokenString);
            this.nodeId = parts[0];
            this.workloadGroupId = parts[1];
            this.workloadGroupCount = Integer.parseInt(parts[2]);
            this.hash = parts[3];
            this.sortOrder = parts[4];
            this.sortBy = parts[5];
        }

        public static String generateEncryptedToken(String nodeId, String workloadGroupId, int workloadGroupCount, String hash, String sortOrder, String sortBy) {
            String raw = String.join((CharSequence)JOIN_DELIMITER, nodeId, workloadGroupId, String.valueOf(workloadGroupCount), hash, sortOrder, sortBy);
            return PaginationStrategy.encryptStringToken(raw);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getWorkloadGroupId() {
            return this.workloadGroupId;
        }

        public int getWorkloadGroupCount() {
            return this.workloadGroupCount;
        }

        public String getHash() {
            return this.hash;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }

        public String getSortBy() {
            return this.sortBy;
        }

        private static boolean isNullOrBlank(String str) {
            return str == null || str.trim().isEmpty();
        }

        private static String[] validateToken(String token) {
            Objects.requireNonNull(token, "Token cannot be null");
            String decrypted = PaginationStrategy.decryptStringToken(token);
            String[] parts = decrypted.split(SPLIT_REGEX);
            if (parts.length != 6 || WlmStrategyToken.isNullOrBlank(parts[0]) || WlmStrategyToken.isNullOrBlank(parts[1]) || WlmStrategyToken.isNullOrBlank(parts[3]) || WlmStrategyToken.isNullOrBlank(parts[4]) || WlmStrategyToken.isNullOrBlank(parts[5])) {
                throw new OpenSearchParseException("Invalid pagination token format", new Object[0]);
            }
            return parts;
        }
    }
}

