/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.block;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;

@PublicApi(since="1.0.0")
public class ClusterBlockException
extends OpenSearchException {
    private final Set<ClusterBlock> blocks;

    public ClusterBlockException(Set<ClusterBlock> globalLevelBlocks) {
        super(ClusterBlockException.buildMessageForGlobalBlocks(globalLevelBlocks), new Object[0]);
        this.blocks = globalLevelBlocks;
    }

    public ClusterBlockException(Map<String, Set<ClusterBlock>> indexLevelBlocks) {
        super(ClusterBlockException.buildMessageForIndexBlocks(indexLevelBlocks), new Object[0]);
        this.blocks = indexLevelBlocks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public ClusterBlockException(StreamInput in) throws IOException {
        super(in);
        this.blocks = Collections.unmodifiableSet(in.readSet(ClusterBlock::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.blocks != null) {
            out.writeCollection(this.blocks);
        } else {
            out.writeVInt(0);
        }
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessageForGlobalBlocks(Set<ClusterBlock> globalLevelBlocks) {
        assert (!globalLevelBlocks.isEmpty());
        Function<ClusterBlock, String> blockDescription = block -> String.valueOf(block.status()) + "/" + block.id() + "/" + block.description();
        StringBuilder sb = new StringBuilder();
        if (!globalLevelBlocks.isEmpty()) {
            sb.append("blocked by: [");
            sb.append(globalLevelBlocks.stream().map(blockDescription).collect(Collectors.joining(", ")));
            sb.append("];");
        }
        return sb.toString();
    }

    private static String buildMessageForIndexBlocks(Map<String, Set<ClusterBlock>> indexLevelBlocks) {
        assert (!indexLevelBlocks.isEmpty());
        Function<ClusterBlock, String> blockDescription = block -> String.valueOf(block.status()) + "/" + block.id() + "/" + block.description();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<ClusterBlock>> entry : indexLevelBlocks.entrySet()) {
            sb.append("index [" + entry.getKey() + "] blocked by: [");
            sb.append(entry.getValue().stream().map(blockDescription).collect(Collectors.joining(", ")));
            sb.append("];");
        }
        return sb.toString();
    }

    public RestStatus status() {
        RestStatus status = null;
        boolean onlyRetryableBlocks = true;
        for (ClusterBlock block : this.blocks) {
            boolean isRetryableBlock;
            boolean bl = isRetryableBlock = block.status() == RestStatus.TOO_MANY_REQUESTS;
            if (!isRetryableBlock) {
                if (status == null) {
                    status = block.status();
                } else if (status.getStatus() < block.status().getStatus()) {
                    status = block.status();
                }
            }
            onlyRetryableBlocks = onlyRetryableBlocks && isRetryableBlock;
        }
        if (onlyRetryableBlocks) {
            return RestStatus.TOO_MANY_REQUESTS;
        }
        return status;
    }
}

