/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Rectangle;

public class GeoShapeUtils {
    public static Polygon toLucenePolygon(org.opensearch.geometry.Polygon polygon) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(polygon.getHole(i).getY(), polygon.getHole(i).getX(), new Polygon[0]);
        }
        return new Polygon(polygon.getPolygon().getY(), polygon.getPolygon().getX(), holes);
    }

    public static Polygon toLucenePolygon(Rectangle r) {
        return new Polygon(new double[]{r.getMinLat(), r.getMinLat(), r.getMaxLat(), r.getMaxLat(), r.getMinLat()}, new double[]{r.getMinLon(), r.getMaxLon(), r.getMaxLon(), r.getMinLon(), r.getMinLon()}, new Polygon[0]);
    }

    public static org.apache.lucene.geo.Rectangle toLuceneRectangle(Rectangle r) {
        return new org.apache.lucene.geo.Rectangle(r.getMinLat(), r.getMaxLat(), r.getMinLon(), r.getMaxLon());
    }

    public static Point toLucenePoint(org.opensearch.geometry.Point point) {
        return new Point(point.getLat(), point.getLon());
    }

    public static Line toLuceneLine(org.opensearch.geometry.Line line) {
        return new Line(line.getLats(), line.getLons());
    }

    public static org.apache.lucene.geo.Circle toLuceneCircle(Circle circle) {
        return new org.apache.lucene.geo.Circle(circle.getLat(), circle.getLon(), circle.getRadiusMeters());
    }

    private GeoShapeUtils() {
    }
}

