/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.index;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.index.OpenSearchLeafReader;
import org.opensearch.core.index.shard.ShardId;

@PublicApi(since="1.0.0")
public final class OpenSearchDirectoryReader
extends FilterDirectoryReader {
    private final ShardId shardId;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;
    private final DelegatingCacheHelper delegatingCacheHelper;

    private OpenSearchDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, ShardId shardId) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.shardId = shardId;
        this.delegatingCacheHelper = new DelegatingCacheHelper(this, in.getReaderCacheHelper());
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.delegatingCacheHelper;
    }

    public DelegatingCacheHelper getDelegatingCacheHelper() {
        return this.delegatingCacheHelper;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new OpenSearchDirectoryReader(in, this.wrapper, this.shardId);
    }

    public static OpenSearchDirectoryReader wrap(DirectoryReader reader, ShardId shardId) throws IOException {
        return new OpenSearchDirectoryReader(reader, new SubReaderWrapper(shardId), shardId);
    }

    @SuppressForbidden(reason="This is the only sane way to add a ReaderClosedListener")
    public static void addReaderCloseListener(DirectoryReader reader, IndexReader.ClosedListener listener) {
        OpenSearchDirectoryReader openSearchDirectoryReader = OpenSearchDirectoryReader.getOpenSearchDirectoryReader(reader);
        if (openSearchDirectoryReader == null) {
            throw new IllegalArgumentException("Can't install close listener reader is not an OpenSearchDirectoryReader/OpenSearchLeafReader");
        }
        IndexReader.CacheHelper cacheHelper = openSearchDirectoryReader.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + String.valueOf((Object)openSearchDirectoryReader) + " does not support caching");
        }
        assert (cacheHelper.getKey() == reader.getReaderCacheHelper().getKey());
        cacheHelper.addClosedListener(listener);
    }

    public static OpenSearchDirectoryReader getOpenSearchDirectoryReader(DirectoryReader reader) {
        if (reader instanceof FilterDirectoryReader) {
            if (reader instanceof OpenSearchDirectoryReader) {
                return (OpenSearchDirectoryReader)reader;
            }
            return OpenSearchDirectoryReader.getOpenSearchDirectoryReader(((FilterDirectoryReader)reader).getDelegate());
        }
        return null;
    }

    @PublicApi(since="2.13.0")
    public class DelegatingCacheHelper
    implements IndexReader.CacheHelper {
        private final IndexReader.CacheHelper cacheHelper;
        private final DelegatingCacheKey serializableCacheKey;

        DelegatingCacheHelper(OpenSearchDirectoryReader this$0, IndexReader.CacheHelper cacheHelper) {
            this.cacheHelper = cacheHelper;
            this.serializableCacheKey = new DelegatingCacheKey(this$0, Optional.ofNullable(cacheHelper).map(key -> this.getKey()).orElse(null));
        }

        public IndexReader.CacheKey getKey() {
            return this.cacheHelper.getKey();
        }

        public DelegatingCacheKey getDelegatingCacheKey() {
            return this.serializableCacheKey;
        }

        public void addClosedListener(IndexReader.ClosedListener listener) {
            this.cacheHelper.addClosedListener(listener);
        }
    }

    private static final class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ShardId shardId;

        SubReaderWrapper(ShardId shardId) {
            this.shardId = shardId;
        }

        public LeafReader wrap(LeafReader reader) {
            return new OpenSearchLeafReader(reader, this.shardId);
        }
    }

    @PublicApi(since="2.13.0")
    public class DelegatingCacheKey {
        private final IndexReader.CacheKey cacheKey;
        private final String uniqueId;

        DelegatingCacheKey(OpenSearchDirectoryReader this$0, IndexReader.CacheKey cacheKey) {
            this.cacheKey = cacheKey;
            this.uniqueId = UUID.randomUUID().toString();
        }

        public IndexReader.CacheKey getCacheKey() {
            return this.cacheKey;
        }

        public String getId() {
            return this.uniqueId;
        }
    }
}

