/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query.rewriters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ComplementAwareQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.search.query.QueryRewriter;

public class MustNotToShouldRewriter
implements QueryRewriter {
    public static final MustNotToShouldRewriter INSTANCE = new MustNotToShouldRewriter();

    private MustNotToShouldRewriter() {
    }

    @Override
    public QueryBuilder rewrite(QueryBuilder query, QueryShardContext context) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (!(query instanceof BoolQueryBuilder)) {
            return query;
        }
        BoolQueryBuilder boolQuery = (BoolQueryBuilder)query;
        List<LeafReaderContext> leafReaderContexts = null;
        ArrayList<QueryBuilder> mustNotClausesToRewrite = new ArrayList<QueryBuilder>();
        if (!boolQuery.mustNot().isEmpty() && (leafReaderContexts = this.getLeafReaderContexts(context)) != null && !leafReaderContexts.isEmpty()) {
            WithFieldName wfn;
            HashMap<String, Integer> fieldCounts = new HashMap<String, Integer>();
            for (QueryBuilder queryBuilder : boolQuery.mustNot()) {
                if (!(queryBuilder instanceof ComplementAwareQueryBuilder) || !(queryBuilder instanceof WithFieldName)) continue;
                wfn = (WithFieldName)((Object)queryBuilder);
                fieldCounts.merge(wfn.fieldName(), 1, Integer::sum);
            }
            for (QueryBuilder queryBuilder : boolQuery.mustNot()) {
                String fieldName;
                if (!(queryBuilder instanceof ComplementAwareQueryBuilder) || !(queryBuilder instanceof WithFieldName) || fieldCounts.getOrDefault(fieldName = (wfn = (WithFieldName)((Object)queryBuilder)).fieldName(), 0) != 1 || !this.checkAllDocsHaveOneValue(leafReaderContexts, fieldName)) continue;
                mustNotClausesToRewrite.add(queryBuilder);
            }
        }
        BoolQueryBuilder rewritten = new BoolQueryBuilder();
        rewritten.boost(boolQuery.boost());
        rewritten.queryName(boolQuery.queryName());
        rewritten.minimumShouldMatch(boolQuery.minimumShouldMatch());
        rewritten.adjustPureNegative(boolQuery.adjustPureNegative());
        for (QueryBuilder queryBuilder : boolQuery.must()) {
            rewritten.must(this.rewrite(queryBuilder, context));
        }
        for (QueryBuilder queryBuilder : boolQuery.filter()) {
            rewritten.filter(this.rewrite(queryBuilder, context));
        }
        for (QueryBuilder queryBuilder : boolQuery.should()) {
            rewritten.should(this.rewrite(queryBuilder, context));
        }
        boolean changed = false;
        for (QueryBuilder mustNotClause : boolQuery.mustNot()) {
            if (mustNotClausesToRewrite.contains(mustNotClause)) {
                ComplementAwareQueryBuilder caq = (ComplementAwareQueryBuilder)((Object)mustNotClause);
                List<? extends QueryBuilder> complement = caq.getComplement(context);
                if (complement != null && !complement.isEmpty()) {
                    BoolQueryBuilder nestedBoolQuery = new BoolQueryBuilder();
                    nestedBoolQuery.minimumShouldMatch(1);
                    for (QueryBuilder queryBuilder : complement) {
                        nestedBoolQuery.should(queryBuilder);
                    }
                    rewritten.must(nestedBoolQuery);
                    changed = true;
                    continue;
                }
                rewritten.mustNot(mustNotClause);
                continue;
            }
            rewritten.mustNot(this.rewrite(mustNotClause, context));
        }
        if (changed && boolQuery.minimumShouldMatch() == null && !boolQuery.should().isEmpty() && boolQuery.must().isEmpty() && boolQuery.filter().isEmpty()) {
            rewritten.minimumShouldMatch(1);
        }
        boolean bl5 = false;
        for (QueryBuilder mustClause : boolQuery.must()) {
            if (!(mustClause instanceof BoolQueryBuilder) || rewritten.must().contains(mustClause)) continue;
            bl4 = true;
            break;
        }
        if (!bl4) {
            for (QueryBuilder filterClause : boolQuery.filter()) {
                if (!(filterClause instanceof BoolQueryBuilder) || rewritten.filter().contains(filterClause)) continue;
                bl3 = true;
                break;
            }
        }
        if (!bl3) {
            for (QueryBuilder shouldClause : boolQuery.should()) {
                if (!(shouldClause instanceof BoolQueryBuilder) || rewritten.should().contains(shouldClause)) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            for (QueryBuilder mustNotClause : boolQuery.mustNot()) {
                if (!(mustNotClause instanceof BoolQueryBuilder) || rewritten.mustNot().contains(mustNotClause)) continue;
                bl = true;
                break;
            }
        }
        return changed || bl ? rewritten : query;
    }

    private List<LeafReaderContext> getLeafReaderContexts(QueryShardContext context) {
        if (context == null) {
            return null;
        }
        try {
            return context.getIndexReader().leaves();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean checkAllDocsHaveOneValue(List<LeafReaderContext> leafReaderContexts, String fieldName) {
        try {
            for (LeafReaderContext leafReaderContext : leafReaderContexts) {
                PointValues pointValues = leafReaderContext.reader().getPointValues(fieldName);
                if (pointValues != null) {
                    long valueCount;
                    int docCount = pointValues.getDocCount();
                    if ((long)docCount != (valueCount = pointValues.size())) {
                        return false;
                    }
                    int maxDoc = leafReaderContext.reader().maxDoc();
                    if (docCount == maxDoc) continue;
                    return false;
                }
                if (leafReaderContext.reader().maxDoc() <= 0) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public int priority() {
        return 175;
    }

    @Override
    public String name() {
        return "must_not_to_should";
    }
}

