/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.transport.TransportProtocol;
import org.opensearch.transport.TransportStatus;

@PublicApi(since="1.0.0")
public class Header {
    private static final String RESPONSE_NAME = "NO_ACTION_NAME_FOR_RESPONSES";
    private final TransportProtocol protocol;
    private final int networkMessageSize;
    private final Version version;
    private final long requestId;
    private final byte status;
    String actionName;
    Tuple<Map<String, String>, Map<String, Set<String>>> headers;
    Set<String> features;

    Header(TransportProtocol protocol, int networkMessageSize, long requestId, byte status, Version version) {
        this.protocol = protocol;
        this.networkMessageSize = networkMessageSize;
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    TransportProtocol getTransportProtocol() {
        return this.protocol;
    }

    public int getNetworkMessageSize() {
        return this.networkMessageSize;
    }

    public Version getVersion() {
        return this.version;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public byte getStatus() {
        return this.status;
    }

    public boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }

    public boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    public boolean isCompressed() {
        return TransportStatus.isCompress(this.status);
    }

    public String getActionName() {
        return this.actionName;
    }

    boolean needsToReadVariableHeader() {
        return this.headers == null;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public Tuple<Map<String, String>, Map<String, Set<String>>> getHeaders() {
        return this.headers;
    }

    void finishParsingHeader(StreamInput input) throws IOException {
        this.headers = ThreadContext.readHeadersFromStream(input);
        if (this.isRequest()) {
            String[] featuresFound = input.readStringArray();
            this.features = featuresFound.length == 0 ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(featuresFound)));
            this.actionName = input.readString();
        } else {
            this.actionName = RESPONSE_NAME;
        }
    }

    public String toString() {
        return "Header{" + String.valueOf((Object)this.protocol) + "}{" + this.networkMessageSize + "}{" + String.valueOf(this.version) + "}{" + this.requestId + "}{" + this.isRequest() + "}{" + this.isError() + "}{" + this.isHandshake() + "}{" + this.isCompressed() + "}{" + this.actionName + "}";
    }
}

