"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasDuplicateAxis = exports.getAxesGeometries = exports.shouldShowTicks = exports.getAxisPosition = exports.getTitleDimension = exports.getVisibleTicks = exports.enableDuplicatedTicks = exports.getAvailableTicks = exports.getMinMaxRange = exports.getHorizontalAxisTickLineProps = exports.getVerticalAxisTickLineProps = exports.getTickLabelProps = exports.computeRotatedLabelDimensions = exports.getScaleForAxisSpec = exports.isYDomain = exports.axisViewModel = exports.defaultTickFormatter = void 0;
var common_1 = require("../../../utils/common");
var dimensions_1 = require("../../../utils/dimensions");
var logger_1 = require("../../../utils/logger");
var line_1 = require("../renderer/canvas/primitives/line");
var spec_1 = require("../state/utils/spec");
var axis_type_utils_1 = require("./axis_type_utils");
var panel_1 = require("./panel");
var scales_1 = require("./scales");
var defaultTickFormatter = function (tick) { return "" + tick; };
exports.defaultTickFormatter = defaultTickFormatter;
function axisViewModel(axisSpec, xDomain, yDomains, totalBarsInCluster, bboxCalculator, chartRotation, _a, fallBackTickFormatter, barsPadding, enableHistogramMode) {
    var e_1, _b;
    var _c, _d;
    var gridLine = _a.gridLine, tickLabel = _a.tickLabel;
    var gridLineVisible = axis_type_utils_1.isVerticalAxis(axisSpec.position) ? gridLine.vertical.visible : gridLine.horizontal.visible;
    if (axisSpec.hide && !gridLineVisible) {
        return null;
    }
    var scale = getScaleForAxisSpec(axisSpec, xDomain, yDomains, totalBarsInCluster, chartRotation, [0, 1], barsPadding, enableHistogramMode);
    if (!scale) {
        logger_1.Logger.warn("Cannot compute scale for axis spec " + axisSpec.id + ". Axis will not be displayed.");
        return null;
    }
    var tickFormat = (_d = (_c = axisSpec.labelFormat) !== null && _c !== void 0 ? _c : axisSpec.tickFormat) !== null && _d !== void 0 ? _d : fallBackTickFormatter;
    var tickFormatOptions = { timeZone: xDomain.timeZone };
    var tickValues = scale.ticks();
    var tickLabels = tickValues.map(function (d) { return tickFormat(d, tickFormatOptions); });
    var maxLabelBboxWidth = 0;
    var maxLabelBboxHeight = 0;
    var maxLabelTextWidth = 0;
    var maxLabelTextHeight = 0;
    if (tickLabel.visible) {
        try {
            for (var tickLabels_1 = __values(tickLabels), tickLabels_1_1 = tickLabels_1.next(); !tickLabels_1_1.done; tickLabels_1_1 = tickLabels_1.next()) {
                var labelText = tickLabels_1_1.value;
                var bbox = bboxCalculator.compute(labelText, 0, tickLabel.fontSize, tickLabel.fontFamily);
                var rotatedBbox = computeRotatedLabelDimensions(bbox, tickLabel.rotation);
                maxLabelBboxWidth = Math.max(maxLabelBboxWidth, Math.ceil(rotatedBbox.width));
                maxLabelBboxHeight = Math.max(maxLabelBboxHeight, Math.ceil(rotatedBbox.height));
                maxLabelTextWidth = Math.max(maxLabelTextWidth, Math.ceil(bbox.width));
                maxLabelTextHeight = Math.max(maxLabelTextHeight, Math.ceil(bbox.height));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (tickLabels_1_1 && !tickLabels_1_1.done && (_b = tickLabels_1.return)) _b.call(tickLabels_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return {
        maxLabelBboxWidth: maxLabelBboxWidth,
        maxLabelBboxHeight: maxLabelBboxHeight,
        maxLabelTextWidth: maxLabelTextWidth,
        maxLabelTextHeight: maxLabelTextHeight,
        tickValues: tickValues,
        tickLabels: tickLabels,
        isHidden: axisSpec.hide && gridLineVisible,
    };
}
exports.axisViewModel = axisViewModel;
function isYDomain(position, chartRotation) {
    return axis_type_utils_1.isVerticalAxis(position) === (chartRotation % 180 === 0);
}
exports.isYDomain = isYDomain;
function getScaleForAxisSpec(_a, xDomain, yDomains, totalBarsInCluster, chartRotation, range, barsPadding, enableHistogramMode) {
    var _b;
    var groupId = _a.groupId, integersOnly = _a.integersOnly, position = _a.position;
    return isYDomain(position, chartRotation)
        ? (_b = scales_1.computeYScales({ yDomains: yDomains, range: range, integersOnly: integersOnly }).get(groupId)) !== null && _b !== void 0 ? _b : null : scales_1.computeXScale({ xDomain: xDomain, totalBarsInCluster: totalBarsInCluster, range: range, barsPadding: barsPadding, enableHistogramMode: enableHistogramMode, integersOnly: integersOnly });
}
exports.getScaleForAxisSpec = getScaleForAxisSpec;
function computeRotatedLabelDimensions(unrotatedDims, degreesRotation) {
    var width = unrotatedDims.width, height = unrotatedDims.height;
    var radians = common_1.getRadians(degreesRotation);
    var rotatedHeight = Math.abs(width * Math.sin(radians)) + Math.abs(height * Math.cos(radians));
    var rotatedWidth = Math.abs(width * Math.cos(radians)) + Math.abs(height * Math.sin(radians));
    return {
        width: rotatedWidth,
        height: rotatedHeight,
    };
}
exports.computeRotatedLabelDimensions = computeRotatedLabelDimensions;
function getUserTextOffsets(dimensions, offset) {
    var defaults = {
        x: 0,
        y: 0,
    };
    if (offset.reference === 'global') {
        return {
            local: defaults,
            global: {
                x: common_1.getPercentageValue(offset.x, dimensions.maxLabelBboxWidth, 0),
                y: common_1.getPercentageValue(offset.y, dimensions.maxLabelBboxHeight, 0),
            },
        };
    }
    return {
        global: defaults,
        local: {
            x: common_1.getPercentageValue(offset.x, dimensions.maxLabelTextWidth, 0),
            y: common_1.getPercentageValue(offset.y, dimensions.maxLabelTextHeight, 0),
        },
    };
}
function getHorizontalTextOffset(width, alignment) {
    switch (alignment) {
        case common_1.HorizontalAlignment.Left:
            return -width / 2;
        case common_1.HorizontalAlignment.Right:
            return width / 2;
        case common_1.HorizontalAlignment.Center:
        default:
            return 0;
    }
}
function getVerticalTextOffset(height, alignment) {
    switch (alignment) {
        case common_1.VerticalAlignment.Top:
            return -height / 2;
        case common_1.VerticalAlignment.Bottom:
            return height / 2;
        case common_1.VerticalAlignment.Middle:
        default:
            return 0;
    }
}
function getHorizontalAlign(position, rotation, alignment) {
    if (alignment === void 0) { alignment = common_1.HorizontalAlignment.Near; }
    if (alignment === common_1.HorizontalAlignment.Center ||
        alignment === common_1.HorizontalAlignment.Right ||
        alignment === common_1.HorizontalAlignment.Left) {
        return alignment;
    }
    if ([-90, 90].includes(rotation)) {
        if (position === common_1.Position.Left || position === common_1.Position.Right) {
            return common_1.HorizontalAlignment.Center;
        }
        if (position === common_1.Position.Top) {
            return rotation === 90 ? common_1.HorizontalAlignment.Right : common_1.HorizontalAlignment.Left;
        }
        return rotation === -90 ? common_1.HorizontalAlignment.Right : common_1.HorizontalAlignment.Left;
    }
    if ([0, 180].includes(rotation) && (position === common_1.Position.Bottom || position === common_1.Position.Top)) {
        return common_1.HorizontalAlignment.Center;
    }
    if (position === common_1.Position.Left) {
        return alignment === common_1.HorizontalAlignment.Near ? common_1.HorizontalAlignment.Right : common_1.HorizontalAlignment.Left;
    }
    if (position === common_1.Position.Right) {
        return alignment === common_1.HorizontalAlignment.Near ? common_1.HorizontalAlignment.Left : common_1.HorizontalAlignment.Right;
    }
    return common_1.HorizontalAlignment.Center;
}
function getVerticalAlign(position, rotation, alignment) {
    if (alignment === void 0) { alignment = common_1.VerticalAlignment.Middle; }
    if (alignment === common_1.VerticalAlignment.Middle ||
        alignment === common_1.VerticalAlignment.Top ||
        alignment === common_1.VerticalAlignment.Bottom) {
        return alignment;
    }
    if ([0, 180].includes(rotation)) {
        if (position === common_1.Position.Bottom || position === common_1.Position.Top) {
            return common_1.VerticalAlignment.Middle;
        }
        if (position === common_1.Position.Left) {
            return rotation === 0 ? common_1.VerticalAlignment.Bottom : common_1.VerticalAlignment.Top;
        }
        return rotation === 180 ? common_1.VerticalAlignment.Bottom : common_1.VerticalAlignment.Top;
    }
    if (position === common_1.Position.Top) {
        return alignment === common_1.VerticalAlignment.Near ? common_1.VerticalAlignment.Bottom : common_1.VerticalAlignment.Top;
    }
    if (position === common_1.Position.Bottom) {
        return alignment === common_1.VerticalAlignment.Near ? common_1.VerticalAlignment.Top : common_1.VerticalAlignment.Bottom;
    }
    return common_1.VerticalAlignment.Middle;
}
function getTickLabelProps(_a, tickPosition, position, rotation, axisSize, tickDimensions, showTicks, textOffset, textAlignment) {
    var tickLine = _a.tickLine, tickLabel = _a.tickLabel;
    var maxLabelBboxWidth = tickDimensions.maxLabelBboxWidth, maxLabelTextWidth = tickDimensions.maxLabelTextWidth, maxLabelBboxHeight = tickDimensions.maxLabelBboxHeight, maxLabelTextHeight = tickDimensions.maxLabelTextHeight;
    var tickDimension = showTicks ? tickLine.size + tickLine.padding : 0;
    var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
    var isLeftAxis = position === common_1.Position.Left;
    var isAxisTop = position === common_1.Position.Top;
    var horizontalAlign = getHorizontalAlign(position, rotation, textAlignment === null || textAlignment === void 0 ? void 0 : textAlignment.horizontal);
    var verticalAlign = getVerticalAlign(position, rotation, textAlignment === null || textAlignment === void 0 ? void 0 : textAlignment.vertical);
    var userOffsets = getUserTextOffsets(tickDimensions, textOffset);
    var textOffsetX = getHorizontalTextOffset(maxLabelTextWidth, horizontalAlign) + userOffsets.local.x;
    var textOffsetY = getVerticalTextOffset(maxLabelTextHeight, verticalAlign) + userOffsets.local.y;
    if (axis_type_utils_1.isVerticalAxis(position)) {
        var x = isLeftAxis ? axisSize.width - tickDimension - labelPadding.inner : tickDimension + labelPadding.inner;
        var offsetX = (isLeftAxis ? -1 : 1) * (maxLabelBboxWidth / 2);
        return {
            x: x,
            y: tickPosition,
            offsetX: offsetX + userOffsets.global.x,
            offsetY: userOffsets.global.y,
            textOffsetY: textOffsetY,
            textOffsetX: textOffsetX,
            horizontalAlign: horizontalAlign,
            verticalAlign: verticalAlign,
        };
    }
    var offsetY = isAxisTop ? -maxLabelBboxHeight / 2 : maxLabelBboxHeight / 2;
    return {
        x: tickPosition,
        y: isAxisTop ? axisSize.height - tickDimension - labelPadding.inner : tickDimension + labelPadding.inner,
        offsetX: userOffsets.global.x,
        offsetY: offsetY + userOffsets.global.y,
        textOffsetX: textOffsetX,
        textOffsetY: textOffsetY,
        horizontalAlign: horizontalAlign,
        verticalAlign: verticalAlign,
    };
}
exports.getTickLabelProps = getTickLabelProps;
function getVerticalAxisTickLineProps(position, axisWidth, tickSize, tickPosition) {
    var isLeftAxis = position === common_1.Position.Left;
    var y = tickPosition;
    var x1 = isLeftAxis ? axisWidth : 0;
    var x2 = isLeftAxis ? axisWidth - tickSize : tickSize;
    return { x1: x1, y1: y, x2: x2, y2: y };
}
exports.getVerticalAxisTickLineProps = getVerticalAxisTickLineProps;
function getHorizontalAxisTickLineProps(position, axisHeight, tickSize, tickPosition) {
    var isTopAxis = position === common_1.Position.Top;
    var x = tickPosition;
    var y1 = isTopAxis ? axisHeight - tickSize : 0;
    var y2 = isTopAxis ? axisHeight : tickSize;
    return { x1: x, y1: y1, x2: x, y2: y2 };
}
exports.getHorizontalAxisTickLineProps = getHorizontalAxisTickLineProps;
function getMinMaxRange(axisPosition, chartRotation, _a) {
    var width = _a.width, height = _a.height;
    switch (axisPosition) {
        case common_1.Position.Bottom:
        case common_1.Position.Top:
            return getBottomTopAxisMinMaxRange(chartRotation, width);
        case common_1.Position.Left:
        case common_1.Position.Right:
        default:
            return getLeftAxisMinMaxRange(chartRotation, height);
    }
}
exports.getMinMaxRange = getMinMaxRange;
function getBottomTopAxisMinMaxRange(chartRotation, width) {
    switch (chartRotation) {
        case 90:
            return { minRange: 0, maxRange: width };
        case -90:
            return { minRange: width, maxRange: 0 };
        case 180:
            return { minRange: width, maxRange: 0 };
        case 0:
        default:
            return { minRange: 0, maxRange: width };
    }
}
function getLeftAxisMinMaxRange(chartRotation, height) {
    switch (chartRotation) {
        case 90:
            return { minRange: 0, maxRange: height };
        case -90:
            return { minRange: height, maxRange: 0 };
        case 180:
            return { minRange: 0, maxRange: height };
        case 0:
        default:
            return { minRange: height, maxRange: 0 };
    }
}
function getAvailableTicks(axisSpec, scale, totalBarsInCluster, enableHistogramMode, fallBackTickFormatter, rotationOffset, tickFormatOptions) {
    var _a, _b;
    var ticks = scale.ticks();
    var isSingleValueScale = scale.domain[0] - scale.domain[1] === 0;
    var hasAdditionalTicks = enableHistogramMode && scale.bandwidth > 0;
    if (hasAdditionalTicks) {
        var lastComputedTick = ticks[ticks.length - 1];
        if (!isSingleValueScale) {
            var penultimateComputedTick = ticks[ticks.length - 2];
            var computedTickDistance = lastComputedTick - penultimateComputedTick;
            var numTicks = scale.minInterval / computedTickDistance;
            for (var i = 1; i <= numTicks; i++) {
                ticks.push(i * computedTickDistance + lastComputedTick);
            }
        }
    }
    var shift = totalBarsInCluster > 0 ? totalBarsInCluster : 1;
    var band = scale.bandwidth / (1 - scale.barsPadding);
    var halfPadding = (band - scale.bandwidth) / 2;
    var offset = (enableHistogramMode ? -halfPadding : (scale.bandwidth * shift) / 2) + (scale.isSingleValue() ? 0 : rotationOffset);
    var tickFormatter = (_a = axisSpec.tickFormat) !== null && _a !== void 0 ? _a : fallBackTickFormatter;
    if (isSingleValueScale && hasAdditionalTicks) {
        var _c = __read(ticks, 1), firstTickValue = _c[0];
        var firstTick = {
            value: firstTickValue,
            label: tickFormatter(firstTickValue, tickFormatOptions),
            position: ((_b = scale.scale(firstTickValue)) !== null && _b !== void 0 ? _b : 0) + offset,
        };
        var lastTickValue = firstTickValue + scale.minInterval;
        var lastTick = {
            value: lastTickValue,
            label: tickFormatter(lastTickValue, tickFormatOptions),
            position: scale.bandwidth + halfPadding * 2,
        };
        return [firstTick, lastTick];
    }
    return enableDuplicatedTicks(axisSpec, scale, offset, fallBackTickFormatter, tickFormatOptions);
}
exports.getAvailableTicks = getAvailableTicks;
function enableDuplicatedTicks(axisSpec, scale, offset, fallBackTickFormatter, tickFormatOptions) {
    var ticks = scale.ticks();
    var allTicks = ticks.map(function (tick) {
        var _a, _b;
        return ({
            value: tick,
            label: ((_a = axisSpec.tickFormat) !== null && _a !== void 0 ? _a : fallBackTickFormatter)(tick, tickFormatOptions),
            position: ((_b = scale.scale(tick)) !== null && _b !== void 0 ? _b : 0) + offset,
        });
    });
    if (axisSpec.showDuplicatedTicks === true) {
        return allTicks;
    }
    return common_1.getUniqueValues(allTicks, 'label', true);
}
exports.enableDuplicatedTicks = enableDuplicatedTicks;
function getVisibleTicks(allTicks, axisSpec, axisDim) {
    allTicks.sort(function (a, b) { return a.position - b.position; });
    var showOverlappingTicks = axisSpec.showOverlappingTicks, showOverlappingLabels = axisSpec.showOverlappingLabels;
    var maxLabelBboxHeight = axisDim.maxLabelBboxHeight, maxLabelBboxWidth = axisDim.maxLabelBboxWidth;
    var requiredSpace = axis_type_utils_1.isVerticalAxis(axisSpec.position) ? maxLabelBboxHeight / 2 : maxLabelBboxWidth / 2;
    var previousOccupiedSpace = 0;
    var visibleTicks = [];
    for (var i = 0; i < allTicks.length; i++) {
        var position = allTicks[i].position;
        if (i === 0) {
            visibleTicks.push(allTicks[i]);
            previousOccupiedSpace = position + requiredSpace;
        }
        else if (position - requiredSpace >= previousOccupiedSpace) {
            visibleTicks.push(allTicks[i]);
            previousOccupiedSpace = position + requiredSpace;
        }
        else {
            if (showOverlappingTicks || showOverlappingLabels) {
                var overlappingTick = __assign(__assign({}, allTicks[i]), { label: showOverlappingLabels ? allTicks[i].label : '' });
                visibleTicks.push(overlappingTick);
            }
        }
    }
    return visibleTicks;
}
exports.getVisibleTicks = getVisibleTicks;
function getTitleDimension(_a) {
    var visible = _a.visible, fontSize = _a.fontSize, padding = _a.padding;
    if (!visible || fontSize <= 0)
        return 0;
    var _b = dimensions_1.getSimplePadding(padding), inner = _b.inner, outer = _b.outer;
    return inner + fontSize + outer;
}
exports.getTitleDimension = getTitleDimension;
function getAxisPosition(chartDimensions, chartMargins, axisTitle, axisPanelTitle, axisSpec, axisDim, smScales, cumTopSum, cumBottomSum, cumLeftSum, cumRightSum, tickDimension, labelPaddingSum, showLabels) {
    var titleDimension = axisSpec.title ? getTitleDimension(axisTitle) : 0;
    var position = axisSpec.position;
    var maxLabelBboxHeight = axisDim.maxLabelBboxHeight, maxLabelBboxWidth = axisDim.maxLabelBboxWidth;
    var top = chartDimensions.top, left = chartDimensions.left, height = chartDimensions.height, width = chartDimensions.width;
    var dimensions = {
        top: top,
        left: left,
        width: width,
        height: height,
    };
    var topIncrement = 0;
    var bottomIncrement = 0;
    var leftIncrement = 0;
    var rightIncrement = 0;
    if (axis_type_utils_1.isVerticalAxis(position)) {
        var panelTitleDimension = panel_1.hasSMDomain(smScales.vertical) ? getTitleDimension(axisPanelTitle) : 0;
        var dimWidth = labelPaddingSum + (showLabels ? maxLabelBboxWidth : 0) + tickDimension + titleDimension + panelTitleDimension;
        if (position === common_1.Position.Left) {
            leftIncrement = chartMargins.left + dimWidth;
            dimensions.left = cumLeftSum + chartMargins.left;
        }
        else {
            rightIncrement = dimWidth + chartMargins.right;
            dimensions.left = left + width + cumRightSum;
        }
        dimensions.width = dimWidth;
    }
    else {
        var panelTitleDimension = panel_1.hasSMDomain(smScales.horizontal) ? getTitleDimension(axisPanelTitle) : 0;
        var dimHeight = labelPaddingSum + (showLabels ? maxLabelBboxHeight : 0) + tickDimension + titleDimension + panelTitleDimension;
        if (position === common_1.Position.Top) {
            topIncrement = dimHeight + chartMargins.top;
            dimensions.top = cumTopSum + chartMargins.top;
        }
        else {
            bottomIncrement = dimHeight + chartMargins.bottom;
            dimensions.top = top + height + cumBottomSum;
        }
        dimensions.height = dimHeight;
    }
    return { dimensions: dimensions, topIncrement: topIncrement, bottomIncrement: bottomIncrement, leftIncrement: leftIncrement, rightIncrement: rightIncrement };
}
exports.getAxisPosition = getAxisPosition;
function shouldShowTicks(_a, axisHidden) {
    var visible = _a.visible, strokeWidth = _a.strokeWidth, size = _a.size;
    return !axisHidden && visible && size > 0 && strokeWidth >= line_1.MIN_STROKE_WIDTH;
}
exports.shouldShowTicks = shouldShowTicks;
function getAxesGeometries(computedChartDims, _a, chartRotation, axisSpecs, axisDimensions, axesStyles, xDomain, yDomains, smScales, totalGroupsCount, enableHistogramMode, fallBackTickFormatter, barsPadding) {
    var chartPaddings = _a.chartPaddings, chartMargins = _a.chartMargins, sharedAxesStyle = _a.axes;
    var axesGeometries = [];
    var chartDimensions = computedChartDims.chartDimensions;
    var panel = panel_1.getPanelSize(smScales);
    var anchorPointByAxisGroups = __spread(axisDimensions.entries()).reduce(function (acc, _a) {
        var _b;
        var _c = __read(_a, 2), axisId = _c[0], dimension = _c[1];
        var axisSpec = spec_1.getSpecsById(axisSpecs, axisId);
        if (!axisSpec) {
            return acc;
        }
        var _d = (_b = axesStyles.get(axisId)) !== null && _b !== void 0 ? _b : sharedAxesStyle, tickLine = _d.tickLine, tickLabel = _d.tickLabel, axisTitle = _d.axisTitle, axisPanelTitle = _d.axisPanelTitle;
        var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
        var showTicks = shouldShowTicks(tickLine, axisSpec.hide);
        var tickDimension = showTicks ? tickLine.size + tickLine.padding : 0;
        var labelPaddingSum = tickLabel.visible ? labelPadding.inner + labelPadding.outer : 0;
        var _e = getAxisPosition(chartDimensions, chartMargins, axisTitle, axisPanelTitle, axisSpec, dimension, smScales, acc.top, acc.bottom, acc.left, acc.right, tickDimension, labelPaddingSum, tickLabel.visible), dimensions = _e.dimensions, topIncrement = _e.topIncrement, bottomIncrement = _e.bottomIncrement, leftIncrement = _e.leftIncrement, rightIncrement = _e.rightIncrement;
        acc.pos.set(axisId, {
            anchor: {
                top: acc.top,
                left: acc.left,
                right: acc.right,
                bottom: acc.bottom,
            },
            dimensions: dimensions,
        });
        return {
            top: acc.top + topIncrement,
            bottom: acc.bottom + bottomIncrement,
            left: acc.left + leftIncrement,
            right: acc.right + rightIncrement,
            pos: acc.pos,
        };
    }, {
        top: 0,
        bottom: chartPaddings.bottom,
        left: computedChartDims.leftMargin,
        right: chartPaddings.right,
        pos: new Map(),
    }).pos;
    axisDimensions.forEach(function (axisDim, id) {
        var axisSpec = spec_1.getSpecsById(axisSpecs, id);
        var anchorPoint = anchorPointByAxisGroups.get(id);
        if (!axisSpec || !anchorPoint) {
            return;
        }
        var isVertical = axis_type_utils_1.isVerticalAxis(axisSpec.position);
        var minMaxRanges = getMinMaxRange(axisSpec.position, chartRotation, panel);
        var scale = getScaleForAxisSpec(axisSpec, xDomain, yDomains, totalGroupsCount, chartRotation, [minMaxRanges.minRange, minMaxRanges.maxRange], barsPadding, enableHistogramMode);
        if (!scale) {
            throw new Error("Cannot compute scale for axis spec " + axisSpec.id);
        }
        var tickFormatOptions = {
            timeZone: xDomain.timeZone,
        };
        var rotationOffset = enableHistogramMode &&
            ((isVertical && [-90].includes(chartRotation)) || (!isVertical && [180].includes(chartRotation)))
            ? scale.step
            : 0;
        var allTicks = getAvailableTicks(axisSpec, scale, totalGroupsCount, enableHistogramMode, isVertical ? fallBackTickFormatter : exports.defaultTickFormatter, rotationOffset, tickFormatOptions);
        var visibleTicks = getVisibleTicks(allTicks, axisSpec, axisDim);
        var size = axisDim.isHidden
            ? { width: 0, height: 0 }
            : {
                width: isVertical ? anchorPoint.dimensions.width : panel.width,
                height: isVertical ? panel.height : anchorPoint.dimensions.height,
            };
        axesGeometries.push({
            axis: {
                id: axisSpec.id,
                position: axisSpec.position,
            },
            anchorPoint: {
                x: anchorPoint.dimensions.left,
                y: anchorPoint.dimensions.top,
            },
            size: size,
            parentSize: {
                height: anchorPoint.dimensions.height,
                width: anchorPoint.dimensions.width,
            },
            dimension: axisDim,
            ticks: allTicks,
            visibleTicks: visibleTicks,
        });
    });
    return axesGeometries;
}
exports.getAxesGeometries = getAxesGeometries;
var hasDuplicateAxis = function (_a, _b, tickMap, specs) {
    var position = _a.position, title = _a.title;
    var tickLabels = _b.tickLabels;
    return __spread(tickMap).some(function (_a) {
        var _b = __read(_a, 2), axisId = _b[0], axisTickLabels = _b[1].tickLabels;
        var spec = spec_1.getSpecsById(specs, axisId);
        return ((spec === null || spec === void 0 ? void 0 : spec.position) === position &&
            title === spec.title &&
            axisTickLabels &&
            tickLabels.length === axisTickLabels.length &&
            tickLabels[0] === axisTickLabels[0] &&
            tickLabels[tickLabels.length - 1] === axisTickLabels[axisTickLabels.length - 1]);
    });
};
exports.hasDuplicateAxis = hasDuplicateAxis;
//# sourceMappingURL=axis_utils.js.map