/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.h3;

import java.util.Arrays;
import org.opensearch.geospatial.h3.BaseCells;
import org.opensearch.geospatial.h3.CellBoundary;
import org.opensearch.geospatial.h3.Constants;
import org.opensearch.geospatial.h3.CoordIJK;
import org.opensearch.geospatial.h3.FaceIJK;
import org.opensearch.geospatial.h3.H3Index;
import org.opensearch.geospatial.h3.HexRing;
import org.opensearch.geospatial.h3.Iterator;
import org.opensearch.geospatial.h3.LatLng;

public final class H3 {
    public static int MIN_H3_RES = Constants.MIN_H3_RES;
    public static int MAX_H3_RES = Constants.MAX_H3_RES;

    public static String h3ToString(long h3) {
        return Long.toHexString(h3);
    }

    public static long stringToH3(String h3Address) {
        return Long.parseUnsignedLong(h3Address, 16);
    }

    public static boolean isPentagon(long h3) {
        return H3Index.H3_is_pentagon(h3);
    }

    public static boolean isPentagon(String h3Address) {
        return H3.isPentagon(H3.stringToH3(h3Address));
    }

    public static boolean h3IsValid(long h3) {
        int digit;
        int r;
        if (H3Index.H3_get_high_bit(h3) != 0) {
            return false;
        }
        if (H3Index.H3_get_mode(h3) != Constants.H3_CELL_MODE) {
            return false;
        }
        if (H3Index.H3_get_reserved_bits(h3) != 0) {
            return false;
        }
        int baseCell = H3Index.H3_get_base_cell(h3);
        if (baseCell < 0 || baseCell >= Constants.NUM_BASE_CELLS) {
            return false;
        }
        int res = H3Index.H3_get_resolution(h3);
        if (res < Constants.MIN_H3_RES || res > Constants.MAX_H3_RES) {
            return false;
        }
        boolean foundFirstNonZeroDigit = false;
        for (r = 1; r <= res; ++r) {
            digit = H3Index.H3_get_index_digit(h3, r);
            if (!foundFirstNonZeroDigit && digit != CoordIJK.Direction.CENTER_DIGIT.digit()) {
                foundFirstNonZeroDigit = true;
                if (BaseCells.isBaseCellPentagon(baseCell) && digit == CoordIJK.Direction.K_AXES_DIGIT.digit()) {
                    return false;
                }
            }
            if (digit >= CoordIJK.Direction.CENTER_DIGIT.digit() && digit < CoordIJK.Direction.NUM_DIGITS.digit()) continue;
            return false;
        }
        for (r = res + 1; r <= Constants.MAX_H3_RES; ++r) {
            digit = H3Index.H3_get_index_digit(h3, r);
            if (digit == CoordIJK.Direction.INVALID_DIGIT.digit()) continue;
            return false;
        }
        return true;
    }

    public static boolean h3IsValid(String h3Address) {
        return H3.h3IsValid(H3.stringToH3(h3Address));
    }

    public static long[] getLongRes0Cells() {
        long[] cells = new long[Constants.NUM_BASE_CELLS];
        for (int bc = 0; bc < Constants.NUM_BASE_CELLS; ++bc) {
            long baseCell = H3Index.H3_INIT;
            baseCell = H3Index.H3_set_mode(baseCell, Constants.H3_CELL_MODE);
            cells[bc] = baseCell = H3Index.H3_set_base_cell(baseCell, bc);
        }
        return cells;
    }

    public static String[] getStringRes0Cells() {
        return H3.h3ToStringList(H3.getLongRes0Cells());
    }

    public static LatLng h3ToLatLng(long h3) {
        FaceIJK fijk = H3Index.h3ToFaceIjk(h3);
        return fijk.faceIjkToGeo(H3Index.H3_get_resolution(h3));
    }

    public static LatLng h3ToLatLng(String h3Address) {
        return H3.h3ToLatLng(H3.stringToH3(h3Address));
    }

    public static CellBoundary h3ToGeoBoundary(long h3) {
        FaceIJK fijk = H3Index.h3ToFaceIjk(h3);
        if (H3Index.H3_is_pentagon(h3)) {
            return fijk.faceIjkPentToCellBoundary(H3Index.H3_get_resolution(h3), 0, Constants.NUM_PENT_VERTS);
        }
        return fijk.faceIjkToCellBoundary(H3Index.H3_get_resolution(h3), 0, Constants.NUM_HEX_VERTS);
    }

    public static CellBoundary h3ToGeoBoundary(String h3Address) {
        return H3.h3ToGeoBoundary(H3.stringToH3(h3Address));
    }

    public static long geoToH3(double lat, double lng, int res) {
        H3.checkResolution(res);
        return new LatLng(Math.toRadians(lat), Math.toRadians(lng)).geoToFaceIJK(res).faceIjkToH3(res);
    }

    public static String geoToH3Address(double lat, double lng, int res) {
        return H3.h3ToString(H3.geoToH3(lat, lng, res));
    }

    public static long h3ToParent(long h3) {
        int childRes = H3Index.H3_get_resolution(h3);
        if (childRes == 0) {
            throw new IllegalArgumentException("Input is a base cell");
        }
        long parentH = H3Index.H3_set_resolution(h3, childRes - 1);
        return H3Index.H3_set_index_digit(parentH, childRes, H3Index.H3_DIGIT_MASK);
    }

    public static String h3ToParent(String h3Address) {
        long parent = H3.h3ToParent(H3.stringToH3(h3Address));
        return H3.h3ToString(parent);
    }

    public static long[] h3ToChildren(long h3) {
        long[] children = new long[H3.cellToChildrenSize(h3)];
        int res = H3Index.H3_get_resolution(h3);
        Iterator.IterCellsChildren it = Iterator.iterInitParent(h3, res + 1);
        int pos = 0;
        while (it.h != 0L) {
            children[pos++] = it.h;
            Iterator.iterStepChild(it);
        }
        return children;
    }

    public static String[] h3ToChildren(String h3Address) {
        return H3.h3ToStringList(H3.h3ToChildren(H3.stringToH3(h3Address)));
    }

    public static String[] hexRing(String h3Address) {
        return H3.h3ToStringList(H3.hexRing(H3.stringToH3(h3Address)));
    }

    public static long[] hexRing(long h3) {
        return HexRing.hexRing(h3);
    }

    private static int cellToChildrenSize(long h) {
        int n = 1;
        if (H3Index.H3_is_pentagon(h)) {
            return 1 + 5 * (H3._ipow(7, n) - 1) / 6;
        }
        return H3._ipow(7, n);
    }

    private static int _ipow(int base, int exp) {
        int result = 1;
        while (exp != 0) {
            if ((exp & 1) != 0) {
                result *= base;
            }
            exp >>= 1;
            base *= base;
        }
        return result;
    }

    private static String[] h3ToStringList(long[] h3s) {
        return (String[])Arrays.stream(h3s).mapToObj(H3::h3ToString).toArray(String[]::new);
    }

    private static void checkResolution(int res) {
        if (res < 0 || res > Constants.MAX_H3_RES) {
            throw new IllegalArgumentException("resolution [" + res + "]  is out of range (must be 0 <= res <= 15)");
        }
    }
}

