/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorTransformer;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;

public abstract class AbstractPerFieldDerivedVectorTransformer
implements PerFieldDerivedVectorTransformer {
    protected Object formatVector(FieldInfo fieldInfo, CheckedSupplier<Object, IOException> vectorSupplier, CheckedSupplier<Object, IOException> vectorCloneSupplier) throws IOException {
        Object vectorValue = vectorSupplier.get();
        if (vectorValue instanceof byte[]) {
            BytesRef vectorBytesRef = new BytesRef((byte[])vectorValue);
            VectorDataType vectorDataType = FieldInfoExtractor.extractVectorDataType(fieldInfo);
            return KNNVectorFieldMapperUtil.deserializeStoredVector(vectorBytesRef, vectorDataType);
        }
        return vectorCloneSupplier.get();
    }
}

