/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.transfer;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.knn.index.KNNSettings;

public abstract class OffHeapVectorTransfer<T>
implements Closeable {
    private long vectorAddress;
    protected final int transferLimit;
    private List<T> vectorsToTransfer;

    public OffHeapVectorTransfer(int bytesPerVector, int totalVectorsToTransfer) {
        this.transferLimit = this.computeTransferLimit(bytesPerVector, totalVectorsToTransfer);
        this.vectorsToTransfer = new ArrayList<T>(this.transferLimit);
        this.vectorAddress = 0L;
    }

    private int computeTransferLimit(int bytesPerVector, int totalVectorsToTransfer) {
        int limit = (int)Math.max(1L, KNNSettings.getVectorStreamingMemoryLimit().getBytes() / (long)bytesPerVector);
        return Math.min(limit, totalVectorsToTransfer);
    }

    public boolean transfer(T vector, boolean append) throws IOException {
        this.vectorsToTransfer.add(vector);
        if (this.vectorsToTransfer.size() == this.transferLimit) {
            this.vectorAddress = this.transfer(this.vectorsToTransfer, append);
            this.vectorsToTransfer.clear();
            return true;
        }
        return false;
    }

    public boolean flush(boolean append) throws IOException {
        if (!this.vectorsToTransfer.isEmpty()) {
            this.vectorAddress = this.transfer(this.vectorsToTransfer, append);
            this.vectorsToTransfer.clear();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.vectorAddress != 0L) {
            this.deallocate();
        }
        this.reset();
    }

    public void reset() {
        this.vectorAddress = 0L;
        this.vectorsToTransfer = null;
    }

    protected abstract void deallocate();

    protected abstract long transfer(List<T> var1, boolean var2) throws IOException;

    @Generated
    public long getVectorAddress() {
        return this.vectorAddress;
    }

    @Generated
    public int getTransferLimit() {
        return this.transferLimit;
    }
}

