/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import org.apache.lucene.search.ScoreDoc;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.KNNEngine;

public final class MemoryOptimizedSearchScoreConverter {
    public static float distanceToRadialThreshold(float distance, SpaceType spaceType) {
        if (spaceType != SpaceType.COSINESIMIL) {
            return KNNEngine.LUCENE.distanceToRadialThreshold(Float.valueOf(distance), spaceType).floatValue();
        }
        float innerProductValue = KNNEngine.FAISS.distanceToRadialThreshold(Float.valueOf(distance), SpaceType.COSINESIMIL).floatValue();
        return SpaceType.INNER_PRODUCT.scoreTranslation(-innerProductValue);
    }

    public static float scoreToRadialThreshold(float score, SpaceType spaceType) {
        if (spaceType != SpaceType.COSINESIMIL) {
            return KNNEngine.LUCENE.scoreToRadialThreshold(Float.valueOf(score), spaceType).floatValue();
        }
        float innerProductValue = KNNEngine.FAISS.scoreToRadialThreshold(Float.valueOf(score), SpaceType.COSINESIMIL).floatValue();
        return SpaceType.INNER_PRODUCT.scoreTranslation(-innerProductValue);
    }

    public static void convertToCosineScore(ScoreDoc[] scoreDocs) {
        for (ScoreDoc scoreDoc : scoreDocs) {
            float innerProductValue = scoreDoc.score >= 1.0f ? scoreDoc.score - 1.0f : 1.0f - 1.0f / scoreDoc.score;
            scoreDoc.score = KNNEngine.FAISS.score(innerProductValue, SpaceType.COSINESIMIL);
        }
    }
}

