/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.KnnCollector;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.KNN990Codec.QuantizationConfigKNNCollector;
import org.opensearch.knn.index.quantizationservice.QuantizationService;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.quantization.models.quantizationParams.QuantizationParams;
import org.opensearch.knn.quantization.models.quantizationParams.ScalarQuantizationParams;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;

public final class SegmentLevelQuantizationUtil {
    public static boolean isAdcEnabled(SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) {
        if (segmentLevelQuantizationInfo == null) {
            return false;
        }
        QuantizationParams quantizationParams = segmentLevelQuantizationInfo.getQuantizationParams();
        if (quantizationParams instanceof ScalarQuantizationParams) {
            ScalarQuantizationParams scalarQuantizationParams = (ScalarQuantizationParams)quantizationParams;
            return scalarQuantizationParams.isEnableADC();
        }
        return false;
    }

    public static byte[] quantizeVector(float[] vector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) {
        if (segmentLevelQuantizationInfo == null) {
            return null;
        }
        QuantizationService quantizationService = QuantizationService.getInstance();
        return (byte[])quantizationService.quantize(segmentLevelQuantizationInfo.getQuantizationState(), vector, quantizationService.createQuantizationOutput(segmentLevelQuantizationInfo.getQuantizationParams()));
    }

    public static void transformVectorWithADC(float[] vector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo, SpaceType spaceType) {
        if (segmentLevelQuantizationInfo == null) {
            return;
        }
        QuantizationService quantizationService = QuantizationService.getInstance();
        quantizationService.transformWithADC(segmentLevelQuantizationInfo.getQuantizationState(), vector, spaceType);
    }

    static QuantizationState getQuantizationState(LeafReader leafReader, String fieldName) throws IOException {
        QuantizationConfigKNNCollector tempCollector = new QuantizationConfigKNNCollector();
        leafReader.searchNearestVectors(fieldName, new float[0], (KnnCollector)tempCollector, null);
        if (tempCollector.getQuantizationState() == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No quantization state found for field %s", fieldName));
        }
        return tempCollector.getQuantizationState();
    }

    @Generated
    private SegmentLevelQuantizationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

