/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNByteVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;

public final class KNNVectorValuesFactory {
    private static final Logger log = LogManager.getLogger(KNNVectorValuesFactory.class);

    public static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, KnnVectorValues knnVectorValues) {
        return KNNVectorValuesFactory.getVectorValues(vectorDataType, new KNNVectorValuesIterator.DocIdsIteratorValues(knnVectorValues));
    }

    public static <T> Supplier<KNNVectorValues<?>> getVectorValuesSupplier(VectorDataType vectorDataType, KnnVectorValues knnVectorValues) {
        return () -> KNNVectorValuesFactory.getVectorValues(vectorDataType, new KNNVectorValuesIterator.DocIdsIteratorValues(knnVectorValues));
    }

    public static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, DocIdSetIterator docIdSetIterator) {
        return KNNVectorValuesFactory.getVectorValues(vectorDataType, new KNNVectorValuesIterator.DocIdsIteratorValues(docIdSetIterator));
    }

    public static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, DocsWithFieldSet docIdWithFieldSet, Map<Integer, T> vectors) {
        return KNNVectorValuesFactory.getVectorValues(vectorDataType, new KNNVectorValuesIterator.FieldWriterIteratorValues<T>(docIdWithFieldSet, vectors));
    }

    public static <T> Supplier<KNNVectorValues<?>> getVectorValuesSupplier(VectorDataType vectorDataType, DocsWithFieldSet docIdWithFieldSet, Map<Integer, T> vectors) {
        return () -> KNNVectorValuesFactory.getVectorValues(vectorDataType, docIdWithFieldSet, vectors);
    }

    public static <T> KNNVectorValues<T> getVectorValues(FieldInfo fieldInfo, LeafReader leafReader) throws IOException {
        if (!fieldInfo.hasVectorValues()) {
            BinaryDocValues docIdSetIterator = DocValues.getBinary((LeafReader)leafReader, (String)fieldInfo.getName());
            KNNVectorValuesIterator.DocIdsIteratorValues vectorValuesIterator = new KNNVectorValuesIterator.DocIdsIteratorValues((DocIdSetIterator)docIdSetIterator);
            return KNNVectorValuesFactory.getVectorValues(FieldInfoExtractor.extractVectorDataType(fieldInfo), vectorValuesIterator);
        }
        if (fieldInfo.getVectorEncoding() == VectorEncoding.BYTE) {
            return KNNVectorValuesFactory.getVectorValues(FieldInfoExtractor.extractVectorDataType(fieldInfo), new KNNVectorValuesIterator.DocIdsIteratorValues((KnnVectorValues)leafReader.getByteVectorValues(fieldInfo.getName())));
        }
        if (fieldInfo.getVectorEncoding() == VectorEncoding.FLOAT32) {
            return KNNVectorValuesFactory.getVectorValues(FieldInfoExtractor.extractVectorDataType(fieldInfo), new KNNVectorValuesIterator.DocIdsIteratorValues((KnnVectorValues)leafReader.getFloatVectorValues(fieldInfo.getName())));
        }
        throw new IllegalArgumentException("Invalid Vector encoding provided, hence cannot return VectorValues");
    }

    public static <T> KNNVectorValues<T> getVectorValues(FieldInfo fieldInfo, DocValuesProducer docValuesProducer, KnnVectorsReader knnVectorsReader) throws IOException {
        if (fieldInfo.hasVectorValues() && knnVectorsReader != null) {
            ByteVectorValues knnVectorValues;
            if (fieldInfo.getVectorEncoding() == VectorEncoding.BYTE) {
                knnVectorValues = knnVectorsReader.getByteVectorValues(fieldInfo.getName());
            } else if (fieldInfo.getVectorEncoding() == VectorEncoding.FLOAT32) {
                knnVectorValues = knnVectorsReader.getFloatVectorValues(fieldInfo.getName());
            } else {
                throw new IllegalArgumentException("Invalid Vector encoding provided, hence cannot return VectorValues");
            }
            return KNNVectorValuesFactory.getVectorValues(FieldInfoExtractor.extractVectorDataType(fieldInfo), new KNNVectorValuesIterator.DocIdsIteratorValues((KnnVectorValues)knnVectorValues));
        }
        if (docValuesProducer != null) {
            return KNNVectorValuesFactory.getVectorValues(FieldInfoExtractor.extractVectorDataType(fieldInfo), new KNNVectorValuesIterator.DocIdsIteratorValues((DocIdSetIterator)docValuesProducer.getBinary(fieldInfo)));
        }
        throw new IllegalArgumentException("Field does not have vector values and DocValues");
    }

    private static <T> KNNVectorValues<T> getVectorValues(VectorDataType vectorDataType, KNNVectorValuesIterator knnVectorValuesIterator) {
        switch (vectorDataType) {
            case FLOAT: {
                return new KNNFloatVectorValues(knnVectorValuesIterator);
            }
            case BYTE: {
                return new KNNByteVectorValues(knnVectorValuesIterator);
            }
            case BINARY: {
                return new KNNBinaryVectorValues(knnVectorValuesIterator);
            }
        }
        throw new IllegalArgumentException("Invalid Vector data type provided, hence cannot return VectorValues");
    }

    private static <T> KNNVectorValues<T> getKNNVectorValuesForMerge(VectorDataType vectorDataType, FieldInfo fieldInfo, MergeState mergeState) {
        try {
            switch (fieldInfo.getVectorEncoding()) {
                case FLOAT32: {
                    FloatVectorValues mergedFloats = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues((FieldInfo)fieldInfo, (MergeState)mergeState);
                    return KNNVectorValuesFactory.getVectorValues(vectorDataType, (KnnVectorValues)mergedFloats);
                }
                case BYTE: {
                    ByteVectorValues mergedBytes = KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues((FieldInfo)fieldInfo, (MergeState)mergeState);
                    return KNNVectorValuesFactory.getVectorValues(vectorDataType, (KnnVectorValues)mergedBytes);
                }
            }
            throw new IllegalStateException("Unsupported vector encoding [" + String.valueOf(fieldInfo.getVectorEncoding()) + "]");
        }
        catch (IOException e) {
            log.error("Unable to merge vectors for field [{}]", (Object)fieldInfo.getName(), (Object)e);
            throw new IllegalStateException("Unable to merge vectors for field [" + fieldInfo.getName() + "]", e);
        }
    }

    public static Supplier<KNNVectorValues<?>> getKNNVectorValuesSupplierForMerge(VectorDataType vectorDataType, FieldInfo fieldInfo, MergeState mergeState) {
        return () -> KNNVectorValuesFactory.getKNNVectorValuesForMerge(vectorDataType, fieldInfo, mergeState);
    }
}

