/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNVectorAsCollectionOfFloatsSerializer;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;

public interface VectorValueExtractorStrategy {
    public static float[] extractFloatVector(KNNVectorValuesIterator iterator) throws IOException {
        return (float[])iterator.getVectorExtractorStrategy().extract(VectorDataType.FLOAT, iterator);
    }

    public static byte[] extractByteVector(KNNVectorValuesIterator iterator) throws IOException {
        return (byte[])iterator.getVectorExtractorStrategy().extract(VectorDataType.BYTE, iterator);
    }

    public static byte[] extractBinaryVector(KNNVectorValuesIterator iterator) throws IOException {
        return (byte[])iterator.getVectorExtractorStrategy().extract(VectorDataType.BINARY, iterator);
    }

    public <T> T extract(VectorDataType var1, KNNVectorValuesIterator var2) throws IOException;

    public static class FieldWriterIteratorVectorExtractor
    implements VectorValueExtractorStrategy {
        @Override
        public <T> T extract(VectorDataType vectorDataType, KNNVectorValuesIterator vectorValuesIterator) throws IOException {
            switch (vectorDataType) {
                case FLOAT: {
                    return ((KNNVectorValuesIterator.FieldWriterIteratorValues)vectorValuesIterator).vectorsValue();
                }
                case BYTE: 
                case BINARY: {
                    return ((KNNVectorValuesIterator.FieldWriterIteratorValues)vectorValuesIterator).vectorsValue();
                }
            }
            throw new IllegalArgumentException("Valid Vector data type not passed to extract vector from FieldWriterIteratorVectorExtractor strategy");
        }
    }

    public static class DISIVectorExtractor
    implements VectorValueExtractorStrategy {
        @Override
        public <T> T extract(VectorDataType vectorDataType, KNNVectorValuesIterator vectorValuesIterator) throws IOException {
            DocIdSetIterator docIdSetIterator = vectorValuesIterator.getDocIdSetIterator();
            if (docIdSetIterator instanceof BinaryDocValues) {
                return this.extractFromBinaryDocValues(vectorDataType, (BinaryDocValues)docIdSetIterator);
            }
            if (docIdSetIterator instanceof KnnVectorValues.DocIndexIterator) {
                return this.extractFromKnnVectorValues(vectorDataType, (KNNVectorValuesIterator.DocIdsIteratorValues)vectorValuesIterator, (KnnVectorValues.DocIndexIterator)docIdSetIterator);
            }
            throw new IllegalArgumentException("VectorValuesIterator is not of a valid type. Valid Types are: BinaryDocValues and KnnVectorValues.DocIndexIterator");
        }

        private <T> T extractFromBinaryDocValues(VectorDataType vectorDataType, BinaryDocValues values) throws IOException {
            BytesRef bytesRef = values.binaryValue();
            if (vectorDataType == VectorDataType.FLOAT) {
                return (T)this.getFloatVectorFromByteRef(bytesRef);
            }
            if (vectorDataType == VectorDataType.BYTE || vectorDataType == VectorDataType.BINARY) {
                return (T)ArrayUtil.copyOfSubArray((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)(bytesRef.offset + bytesRef.length));
            }
            throw new IllegalArgumentException("Invalid vector data type for BinaryDocValues");
        }

        private <T> T extractFromKnnVectorValues(VectorDataType vectorDataType, KNNVectorValuesIterator.DocIdsIteratorValues docIdsIteratorValues, KnnVectorValues.DocIndexIterator docIdSetIterator) throws IOException {
            int ord = docIdSetIterator.index();
            if (ord == docIdsIteratorValues.getLastOrd()) {
                return (T)docIdsIteratorValues.getLastAccessedVector();
            }
            docIdsIteratorValues.setLastOrd(ord);
            if (vectorDataType == VectorDataType.FLOAT) {
                FloatVectorValues knnVectorValues = (FloatVectorValues)docIdsIteratorValues.getKnnVectorValues();
                docIdsIteratorValues.setLastAccessedVector(knnVectorValues.vectorValue(ord));
            } else if (vectorDataType == VectorDataType.BYTE || vectorDataType == VectorDataType.BINARY) {
                ByteVectorValues byteVectorValues = (ByteVectorValues)docIdsIteratorValues.getKnnVectorValues();
                docIdsIteratorValues.setLastAccessedVector(byteVectorValues.vectorValue(ord));
            } else {
                throw new IllegalArgumentException("Invalid vector data type for KnnVectorValues");
            }
            return (T)docIdsIteratorValues.getLastAccessedVector();
        }

        private float[] getFloatVectorFromByteRef(BytesRef bytesRef) {
            KNNVectorAsCollectionOfFloatsSerializer vectorSerializer = KNNVectorAsCollectionOfFloatsSerializer.INSTANCE;
            return vectorSerializer.byteToFloatArray(bytesRef);
        }
    }
}

