/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationOutput;

import java.util.Arrays;
import lombok.Generated;
import org.opensearch.knn.quantization.models.quantizationOutput.QuantizationOutput;

public class BinaryQuantizationOutput
implements QuantizationOutput<byte[]> {
    private byte[] quantizedVector;
    private final int bitsPerCoordinate;
    private int currentVectorLength = -1;

    @Override
    public void prepareQuantizedVector(int vectorLength) {
        if (vectorLength <= 0) {
            throw new IllegalArgumentException("Vector length must be greater than zero.");
        }
        if (vectorLength != this.currentVectorLength) {
            int totalBits = this.bitsPerCoordinate * vectorLength;
            int byteLength = totalBits + 7 >> 3;
            this.quantizedVector = new byte[byteLength];
            this.currentVectorLength = vectorLength;
        } else {
            Arrays.fill(this.quantizedVector, (byte)0);
        }
    }

    @Override
    public boolean isPrepared(int vectorLength) {
        return vectorLength == this.currentVectorLength && this.quantizedVector != null;
    }

    @Override
    public byte[] getQuantizedVector() {
        return this.quantizedVector;
    }

    @Override
    public byte[] getQuantizedVectorCopy() {
        byte[] clonedByteArray = new byte[this.quantizedVector.length];
        System.arraycopy(this.quantizedVector, 0, clonedByteArray, 0, this.quantizedVector.length);
        return clonedByteArray;
    }

    @Generated
    public int getBitsPerCoordinate() {
        return this.bitsPerCoordinate;
    }

    @Generated
    public int getCurrentVectorLength() {
        return this.currentVectorLength;
    }

    @Generated
    public BinaryQuantizationOutput(int bitsPerCoordinate) {
        this.bitsPerCoordinate = bitsPerCoordinate;
    }
}

