/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationState;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class QuantizationStateCache
implements Closeable {
    @Generated
    private static final Logger log = LogManager.getLogger(QuantizationStateCache.class);
    private static volatile QuantizationStateCache instance;
    private static ThreadPool threadPool;
    private Cache<String, QuantizationState> cache;
    private long maxCacheSizeInKB = ((ByteSizeValue)KNNSettings.state().getSettingValue("knn.quantization.cache.size.limit")).getKb();
    private Instant evictedDueToSizeAt;
    private Scheduler.Cancellable maintenanceTask;

    @VisibleForTesting
    QuantizationStateCache() {
        this.buildCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static QuantizationStateCache getInstance() {
        if (instance != null) return instance;
        Class<QuantizationStateCache> clazz = QuantizationStateCache.class;
        synchronized (QuantizationStateCache.class) {
            if (instance != null) return instance;
            instance = new QuantizationStateCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void buildCache() {
        long maxCacheSizeInBytes = this.maxCacheSizeInKB * 1024L;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(maxCacheSizeInBytes).weigher((k, v) -> {
            try {
                return ((QuantizationState)v).toByteArray().length;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).expireAfterAccess(((TimeValue)KNNSettings.state().getSettingValue("knn.quantization.cache.expiry.minutes")).getMinutes(), TimeUnit.MINUTES).removalListener(this::onRemoval).build();
        if (threadPool != null) {
            this.startMaintenance(this.cache);
        } else {
            log.warn("ThreadPool is null during QuantizationStateCache initialization. Maintenance will not start.");
        }
    }

    private void startMaintenance(Cache<String, QuantizationState> cacheInstance) {
        if (this.maintenanceTask != null) {
            this.maintenanceTask.cancel();
        }
        Runnable cleanUp = () -> {
            try {
                cacheInstance.cleanUp();
            }
            catch (Exception e) {
                log.error("Error cleaning up cache", (Throwable)e);
            }
        };
        TimeValue interval = (TimeValue)KNNSettings.state().getSettingValue("knn.quantization.cache.expiry.minutes");
        this.maintenanceTask = threadPool.scheduleWithFixedDelay(cleanUp, interval, "management");
    }

    synchronized void rebuildCache() {
        this.clear();
        this.buildCache();
    }

    QuantizationState getQuantizationState(String fieldName, Callable<QuantizationState> valueLoader) {
        try {
            return (QuantizationState)this.cache.get((Object)fieldName, valueLoader);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void evict(String fieldName) {
        this.cache.invalidate((Object)fieldName);
    }

    private void onRemoval(RemovalNotification<String, QuantizationState> removalNotification) {
        if (RemovalCause.SIZE == removalNotification.getCause()) {
            this.updateEvictedDueToSizeAt();
            log.info("[KNN] Quantization state evicted from cache. Key {}, Reason: {}", removalNotification.getKey(), (Object)removalNotification.getCause());
        }
    }

    void setMaxCacheSizeInKB(long maxCacheSizeInKB) {
        this.maxCacheSizeInKB = maxCacheSizeInKB;
    }

    private void updateEvictedDueToSizeAt() {
        this.evictedDueToSizeAt = Instant.now();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        if (this.maintenanceTask != null) {
            this.maintenanceTask.cancel();
        }
    }

    @Generated
    public static void setThreadPool(ThreadPool threadPool) {
        QuantizationStateCache.threadPool = threadPool;
    }

    @Generated
    public long getMaxCacheSizeInKB() {
        return this.maxCacheSizeInKB;
    }

    @Generated
    public Instant getEvictedDueToSizeAt() {
        return this.evictedDueToSizeAt;
    }

    @Generated
    public Scheduler.Cancellable getMaintenanceTask() {
        return this.maintenanceTask;
    }
}

