/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.search.processor.mmr;

import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.SpaceTypeResolver;

public class MMRVectorFieldInfo {
    private String indexName;
    private String fieldPath;
    private VectorDataType vectorDataType;
    private String modelId;
    private SpaceType spaceType;
    private boolean unmapped;
    private String fieldType;

    public MMRVectorFieldInfo(SpaceType spaceType, VectorDataType vectorDataType) {
        this.spaceType = spaceType;
        this.vectorDataType = vectorDataType;
    }

    public boolean isKNNVectorField() {
        return "knn_vector".equals(this.fieldType);
    }

    public void setKnnConfig(@NonNull Map<String, Object> knnConfig) {
        if (knnConfig == null) {
            throw new NullPointerException("knnConfig is marked non-null but is null");
        }
        this.setVectorDataTypeByConfig(knnConfig);
        if (this.setModelIdIfPresent(knnConfig)) {
            return;
        }
        if (this.setSpaceTypeIfPresent(knnConfig)) {
            return;
        }
        this.spaceType = SpaceTypeResolver.getDefaultSpaceType(this.vectorDataType);
    }

    public void setIndexNameByIndexMetadata(@NonNull IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            throw new NullPointerException("indexMetadata is marked non-null but is null");
        }
        this.indexName = indexMetadata.getIndex().getName();
    }

    private void setVectorDataTypeByConfig(Map<String, Object> knnConfig) {
        String dataType = (String)knnConfig.get("data_type");
        this.vectorDataType = dataType == null ? VectorDataType.DEFAULT : VectorDataType.get(dataType);
    }

    private boolean setModelIdIfPresent(Map<String, Object> knnConfig) {
        String modelId = (String)knnConfig.get("model_id");
        if (modelId != null) {
            this.modelId = modelId;
            return true;
        }
        return false;
    }

    private boolean setSpaceTypeIfPresent(Map<String, Object> knnConfig) {
        String spaceType;
        String topLevelSpaceType = (String)knnConfig.get("space_type");
        if (topLevelSpaceType != null) {
            this.spaceType = SpaceType.getSpace(topLevelSpaceType);
            return true;
        }
        Map knnMethod = (Map)knnConfig.get("method");
        if (knnMethod != null && (spaceType = (String)knnMethod.get("space_type")) != null) {
            this.spaceType = SpaceType.getSpace(spaceType);
            return true;
        }
        return false;
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public String getFieldPath() {
        return this.fieldPath;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    @Generated
    public boolean isUnmapped() {
        return this.unmapped;
    }

    @Generated
    public String getFieldType() {
        return this.fieldType;
    }

    @Generated
    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Generated
    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Generated
    public void setVectorDataType(VectorDataType vectorDataType) {
        this.vectorDataType = vectorDataType;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setSpaceType(SpaceType spaceType) {
        this.spaceType = spaceType;
    }

    @Generated
    public void setUnmapped(boolean unmapped) {
        this.unmapped = unmapped;
    }

    @Generated
    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MMRVectorFieldInfo)) {
            return false;
        }
        MMRVectorFieldInfo other = (MMRVectorFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUnmapped() != other.isUnmapped()) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$fieldPath = this.getFieldPath();
        String other$fieldPath = other.getFieldPath();
        if (this$fieldPath == null ? other$fieldPath != null : !this$fieldPath.equals(other$fieldPath)) {
            return false;
        }
        VectorDataType this$vectorDataType = this.getVectorDataType();
        VectorDataType other$vectorDataType = other.getVectorDataType();
        if (this$vectorDataType == null ? other$vectorDataType != null : !((Object)((Object)this$vectorDataType)).equals((Object)other$vectorDataType)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        SpaceType this$spaceType = this.getSpaceType();
        SpaceType other$spaceType = other.getSpaceType();
        if (this$spaceType == null ? other$spaceType != null : !((Object)((Object)this$spaceType)).equals((Object)other$spaceType)) {
            return false;
        }
        String this$fieldType = this.getFieldType();
        String other$fieldType = other.getFieldType();
        return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MMRVectorFieldInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUnmapped() ? 79 : 97);
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $fieldPath = this.getFieldPath();
        result = result * 59 + ($fieldPath == null ? 43 : $fieldPath.hashCode());
        VectorDataType $vectorDataType = this.getVectorDataType();
        result = result * 59 + ($vectorDataType == null ? 43 : ((Object)((Object)$vectorDataType)).hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        SpaceType $spaceType = this.getSpaceType();
        result = result * 59 + ($spaceType == null ? 43 : ((Object)((Object)$spaceType)).hashCode());
        String $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MMRVectorFieldInfo(indexName=" + this.getIndexName() + ", fieldPath=" + this.getFieldPath() + ", vectorDataType=" + String.valueOf((Object)this.getVectorDataType()) + ", modelId=" + this.getModelId() + ", spaceType=" + String.valueOf((Object)this.getSpaceType()) + ", unmapped=" + this.isUnmapped() + ", fieldType=" + this.getFieldType() + ")";
    }

    @Generated
    public MMRVectorFieldInfo() {
    }
}

