/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ChainedTokenCredential;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;

public class ChainedTokenCredentialBuilder {
    private final Deque<TokenCredential> credentials = new ArrayDeque<TokenCredential>();
    private static final ClientLogger LOGGER = new ClientLogger(ChainedTokenCredentialBuilder.class);

    public ChainedTokenCredentialBuilder addFirst(TokenCredential credential) {
        this.credentials.addFirst(credential);
        return this;
    }

    public ChainedTokenCredentialBuilder addLast(TokenCredential credential) {
        this.credentials.addLast(credential);
        return this;
    }

    public ChainedTokenCredentialBuilder addAll(Collection<? extends TokenCredential> credentials) {
        this.credentials.addAll(credentials);
        return this;
    }

    public ChainedTokenCredential build() {
        if (this.credentials.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("At least one credential must be added to the chain."));
        }
        return new ChainedTokenCredential(new ArrayList<TokenCredential>(this.credentials));
    }
}

