/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.azure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.azure.AzureRepository;
import org.opensearch.repositories.azure.AzureStorageService;
import org.opensearch.repositories.azure.AzureStorageSettings;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    public static final String REPOSITORY_THREAD_POOL_NAME = "repository_azure";
    final AzureStorageService azureStoreService;

    public AzureRepositoryPlugin(Settings settings) {
        this.azureStoreService = this.createAzureStoreService(settings);
    }

    AzureStorageService createAzureStoreService(Settings settings) {
        return new AzureStorageService(settings);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("azure", metadata -> new AzureRepository(metadata, namedXContentRegistry, this.azureStoreService, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AzureStorageSettings.ACCOUNT_SETTING, AzureStorageSettings.KEY_SETTING, AzureStorageSettings.SAS_TOKEN_SETTING, AzureStorageSettings.TOKEN_CREDENTIAL_TYPE_SETTING, AzureStorageSettings.ENDPOINT_SUFFIX_SETTING, AzureStorageSettings.TIMEOUT_SETTING, AzureStorageSettings.MAX_RETRIES_SETTING, AzureStorageSettings.CONNECT_TIMEOUT_SETTING, AzureStorageSettings.WRITE_TIMEOUT_SETTING, AzureStorageSettings.READ_TIMEOUT_SETTING, AzureStorageSettings.RESPONSE_TIMEOUT_SETTING, AzureStorageSettings.PROXY_TYPE_SETTING, AzureStorageSettings.PROXY_HOST_SETTING, AzureStorageSettings.PROXY_PORT_SETTING, AzureStorageSettings.PROXY_USERNAME_SETTING, AzureStorageSettings.PROXY_PASSWORD_SETTING);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return Collections.singletonList(AzureRepositoryPlugin.executorBuilder());
    }

    public static ExecutorBuilder<?> executorBuilder() {
        return new ScalingExecutorBuilder(REPOSITORY_THREAD_POOL_NAME, 0, 32, TimeValue.timeValueSeconds((long)30L));
    }

    public void reload(Settings settings) {
        Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(settings);
        if (clientsSettings.isEmpty()) {
            throw new SettingsException("If you want to use an azure repository, you need to define a client configuration.");
        }
        this.azureStoreService.refreshAndClearCache(clientsSettings);
    }
}

