/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import java.util.function.Predicate;

class ContinuationState<C> {
    private final Predicate<C> continuationPredicate;
    private C lastContinuationToken;
    private boolean isDone;

    ContinuationState(C token, Predicate<C> continuationPredicate) {
        this.lastContinuationToken = token;
        this.continuationPredicate = continuationPredicate;
    }

    void setLastContinuationToken(C token) {
        this.isDone = !this.continuationPredicate.test(token);
        this.lastContinuationToken = token;
    }

    C getLastContinuationToken() {
        return this.lastContinuationToken;
    }

    boolean isDone() {
        return this.isDone;
    }
}

