/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.GenericArrays;
import com.selectivem.collections.ImmutableMapImpl;
import com.selectivem.collections.IndexRefMapImpl;
import com.selectivem.collections.IndexedImmutableSetImpl;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class CompactMapGroupBuilder<K, V> {
    private final IndexedImmutableSetImpl<K> keyToIndexMap;
    private final Function<K, V> missingValueSupplier;
    private int estimatedBackingArraySize = 0;
    private int estimatedObjectOverheadSize = 0;

    public CompactMapGroupBuilder(Set<K> keySuperSet, Function<K, V> missingValueSupplier) {
        this.keyToIndexMap = IndexedImmutableSetImpl.of(keySuperSet);
        this.missingValueSupplier = missingValueSupplier;
    }

    public CompactMapGroupBuilder(Set<K> keySuperSet) {
        this(keySuperSet, null);
    }

    public Map<K, V> of(Map<K, V> original) {
        MapBuilder<K, V> builder = this.createMapBuilder();
        original.forEach(builder::put);
        return builder.build();
    }

    public MapBuilder<K, V> createMapBuilder() {
        return new MapBuilder<K, V>(this, this.missingValueSupplier);
    }

    public int getEstimatedByteSize() {
        return this.estimatedBackingArraySize + this.estimatedObjectOverheadSize;
    }

    public static class MapBuilder<K, V> {
        private final CompactMapGroupBuilder<K, V> root;
        private V[] values;
        private final Function<K, V> missingValueSupplier;
        private int size = 0;
        private int minIndex = Integer.MAX_VALUE;
        private int maxIndex = Integer.MIN_VALUE;
        private int estimatedSize = 36;

        MapBuilder(CompactMapGroupBuilder<K, V> root, Function<K, V> missingValueSupplier) {
            this.root = root;
            this.values = GenericArrays.create(((CompactMapGroupBuilder)root).keyToIndexMap.size());
            this.missingValueSupplier = missingValueSupplier;
            ((CompactMapGroupBuilder)root).estimatedObjectOverheadSize += 36;
        }

        public void put(K key, V value) {
            this.checkState();
            int i = ((CompactMapGroupBuilder)this.root).keyToIndexMap.elementToIndex(key);
            if (i == -1) {
                throw new IllegalArgumentException("Invalid key " + key + "; not present in keySuperSet");
            }
            if (value == null) {
                throw new IllegalArgumentException("Does not support null values; key: " + key);
            }
            if (this.values[i] != null) {
                this.values[i] = value;
            } else {
                this.putNonExistent(i, value);
            }
        }

        public V get(K key) {
            this.checkState();
            int i = ((CompactMapGroupBuilder)this.root).keyToIndexMap.elementToIndex(key);
            if (i == -1) {
                throw new IllegalArgumentException("Invalid key " + key + "; not present in keySuperSet");
            }
            V value = this.values[i];
            if (value == null && this.missingValueSupplier != null) {
                value = this.missingValueSupplier.apply(key);
                this.putNonExistent(i, value);
            }
            return value;
        }

        public int size() {
            return this.size;
        }

        public Map<K, V> build() {
            return this.build(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V2> Map<K, V2> build(Function<V, V2> valueMappingFunction) {
            this.checkState();
            try {
                int valuesArrayOffset;
                Object[] compactedValues;
                ImmutableMapImpl<K, V2> basicHashTable;
                int estimatedBasicHashTableSize;
                if (this.size == 0) {
                    ImmutableMapImpl immutableMapImpl = ImmutableMapImpl.empty();
                    return immutableMapImpl;
                }
                if (this.size == 1) {
                    int i = this.findNext(0);
                    V2 value = MapBuilder.mapValue(this.values[i], valueMappingFunction);
                    Object key = ((CompactMapGroupBuilder)this.root).keyToIndexMap.indexToElement(i);
                    ImmutableMapImpl immutableMapImpl = ImmutableMapImpl.of(key, value);
                    return immutableMapImpl;
                }
                if (this.size == 2) {
                    int i = this.findNext(0);
                    V2 v1 = MapBuilder.mapValue(this.values[i], valueMappingFunction);
                    Object k1 = ((CompactMapGroupBuilder)this.root).keyToIndexMap.indexToElement(i);
                    i = this.findNext(i + 1);
                    V2 v2 = MapBuilder.mapValue(this.values[i], valueMappingFunction);
                    Object k2 = ((CompactMapGroupBuilder)this.root).keyToIndexMap.indexToElement(i);
                    ImmutableMapImpl immutableMapImpl = ImmutableMapImpl.of(k1, v1, k2, v2);
                    return immutableMapImpl;
                }
                V2[] mappedValues = GenericArrays.mapInPlace(this.values, valueMappingFunction);
                int estimatedIndexRefMapSize = this.estimatedSize;
                if (this.minIndex > 4 || this.maxIndex < this.values.length - 5) {
                    estimatedIndexRefMapSize -= (this.minIndex + (this.values.length - this.maxIndex)) * 8;
                }
                if ((estimatedBasicHashTableSize = ImmutableMapImpl.HashArrayBackedMap.getEstimatedByteSize(this.size)) < estimatedIndexRefMapSize && (basicHashTable = this.buildBasicHashTable(mappedValues, estimatedIndexRefMapSize)) != null && basicHashTable.getEstimatedByteSize() < estimatedIndexRefMapSize) {
                    ((CompactMapGroupBuilder)this.root).estimatedBackingArraySize += basicHashTable.getEstimatedByteSize() - this.estimatedSize;
                    ImmutableMapImpl<K, V2> k2 = basicHashTable;
                    return k2;
                }
                if (this.minIndex > 4 || this.maxIndex < this.values.length - 5) {
                    compactedValues = GenericArrays.create(this.maxIndex - this.minIndex + 1);
                    System.arraycopy(mappedValues, this.minIndex, compactedValues, 0, this.maxIndex - this.minIndex + 1);
                    valuesArrayOffset = this.minIndex;
                } else {
                    compactedValues = mappedValues;
                    valuesArrayOffset = 0;
                }
                IndexRefMapImpl indexRefMapImpl = new IndexRefMapImpl(compactedValues, this.size, ((CompactMapGroupBuilder)this.root).keyToIndexMap, valuesArrayOffset);
                return indexRefMapImpl;
            }
            finally {
                this.values = null;
            }
        }

        private void putNonExistent(int keyIndex, V value) {
            this.values[keyIndex] = value;
            if (this.minIndex > keyIndex) {
                this.minIndex = keyIndex;
            }
            if (this.maxIndex < keyIndex) {
                this.maxIndex = keyIndex;
            }
            ++this.size;
            if (this.size <= 2) {
                ((CompactMapGroupBuilder)this.root).estimatedBackingArraySize += 8;
                this.estimatedSize += 8;
            } else if (this.size == 3) {
                ((CompactMapGroupBuilder)this.root).estimatedBackingArraySize += (this.values.length - 2) * 8;
                this.estimatedSize += (this.values.length - 2) * 8;
            }
        }

        private int findNext(int start) {
            for (int i = start; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                return i;
            }
            return -1;
        }

        private void checkState() {
            if (this.values == null) {
                throw new IllegalStateException("This builder instance was already built");
            }
        }

        private <V2> ImmutableMapImpl<K, V2> buildBasicHashTable(V2[] values, int maxByteSize) {
            ImmutableMapImpl.InternalBuilder builder = ImmutableMapImpl.InternalBuilder.create(this.size);
            for (int i = 0; i < values.length; ++i) {
                V2 value = values[i];
                if (value == null || (builder = builder.with(((CompactMapGroupBuilder)this.root).keyToIndexMap.indexToElement(i), value)).getEstimatedByteSize() <= maxByteSize) continue;
                return null;
            }
            return builder.build();
        }

        private static <V, V2> V2 mapValue(V value, Function<V, V2> valueMappingFunction) {
            if (valueMappingFunction == null) {
                V value2 = value;
                return (V2)value2;
            }
            return valueMappingFunction.apply(value);
        }
    }
}

