/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.Rankdir;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;

public abstract class AbstractEntityImageBorder
extends AbstractEntityImage {
    public final EntityPosition entityPosition;
    protected final Cluster parent;
    protected final Bibliotekon bibliotekon;
    protected final Rankdir rankdir;

    protected abstract StyleSignatureBasic getSignature();

    protected final Style getStyle() {
        Stereotype stereotype = this.getEntity().getStereotype();
        return this.getSignature().withTOBECHANGED(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    AbstractEntityImageBorder(Entity leaf, Cluster parent, Bibliotekon bibliotekon, FontParam fontParam) {
        super(leaf);
        this.parent = parent;
        this.bibliotekon = bibliotekon;
        this.entityPosition = leaf.getEntityPosition();
        this.rankdir = this.getSkinParam().getRankdir();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
    }

    protected final TextBlock getDesc() {
        Entity leaf = this.getEntity();
        FontConfiguration fc = FontConfiguration.create(this.getSkinParam(), this.getStyle());
        return leaf.getDisplay().create(fc, HorizontalAlignment.CENTER, this.getSkinParam());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.entityPosition.getDimension(this.rankdir);
    }

    @Override
    public ShapeType getShapeType() {
        return this.entityPosition.getShapeType();
    }
}

