/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.Flags;
import com.strobel.core.ArrayUtilities;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import java.util.List;

public class JavaModifierToken
extends JavaTokenNode {
    private static final List<Flags.Flag> ALL_MODIFIERS = ArrayUtilities.asUnmodifiableList(Flags.Flag.values());
    private Flags.Flag _modifier;

    public static List<Flags.Flag> allModifiers() {
        return ALL_MODIFIERS;
    }

    public JavaModifierToken(Flags.Flag modifier) {
        this(TextLocation.EMPTY, modifier);
    }

    public JavaModifierToken(TextLocation startLocation, Flags.Flag modifier) {
        super(startLocation);
        this._modifier = modifier;
    }

    public final Flags.Flag getModifier() {
        return this._modifier;
    }

    public final void setModifier(Flags.Flag modifier) {
        this.verifyNotFrozen();
        this._modifier = modifier;
    }

    public static String getModifierName(Flags.Flag modifier) {
        return String.valueOf((Object)modifier);
    }

    @Override
    public String getText(JavaFormattingOptions options) {
        return JavaModifierToken.getModifierName(this._modifier);
    }

    @Override
    protected int getTokenLength() {
        return JavaModifierToken.getModifierName(this._modifier).length();
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof JavaModifierToken && ((JavaModifierToken)other)._modifier == this._modifier;
    }
}

