/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: tf_ops.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace TF {
/// Computes the absolute value of a tensor.
/// Given a tensor `x`, this operation returns a tensor containing the absolute
/// value of each element in `x`. For example, if x is an input element and y is
/// an output element, this operation computes \\(y = |x|\\).
class AbsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes acos of x element-wise.
/// Provided an input tensor, the `tf.math.acos` operation returns the inverse cosine of each element of the tensor. If `y = tf.math.cos(x)` then, `x = tf.math.acos(y)`.
/// 
///   Input range is `[-1, 1]` and the output has a range of `[0, pi]`.
class AcosOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes inverse hyperbolic cosine of x element-wise.
/// Given an input tensor, the function computes inverse hyperbolic cosine of every element.
/// Input range is `[1, inf]`. It returns `nan` if the input lies outside the range.
/// 
/// ```python
/// x = tf.constant([-2, -0.5, 1, 1.2, 200, 10000, float("inf")])
/// tf.math.acosh(x) ==> [nan nan 0. 0.62236255 5.9914584 9.903487 inf]
/// ```
class AcoshOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Add all input tensors element wise.
/// Inputs must be of same size and shape.
/// 
///   ```python
///   x = [9, 7, 10]
///   tf.math.add_n(x) ==> 26
///   ```
class AddNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x + y element-wise.
/// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
/// 
/// Given two input tensors, the `tf.add` operation computes the sum for every element in the tensor.
/// 
/// Both input and output have a range `(-inf, inf)`.
class AddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x + y element-wise.
/// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class AddV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adjust the contrast of one or more images.
/// `images` is a tensor of at least 3 dimensions.  The last 3 dimensions are
/// interpreted as `[height, width, channels]`.  The other dimensions only
/// represent a collection of images, such as `[batch, height, width, channels].`
/// 
/// Contrast is adjusted independently for each channel of each image.
/// 
/// For each channel, the Op first computes the mean of the image pixels in the
/// channel and then adjusts each component of each pixel to
/// `(x - mean) * contrast_factor + mean`.
class AdjustContrastv2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adjust the hue of one or more images.
/// `images` is a tensor of at least 3 dimensions.  The last dimension is
/// interpreted as channels, and must be three.
/// 
/// The input image is considered in the RGB colorspace. Conceptually, the RGB
/// colors are first mapped into HSV. A delta is then applied all the hue values,
/// and then remapped back to RGB colorspace.
class AdjustHueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adjust the saturation of one or more images.
/// `images` is a tensor of at least 3 dimensions.  The last dimension is
/// interpreted as channels, and must be three.
/// 
/// The input image is considered in the RGB colorspace. Conceptually, the RGB
/// colors are first mapped into HSV. A scale is then applied all the saturation
/// values, and then remapped back to RGB colorspace.
class AdjustSaturationOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the "logical and" of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class AllOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An Op to exchange data across TPU replicas.
/// On each replica, the input is split into `split_count` blocks along
/// `split_dimension` and send to the other replicas given group_assignment. After
/// receiving `split_count` - 1 blocks from other replicas, we concatenate the
/// blocks along `concat_dimension` as the output.
/// 
/// For example, suppose there are 2 TPU replicas:
/// replica 0 receives input: `[[A, B]]`
/// replica 1 receives input: `[[C, D]]`
/// 
/// group_assignment=`[[0, 1]]`
/// concat_dimension=0
/// split_dimension=1
/// split_count=2
/// 
/// replica 0's output: `[[A], [C]]`
/// replica 1's output: `[[B], [D]]`
class AllToAllOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the argument of a complex number.
/// Given a tensor `input` of complex numbers, this operation returns a tensor of
/// type `float` that is the argument of each element in `input`. All elements in
/// `input` must be complex numbers of the form \\(a + bj\\), where *a*
/// is the real part and *b* is the imaginary part.
/// 
/// The argument returned by this operation is of the form \\(atan2(b, a)\\).
/// 
/// For example:
/// 
/// ```
/// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
/// tf.math.angle(input) ==> [2.0132, 1.056]
/// ```
/// 
/// @compatibility(numpy)
/// Equivalent to np.angle.
/// @end_compatibility
class AngleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for an iterator resource.
class AnonymousIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for an iterator resource.
class AnonymousIteratorV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for an iterator resource.
class AnonymousIteratorV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class AnonymousMemoryCacheOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for a multi device iterator resource.
class AnonymousMultiDeviceIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for a multi device iterator resource.
class AnonymousMultiDeviceIteratorV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class AnonymousRandomSeedGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class AnonymousSeedGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the "logical or" of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class AnyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns min/max k values and their indices of the input operand in an approximate manner.
/// See https://arxiv.org/abs/2206.14286 for the algorithm details.
/// This op is only optimized on TPU currently.
class ApproxTopKOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of abs(x-y) < tolerance element-wise.
class ApproximateEqualOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the index with the largest value across dimensions of a tensor.
/// Note that in case of ties the identity of the return value is not guaranteed.
/// 
/// Usage:
///   ```python
///   import tensorflow as tf
///   a = [1, 10, 26.9, 2.8, 166.32, 62.3]
///   b = tf.math.argmax(input = a)
///   c = tf.keras.backend.eval(b)
///   # c = 4
///   # here a[4] = 166.32 which is the largest element of a across axis 0
///   ```
class ArgMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the index with the smallest value across dimensions of a tensor.
/// Note that in case of ties the identity of the return value is not guaranteed.
/// 
/// Usage:
///   ```python
///   import tensorflow as tf
///   a = [1, 10, 26.9, 2.8, 166.32, 62.3]
///   b = tf.math.argmin(input = a)
///   c = tf.keras.backend.eval(b)
///   # c = 0
///   # here a[0] = 1 which is the smallest element of a across axis 0
///   ```
class ArgMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts each entry in the given tensor to strings.
/// Supports many numeric types and boolean.
/// 
/// For Unicode, see the
/// [https://www.tensorflow.org/text/guide/unicode](Working with Unicode text)
/// tutorial.
/// 
/// Examples:
/// 
/// >>> tf.strings.as_string([3, 2])
/// <tf.Tensor: shape=(2,), dtype=string, numpy=array([b'3', b'2'], dtype=object)>
/// >>> tf.strings.as_string([3.1415926, 2.71828], precision=2).numpy()
/// array([b'3.14', b'2.72'], dtype=object)
class AsStringOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the trignometric inverse sine of x element-wise.
/// The `tf.math.asin` operation returns the inverse of `tf.math.sin`, such that
/// if `y = tf.math.sin(x)` then, `x = tf.math.asin(y)`.
/// 
/// **Note**: The output of `tf.math.asin` will lie within the invertible range
/// of sine, i.e [-pi/2, pi/2].
/// 
/// For example:
/// 
/// ```python
/// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
/// x = tf.constant([1.047, 0.785])
/// y = tf.math.sin(x) # [0.8659266, 0.7068252]
/// 
/// tf.math.asin(y) # [1.047, 0.785] = x
/// ```
class AsinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes inverse hyperbolic sine of x element-wise.
/// Given an input tensor, this function computes inverse hyperbolic sine
///   for every element in the tensor. Both input and output has a range of
///   `[-inf, inf]`.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -2, -0.5, 1, 1.2, 200, 10000, float("inf")])
///   tf.math.asinh(x) ==> [-inf -1.4436355 -0.4812118 0.8813736 1.0159732 5.991471 9.903487 inf]
///   ```
class AsinhOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Asserts that the given condition is true.
/// If `condition` evaluates to false, print the list of tensors in `data`.
/// `summarize` determines how many entries of the tensors to print.
class AssertOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds a value to the current value of a variable.
/// Any ReadVariableOp with a control dependency on this op is guaranteed to
/// see the incremented value or a subsequent newer one.
class AssignAddVariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update 'ref' by assigning 'value' to it.
/// This operation outputs "ref" after the assignment is done.
/// This makes it easier to chain operations that need to use the reset value.
class AssignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Subtracts a value from the current value of a variable.
/// Any ReadVariableOp with a control dependency on this op is guaranteed to
/// see the decremented value or a subsequent newer one.
class AssignSubVariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assigns a new value to a variable.
/// Any ReadVariableOp with a control dependency on this op is guaranteed to return
/// this value or a subsequent newer value of the variable.
class AssignVariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes arctangent of `y/x` element-wise, respecting signs of the arguments.
/// This is the angle \\( \theta \in [-\pi, \pi] \\) such that
/// \\[ x = r \cos(\theta) \\]
/// and
/// \\[ y = r \sin(\theta) \\]
/// where \\(r = \sqrt{x^2 + y^2} \\).
/// 
/// For example:
/// 
/// >>> x = [1., 1.]
/// >>> y = [1., -1.]
/// >>> print((tf.math.atan2(y,x) * (180 / np.pi)).numpy())
/// [ 45. -45.]
class Atan2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the trignometric inverse tangent of x element-wise.
/// The `tf.math.atan` operation returns the inverse of `tf.math.tan`, such that
/// if `y = tf.math.tan(x)` then, `x = tf.math.atan(y)`.
/// 
/// **Note**: The output of `tf.math.atan` will lie within the invertible range
/// of tan, i.e (-pi/2, pi/2).
/// 
/// For example:
/// 
/// ```python
/// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
/// x = tf.constant([1.047, 0.785])
/// y = tf.math.tan(x) # [1.731261, 0.99920404]
/// 
/// tf.math.atan(y) # [1.047, 0.785] = x
/// ```
class AtanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes inverse hyperbolic tangent of x element-wise.
/// Given an input tensor, this function computes inverse hyperbolic tangent
///   for every element in the tensor. Input range is `[-1,1]` and output range is
///   `[-inf, inf]`. If input is `-1`, output will be `-inf` and if the
///   input is `1`, output will be `inf`. Values outside the range will have
///   `nan` as output.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -1, -0.5, 1, 0, 0.5, 10, float("inf")])
///   tf.math.atanh(x) ==> [nan -inf -0.54930615 inf  0. 0.54930615 nan nan]
///   ```
class AtanhOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients of average pooling function.
class AvgPool3DGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs 3D average pooling on the input.
/// Each entry in `output` is the mean of the corresponding size `ksize` window in
/// `value`.
class AvgPool3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients of the average pooling function.
class AvgPoolGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs average pooling on the input.
/// Each entry in `output` is the mean of the corresponding size `ksize`
/// window in `value`.
class AvgPoolOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that batches `batch_size` elements from `input_dataset`.
class BatchDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Batches all the inputs tensors to the computation done by the function.
/// So, for example, in the following code
/// 
///   ```python
/// 
///   # This input will be captured.
///   y = tf.placeholder_with_default(1.0, shape=[])
/// 
///   @tf.Defun(tf.float32)
///   def computation(a):
///     return tf.matmul(a, a) + y
/// 
///   b = gen_batch_ops.batch_function(
///           f=computation
///           in_tensors=[a],
///           captured_tensors=computation.captured_inputs,
///           Tout=[o.type for o in computation.definition.signature.output_arg],
///           num_batch_threads=1,
///           max_batch_size=10,
///           batch_timeout_micros=100000,  # 100ms
///           allowed_batch_sizes=[3, 10],
///           batching_queue="")
///   ```
/// 
/// If more than one session.run call is simultaneously trying to compute `b`
/// the values of `a` will be gathered, non-deterministically concatenated
/// along the first axis, and only one thread will run the computation.
/// 
/// Assumes that all arguments of the function are Tensors which will be batched
/// along their first dimension.
/// 
/// Arguments that are captured, are not batched. The session.run call which does
/// the concatenation, will use the values of the captured tensors available to it.
/// Therefore, typical uses of captured tensors should involve values which remain
/// unchanged across session.run calls. Inference is a good example of this.
/// 
/// SparseTensor is not supported. The return value of the decorated function
/// must be a Tensor or a list/tuple of Tensors.
class BatchFunctionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiplies slices of two tensors in batches.
/// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
/// viewed as an element of a batch), and arranges the individual results
/// in a single output tensor of the same batch size. Each of the
/// individual slices can optionally be adjointed (to adjoint a matrix
/// means to transpose and conjugate it) before multiplication by setting
/// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
/// 
/// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
/// and `[..., r_y, c_y]`.
/// 
/// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
/// 
///     r_o = c_x if adj_x else r_x
///     c_o = r_y if adj_y else c_y
/// 
/// It is computed as:
/// 
///     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
class BatchMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiplies slices of two tensors in batches.
/// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
/// viewed as an element of a batch), and arranges the individual results
/// in a single output tensor of the same batch size. Each of the
/// individual slices can optionally be adjointed (to adjoint a matrix
/// means to transpose and conjugate it) before multiplication by setting
/// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
/// 
/// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
/// and `[..., r_y, c_y]`.
/// 
/// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
/// 
///     r_o = c_x if adj_x else r_x
///     c_o = r_y if adj_y else c_y
/// 
/// It is computed as:
/// 
///     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
/// 
/// *NOTE*: `BatchMatMulV2` supports broadcasting in the batch dimensions. More
/// about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
class BatchMatMulV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiplies slices of two tensors in batches.
/// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
/// viewed as an element of a batch), and arranges the individual results
/// in a single output tensor of the same batch size. Each of the
/// individual slices can optionally be adjointed (to adjoint a matrix
/// means to transpose and conjugate it) before multiplication by setting
/// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
/// 
/// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
/// and `[..., r_y, c_y]`.
/// 
/// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
/// 
///     r_o = c_x if adj_x else r_x
///     c_o = r_y if adj_y else c_y
/// 
/// It is computed as:
/// 
///     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
/// 
/// *NOTE*: `BatchMatMulV3` supports broadcasting in the batch dimensions. More
/// about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
class BatchMatMulV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Batch normalization.
/// This op is deprecated. Prefer `tf.nn.batch_normalization`.
class BatchNormWithGlobalNormalizationOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// BatchToSpace for N-D tensors of type T.
/// This operation reshapes the "batch" dimension 0 into `M + 1` dimensions of shape
/// `block_shape + [batch]`, interleaves these blocks back into the grid defined by
/// the spatial dimensions `[1, ..., M]`, to obtain a result with the same rank as
/// the input.  The spatial dimensions of this intermediate result are then
/// optionally cropped according to `crops` to produce the output.  This is the
/// reverse of SpaceToBatch.  See below for a precise description.
class BatchToSpaceNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// BatchToSpace for 4-D tensors of type T.
/// This is a legacy version of the more general BatchToSpaceND.
/// 
/// Rearranges (permutes) data from batch into blocks of spatial data, followed by
/// cropping. This is the reverse transformation of SpaceToBatch. More specifically,
/// this op outputs a copy of the input tensor where values from the `batch`
/// dimension are moved in spatial blocks to the `height` and `width` dimensions,
/// followed by cropping along the `height` and `width` dimensions.
class BatchToSpaceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the Bessel i0e function of `x` element-wise.
/// Exponentially scaled modified Bessel function of order 0 defined as
/// `bessel_i0e(x) = exp(-abs(x)) bessel_i0(x)`.
/// 
/// This function is faster and numerically stabler than `bessel_i0(x)`.
class BesselI0eOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the Bessel i1e function of `x` element-wise.
/// Exponentially scaled modified Bessel function of order 0 defined as
/// `bessel_i1e(x) = exp(-abs(x)) bessel_i1(x)`.
/// 
/// This function is faster and numerically stabler than `bessel_i1(x)`.
class BesselI1eOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the regularized incomplete beta integral \\(I_x(a, b)\\).
/// The regularized incomplete beta integral is defined as:
/// 
/// 
/// \\(I_x(a, b) = \frac{B(x; a, b)}{B(a, b)}\\)
/// 
/// where
/// 
/// 
/// \\(B(x; a, b) = \int_0^x t^{a-1} (1 - t)^{b-1} dt\\)
/// 
/// 
/// is the incomplete beta function and \\(B(a, b)\\) is the *complete*
/// beta function.
class BetaincOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// The backward operation for "BiasAdd" on the "bias" tensor.
/// It accumulates all the values from out_backprop into the feature dimension.
/// For NHWC data format, the feature dimension is the last. For NCHW data format,
/// the feature dimension is the third-to-last.
class BiasAddGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds `bias` to `value`.
/// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
/// Broadcasting is supported, so `value` may have any number of dimensions.
class BiasAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds `bias` to `value`.
/// This is a deprecated version of BiasAdd and will be soon removed.
/// 
/// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
/// Broadcasting is supported, so `value` may have any number of dimensions.
class BiasAddV1Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Counts the number of occurrences of each value in an integer array.
/// Outputs a vector with length `size` and the same dtype as `weights`. If
/// `weights` are empty, then index `i` stores the number of times the value `i` is
/// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
/// the value in `weights` at each index where the corresponding value in `arr` is
/// `i`.
/// 
/// Values in `arr` outside of the range [0, size) are ignored.
class BincountOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Bitcasts a tensor from one type to another without copying data.
/// Given a tensor `input`, this operation returns a tensor that has the same buffer
/// data as `input` with datatype `type`.
/// 
/// If the input datatype `T` is larger than the output datatype `type` then the
/// shape changes from [...] to [..., sizeof(`T`)/sizeof(`type`)].
/// 
/// If `T` is smaller than `type`, the operator requires that the rightmost
/// dimension be equal to sizeof(`type`)/sizeof(`T`). The shape then goes from
/// [..., sizeof(`type`)/sizeof(`T`)] to [...].
/// 
/// tf.bitcast() and tf.cast() work differently when real dtype is casted as a complex dtype
/// (e.g. tf.complex64 or tf.complex128) as tf.cast() make imaginary part 0 while tf.bitcast()
/// gives module error.
/// For example,
/// 
/// Example 1:
/// 
/// >>> a = [1., 2., 3.]
/// >>> equality_bitcast = tf.bitcast(a, tf.complex128)
/// Traceback (most recent call last):
/// ...
/// InvalidArgumentError: Cannot bitcast from 1 to 18 [Op:Bitcast]
/// >>> equality_cast = tf.cast(a, tf.complex128)
/// >>> print(equality_cast)
/// tf.Tensor([1.+0.j 2.+0.j 3.+0.j], shape=(3,), dtype=complex128)
/// 
/// Example 2:
/// 
/// >>> tf.bitcast(tf.constant(0xffffffff, dtype=tf.uint32), tf.uint8)
/// <tf.Tensor: shape=(4,), dtype=uint8, numpy=array([255, 255, 255, 255], dtype=uint8)>
/// 
/// Example 3:
/// 
/// >>> x = [1., 2., 3.]
/// >>> y = [0., 2., 3.]
/// >>> equality= tf.equal(x,y)
/// >>> equality_cast = tf.cast(equality,tf.float32)
/// >>> equality_bitcast = tf.bitcast(equality_cast,tf.uint8)
/// >>> print(equality)
/// tf.Tensor([False True True], shape=(3,), dtype=bool)
/// >>> print(equality_cast)
/// tf.Tensor([0. 1. 1.], shape=(3,), dtype=float32)
/// >>> print(equality_bitcast)
/// tf.Tensor(
///     [[  0   0   0   0]
///      [  0   0 128  63]
///      [  0   0 128  63]], shape=(3, 4), dtype=uint8)
/// 
/// *NOTE*: Bitcast is implemented as a low-level cast, so machines with different
/// endian orderings will give different results. A copy from input buffer to output
/// buffer is made on BE machines when types are of different sizes in order to get
/// the same casting results as on LE machines.
class BitcastOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Elementwise computes the bitwise AND of `x` and `y`.
/// The result will have those bits set, that are set in both `x` and `y`. The
/// computation is performed on the underlying representations of `x` and `y`.
/// 
/// For example:
/// 
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
///               tf.uint8, tf.uint16, tf.uint32, tf.uint64]
/// 
/// for dtype in dtype_list:
///   lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
///   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
///   exp = tf.constant([0, 0, 3, 10], dtype=tf.float32)
/// 
///   res = bitwise_ops.bitwise_and(lhs, rhs)
///   tf.assert_equal(tf.cast(res, tf.float32), exp) # TRUE
/// ```
class BitwiseAndOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Elementwise computes the bitwise OR of `x` and `y`.
/// The result will have those bits set, that are set in `x`, `y` or both. The
/// computation is performed on the underlying representations of `x` and `y`.
/// 
/// For example:
/// 
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
///               tf.uint8, tf.uint16, tf.uint32, tf.uint64]
/// 
/// for dtype in dtype_list:
///   lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
///   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
///   exp = tf.constant([5, 5, 7, 15], dtype=tf.float32)
/// 
///   res = bitwise_ops.bitwise_or(lhs, rhs)
///   tf.assert_equal(tf.cast(res,  tf.float32), exp)  # TRUE
/// ```
class BitwiseOrOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Elementwise computes the bitwise XOR of `x` and `y`.
/// The result will have those bits set, that are different in `x` and `y`. The
/// computation is performed on the underlying representations of `x` and `y`.
/// 
/// For example:
/// 
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
///               tf.uint8, tf.uint16, tf.uint32, tf.uint64]
/// 
/// for dtype in dtype_list:
///   lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
///   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
///   exp = tf.constant([5, 5, 4, 5],  dtype=tf.float32)
/// 
///   res = bitwise_ops.bitwise_xor(lhs, rhs)
///   tf.assert_equal(tf.cast(res, tf.float32), exp) # TRUE
/// ```
class BitwiseXorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Bucketize each feature based on bucket boundaries.
/// An op that returns a list of float tensors, where each tensor represents the
/// bucketized values for a single feature.
class BoostedTreesBucketizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return the shape of s0 op s1 with broadcast.
/// Given `s0` and `s1`, tensors that represent shapes, compute `r0`, the
/// broadcasted shape. `s0`, `s1` and `r0` are all integer vectors.
class BroadcastArgsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return the reduction indices for computing gradients of s0 op s1 with broadcast.
/// This is typically used by gradient computations for a broadcasting operation.
class BroadcastGradientArgsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Broadcast an array for a compatible shape.
/// Broadcasting is the process of making arrays to have compatible shapes
/// for arithmetic operations. Two shapes are compatible if for each
/// dimension pair they are either equal or one of them is one.
/// 
/// For example:
/// 
/// >>> x = tf.constant([[1, 2, 3]])   # Shape (1, 3,)
/// >>> y = tf.broadcast_to(x, [2, 3])
/// >>> print(y)
/// tf.Tensor(
///     [[1 2 3]
///      [1 2 3]], shape=(2, 3), dtype=int32)
/// 
/// In the above example, the input Tensor with the shape of `[1, 3]`
/// is broadcasted to output Tensor with shape of `[2, 3]`.
/// 
/// When broadcasting, if a tensor has fewer axes than necessary its shape is
/// padded on the left with ones. So this gives the same result as the previous
/// example:
/// 
/// >>> x = tf.constant([1, 2, 3])   # Shape (3,)
/// >>> y = tf.broadcast_to(x, [2, 3])
/// 
/// 
/// When doing broadcasted operations such as multiplying a tensor
/// by a scalar, broadcasting (usually) confers some time or space
/// benefit, as the broadcasted tensor is never materialized.
/// 
/// However, `broadcast_to` does not carry with it any such benefits.
/// The newly-created tensor takes the full memory of the broadcasted
/// shape. (In a graph context, `broadcast_to` might be fused to
/// subsequent operation and then be optimized away, however.)
class BroadcastToOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Bucketizes 'input' based on 'boundaries'.
/// For example, if the inputs are
///     boundaries = [0, 10, 100]
///     input = [[-5, 10000]
///              [150,   10]
///              [5,    100]]
/// 
/// then the output will be
///     output = [[0, 3]
///               [3, 2]
///               [1, 3]]
class BucketizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class CacheDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An n-way switch statement which calls a single branch function.
/// An n-way switch statement, implementing the following:
///     ```
///     switch (branch_index) {
///       case 0:
///         output = branches[0](input);
///         break;
///       case 1:
///         output = branches[1](input);
///         break;
///       ...
///       case [[nbranches-1]]:
///       default:
///         output = branches[nbranches-1](input);
///         break;
///     }
///     ```
class CaseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An n-way switch statement which calls a single branch function.
/// An n-way switch statement, implementing the following:
///     ```
///     switch (branch_index) {
///       case 0:
///         output = branches[0](input);
///         break;
///       case 1:
///         output = branches[1](input);
///         break;
///       ...
///       case [[nbranches-1]]:
///       default:
///         output = branches[nbranches-1](input);
///         break;
///     }
///     ```
class CaseRegionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Cast x of type SrcT to y of DstT.
class CastOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise smallest integer not less than x.
class CeilOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Checks a tensor for NaN and Inf values.
/// When run, reports an `InvalidArgument` error if `tensor` has any values
/// that are not a number (NaN) or infinity (Inf). Otherwise, returns the input
/// tensor.
/// 
/// Example usage:
/// 
/// ``` python
/// a = tf.Variable(1.0)
/// tf.debugging.check_numerics(a, message='')
/// 
/// b = tf.Variable(np.nan)
/// try:
///   tf.debugging.check_numerics(b, message='Checking b')
/// except Exception as e:
///   assert "Checking b : Tensor had NaN values" in e.message
/// 
/// c = tf.Variable(np.inf)
/// try:
///   tf.debugging.check_numerics(c, message='Checking c')
/// except Exception as e:
///   assert "Checking c : Tensor had Inf values" in e.message
/// ```
class CheckNumericsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the Cholesky decomposition of one or more square matrices.
/// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
/// form square matrices.
/// 
/// The input has to be symmetric and positive definite. Only the lower-triangular
/// part of the input will be used for this operation. The upper-triangular part
/// will not be read.
/// 
/// The output is a tensor of the same shape as the input
/// containing the Cholesky decompositions for all input submatrices `[..., :, :]`.
/// 
/// **Note**: The gradient computation on GPU is faster for large matrices but
/// not for large batch dimensions when the submatrices are small. In this
/// case it might be faster to use the CPU.
class CholeskyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Clips tensor values to a specified min and max.
/// Given a tensor `x`, this operation returns a tensor of the same type and
/// shape as `x` with its values clipped to `clip_value_min` and `clip_value_max`.
/// Any values less than `clip_value_min` are set to `clip_value_min`. Any values
/// greater than `clip_value_max` are set to `clip_value_max`.
class ClipByValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Flushes and closes the summary writer.
/// Also removes it from the resource manager. To reopen, use another
/// CreateSummaryFileWriter op.
/// 
/// writer: A handle to the summary writer resource.
class CloseSummaryWriterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that merges the string-encoded memory config protos from all hosts.
class CollateTPUEmbeddingMemoryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Mutually exchanges multiple tensors of identical type and shape.
/// `is_stateless` means each op does not need control dependencies to other
/// collective ops. In this case, keys that are unique at runtime
/// (e.g. `instance_key`) should be used to distinguish collective groups.
class CollectiveAllToAllV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assign group keys based on group assignment.
class CollectiveAssignGroupV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives a tensor value broadcast from another device.
class CollectiveBcastRecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Broadcasts a tensor value to one or more other devices.
class CollectiveBcastSendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Mutually accumulates multiple tensors of identical type and shape.
class CollectiveGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Mutually accumulates multiple tensors of identical type and shape.
/// `is_stateless` means each op does not need control dependencies to other
/// collective ops. In this case, keys that are unique at runtime
/// (e.g. `instance_key`) should be used to distinguish collective groups.
class CollectiveGatherV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An Op to permute tensors across replicated TPU instances.
/// Each instance supplies its own input.
/// 
/// For example, suppose there are 4 TPU instances: `[A, B, C, D]`. Passing
/// source_target_pairs=`[[0,1],[1,2],[2,3],[3,0]]` gets the outputs:
/// `[D, A, B, C]`.
class CollectivePermuteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Mutually reduces multiple tensors of identical type and shape.
class CollectiveReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Mutually reduces multiple tensors of identical type and shape and scatters the result.
/// `is_stateless` means each op does not need control dependencies to other
/// collective ops. In this case, keys that are unique at runtime
/// (e.g. `instance_key`) should be used to distinguish collective groups.
class CollectiveReduceScatterV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Mutually reduces multiple tensors of identical type and shape.
/// `is_stateless` means each op does not need control dependencies to other
/// collective ops. In this case, keys that are unique at runtime
/// (e.g. `instance_key`) should be used to distinguish collective groups.
class CollectiveReduceV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the complex absolute value of a tensor.
/// Given a tensor `x` of complex numbers, this operation returns a tensor of type
/// `float` or `double` that is the absolute value of each element in `x`. All
/// elements in `x` must be complex numbers of the form \\(a + bj\\). The absolute
/// value is computed as \\( \sqrt{a^2 + b^2}\\).
/// 
/// For example:
/// 
/// >>> x = tf.complex(3.0, 4.0)
/// >>> print((tf.raw_ops.ComplexAbs(x=x, Tout=tf.dtypes.float32, name=None)).numpy())
/// 5.0
class ComplexAbsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts two real numbers to a complex number.
/// Given a tensor `real` representing the real part of a complex number, and a
/// tensor `imag` representing the imaginary part of a complex number, this
/// operation returns complex numbers elementwise of the form \\(a + bj\\), where
/// *a* represents the `real` part and *b* represents the `imag` part.
/// 
/// The input tensors `real` and `imag` must have the same shape.
/// 
/// For example:
/// 
/// ```
/// # tensor 'real' is [2.25, 3.25]
/// # tensor `imag` is [4.75, 5.75]
/// tf.complex(real, imag) ==> [[2.25 + 4.75j], [3.25 + 5.75j]]
/// ```
class ComplexOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes offsets of concat inputs within its output.
/// For example:
/// 
/// >>> x = [2, 2, 7]
/// >>> y = [2, 3, 7]
/// >>> z = [2, 9, 7]
/// >>> offsets = concat_offset(1, [x, y, z])
/// >>> [[a.item() for a in list(off.numpy())] for off in offsets]
/// [[0, 0, 0], [0, 2, 0], [0, 5, 0]]
/// 
/// This is typically used by gradient computations for a concat operation.
class ConcatOffsetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concatenates tensors along one dimension.
class ConcatOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concatenates tensors along one dimension.
class ConcatV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that initialize the TPU system in a multi-client set up.
/// Initializes global TPU system for mutli-client execution.
/// 
/// This op does the work of both ConfigureDistributedTpuOp and
/// InitializeHostForDistributedTpuOp, and outputs the latter's result.
class ConfigureAndInitializeGlobalTPUOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sets up the centralized structures for a distributed TPU system.
class ConfigureDistributedTPUOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that configures the TPUEmbedding software on a host.
class ConfigureTPUEmbeddingHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that configures the TPUEmbedding software on a host.
class ConfigureTPUEmbeddingMemoryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sets up TPUEmbedding in a distributed TPU system.
class ConfigureTPUEmbeddingOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the complex conjugate of a complex number.
/// Given a tensor `input` of complex numbers, this operation returns a tensor of
/// complex numbers that are the complex conjugate of each element in `input`. The
/// complex numbers in `input` must be of the form \\(a + bj\\), where *a* is the
/// real part and *b* is the imaginary part.
/// 
/// The complex conjugate returned by this operation is of the form \\(a - bj\\).
/// 
/// For example:
/// 
/// ```
/// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
/// tf.conj(input) ==> [-2.25 - 4.75j, 3.25 - 5.75j]
/// ```
class ConjOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Shuffle dimensions of x according to a permutation and conjugate the result.
/// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
///   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
///   `y[i,j,k,...,s,t,u] == conj(x[perm[i], perm[j], perm[k],...,perm[s], perm[t], perm[u]])`
class ConjugateTransposeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that sets up communication between TPUEmbedding host software instances
/// after ConfigureTPUEmbeddingHost has been called on each host.
class ConnectTPUEmbeddingHostsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Constant tensor op
class ConstOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of convolution with respect to the filter.
class Conv2DBackpropFilterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of convolution with respect to the filter.
class Conv2DBackpropFilterV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of convolution with respect to the input.
class Conv2DBackpropInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of convolution with respect to the input.
class Conv2DBackpropInputV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes a 2-D convolution given 4-D `input` and `filter` tensors.
/// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
/// and a filter / kernel tensor of shape
/// `[filter_height, filter_width, in_channels, out_channels]`, this op
/// performs the following:
/// 
/// 1. Flattens the filter to a 2-D matrix with shape
///    `[filter_height * filter_width * in_channels, output_channels]`.
/// 2. Extracts image patches from the input tensor to form a *virtual*
///    tensor of shape `[batch, out_height, out_width,
///    filter_height * filter_width * in_channels]`.
/// 3. For each patch, right-multiplies the filter matrix and the image patch
///    vector.
/// 
/// In detail, with the default NHWC format,
/// 
///     output[b, i, j, k] =
///         sum_{di, dj, q} input[b, strides[1] * i + di, strides[2] * j + dj, q] *
///                         filter[di, dj, q, k]
/// 
/// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
/// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
class Conv2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of 3-D convolution with respect to the filter.
class Conv3DBackpropFilterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of 3-D convolution with respect to the filter.
class Conv3DBackpropFilterV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of 3-D convolution with respect to the input.
class Conv3DBackpropInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of 3-D convolution with respect to the input.
class Conv3DBackpropInputV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes a 3-D convolution given 5-D `input` and `filter` tensors.
/// In signal processing, cross-correlation is a measure of similarity of
/// two waveforms as a function of a time-lag applied to one of them. This
/// is also known as a sliding dot product or sliding inner-product.
/// 
/// Our Conv3D implements a form of cross-correlation.
class Conv3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes a N-D convolution given (N+1+batch_dims)-D `input` and (N+2)-D `filter` tensors.
/// General function for computing a N-D convolution. It is required that
/// `1 <= N <= 3`.
class ConvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that converts tensors into coo format.
/// This op coverts the dense, sparse and ragged tensor into standard coo tensor
/// format which contains three 1D tensors.
class ConvertToCooTensorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which converts the sparse/ragged/dense tensor into a list of COO tensor for each SparseCore.
class ConvertToListOfSparseCoreCooTensorsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which converts the sorted coo tensor into sparse core CSR wrapped COO format.
class ConvertToSparseCoreCsrWrappedCooTensorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes cos of x element-wise.
/// Given an input tensor, this function computes cosine of every
///   element in the tensor. Input range is `(-inf, inf)` and
///   output range is `[-1,1]`. If input lies outside the boundary, `nan`
///   is returned.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10000, float("inf")])
///   tf.math.cos(x) ==> [nan -0.91113025 0.87758255 0.5403023 0.36235774 0.48718765 -0.95215535 nan]
///   ```
class CosOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes hyperbolic cosine of x element-wise.
/// Given an input tensor, this function computes hyperbolic cosine of every
///   element in the tensor. Input range is `[-inf, inf]` and output range
///   is `[1, inf]`.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
///   tf.math.cosh(x) ==> [inf 4.0515420e+03 1.1276259e+00 1.5430807e+00 1.8106556e+00 3.7621956e+00 1.1013233e+04 inf]
///   ```
class CoshOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates summary database writer accessible by given resource handle.
/// This can be used to write tensors from the execution graph directly
/// to a database. Only SQLite is supported right now. This function
/// will create the schema if it doesn't exist. Entries in the Users,
/// Experiments, and Runs tables will be created automatically if they
/// don't already exist.
/// 
/// writer: Handle to SummaryWriter resource to overwrite.
/// db_uri: For example "file:/tmp/foo.sqlite".
/// experiment_name: Can't contain ASCII control characters or <>. Case
///   sensitive. If empty, then the Run will not be associated with any
///   Experiment.
/// run_name: Can't contain ASCII control characters or <>. Case sensitive.
///   If empty, then each Tag will not be associated with any Run.
/// user_name: Must be valid as both a DNS label and Linux username. If
///   empty, then the Experiment will not be associated with any User.
class CreateSummaryDbWriterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a summary file writer accessible by the given resource handle.
/// writer: A handle to the summary writer resource
/// logdir: Directory where the event file will be written.
/// max_queue: Size of the queue of pending events and summaries.
/// flush_millis: How often, in milliseconds, to flush the pending events and
///   summaries to disk.
/// filename_suffix: Every event file's name is suffixed with this suffix.
class CreateSummaryFileWriterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the pairwise cross product.
/// `a` and `b` must be the same shape; they can either be simple 3-element vectors,
/// or any shape where the innermost dimension is 3. In the latter case, each pair
/// of corresponding 3-element vectors is cross-multiplied independently.
class CrossOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An Op to sum inputs across replicated TPU instances.
/// Each instance supplies its own input.
/// 
/// For example, suppose there are 8 TPU instances: `[A, B, C, D, E, F, G, H]`.
/// Passing group_assignment=`[[0,2,4,6],[1,3,5,7]]` sets `A, C, E, G` as group 0,
/// and `B, D, F, H` as group 1. Thus we get the outputs:
/// `[A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H]`.
class CrossReplicaSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the cumulative product of the tensor `x` along `axis`.
/// By default, this op performs an inclusive cumprod, which means that the first
/// element of the input is identical to the first element of the output:
/// 
/// ```python
/// tf.cumprod([a, b, c])  # => [a, a * b, a * b * c]
/// ```
/// 
/// By setting the `exclusive` kwarg to `True`, an exclusive cumprod is
/// performed instead:
/// 
/// ```python
/// tf.cumprod([a, b, c], exclusive=True)  # => [1, a, a * b]
/// ```
/// 
/// By setting the `reverse` kwarg to `True`, the cumprod is performed in the
/// opposite direction:
/// 
/// ```python
/// tf.cumprod([a, b, c], reverse=True)  # => [a * b * c, b * c, c]
/// ```
/// 
/// This is more efficient than using separate `tf.reverse` ops.
/// 
/// The `reverse` and `exclusive` kwargs can also be combined:
/// 
/// ```python
/// tf.cumprod([a, b, c], exclusive=True, reverse=True)  # => [b * c, c, 1]
/// ```
class CumprodOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the cumulative sum of the tensor `x` along `axis`.
/// By default, this op performs an inclusive cumsum, which means that the first
/// element of the input is identical to the first element of the output:
/// 
/// ```python
/// tf.cumsum([a, b, c])  # => [a, a + b, a + b + c]
/// ```
/// 
/// By setting the `exclusive` kwarg to `True`, an exclusive cumsum is
/// performed instead:
/// 
/// ```python
/// tf.cumsum([a, b, c], exclusive=True)  # => [0, a, a + b]
/// ```
/// 
/// By setting the `reverse` kwarg to `True`, the cumsum is performed in the
/// opposite direction:
/// 
/// ```python
/// tf.cumsum([a, b, c], reverse=True)  # => [a + b + c, b + c, c]
/// ```
/// 
/// This is more efficient than using separate `tf.reverse` ops.
/// 
/// The `reverse` and `exclusive` kwargs can also be combined:
/// 
/// ```python
/// tf.cumsum([a, b, c], exclusive=True, reverse=True)  # => [b + c, c, 0]
/// ```
class CumsumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the cumulative product of the tensor `x` along `axis`.
/// By default, this op performs an inclusive cumulative log-sum-exp,
/// which means that the first
/// element of the input is identical to the first element of the output:
/// ```python
/// tf.math.cumulative_logsumexp([a, b, c])  # => [a, log(exp(a) + exp(b)), log(exp(a) + exp(b) + exp(c))]
/// ```
/// 
/// By setting the `exclusive` kwarg to `True`, an exclusive cumulative log-sum-exp is
/// performed instead:
/// ```python
/// tf.cumulative_logsumexp([a, b, c], exclusive=True)  # => [-inf, a, log(exp(a) * exp(b))]
/// ```
/// Note that the neutral element of the log-sum-exp operation is `-inf`,
/// however, for performance reasons, the minimal value representable by the
/// floating point type is used instead.
/// 
/// By setting the `reverse` kwarg to `True`, the cumulative log-sum-exp is performed in the
/// opposite direction.
class CumulativeLogsumexpOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the dimension index in the destination data format given the one in
/// the source data format.
class DataFormatDimMapOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Permute input tensor from `src_format` to `dst_format`.
/// Given source and destination format strings of length n=4 or 5, the input
/// tensor must be a vector of size n or n-2, or a 2D tensor of shape
/// (n, 2) or (n-2, 2).
/// 
/// If the first dimension of the input tensor is n-2, it is assumed that
/// non-spatial dimensions are omitted (i.e `N`, `C`).
/// 
/// For example, with `src_format` of `NHWC`, `dst_format` of `NCHW`, and input:
/// ```
/// [1, 2, 3, 4]
/// ```
/// , the output will be:
/// ```
/// [1, 4, 2, 3]
/// ```
/// With `src_format` of `NDHWC`, `dst_format` of `NCDHW`, and input:
/// ```
/// [[1, 6], [2, 7], [3, 8], [4, 9], [5, 10]]
/// ```
/// , the output will be:
/// ```
/// [[1, 6], [5, 10], [2, 7], [3, 8], [4, 9]]
/// ```
/// With `src_format` of `NHWC`, `dst_format` of `NCHW`, and input:
/// ```
/// [1, 2]
/// ```
/// , the output will be:
/// ```
/// [1, 2]
/// ```
class DataFormatVecPermuteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Debug Identity V2 Op.
/// Provides an identity mapping from input to output, while writing the content of
/// the input tensor by calling DebugEventsWriter.
/// 
/// The semantics of the input tensor depends on tensor_debug_mode. In typical
/// usage, the input tensor comes directly from the user computation only when
/// graph_debug_mode is FULL_TENSOR (see protobuf/debug_event.proto for a
/// list of all the possible values of graph_debug_mode). For the other debug modes,
/// the input tensor should be produced by an additional op or subgraph that
/// computes summary information about one or more tensors.
class DebugIdentityV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Decode and Crop a JPEG-encoded image to a uint8 tensor.
/// The attr `channels` indicates the desired number of color channels for the
/// decoded image.
/// 
/// Accepted values are:
/// 
/// *   0: Use the number of channels in the JPEG-encoded image.
/// *   1: output a grayscale image.
/// *   3: output an RGB image.
/// 
/// If needed, the JPEG-encoded image is transformed to match the requested number
/// of color channels.
/// 
/// The attr `ratio` allows downscaling the image by an integer factor during
/// decoding.  Allowed values are: 1, 2, 4, and 8.  This is much faster than
/// downscaling the image later.
/// 
/// 
/// It is equivalent to a combination of decode and crop, but much faster by only
/// decoding partial jpeg image.
class DecodeAndCropJpegOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Decode the frame(s) of a GIF-encoded image to a uint8 tensor.
/// GIF images with frame or transparency compression are not supported.
/// On Linux and MacOS systems, convert animated GIFs from compressed to
/// uncompressed by running:
/// 
///     convert $src.gif -coalesce $dst.gif
/// 
/// This op also supports decoding JPEGs and PNGs, though it is cleaner to use
/// `tf.io.decode_image`.
class DecodeGifOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Decode a JPEG-encoded image to a uint8 tensor.
/// The attr `channels` indicates the desired number of color channels for the
/// decoded image.
/// 
/// Accepted values are:
/// 
/// *   0: Use the number of channels in the JPEG-encoded image.
/// *   1: output a grayscale image.
/// *   3: output an RGB image.
/// 
/// If needed, the JPEG-encoded image is transformed to match the requested number
/// of color channels.
/// 
/// The attr `ratio` allows downscaling the image by an integer factor during
/// decoding.  Allowed values are: 1, 2, 4, and 8.  This is much faster than
/// downscaling the image later.
/// 
/// 
/// This op also supports decoding PNGs and non-animated GIFs since the interface is
/// the same, though it is cleaner to use `tf.io.decode_image`.
class DecodeJpegOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reinterpret the bytes of a string as a vector of numbers.
class DecodePaddedRawOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Decode a PNG-encoded image to a uint8 or uint16 tensor.
/// The attr `channels` indicates the desired number of color channels for the
/// decoded image.
/// 
/// Accepted values are:
/// 
/// *   0: Use the number of channels in the PNG-encoded image.
/// *   1: output a grayscale image.
/// *   3: output an RGB image.
/// *   4: output an RGBA image.
/// 
/// If needed, the PNG-encoded image is transformed to match the requested number
/// of color channels.
/// 
/// This op also supports decoding JPEGs and non-animated GIFs since the interface
/// is the same, though it is cleaner to use `tf.io.decode_image`.
class DecodePngOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for an iterator resource.
class DeleteIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class DeleteMemoryCacheOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for an iterator resource.
class DeleteMultiDeviceIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class DeleteRandomSeedGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class DeleteSeedGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// DepthToSpace for tensors of type T.
/// Rearranges data from depth into blocks of spatial data.
/// This is the reverse transformation of SpaceToDepth. More specifically,
/// this op outputs a copy of the input tensor where values from the `depth`
/// dimension are moved in spatial blocks to the `height` and `width` dimensions.
/// The attr `block_size` indicates the input block size and how the data is moved.
/// 
///   * Chunks of data of size `block_size * block_size` from depth are rearranged
///     into non-overlapping blocks of size `block_size x block_size`
///   * The width of the output tensor is `input_depth * block_size`, whereas the
///     height is `input_height * block_size`.
///   * The Y, X coordinates within each block of the output image are determined
///     by the high order component of the input channel index.
///   * The depth of the input tensor must be divisible by
///     `block_size * block_size`.
/// 
/// The `data_format` attr specifies the layout of the input and output tensors
/// with the following options:
///   "NHWC": `[ batch, height, width, channels ]`
///   "NCHW": `[ batch, channels, height, width ]`
///   "NCHW_VECT_C":
///       `qint8 [ batch, channels / 4, height, width, 4 ]`
/// 
/// It is useful to consider the operation as transforming a 6-D Tensor.
/// e.g. for data_format = NHWC,
///      Each element in the input tensor can be specified via 6 coordinates,
///      ordered by decreasing memory layout significance as:
///      n,iY,iX,bY,bX,oC  (where n=batch index, iX, iY means X or Y coordinates
///                         within the input image, bX, bY means coordinates
///                         within the output block, oC means output channels).
///      The output would be the input transposed to the following layout:
///      n,iY,bY,iX,bX,oC
/// 
/// This operation is useful for resizing the activations between convolutions
/// (but keeping all data), e.g. instead of pooling. It is also useful for training
/// purely convolutional models.
/// 
/// For example, given an input of shape `[1, 1, 1, 4]`, data_format = "NHWC" and
/// block_size = 2:
/// 
/// ```
/// x = [[[[1, 2, 3, 4]]]]
/// 
/// ```
/// 
/// This operation will output a tensor of shape `[1, 2, 2, 1]`:
/// 
/// ```
///    [[[[1], [2]],
///      [[3], [4]]]]
/// ```
/// 
/// Here, the input has a batch of 1 and each batch element has shape `[1, 1, 4]`,
/// the corresponding output will have 2x2 elements and will have a depth of
/// 1 channel (1 = `4 / (block_size * block_size)`).
/// The output element shape is `[2, 2, 1]`.
/// 
/// For an input tensor with larger depth, here of shape `[1, 1, 1, 12]`, e.g.
/// 
/// ```
/// x = [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
/// ```
/// 
/// This operation, for block size of 2, will return the following tensor of shape
/// `[1, 2, 2, 3]`
/// 
/// ```
///    [[[[1, 2, 3], [4, 5, 6]],
///      [[7, 8, 9], [10, 11, 12]]]]
/// 
/// ```
/// 
/// Similarly, for the following input of shape `[1 2 2 4]`, and a block size of 2:
/// 
/// ```
/// x =  [[[[1, 2, 3, 4],
///        [5, 6, 7, 8]],
///       [[9, 10, 11, 12],
///        [13, 14, 15, 16]]]]
/// ```
/// 
/// the operator will return the following tensor of shape `[1 4 4 1]`:
/// 
/// ```
/// x = [[[ [1],   [2],  [5],  [6]],
///       [ [3],   [4],  [7],  [8]],
///       [ [9],  [10], [13],  [14]],
///       [ [11], [12], [15],  [16]]]]
/// 
/// ```
class DepthToSpaceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of depthwise convolution with respect to the filter.
class DepthwiseConv2dNativeBackpropFilterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradients of depthwise convolution with respect to the input.
class DepthwiseConv2dNativeBackpropInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes a 2-D depthwise convolution given 4-D `input` and `filter` tensors.
/// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
/// and a filter / kernel tensor of shape
/// `[filter_height, filter_width, in_channels, channel_multiplier]`, containing
/// `in_channels` convolutional filters of depth 1, `depthwise_conv2d` applies
/// a different filter to each input channel (expanding from 1 channel to
/// `channel_multiplier` channels for each), then concatenates the results
/// together. Thus, the output has `in_channels * channel_multiplier` channels.
/// 
/// ```
/// for k in 0..in_channels-1
///   for q in 0..channel_multiplier-1
///     output[b, i, j, k * channel_multiplier + q] =
///       sum_{di, dj} input[b, strides[1] * i + di, strides[2] * j + dj, k] *
///                         filter[di, dj, k, q]
/// ```
/// 
/// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
/// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
class DepthwiseConv2dNativeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Dequantize the 'input' tensor into a float or bfloat16 Tensor.
/// [min_range, max_range] are scalar floats that specify the range for
/// the output. The 'mode' attribute controls exactly which calculations are
/// used to convert the float values to their quantized equivalents.
/// 
/// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
/// 
/// ```
/// if T == qint8: in[i] += (range(T) + 1)/ 2.0
/// out[i] = min_range + (in[i]* (max_range - min_range) / range(T))
/// ```
/// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
/// 
/// *MIN_COMBINED Mode Example*
/// 
/// If the input comes from a QuantizedRelu6, the output type is
/// quint8 (range of 0-255) but the possible range of QuantizedRelu6 is
/// 0-6.  The min_range and max_range values are therefore 0.0 and 6.0.
/// Dequantize on quint8 will take each value, cast to float, and multiply
/// by 6 / 255.
/// Note that if quantizedtype is qint8, the operation will additionally add
/// each value by 128 prior to casting.
/// 
/// If the mode is 'MIN_FIRST', then this approach is used:
/// 
/// ```c++
/// num_discrete_values = 1 << (# of bits in T)
/// range_adjust = num_discrete_values / (num_discrete_values - 1)
/// range = (range_max - range_min) * range_adjust
/// range_scale = range / num_discrete_values
/// const double offset_input = static_cast<double>(input) - lowest_quantized;
/// result = range_min + ((input - numeric_limits<T>::min()) * range_scale)
/// ```
/// 
/// If the mode is `SCALED`, dequantization is performed by multiplying each
/// input value by a scaling_factor. (Thus an input of 0 always maps to 0.0).
/// 
/// The scaling_factor is determined from `min_range`, `max_range`, and
/// `narrow_range` in a way that is compatible with `QuantizeAndDequantize{V2|V3}`
/// and `QuantizeV2`, using the following algorithm:
/// 
/// ```c++
/// 
///   const int min_expected_T = std::numeric_limits<T>::min() +
///     (narrow_range ? 1 : 0);
///   const int max_expected_T = std::numeric_limits<T>::max();
///   const float max_expected_T = std::numeric_limits<float>::max();
/// 
///   const float scale_factor =
///     (std::numeric_limits<T>::min() == 0) ? (max_range / max_expected_T)
///                                          : std::max(min_range / min_expected_T,
///                                                     max_range / max_expected_T);
/// ```
class DequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts the given variant tensor to an iterator and stores it in the given resource.
class DeserializeIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Deserialize `SparseTensor` objects.
/// The input `serialized_sparse` must have the shape `[?, ?, ..., ?, 3]` where
/// the last dimension stores serialized `SparseTensor` objects and the other N
/// dimensions (N >= 0) correspond to a batch. The ranks of the original
/// `SparseTensor` objects must all match. When the final `SparseTensor` is
/// created, its rank is the rank of the incoming `SparseTensor` objects plus N;
/// the sparse tensors have been concatenated along new dimensions, one for each
/// batch.
/// 
/// The output `SparseTensor` object's shape values for the original dimensions
/// are the max across the input `SparseTensor` objects' shape values for the
/// corresponding dimensions. The new dimensions match the size of the batch.
/// 
/// The input `SparseTensor` objects' indices are assumed ordered in
/// standard lexicographic order.  If this is not the case, after this
/// step run `SparseReorder` to restore index ordering.
/// 
/// For example, if the serialized input is a `[2 x 3]` matrix representing two
/// original `SparseTensor` objects:
/// 
///     index = [ 0]
///             [10]
///             [20]
///     values = [1, 2, 3]
///     shape = [50]
/// 
/// and
/// 
///     index = [ 2]
///             [10]
///     values = [4, 5]
///     shape = [30]
/// 
/// then the final deserialized `SparseTensor` will be:
/// 
///     index = [0  0]
///             [0 10]
///             [0 20]
///             [1  2]
///             [1 10]
///     values = [1, 2, 3, 4, 5]
///     shape = [2 50]
class DeserializeSparseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Deletes the resource specified by the handle.
/// All subsequent operations using the resource will result in a NotFound
/// error status.
class DestroyResourceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return the index of device the op runs.
/// Given a list of device names, this operation returns the index of the device
/// this op runs. The length of the list is returned in two cases:
/// (1) Device does not exist in the given device list.
/// (2) It is in XLA compilation.
class DeviceIndexOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a diagonal tensor with a given diagonal values.
/// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
/// everything else padded with zeros. The diagonal is computed as follows:
/// 
/// Assume `diagonal` has dimensions [D1,..., Dk], then the output is a tensor of
/// rank 2k with dimensions [D1,..., Dk, D1,..., Dk] where:
/// 
/// `output[i1,..., ik, i1,..., ik] = diagonal[i1, ..., ik]` and 0 everywhere else.
/// 
/// For example:
/// 
/// ```
/// # 'diagonal' is [1, 2, 3, 4]
/// tf.diag(diagonal) ==> [[1, 0, 0, 0]
///                        [0, 2, 0, 0]
///                        [0, 0, 3, 0]
///                        [0, 0, 0, 4]]
/// ```
class DiagOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the diagonal part of the tensor.
/// This operation returns a tensor with the `diagonal` part
/// of the `input`. The `diagonal` part is computed as follows:
/// 
/// Assume `input` has dimensions `[D1,..., Dk, D1,..., Dk]`, then the output is a
/// tensor of rank `k` with dimensions `[D1,..., Dk]` where:
/// 
/// `diagonal[i1,..., ik] = input[i1, ..., ik, i1,..., ik]`.
/// 
/// For example:
/// 
/// ```
/// # 'input' is [[1, 0, 0, 0]
///               [0, 2, 0, 0]
///               [0, 0, 3, 0]
///               [0, 0, 0, 4]]
/// 
/// tf.diag_part(input) ==> [1, 2, 3, 4]
/// ```
class DiagPartOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes Psi, the derivative of Lgamma (the log of the absolute value of
/// `Gamma(x)`), element-wise.
class DigammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Turns off the copy-on-read mode.
/// Turns off the copy-on-read mode of a resource variable. If the variable is not in copy-on-read mode, this op has no effect.
class DisableCopyOnReadOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if the denominator is zero.
/// *NOTE*: `DivNoNan` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class DivNoNanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x / y element-wise.
/// *NOTE*: `Div` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class DivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class DummyMemoryCacheOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class DummySeedGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
/// embedding_indices[i] and aggregation_weights[i] correspond
/// to the ith feature.
/// 
/// The tensors at corresponding positions in the three input lists (sample_indices,
/// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
/// with dim_size() equal to the total number of lookups into the table described by
/// the corresponding feature.
class DynamicEnqueueTPUEmbeddingArbitraryTensorBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Partitions `data` into `num_partitions` tensors using indices from `partitions`.
/// For each index tuple `js` of size `partitions.ndim`, the slice `data[js, ...]`
/// becomes part of `outputs[partitions[js]]`.  The slices with `partitions[js] = i`
/// are placed in `outputs[i]` in lexicographic order of `js`, and the first
/// dimension of `outputs[i]` is the number of entries in `partitions` equal to `i`.
/// In detail,
/// 
/// ```python
///     outputs[i].shape = [sum(partitions == i)] + data.shape[partitions.ndim:]
/// 
///     outputs[i] = pack([data[js, ...] for js if partitions[js] == i])
/// ```
/// 
/// `data.shape` must start with `partitions.shape`.
/// 
/// For example:
/// 
/// ```python
///     # Scalar partitions.
///     partitions = 1
///     num_partitions = 2
///     data = [10, 20]
///     outputs[0] = []  # Empty with shape [0, 2]
///     outputs[1] = [[10, 20]]
/// 
///     # Vector partitions.
///     partitions = [0, 0, 1, 1, 0]
///     num_partitions = 2
///     data = [10, 20, 30, 40, 50]
///     outputs[0] = [10, 20, 50]
///     outputs[1] = [30, 40]
/// ```
/// 
/// See `dynamic_stitch` for an example on how to merge partitions back.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicPartition.png" alt>
/// </div>
/// 
/// 
/// Raises:
///   * `InvalidArgumentError` in following cases:
///     - If partitions is not in range `[0, num_partiions)`
///     - If `partitions.shape` does not match prefix of `data.shape` argument.
class DynamicPartitionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Interleave the values from the `data` tensors into a single tensor.
/// Builds a merged tensor such that
/// 
/// ```python
///     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
/// ```
/// 
/// For example, if each `indices[m]` is scalar or vector, we have
/// 
/// ```python
///     # Scalar indices:
///     merged[indices[m], ...] = data[m][...]
/// 
///     # Vector indices:
///     merged[indices[m][i], ...] = data[m][i, ...]
/// ```
/// 
/// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
/// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
/// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
/// `constant`, the output shape is
/// 
///     merged.shape = [max(indices) + 1] + constant
/// 
/// Values are merged in order, so if an index appears in both `indices[m][i]` and
/// `indices[n][j]` for `(m,i) < (n,j)` the slice `data[n][j]` will appear in the
/// merged result. If you do not need this guarantee, ParallelDynamicStitch might
/// perform better on some devices.
/// 
/// For example:
/// 
/// ```python
///     indices[0] = 6
///     indices[1] = [4, 1]
///     indices[2] = [[5, 2], [0, 3]]
///     data[0] = [61, 62]
///     data[1] = [[41, 42], [11, 12]]
///     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
///     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
///               [51, 52], [61, 62]]
/// ```
/// 
/// This method can be used to merge partitions created by `dynamic_partition`
/// as illustrated on the following example:
/// 
/// ```python
///     # Apply function (increments x_i) on elements for which a certain condition
///     # apply (x_i != -1 in this example).
///     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
///     condition_mask=tf.not_equal(x,tf.constant(-1.))
///     partitioned_data = tf.dynamic_partition(
///         x, tf.cast(condition_mask, tf.int32) , 2)
///     partitioned_data[1] = partitioned_data[1] + 1.0
///     condition_indices = tf.dynamic_partition(
///         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
///     x = tf.dynamic_stitch(condition_indices, partitioned_data)
///     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
///     # unchanged.
/// ```
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
/// </div>
class DynamicStitchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Tensor contraction according to Einstein summation convention.
/// Implements generalized Tensor contraction and reduction. Each input Tensor must
/// have a corresponding input subscript appearing in the comma-separated left-hand
/// side of the equation. The right-hand side of the equation consists of the
/// output subscript. The input subscripts and the output subscript should consist
/// of zero or more named axis labels and at most one ellipsis (`...`).
/// 
/// The named axis labels may be any single character other than those having
/// special meaning, namely `,.->`. The behavior of this Op is undefined if it
/// receives an ill-formatted equation; since the validation is done at
/// graph-building time, we omit format validation checks at runtime.
/// 
/// Note: This Op is *not* intended to be called by the user; instead users should
/// call `tf.einsum` directly. It is a hidden Op used by `tf.einsum`.
/// 
/// Operations are applied to the input(s) according to the following rules:
/// 
///  (a) Generalized Diagonals: For input dimensions corresponding to axis labels
///      appearing more than once in the same input subscript, we take the
///      generalized (`k`-dimensional) diagonal.
///      For example, in the equation `iii->i` with input shape `[3, 3, 3]`, the
///      generalized diagonal would consist of `3` elements at indices `(0, 0, 0)`,
///      `(1, 1, 1)` and `(2, 2, 2)` to create a Tensor of shape `[3]`.
/// 
///  (b) Reduction: Axes corresponding to labels appearing only in one input
///      subscript but not in the output subscript are summed over prior to Tensor
///      contraction.
///      For example, in the equation `ab,bc->b`, the axis labels `a` and `c` are
///      the reduction axis labels.
/// 
///  (c) Batch Dimensions: Axes corresponding to labels appearing in each of the
///      input subscripts and also in the output subscript make up the batch
///      dimensions in Tensor contraction. Unnamed axis labels corresponding to
///      ellipsis (`...`) also correspond to batch dimensions.
///      For example, for the equation denoting batch matrix multiplication,
///      `bij,bjk->bik`, the axis label `b` corresponds to a batch dimension.
/// 
///  (d) Contraction: In case of binary einsum, axes corresponding to labels
///      appearing in two different inputs (and not in the output) are contracted
///      against each other.
///      Considering the batch matrix multiplication equation again
///      (`bij,bjk->bik`), the contracted axis label is `j`.
/// 
///  (e) Expand Diagonal: If the output subscripts contain repeated (explicit) axis
///      labels, the opposite operation of (a) is applied. For example, in the
///      equation `i->iii`, and input shape `[3]`, the output of shape `[3, 3, 3]`
///      are all zeros, except for the (generalized) diagonal which is populated
///      with values from the input.
///      Note: This operation is not supported by `np.einsum` or `tf.einsum`; it is
///      provided to enable computing the symbolic gradient of `tf.einsum`.
/// 
/// The output subscripts must contain only labels appearing in at least one of the
/// input subscripts. Furthermore, all dimensions mapping to the same axis label
/// must be equal.
/// 
/// Any of the input and output subscripts may contain at most a single ellipsis
/// (`...`). These ellipsis are mapped against dimensions not corresponding to any
/// named axis label. If two inputs contain ellipsis, then they are broadcasted
/// according to standard NumPy broadcasting
/// [rules](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
/// 
/// The broadcasted dimensions are placed in the corresponding location of the
/// ellipsis in the output subscript. If the broadcasted dimensions are non-empty
/// and the output subscripts do not contain ellipsis, then an InvalidArgument error
/// is raised.
/// 
/// @compatibility(numpy)
/// Similar to [`numpy.einsum`](https://docs.scipy.org/doc/numpy/reference/generated/numpy.einsum.html).
/// 
/// Comparison with `numpy.einsum`:
/// 
///  * This Op only supports unary and binary forms of `numpy.einsum`.
///  * This Op does not support implicit form. (i.e. equations without `->`).
///  * This Op also supports repeated indices in the output subscript, which is not
///    supported by `numpy.einsum`.
/// @end_compatibility
class EinsumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for the exponential linear (Elu) operation.
class EluGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the exponential linear function.
/// The ELU function is defined as:
/// 
///  * $ e ^ x - 1 $ if $ x < 0 $
///  * $ x $ if $ x >= 0 $
/// 
/// Examples:
/// 
/// >>> tf.nn.elu(1.0)
/// <tf.Tensor: shape=(), dtype=float32, numpy=1.0>
/// >>> tf.nn.elu(0.0)
/// <tf.Tensor: shape=(), dtype=float32, numpy=0.0>
/// >>> tf.nn.elu(-1000.0)
/// <tf.Tensor: shape=(), dtype=float32, numpy=-1.0>
/// 
/// See [Fast and Accurate Deep Network Learning by Exponential Linear Units (ELUs)
/// ](http://arxiv.org/abs/1511.07289)
class EluOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a tensor with the given shape.
/// 
/// This operation creates a tensor of `shape` and `dtype`.
class EmptyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates and returns an empty tensor list.
/// All list elements must be tensors of dtype element_dtype and shape compatible
/// with element_shape.
/// 
/// handle: an empty tensor list.
/// element_dtype: the type of elements in the list.
/// element_shape: a shape compatible with that of elements in the list.
class EmptyTensorListOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// PNG-encode an image.
/// `image` is a 3-D uint8 or uint16 Tensor of shape `[height, width, channels]`
/// where `channels` is:
/// 
/// *   1: for grayscale.
/// *   2: for grayscale + alpha.
/// *   3: for RGB.
/// *   4: for RGBA.
/// 
/// The ZLIB compression level, `compression`, can be -1 for the PNG-encoder
/// default or a value from 0 to 9.  9 is the highest compression level, generating
/// the smallest output, but is slower.
class EncodePngOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
/// embedding_indices[i] and aggregation_weights[i] correspond
/// to the ith feature.
/// 
/// The tensors at corresponding positions in the three input lists (sample_indices,
/// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
/// with dim_size() equal to the total number of lookups into the table described by
/// the corresponding feature.
class EnqueueTPUEmbeddingArbitraryTensorBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that enqueues a list of input batch tensors to TPUEmbedding.
/// An op that enqueues a list of input batch tensors to TPUEmbedding.
class EnqueueTPUEmbeddingBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that enqueues a list of input batch tensors to TPUEmbedding.
class EnqueueTPUEmbeddingIntegerBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Eases the porting of code that uses tf.nn.embedding_lookup().
/// sample_splits[i], embedding_indices[i] and aggregation_weights[i] correspond
/// to the ith feature. table_ids[i] indicates which embedding table to look up ith
/// feature.
/// 
/// The tensors at corresponding positions in two of the input lists,
/// embedding_indices and aggregation_weights, must have the same shape, i.e. rank 1
/// with dim_size() equal to the total number of lookups into the table described by
/// the corresponding feature.
class EnqueueTPUEmbeddingRaggedTensorBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that enqueues TPUEmbedding input indices from a SparseTensor.
/// This Op eases the porting of code that uses embedding_lookup_sparse(),
/// although some Python preprocessing of the SparseTensor arguments to
/// embedding_lookup_sparse() is required to produce the arguments to this Op,
/// since only a single EnqueueTPUEmbeddingSparseBatch Op is allowed per training
/// step.
/// 
/// The tensors at corresponding positions in the three input lists
/// must have the same shape, i.e. rank 1 with dim_size() equal to the total
/// number of lookups into the table described by the corresponding table_id.
class EnqueueTPUEmbeddingSparseBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
/// sample_indices[i], embedding_indices[i] and aggregation_weights[i] correspond
/// to the ith feature. table_ids[i] indicates which embedding table to look up ith
/// feature.
/// 
/// The tensors at corresponding positions in the three input lists (sample_indices,
/// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
/// with dim_size() equal to the total number of lookups into the table described by
/// the corresponding feature.
class EnqueueTPUEmbeddingSparseTensorBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Ensures that the tensor's shape matches the expected shape.
/// Raises an error if the input tensor's shape does not match the specified shape.
/// Returns the input tensor otherwise.
class EnsureShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x == y) element-wise.
/// *NOTE*: `Equal` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
/// 
/// ```python
/// x = tf.constant([2, 4])
/// y = tf.constant(2)
/// tf.math.equal(x, y) ==> array([True, False])
/// 
/// x = tf.constant([2, 4])
/// y = tf.constant([2, 4])
/// tf.math.equal(x, y) ==> array([True,  True])
/// ```
class EqualOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the [Gauss error function](https://en.wikipedia.org/wiki/Error_function) of `x` element-wise. In statistics, for non-negative values of $x$, the error function has the following interpretation: for a random variable $Y$ that is normally distributed with mean 0 and variance $1/\sqrt{2}$, $erf(x)$ is the probability that $Y$ falls in the range $[−x, x]$.
class ErfOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the complementary error function of `x` element-wise.
class ErfcOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ErfinvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that executes the TPUEmbedding partitioner on the central configuration
/// device and computes the HBM size (in bytes) required for TPUEmbedding operation.
class ExecuteTPUEmbeddingPartitionerOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes exponential of x element-wise.  \\(y = e^x\\).
/// This function computes the exponential of every element in the input tensor.
///   i.e. `exp(x)` or `e^(x)`, where `x` is the input tensor.
///   `e` denotes Euler's number and is approximately equal to 2.718281.
///   Output is positive for any real input.
/// 
///   ```python
///   x = tf.constant(2.0)
///   tf.math.exp(x) ==> 7.389056
/// 
///   x = tf.constant([2.0, 8.0])
///   tf.math.exp(x) ==> array([7.389056, 2980.958], dtype=float32)
///   ```
/// 
///   For complex numbers, the exponential value is calculated as follows:
/// 
///   ```
///   e^(x+iy) = e^x * e^iy = e^x * (cos y + i sin y)
///   ```
/// 
///   Let's consider complex number 1+1j as an example.
///   e^1 * (cos 1 + i sin 1) = 2.7182818284590 * (0.54030230586+0.8414709848j)
/// 
///   ```python
///   x = tf.constant(1 + 1j)
///   tf.math.exp(x) ==> 1.4686939399158851+2.2873552871788423j
///   ```
class ExpOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inserts a dimension of 1 into a tensor's shape.
/// Given a tensor `input`, this operation inserts a dimension of 1 at the
/// dimension index `axis` of `input`'s shape. The dimension index `axis` starts at
/// zero; if you specify a negative number for `axis` it is counted backward from
/// the end.
/// 
/// This operation is useful if you want to add a batch dimension to a single
/// element. For example, if you have a single image of shape `[height, width,
/// channels]`, you can make it a batch of 1 image with `expand_dims(image, 0)`,
/// which will make the shape `[1, height, width, channels]`.
/// 
/// Other examples:
/// 
/// ```
/// # 't' is a tensor of shape [2]
/// shape(expand_dims(t, 0)) ==> [1, 2]
/// shape(expand_dims(t, 1)) ==> [2, 1]
/// shape(expand_dims(t, -1)) ==> [2, 1]
/// 
/// # 't2' is a tensor of shape [2, 3, 5]
/// shape(expand_dims(t2, 0)) ==> [1, 2, 3, 5]
/// shape(expand_dims(t2, 2)) ==> [2, 3, 1, 5]
/// shape(expand_dims(t2, 3)) ==> [2, 3, 5, 1]
/// ```
/// 
/// This operation requires that:
/// 
/// `-1-input.dims() <= dim <= input.dims()`
/// 
/// This operation is related to `squeeze()`, which removes dimensions of
/// size 1.
class ExpandDimsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes `exp(x) - 1` element-wise.
/// i.e. `exp(x) - 1` or `e^(x) - 1`, where `x` is the input tensor.
///   `e` denotes Euler's number and is approximately equal to 2.718281.
/// 
///   ```python
///   x = tf.constant(2.0)
///   tf.math.expm1(x) ==> 6.389056
/// 
///   x = tf.constant([2.0, 8.0])
///   tf.math.expm1(x) ==> array([6.389056, 2979.958], dtype=float32)
/// 
///   x = tf.constant(1 + 1j)
///   tf.math.expm1(x) ==> (0.46869393991588515+2.2873552871788423j)
///   ```
class Expm1Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Extract `patches` from `images` and put them in the "depth" output dimension.
class ExtractImagePatchesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// 2D fast Fourier transform.
/// Computes the 2-dimensional discrete Fourier transform over the inner-most
/// 2 dimensions of `input`.
class FFT2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// 3D fast Fourier transform.
/// Computes the 3-dimensional discrete Fourier transform over the inner-most 3
/// dimensions of `input`.
class FFT3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fast Fourier transform.
/// Computes the 1-dimensional discrete Fourier transform over the inner-most
/// dimension of `input`.
class FFTOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op is used as a placeholder in If branch functions. It doesn't provide a
///   valid output when run, so must either be removed (e.g. replaced with a
///   function input) or guaranteed not to be used (e.g. if mirroring an
///   intermediate output needed for the gradient computation of the other branch).
class FakeParamOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute gradients for a FakeQuantWithMinMaxArgs operation.
class FakeQuantWithMinMaxArgsGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fake-quantize the 'inputs' tensor, type float to 'outputs' tensor of same shape and type.
/// Quantization is called fake since the output is still in floating point.
///   The API converts inputs into values within the range [min and max] and returns
///   as output.
/// 
/// Attributes
/// 
/// *   `[min; max]` define the clamping range for the `inputs` data.
/// *   `inputs` values are quantized into the quantization range (
/// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
/// when it is true) and then de-quantized and output as floats in `[min; max]`
/// interval.
/// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
/// 
/// Before quantization, `min` and `max` values are adjusted with the following
/// logic.
/// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
/// the behavior can be unexpected:
/// 
/// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
/// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
/// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
/// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
/// 
/// 
/// Examples
/// 
/// ```python
/// 
/// inp = tf.constant ([10.03, -10.23, 3])
/// out = tf.quantization.fake_quant_with_min_max_args(inp, min=-5, max=5,
///                                                    num_bits=16)
/// print(out)
/// 
/// #  Output:
/// #  tf.Tensor([ 4.9999237 -5.0000763  3.0000763], shape=(3,), dtype=float32)
/// ```
/// 
/// Raises:
///   * InvalidArgumentError:
///     - If num_bits are outside of range [2, 16].
///     - If min >= max.
///   * ValueError: If `inputs` are of any other type than float32.
class FakeQuantWithMinMaxArgsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute gradients for a FakeQuantWithMinMaxVars operation.
class FakeQuantWithMinMaxVarsGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fake-quantize the 'inputs' tensor of type float via global float scalars
/// Fake-quantize the `inputs` tensor of type float via global float scalars
/// `min` and `max` to `outputs` tensor of same shape as `inputs`.
/// 
/// Attributes
/// 
/// *   `[min; max]` define the clamping range for the `inputs` data.
/// *   `inputs` values are quantized into the quantization range (
/// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
/// when it is true) and then de-quantized and output as floats in `[min; max]`
/// interval.
/// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
/// 
/// Before quantization, `min` and `max` values are adjusted with the following
/// logic.
/// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
/// the behavior can be unexpected:
/// 
/// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
/// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
/// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
/// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
/// 
/// This operation has a gradient and thus allows for training `min` and `max`
/// values.
/// 
/// >>> constant_input = tf.constant([[1.2, -0.3, 0.7], [2.1, 0.5, -1.0]], dtype=tf.float32)
/// >>>
/// >>> min_val = -0.5
/// >>> max_val = 0.8
/// >>> num_bits = 8
/// >>> narrow_range = False #False:for the quantization range [0; 2^num_bits - 1]
/// >>>
/// >>> quantized_data = tf.quantization.fake_quant_with_min_max_vars(
/// ...   inputs=constant_input, min=min_val, max=max_val, num_bits=num_bits, narrow_range=narrow_range
/// ... )
/// >>>
/// >>> print("Input:\n", constant_input.numpy())
/// Input:
/// [[ 1.2 -0.3  0.7]
/// [ 2.1  0.5 -1. ]]
/// >>> print("Output:\n", quantized_data.numpy())
/// Output:
/// [[ 0.8003921 -0.3007843  0.6984313]
/// [ 0.8003921  0.4996078 -0.4996078]]
class FakeQuantWithMinMaxVarsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute gradients for a FakeQuantWithMinMaxVarsPerChannel operation.
class FakeQuantWithMinMaxVarsPerChannelGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fake-quantize the 'inputs' tensor of type float via per-channel floats
/// Fake-quantize the `inputs` tensor of type float per-channel and one of the
/// shapes: `[d]`, `[b, d]` `[b, h, w, d]` via per-channel floats `min` and `max`
/// of shape `[d]` to `outputs` tensor of same shape as `inputs`.
/// 
/// Attributes
/// 
/// *   `[min; max]` define the clamping range for the `inputs` data.
/// *   `inputs` values are quantized into the quantization range (
/// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
/// when it is true) and then de-quantized and output as floats in `[min; max]`
/// interval.
/// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
/// 
/// Before quantization, `min` and `max` values are adjusted with the following
/// logic.
/// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
/// the behavior can be unexpected:
/// 
/// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
/// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
/// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
/// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
/// 
/// This operation has a gradient and thus allows for training `min` and `max`
/// values.
class FakeQuantWithMinMaxVarsPerChannelOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a tensor filled with a scalar value.
/// This operation creates a tensor of shape `dims` and fills it with `value`.
/// 
/// For example:
/// 
/// ```
/// # Output tensor has shape [2, 3].
/// fill([2, 3], 9) ==> [[9, 9, 9]
///                      [9, 9, 9]]
/// ```
/// 
/// `tf.fill` differs from `tf.constant` in a few ways:
/// 
/// *   `tf.fill` only supports scalar contents, whereas `tf.constant` supports
///     Tensor values.
/// *   `tf.fill` creates an Op in the computation graph that constructs the actual
///     Tensor value at runtime. This is in contrast to `tf.constant` which embeds
///     the entire Tensor into the graph with a `Const` node.
/// *   Because `tf.fill` evaluates at graph runtime, it supports dynamic shapes
///     based on other runtime Tensors, unlike `tf.constant`.
class FillOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset by applying `tf.data.Options` to `input_dataset`.
class FinalizeDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that finalizes the TPUEmbedding configuration.
class FinalizeTPUEmbeddingOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that applies `f` to the outputs of `input_dataset`.
/// Unlike MapDataset, the `f` in FlatMapDataset is expected to return a
/// Dataset variant, and FlatMapDataset will flatten successive results
/// into a single Dataset.
class FlatMapDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x // y element-wise.
/// *NOTE*: `FloorDiv` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class FloorDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise remainder of division.
/// This follows Python semantics in that the
/// result here is consistent with a flooring divide. E.g.
/// `floor(x / y) * y + floormod(x, y) = x`, regardless of the signs of x and y.
/// 
/// *NOTE*: `FloorMod` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class FloorModOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise largest integer not greater than x.
class FloorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Flushes the writer's unwritten events.
/// writer: A handle to the summary writer resource.
class FlushSummaryWriterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gradient for batch normalization.
/// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
/// The size of 1D Tensors matches the dimension C of the 4D Tensors.
class FusedBatchNormGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gradient for batch normalization.
/// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
/// The size of 1D Tensors matches the dimension C of the 4D Tensors.
class FusedBatchNormGradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gradient for batch normalization.
/// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
/// The size of 1D Tensors matches the dimension C of the 4D Tensors.
class FusedBatchNormGradV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Batch normalization.
/// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
/// The size of 1D Tensors matches the dimension C of the 4D Tensors.
class FusedBatchNormOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Batch normalization.
/// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
/// The size of 1D Tensors matches the dimension C of the 4D Tensors.
class FusedBatchNormV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Batch normalization.
/// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
/// The size of 1D Tensors matches the dimension C of the 4D Tensors.
class FusedBatchNormV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes a fused kernel which implements: 2-D convolution, adds side input,
/// with separate scaling on convolution and side inputs, then adds bias and
///     applies the RELU activation function to the result. Supports both float and
///     qint8 data formats. In the case of qint8, the output is clipped to [0..127].
/// 
///     conv_input: A tensor with format as specified by `data_format` (see below).
///     filter: A tensor with format depending on `data_format` as follows:
///         "NHWC", "NCHW":
///              `float [ filter_height, filter_width, in_channels, out_channels ]`
///         "NCHW_VECT_C":
///              `qint8 [ out_channels, in_channels, filter_height, filter_width ]`
///     bias: 1-D float tensor with size matching the `out_channels` dimension of
///         `filter`.
///         Note: this tensor is still float, even if other inputs are qint8.
///     side_input: A tensor with format as specified by `data_format` (see below).
///         This tensor will be ignored and can be [] if side_input_scale == 0.
///         Otherwise, the size of each dimension must match the `output` tensor.
///     conv_input_scale: scalar float value to be multiplied by `conv_input`.
///         (conceptually.. in reality it is applied after convolution).
///         For the CPU version, this can also be a 1-D Tensor of per output-channel
///         scales.
///     side_input_scale: scalar float value to be multiplied by `side_input`.
///     output: A tensor with format as specified by `data_format` (see below).
///         The dimension sizes are determined automatically based on other inputs
///         and attributes.
///     T: The element data type of `conv_input`, `side_input` and `output` tensors.
///         Note: must match with the `data_format`.
///     Tbias: The element data type of `bias`.
///     strides: 1-D tensor of length 4.  The stride of the sliding window for each
///         dimension of `input`. The dimension order is determined by the value of
///         `data_format`, see below for details.
///         Note: the stride for batch and channel dimensions must be 1.
///     padding: The type of padding algorithm to use.
///     data_format: A string specifying the data format of `conv_input`,
///         `side_input` and `output` tensors with the following options:
///         "NHWC": `float [ batch, height, width, channels ]`
///         "NCHW": `float [ batch, channels, height, width ]`
///         "NCHW_VECT_C":
///             `qint8 [ batch, channels / 4, height, width, channels % 4 ]`
///         Note: for "NCHW_VECT_C", `channels` must be a multiple of 4.
///     filter_format: A string specifying the data format of `filter`,
///         "HWIO": `float [ kernel_height, kernel_width, input_channels,
///                          output_channels ]`
///         "OIHW_VECT_I":
///             `qint8 [ output_channels, input_channels / 4,
///                      kernel_height, kernel_width, input_channels % 4 ]`
///     activation_mode: The activation applied to the output.
///         Must be "Relu" or "None".
///     dilations: 1-D tensor of length 4.  The dilation factor for each dimension
///         of `input`. If set to k > 1, there will be k-1 skipped cells between
///         each filter element on that dimension. The dimension order is determined
///         by the value of `data_format`, see above for details. Dilations in the
///         batch and depth dimensions must be 1.
class FusedConv2DBiasActivationOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather slices from `params` into a Tensor with shape specified by `indices`.
/// `indices` is a K-dimensional integer tensor, best thought of as a
/// (K-1)-dimensional tensor of indices into `params`, where each element defines a
/// slice of `params`:
/// 
///     output[\\(i_0, ..., i_{K-2}\\)] = params[indices[\\(i_0, ..., i_{K-2}\\)]]
/// 
/// Whereas in `tf.gather` `indices` defines slices into the `axis`
/// dimension of `params`, in `tf.gather_nd`, `indices` defines slices into the
/// first `N` dimensions of `params`, where `N = indices.shape[-1]`.
/// 
/// The last dimension of `indices` can be at most the rank of
/// `params`:
/// 
///     indices.shape[-1] <= params.rank
/// 
/// The last dimension of `indices` corresponds to elements
/// (if `indices.shape[-1] == params.rank`) or slices
/// (if `indices.shape[-1] < params.rank`) along dimension `indices.shape[-1]`
/// of `params`.  The output tensor has shape
/// 
///     indices.shape[:-1] + params.shape[indices.shape[-1]:]
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore error and set the corresponding output to 0;
///    supported on both CPU and GPU.
/// 
/// Some examples below.
/// 
/// Simple indexing into a matrix:
/// 
/// ```python
///     indices = [[0, 0], [1, 1]]
///     params = [['a', 'b'], ['c', 'd']]
///     output = ['a', 'd']
/// ```
/// 
/// Slice indexing into a matrix:
/// 
/// ```python
///     indices = [[1], [0]]
///     params = [['a', 'b'], ['c', 'd']]
///     output = [['c', 'd'], ['a', 'b']]
/// ```
/// 
/// Indexing into a 3-tensor:
/// 
/// ```python
///     indices = [[1]]
///     params = [[['a0', 'b0'], ['c0', 'd0']],
///               [['a1', 'b1'], ['c1', 'd1']]]
///     output = [[['a1', 'b1'], ['c1', 'd1']]]
/// 
/// 
///     indices = [[0, 1], [1, 0]]
///     params = [[['a0', 'b0'], ['c0', 'd0']],
///               [['a1', 'b1'], ['c1', 'd1']]]
///     output = [['c0', 'd0'], ['a1', 'b1']]
/// 
/// 
///     indices = [[0, 0, 1], [1, 0, 1]]
///     params = [[['a0', 'b0'], ['c0', 'd0']],
///               [['a1', 'b1'], ['c1', 'd1']]]
///     output = ['b0', 'b1']
/// ```
/// 
/// Batched indexing into a matrix:
/// 
/// ```python
///     indices = [[[0, 0]], [[0, 1]]]
///     params = [['a', 'b'], ['c', 'd']]
///     output = [['a'], ['b']]
/// ```
/// 
/// Batched slice indexing into a matrix:
/// 
/// ```python
///     indices = [[[1]], [[0]]]
///     params = [['a', 'b'], ['c', 'd']]
///     output = [[['c', 'd']], [['a', 'b']]]
/// ```
/// 
/// Batched indexing into a 3-tensor:
/// 
/// ```python
///     indices = [[[1]], [[0]]]
///     params = [[['a0', 'b0'], ['c0', 'd0']],
///               [['a1', 'b1'], ['c1', 'd1']]]
///     output = [[[['a1', 'b1'], ['c1', 'd1']]],
///               [[['a0', 'b0'], ['c0', 'd0']]]]
/// 
///     indices = [[[0, 1], [1, 0]], [[0, 0], [1, 1]]]
///     params = [[['a0', 'b0'], ['c0', 'd0']],
///               [['a1', 'b1'], ['c1', 'd1']]]
///     output = [[['c0', 'd0'], ['a1', 'b1']],
///               [['a0', 'b0'], ['c1', 'd1']]]
/// 
/// 
///     indices = [[[0, 0, 1], [1, 0, 1]], [[0, 1, 1], [1, 1, 0]]]
///     params = [[['a0', 'b0'], ['c0', 'd0']],
///               [['a1', 'b1'], ['c1', 'd1']]]
///     output = [['b0', 'b1'], ['d0', 'c1']]
/// ```
/// 
/// See also `tf.gather` and `tf.batch_gather`.
class GatherNdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather slices from `params` according to `indices`.
/// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
/// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
/// 
/// ```python
///     # Scalar indices
///     output[:, ..., :] = params[indices, :, ... :]
/// 
///     # Vector indices
///     output[i, :, ..., :] = params[indices[i], :, ... :]
/// 
///     # Higher rank indices
///     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
/// ```
/// 
/// If `indices` is a permutation and `len(indices) == params.shape[0]` then
/// this operation will permute `params` accordingly.
/// 
/// `validate_indices`: DEPRECATED. If this operation is assigned to CPU, values in
/// `indices` are always validated to be within range. If assigned to GPU,
/// out-of-bound indices result in safe but unspecified behavior, which may include
/// raising an error.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
/// </div>
class GatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather slices from `params` axis `axis` according to `indices`.
/// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
/// Produces an output tensor with shape `params.shape[:axis] +
/// indices.shape[batch_dims:] + params.shape[axis + 1:]` where:
/// 
/// ```python
///     # Scalar indices (output is rank(params) - 1).
///     output[a_0, ..., a_n, b_0, ..., b_n] =
///       params[a_0, ..., a_n, indices, b_0, ..., b_n]
/// 
///     # Vector indices (output is rank(params)).
///     output[a_0, ..., a_n, i, b_0, ..., b_n] =
///       params[a_0, ..., a_n, indices[i], b_0, ..., b_n]
/// 
///     # Higher rank indices (output is rank(params) + rank(indices) - 1).
///     output[a_0, ..., a_n, i, ..., j, b_0, ... b_n] =
///       params[a_0, ..., a_n, indices[i, ..., j], b_0, ..., b_n]
/// ```
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
/// </div>
/// 
/// Note that on CPU, if an out of bound index is found, an error is returned.
/// On GPU, if an out of bound index is found, a 0 is stored in the
/// corresponding output value.
/// 
/// Note that on TPU, if any dimension of `params` is of size 0 then the output will
/// be the expected shape filled with zeros. On CPU and GPU an error will be
/// returned.
/// 
/// See also `tf.batch_gather` and `tf.gather_nd`.
class GatherV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that invokes a function to generate elements.
class GeneratorDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Regional version of GeneratorDataset
/// Creates a dataset that invokes its 'next' region to generate elements. Conceptually,
/// within MLIR, we treat this op as if it fills a buffer with all the results right away,
/// and those results are then passed (through the variant tensor result) to
/// MakeIterator / IteratorGetNext. Note that the actual TF implementation differs: It
/// generates the next element just in time, during IteratorGetNext.
/// 
/// init_extra_args: Additional arguments to pass to 'init'.
/// next_extra_args: Additional arguments to pass to 'next'. (Passed after the
///                  normal arguments which are from the return values of 'init'.)
/// finalize_extra_args: Additional arguments to pass to 'finalize'. (Passed after
///                  the normal arguments which are from the return values of 'init'.)
class GeneratorDatasetRegionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class GetMinibatchSplitsWithPhysicalReplicaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class GetMinibatchesInCsrWithPhysicalReplicaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which computes the max_ids/uniques for a given table.
class GetStatsFromListOfSparseCoreCooTensorsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that gets the global step id.
/// This op gets the step id for each loop iteration.
class GlobalIterIdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x >= y) element-wise.
/// *NOTE*: `GreaterEqual` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5, 4, 6, 7])
/// y = tf.constant([5, 2, 5, 10])
/// tf.math.greater_equal(x, y) ==> [True, True, True, False]
/// 
/// x = tf.constant([5, 4, 6, 7])
/// y = tf.constant([5])
/// tf.math.greater_equal(x, y) ==> [True, False, True, True]
/// ```
class GreaterEqualOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x > y) element-wise.
/// *NOTE*: `Greater` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5, 4, 6])
/// y = tf.constant([5, 2, 5])
/// tf.math.greater(x, y) ==> [False, True, True]
/// 
/// x = tf.constant([5, 4, 6])
/// y = tf.constant([5])
/// tf.math.greater(x, y) ==> [False, False, True]
/// ```
class GreaterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Convert one or more images from HSV to RGB.
/// Outputs a tensor of the same shape as the `images` tensor, containing the RGB
/// value of the pixels. The output is only well defined if the value in `images`
/// are in `[0,1]`.
/// 
/// See `rgb_to_hsv` for a description of the HSV encoding.
class HSVToRGBOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a non-initialized hash table.
/// This op creates a hash table, specifying the type of its keys and values.
/// Before using the table you will have to initialize it.  After initialization the
/// table will be immutable.
class HashTableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a non-initialized hash table.
/// This op creates a hash table, specifying the type of its keys and values.
/// Before using the table you will have to initialize it.  After initialization the
/// table will be immutable.
class HashTableV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse 2D fast Fourier transform.
/// Computes the inverse 2-dimensional discrete Fourier transform over the
/// inner-most 2 dimensions of `input`.
class IFFT2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse 3D fast Fourier transform.
/// Computes the inverse 3-dimensional discrete Fourier transform over the
/// inner-most 3 dimensions of `input`.
class IFFT3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse fast Fourier transform.
/// Computes the inverse 1-dimensional discrete Fourier transform over the
/// inner-most dimension of `input`.
class IFFTOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse 2D real-valued fast Fourier transform.
/// Computes the inverse 2-dimensional discrete Fourier transform of a real-valued
/// signal over the inner-most 2 dimensions of `input`.
/// 
/// The inner-most 2 dimensions of `input` are assumed to be the result of `RFFT2D`:
/// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
/// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
/// from the size of the inner-most 2 dimensions of `input`. If the FFT length used
/// to compute `input` is odd, it should be provided since it cannot be inferred
/// properly.
/// 
/// Along each axis `IRFFT2D` is computed on, if `fft_length` (or
/// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class IRFFT2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse 3D real-valued fast Fourier transform.
/// Computes the inverse 3-dimensional discrete Fourier transform of a real-valued
/// signal over the inner-most 3 dimensions of `input`.
/// 
/// The inner-most 3 dimensions of `input` are assumed to be the result of `RFFT3D`:
/// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
/// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
/// from the size of the inner-most 3 dimensions of `input`. If the FFT length used
/// to compute `input` is odd, it should be provided since it cannot be inferred
/// properly.
/// 
/// Along each axis `IRFFT3D` is computed on, if `fft_length` (or
/// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class IRFFT3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse real-valued fast Fourier transform.
/// Computes the inverse 1-dimensional discrete Fourier transform of a real-valued
/// signal over the inner-most dimension of `input`.
/// 
/// The inner-most dimension of `input` is assumed to be the result of `RFFT`: the
/// `fft_length / 2 + 1` unique components of the DFT of a real-valued signal. If
/// `fft_length` is not provided, it is computed from the size of the inner-most
/// dimension of `input` (`fft_length = 2 * (inner - 1)`). If the FFT length used to
/// compute `input` is odd, it should be provided since it cannot be inferred
/// properly.
/// 
/// Along the axis `IRFFT` is computed on, if `fft_length / 2 + 1` is smaller
/// than the corresponding dimension of `input`, the dimension is cropped. If it is
/// larger, the dimension is padded with zeros.
class IRFFTOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a list of tensors with the same shapes and contents as the input
/// tensors.
/// 
/// This op can be used to override the gradient for complicated functions. For
/// example, suppose y = f(x) and we wish to apply a custom function g for backprop
/// such that dx = g(dy). In Python,
/// 
/// ```python
/// with tf.get_default_graph().gradient_override_map(
///     {'IdentityN': 'OverrideGradientWithG'}):
///   y, _ = identity_n([f(x), x])
/// 
/// @tf.RegisterGradient('OverrideGradientWithG')
/// def ApplyG(op, dy, _):
///   return [None, g(dy)]  # Do not backprop to f(x).
/// ```
class IdentityNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return a tensor with the same shape and contents as the input tensor or value.
class IdentityOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// output = cond ? then_branch(input) : else_branch(input)
/// output = cond ? then_branch(input) : else_branch(input)
/// 
/// cond: A Tensor. If the tensor is a scalar of non-boolean type, the
///     scalar is converted to a boolean according to the
///     following rule: if the scalar is a numerical value, non-zero means
///     True and zero means False; if the scalar is a string, non-empty
///     means True and empty means False. If the tensor is not a scalar,
///     being empty means False and being non-empty means True.
/// input: A list of input tensors.
/// then_branch: A function that takes 'inputs' and returns a list of
///     tensors, whose types are the same as what else_branch returns.
/// else_branch: A function that takes 'inputs' and returns a list of
///     tensors.  whose types are the same as what then_branch returns.
class IfOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// output = cond ? then_branch output : else_branch output
/// "output = cond ? then_branch output : else_branch output"
/// 
/// cond: A Tensor. If the tensor is a scalar of non-boolean type, the
///     scalar is converted to a boolean according to the
///     following rule: if the scalar is a numerical value, non-zero means
///     True and zero means False; if the scalar is a string, non-empty
///     means True and empty means False. If the tensor is not a scalar,
///     being empty means False and being non-empty means True.
/// then_branch: A region that computes the outputs of the op if cond = true.
///     It returns a list of tensors using tf.yield (as the terminator). The
///     types of these returned tensors is same as that of the else_branch
/// else_branch: A region that computes the outputs of the op if cond = false.
///     It returns a list of tensors using tf.yield (as the terminator). The
///     types of these returned tensors is same as that of the then_branch
class IfRegionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of `igamma(a, x)` wrt `a`.
class IgammaGradAOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the lower regularized incomplete Gamma function `P(a, x)`.
/// The lower regularized incomplete Gamma function is defined as:
/// 
/// 
/// \\(P(a, x) = gamma(a, x) / Gamma(a) = 1 - Q(a, x)\\)
/// 
/// where
/// 
/// \\(gamma(a, x) = \int_{0}^{x} t^{a-1} exp(-t) dt\\)
/// 
/// is the lower incomplete Gamma function.
/// 
/// Note, above `Q(a, x)` (`Igammac`) is the upper regularized complete
/// Gamma function.
class IgammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the upper regularized incomplete Gamma function `Q(a, x)`.
/// The upper regularized incomplete Gamma function is defined as:
/// 
/// \\(Q(a, x) = Gamma(a, x) / Gamma(a) = 1 - P(a, x)\\)
/// 
/// where
/// 
/// \\(Gamma(a, x) = \int_{x}^{\infty} t^{a-1} exp(-t) dt\\)
/// 
/// is the upper incomplete Gamma function.
/// 
/// Note, above `P(a, x)` (`Igamma`) is the lower regularized complete
/// Gamma function.
class IgammacOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the imaginary part of a complex number.
/// Given a tensor `input` of complex numbers, this operation returns a tensor of
/// type `float` that is the imaginary part of each element in `input`. All
/// elements in `input` must be complex numbers of the form \\(a + bj\\), where *a*
/// is the real part and *b* is the imaginary part returned by this operation.
/// 
/// For example:
/// 
/// ```
/// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
/// tf.imag(input) ==> [4.75, 5.75]
/// ```
class ImagOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs a `tf.Event` protocol buffer.
/// When CreateSummaryDbWriter is being used, this op can be useful for
/// importing data from event logs.
/// 
/// writer: A handle to a summary writer.
/// event: A string containing a binary-encoded tf.Event proto.
class ImportEventOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Says whether the targets are in the top `K` predictions.
/// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
/// prediction for the target class is among the top `k` predictions among
/// all predictions for example `i`. Note that the behavior of `InTopK` differs
/// from the `TopK` op in its handling of ties; if multiple classes have the
/// same prediction value and straddle the top-`k` boundary, all of those
/// classes are considered to be in the top `k`.
/// 
/// More formally, let
/// 
///   \\(predictions_i\\) be the predictions for all classes for example `i`,
///   \\(targets_i\\) be the target class for example `i`,
///   \\(out_i\\) be the output for example `i`,
/// 
/// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
class InTopKV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A placeholder op for a value that will be fed into the computation.
class InfeedDequeueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fetches multiple values from infeed as an XLA tuple.
class InfeedDequeueTupleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Feeds multiple Tensor values into the computation as an XLA tuple.
class InfeedEnqueueTupleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class InitializeTableFromDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Initializes a table from a text file.
/// It inserts one key-value pair into the table for each line of the file.
/// The key and value is extracted from the whole line content, elements from the
/// split line based on `delimiter` or the line number (starting from zero).
/// Where to extract the key and value from a line is specified by `key_index` and
/// `value_index`.
/// 
/// - A value of -1 means use the line number(starting from zero), expects `int64`.
/// - A value of -2 means use the whole line content, expects `string`.
/// - A value >= 0 means use the index (starting at zero) of the split line based
///   on `delimiter`.
class InitializeTableFromTextFileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Initializes a table from a text file.
/// It inserts one key-value pair into the table for each line of the file.
/// The key and value is extracted from the whole line content, elements from the
/// split line based on `delimiter` or the line number (starting from zero).
/// Where to extract the key and value from a line is specified by `key_index` and
/// `value_index`.
/// 
/// - A value of -1 means use the line number(starting from zero), expects `int64`.
/// - A value of -2 means use the whole line content, expects `string`.
/// - A value >= 0 means use the index (starting at zero) of the split line based
///   on `delimiter`.
class InitializeTableFromTextFileV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Table initializer that takes two tensors for keys and values respectively.
class InitializeTableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Table initializer that takes two tensors for keys and values respectively.
class InitializeTableV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds v into specified rows of x.
/// Computes y = x; y[i, :] += v; return y.
class InplaceAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Updates specified rows 'i' with values 'v'.
/// Computes `x[i, :] = v; return x`.
/// 
/// Originally this function is mutative however for compilation we make this
/// operation create / operate on a copy of `x`.
class InplaceUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the reciprocal of x element-wise.
/// I.e., \\(y = 1 / x\\).
class InvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Invert (flip) each bit of supported types; for example, type `uint8` value 01010101 becomes 10101010.
/// Flip each bit of supported types.  For example, type `int8` (decimal 2) binary 00000010 becomes (decimal -3) binary 11111101.
/// This operation is performed on each element of the tensor argument `x`.
/// 
/// Example:
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// 
/// # flip 2 (00000010) to -3 (11111101)
/// tf.assert_equal(-3, bitwise_ops.invert(2))
/// 
/// dtype_list = [dtypes.int8, dtypes.int16, dtypes.int32, dtypes.int64,
///               dtypes.uint8, dtypes.uint16, dtypes.uint32, dtypes.uint64]
/// 
/// inputs = [0, 5, 3, 14]
/// for dtype in dtype_list:
///   # Because of issues with negative numbers, let's test this indirectly.
///   # 1. invert(a) and a = 0
///   # 2. invert(a) or a = invert(0)
///   input_tensor = tf.constant([0, 5, 3, 14], dtype=dtype)
///   not_a_and_a, not_a_or_a, not_0 = [bitwise_ops.bitwise_and(
///                                       input_tensor, bitwise_ops.invert(input_tensor)),
///                                     bitwise_ops.bitwise_or(
///                                       input_tensor, bitwise_ops.invert(input_tensor)),
///                                     bitwise_ops.invert(
///                                       tf.constant(0, dtype=dtype))]
/// 
///   expected = tf.constant([0, 0, 0, 0], dtype=tf.float32)
///   tf.assert_equal(tf.cast(not_a_and_a, tf.float32), expected)
/// 
///   expected = tf.cast([not_0] * 4, tf.float32)
///   tf.assert_equal(tf.cast(not_a_or_a, tf.float32), expected)
/// 
///   # For unsigned dtypes let's also check the result directly.
///   if dtype.is_unsigned:
///     inverted = bitwise_ops.invert(input_tensor)
///     expected = tf.constant([dtype.max - x for x in inputs], dtype=tf.float32)
///     tf.assert_equal(tf.cast(inverted, tf.float32), tf.cast(expected, tf.float32))
/// ```
class InvertOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the inverse permutation of a tensor.
/// This operation computes the inverse of an index permutation. It takes a 1-D
/// integer tensor `x`, which represents the indices of a zero-based array, and
/// swaps each value with its index position. In other words, for an output tensor
/// `y` and an input tensor `x`, this operation computes the following:
/// 
/// `y[x[i]] = i for i in [0, 1, ..., len(x) - 1]`
/// 
/// The values must include 0. There can be no duplicate values or negative values.
/// 
/// For example:
/// 
/// ```
/// # tensor `x` is [3, 4, 0, 2, 1]
/// invert_permutation(x) ==> [2, 4, 3, 0, 1]
/// ```
class InvertPermutationOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns which elements of x are finite.
/// @compatibility(numpy)
/// Equivalent to np.isfinite
/// @end_compatibility
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5.0, 4.8, 6.8, np.inf, np.nan])
/// tf.math.is_finite(x) ==> [True, True, True, False, False]
/// ```
class IsFiniteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns which elements of x are Inf.
/// @compatibility(numpy)
/// Equivalent to np.isinf
/// @end_compatibility
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5.0, np.inf, 6.8, np.inf])
/// tf.math.is_inf(x) ==> [False, True, False, True]
/// ```
class IsInfOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns which elements of x are NaN.
/// @compatibility(numpy)
/// Equivalent to np.isnan
/// @end_compatibility
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5.0, np.nan, 6.8, np.nan, np.inf])
/// tf.math.is_nan(x) ==> [False, True, False, True, False]
/// ```
class IsNanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts the given string representing a handle to an iterator to a resource.
class IteratorFromStringHandleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class IteratorFromStringHandleV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gets the next output from the given iterator as an Optional variant.
class IteratorGetNextAsOptionalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gets the next output from the given iterator .
class IteratorGetNextOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gets the next output from the given iterator.
/// This operation is a synchronous version IteratorGetNext. It should only be used
/// in situations where the iterator does not block the calling thread, or where
/// the calling thread is not a member of the thread pool used to execute parallel
/// operations (e.g. in eager mode).
class IteratorGetNextSyncOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A container for an iterator resource.
class IteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts the given `resource_handle` representing an iterator to a string.
class IteratorToStringHandleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class IteratorV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the Kth order statistic of a data set. The current
/// implementation uses a binary search requiring exactly 32 passes over
/// the input data. The running time is linear with respect to input
/// size. The median-of-medians algorithm is probably faster, but is
/// difficult to implement efficiently in XLA. The implementation imposes
/// a total ordering on floats. The ordering is consistent with the usual
/// partial order.  Positive NaNs are greater than positive
/// infinity. Negative NaNs are less than negative infinity. NaNs with
/// distinct payloads are treated as distinct. Subnormal numbers are
/// preserved (not flushed to zero). Positive infinity is greater than all
/// numbers. Negative infinity is less than all numbers. Positive is
/// greater than negative zero. There are less than k values greater than
/// the kth order statistic. There are at least k values greater than or
/// equal to the Kth order statistic. The semantics are not the same as
/// top_k_unique.
class KthOrderStatisticOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// L2 Loss.
/// Computes half the L2 norm of a tensor without the `sqrt`:
/// 
///     output = sum(t ** 2) / 2
class L2LossOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gradients for Local Response Normalization.
class LRNGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Local Response Normalization.
/// The 4-D `input` tensor is treated as a 3-D array of 1-D vectors (along the last
/// dimension), and each vector is normalized independently.  Within a given vector,
/// each component is divided by the weighted, squared sum of inputs within
/// `depth_radius`.  In detail,
/// 
///     sqr_sum[a, b, c, d] =
///         sum(input[a, b, c, d - depth_radius : d + depth_radius + 1] ** 2)
///     output = input / (bias + alpha * sqr_sum) ** beta
/// 
/// For details, see [Krizhevsky et al., ImageNet classification with deep
/// convolutional neural networks (NIPS 2012)](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks).
class LRNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear gradients for a LeakyRelu operation.
class LeakyReluGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear: `max(features, features * alpha)`.
class LeakyReluOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Elementwise computes the bitwise left-shift of `x` and `y`.
/// If `y` is negative, or greater than or equal to the width of `x` in bits the
/// result is implementation defined.
/// 
/// Example:
/// 
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// import numpy as np
/// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64]
/// 
/// for dtype in dtype_list:
///   lhs = tf.constant([-1, -5, -3, -14], dtype=dtype)
///   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
/// 
///   left_shift_result = bitwise_ops.left_shift(lhs, rhs)
/// 
///   print(left_shift_result)
/// 
/// # This will print:
/// # tf.Tensor([ -32   -5 -128    0], shape=(4,), dtype=int8)
/// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int16)
/// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int32)
/// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int64)
/// 
/// lhs = np.array([-2, 64, 101, 32], dtype=np.int8)
/// rhs = np.array([-1, -5, -3, -14], dtype=np.int8)
/// bitwise_ops.left_shift(lhs, rhs)
/// # <tf.Tensor: shape=(4,), dtype=int8, numpy=array([ -2,  64, 101,  32], dtype=int8)>
/// ```
class LeftShiftOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// returns `f(inputs)`, where `f` is a function.
/// The LegacyCall operation represents a direct call to a function that is
///     within the same symbol scope as the call and is mapped to a GraphDef node
///     with the function name as the op name. Unlike a PartitionedCall which
///     represents asynchronously executing a function across multiple devices, a
///     LegacyCall ignores specification for ops in the attached function and
///     instead executes it on the device assigned to this op.
class LegacyCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x <= y) element-wise.
/// *NOTE*: `LessEqual` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5, 4, 6])
/// y = tf.constant([5])
/// tf.math.less_equal(x, y) ==> [True, True, False]
/// 
/// x = tf.constant([5, 4, 6])
/// y = tf.constant([5, 6, 6])
/// tf.math.less_equal(x, y) ==> [True, True, True]
/// ```
class LessEqualOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x < y) element-wise.
/// *NOTE*: `Less` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([5, 4, 6])
/// y = tf.constant([5])
/// tf.math.less(x, y) ==> [False, True, False]
/// 
/// x = tf.constant([5, 4, 6])
/// y = tf.constant([5, 6, 7])
/// tf.math.less(x, y) ==> [False, True, True]
/// ```
class LessOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the log of the absolute value of `Gamma(x)` element-wise.
/// For positive numbers, this function computes log((input - 1)!) for every element in the tensor.
///   `lgamma(5) = log((5-1)!) = log(4!) = log(24) = 3.1780539`
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([0, 0.5, 1, 4.5, -4, -5.6])
/// tf.math.lgamma(x) ==> [inf, 0.5723649, 0., 2.4537368, inf, -4.6477685]
/// ```
class LgammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Generates values in an interval.
/// A sequence of `num` evenly-spaced values are generated beginning at `start`.
/// If `num > 1`, the values in the sequence increase by
/// `(stop - start) / (num - 1)`, so that the last one is exactly `stop`.
/// 
/// For example:
/// 
/// ```
/// tf.linspace(10.0, 12.0, 3, name="linspace") => [ 10.0  11.0  12.0]
/// ```
class LinSpaceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the difference between two lists of numbers or strings.
/// Given a list `x` and a list `y`, this operation returns a list `out` that
/// represents all values that are in `x` but not in `y`. The returned list `out`
/// is sorted in the same order that the numbers appear in `x` (duplicates are
/// preserved). This operation also returns a list `idx` that represents the
/// position of each `out` element in `x`. In other words:
/// 
/// `out[i] = x[idx[i]] for i in [0, 1, ..., len(out) - 1]`
/// 
/// For example, given this input:
/// 
/// ```
/// x = [1, 2, 3, 4, 5, 6]
/// y = [1, 3, 5]
/// ```
/// 
/// This operation would return:
/// 
/// ```
/// out ==> [2, 4, 6]
/// idx ==> [1, 3, 5]
/// ```
class ListDiffOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingADAMParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load ADAM embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingADAMParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingAdadeltaParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load Adadelta embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingAdadeltaParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingAdagradParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load Adagrad embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingAdagradParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load centered RMSProp embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingCenteredRMSPropParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingFTRLParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load FTRL embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingFTRLParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load MDL Adagrad Light embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingMDLAdagradLightParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingMomentumParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load Momentum embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingMomentumParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingProximalAdagradParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load proximal Adagrad embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingProximalAdagradParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingProximalYogiParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingProximalYogiParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingRMSPropParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load RMSProp embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingRMSPropParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class LoadTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Load SGD embedding parameters.
/// An op that loads optimization parameters into HBM for embedding. Must be
/// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
/// embedding table configuration. For example, this op is used to install
/// parameters that are loaded from a checkpoint before a training loop is
/// executed.
class LoadTPUEmbeddingStochasticGradientDescentParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes natural logarithm of (1 + x) element-wise.
/// I.e., \\(y = \log_e (1 + x)\\).
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([0, 0.5, 1, 5])
/// tf.math.log1p(x) ==> [0., 0.4054651, 0.6931472, 1.7917595]
/// ```
class Log1pOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes natural logarithm of x element-wise.
/// I.e., \\(y = \log_e x\\).
/// 
/// Example:
/// 
/// ```python
/// x = tf.constant([0, 0.5, 1, 5])
/// tf.math.log(x) ==> [-inf, -0.6931472,  0. ,  1.609438]
/// ```
class LogOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes log softmax activations.
/// For each batch `i` and class `j` we have
/// 
///     logsoftmax[i, j] = logits[i, j] - log(sum(exp(logits[i])))
class LogSoftmaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of x AND y element-wise.
/// *NOTE*: `LogicalAnd` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class LogicalAndOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of `NOT x` element-wise.
class LogicalNotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of x OR y element-wise.
/// *NOTE*: `LogicalOr` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class LogicalOrOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs all keys and values in the table.
class LookupTableExportV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Looks up keys in a table, outputs the corresponding values.
/// The tensor `keys` must of the same type as the keys of the table.
/// The output `values` is of the type of the table values.
/// 
/// The scalar `default_value` is the value output for keys not present in the
/// table. It must also be of the same type as the table values.
class LookupTableFindOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Looks up keys in a table, outputs the corresponding values.
/// The tensor `keys` must of the same type as the keys of the table.
/// The output `values` is of the type of the table values.
/// 
/// The scalar `default_value` is the value output for keys not present in the
/// table. It must also be of the same type as the table values.
class LookupTableFindV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Replaces the contents of the table with the specified keys and values.
/// The tensor `keys` must be of the same type as the keys of the table.
/// The tensor `values` must be of the type of the table values.
class LookupTableImportV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Updates the table to associates keys with values.
/// The tensor `keys` must be of the same type as the keys of the table.
/// The tensor `values` must be of the type of the table values.
class LookupTableInsertV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Removes keys and its associated values from a table.
/// The tensor `keys` must of the same type as the keys of the table. Keys not
/// already in the table are silently ignored.
class LookupTableRemoveV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the number of elements in the given table.
class LookupTableSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the number of elements in the given table.
class LookupTableSizeV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies lower_bound(sorted_search_values, values) along each row.
/// Each set of rows with the same index in (sorted_inputs, values) is treated
/// independently.  The resulting row is the equivalent of calling
/// `np.searchsorted(sorted_inputs, values, side='left')`.
/// 
/// The result is not a global index to the entire
/// `Tensor`, but rather just the index in the last dimension.
/// 
/// A 2-D example:
///   sorted_sequence = [[0, 3, 9, 9, 10],
///                      [1, 2, 3, 4, 5]]
///   values = [[2, 4, 9],
///             [0, 2, 6]]
/// 
///   result = LowerBound(sorted_sequence, values)
/// 
///   result == [[1, 2, 2],
///              [0, 1, 5]]
class LowerBoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Makes a new iterator from the given `dataset` and stores it in `iterator`.
/// This operation may be executed multiple times. Each execution will reset the
/// iterator in `iterator` to the first element of `dataset`.
class MakeIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Make all elements in the non-Batch dimension unique, but \"close\" to
/// their initial value. Never returns a sub-normal number. Never returns
/// zero. The sign of each input element is always identical to the sign
/// of the corresponding output element. Behavior for infinite elements is
/// undefined. Behavior for subnormal elements is undefined.
class MakeUniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that fuses mapping with batching.
/// Creates a dataset that applies `f` to the outputs of `input_dataset` and then
/// batches `batch_size` of them.
/// 
/// Unlike a "MapDataset", which applies `f` sequentially, this dataset invokes up
/// to `batch_size * num_parallel_batches` copies of `f` in parallel.
class MapAndBatchDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that applies `f` to the outputs of `input_dataset`.
class MapDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiply the matrix "a" by the matrix "b".
/// The inputs must be two-dimensional matrices and the inner dimension of
/// "a" (after being transposed if transpose_a is true) must match the
/// outer dimension of "b" (after being transposed if transposed_b is
/// true).
/// 
/// *Note*: The default kernel implementation for MatMul on GPUs uses
/// cublas.
class MatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Copy a tensor setting everything outside a central band in each innermost matrix to zero.
/// The `band` part is computed as follows:
/// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
/// tensor with the same shape where
/// 
/// `band[i, j, k, ..., m, n] = in_band(m, n) * input[i, j, k, ..., m, n]`.
/// 
/// The indicator function
/// 
/// `in_band(m, n) = (num_lower < 0 || (m-n) <= num_lower)) &&
///                  (num_upper < 0 || (n-m) <= num_upper)`.
/// 
/// For example:
/// 
/// ```
/// # if 'input' is [[ 0,  1,  2, 3]
/// #                [-1,  0,  1, 2]
/// #                [-2, -1,  0, 1]
/// #                [-3, -2, -1, 0]],
/// 
/// tf.linalg.band_part(input, 1, -1) ==> [[ 0,  1,  2, 3]
///                                        [-1,  0,  1, 2]
///                                        [ 0, -1,  0, 1]
///                                        [ 0,  0, -1, 0]],
/// 
/// tf.linalg.band_part(input, 2, 1) ==> [[ 0,  1,  0, 0]
///                                       [-1,  0,  1, 0]
///                                       [-2, -1,  0, 1]
///                                       [ 0, -2, -1, 0]]
/// ```
/// 
/// Useful special cases:
/// 
/// ```
///  tf.linalg.band_part(input, 0, -1) ==> Upper triangular part.
///  tf.linalg.band_part(input, -1, 0) ==> Lower triangular part.
///  tf.linalg.band_part(input, 0, 0) ==> Diagonal.
/// ```
class MatrixBandPartOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a batched diagonal tensor with a given batched diagonal values.
/// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
/// everything else padded with zeros. The diagonal is computed as follows:
/// 
/// Assume `diagonal` has `k` dimensions `[I, J, K, ..., N]`, then the output is a
/// tensor of rank `k+1` with dimensions [I, J, K, ..., N, N]` where:
/// 
/// `output[i, j, k, ..., m, n] = 1{m=n} * diagonal[i, j, k, ..., n]`.
/// 
/// For example:
/// 
/// ```
/// # 'diagonal' is [[1, 2, 3, 4], [5, 6, 7, 8]]
/// 
/// and diagonal.shape = (2, 4)
/// 
/// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0]
///                                      [0, 2, 0, 0]
///                                      [0, 0, 3, 0]
///                                      [0, 0, 0, 4]],
///                                     [[5, 0, 0, 0]
///                                      [0, 6, 0, 0]
///                                      [0, 0, 7, 0]
///                                      [0, 0, 0, 8]]]
/// 
/// which has shape (2, 4, 4)
/// ```
class MatrixDiagOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the batched diagonal part of a batched tensor.
/// Returns a tensor with the `k[0]`-th to `k[1]`-th diagonals of the batched
/// `input`.
/// 
/// Assume `input` has `r` dimensions `[I, J, ..., L, M, N]`.
/// Let `max_diag_len` be the maximum length among all diagonals to be extracted,
/// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
/// Let `num_diags` be the number of diagonals to extract,
/// `num_diags = k[1] - k[0] + 1`.
/// 
/// If `num_diags == 1`, the output tensor is of rank `r - 1` with shape
/// `[I, J, ..., L, max_diag_len]` and values:
/// 
/// ```
/// diagonal[i, j, ..., l, n]
///   = input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
///     padding_value                 ; otherwise.
/// ```
/// where `y = max(-k[1], 0)`, `x = max(k[1], 0)`.
/// 
/// Otherwise, the output tensor has rank `r` with dimensions
/// `[I, J, ..., L, num_diags, max_diag_len]` with values:
/// 
/// ```
/// diagonal[i, j, ..., l, m, n]
///   = input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
///     padding_value                 ; otherwise.
/// ```
/// where `d = k[1] - m`, `y = max(-d, 0) - offset`, and `x = max(d, 0) - offset`.
/// 
/// `offset` is zero except when the alignment of the diagonal is to the right.
/// ```
/// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
///                                            and `d >= 0`) or
///                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
///                                            and `d <= 0`)
///          0                          ; otherwise
/// ```
/// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
/// 
/// The input must be at least a matrix.
/// 
/// For example:
/// 
/// ```
/// input = np.array([[[1, 2, 3, 4],  # Input shape: (2, 3, 4)
///                    [5, 6, 7, 8],
///                    [9, 8, 7, 6]],
///                   [[5, 4, 3, 2],
///                    [1, 2, 3, 4],
///                    [5, 6, 7, 8]]])
/// 
/// # A main diagonal from each batch.
/// tf.matrix_diag_part(input) ==> [[1, 6, 7],  # Output shape: (2, 3)
///                                 [5, 2, 7]]
/// 
/// # A superdiagonal from each batch.
/// tf.matrix_diag_part(input, k = 1)
///   ==> [[2, 7, 6],  # Output shape: (2, 3)
///        [4, 3, 8]]
/// 
/// # A band from each batch.
/// tf.matrix_diag_part(input, k = (-1, 2))
///   ==> [[[0, 3, 8],  # Output shape: (2, 4, 3)
///         [2, 7, 6],
///         [1, 6, 7],
///         [5, 8, 0]],
///        [[0, 3, 4],
///         [4, 3, 8],
///         [5, 2, 7],
///         [1, 6, 0]]]
/// 
/// # LEFT_RIGHT alignment.
/// tf.matrix_diag_part(input, k = (-1, 2), align="LEFT_RIGHT")
///   ==> [[[3, 8, 0],  # Output shape: (2, 4, 3)
///         [2, 7, 6],
///         [1, 6, 7],
///         [0, 5, 8]],
///        [[3, 4, 0],
///         [4, 3, 8],
///         [5, 2, 7],
///         [0, 1, 6]]]
/// 
/// # max_diag_len can be shorter than the main diagonal.
/// tf.matrix_diag_part(input, k = (-2, -1))
///   ==> [[[5, 8],
///         [9, 0]],
///        [[1, 6],
///         [5, 0]]]
/// 
/// # padding_value = 9
/// tf.matrix_diag_part(input, k = (1, 3), padding_value = 9)
///   ==> [[[9, 9, 4],  # Output shape: (2, 3, 3)
///         [9, 3, 8],
///         [2, 7, 6]],
///        [[9, 9, 2],
///         [9, 3, 4],
///         [4, 3, 8]]]
/// 
/// ```
class MatrixDiagPartV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a batched diagonal tensor with given batched diagonal values.
/// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
/// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
/// and `num_cols` specify the dimension of the innermost matrix of the output. If
/// both are not specified, the op assumes the innermost matrix is square and infers
/// its size from `k` and the innermost dimension of `diagonal`. If only one of them
/// is specified, the op assumes the unspecified value is the smallest possible
/// based on other criteria.
/// 
/// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
/// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
/// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
/// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
/// 
/// The second innermost dimension of `diagonal` has double meaning.
/// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
/// [I, J, ..., M], and the output tensor is:
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
///     padding_value                             ; otherwise
/// ```
/// 
/// Otherwise, `M` is treated as the number of diagonals for the matrix in the
/// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
///     padding_value                                     ; otherwise
/// ```
/// where `d = n - m`, `diag_index = k[1] - d`, and `index_in_diag = n - max(d, 0)`.
/// 
/// For example:
/// 
/// ```
/// # The main diagonal.
/// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
///                      [5, 6, 7, 8]])
/// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
///                                [0, 2, 0, 0],
///                                [0, 0, 3, 0],
///                                [0, 0, 0, 4]],
///                               [[5, 0, 0, 0],
///                                [0, 6, 0, 0],
///                                [0, 0, 7, 0],
///                                [0, 0, 0, 8]]]
/// 
/// # A superdiagonal (per batch).
/// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
///                      [4, 5, 6]])
/// tf.matrix_diag(diagonal, k = 1)
///   ==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
///         [0, 0, 2, 0],
///         [0, 0, 0, 3],
///         [0, 0, 0, 0]],
///        [[0, 4, 0, 0],
///         [0, 0, 5, 0],
///         [0, 0, 0, 6],
///         [0, 0, 0, 0]]]
/// 
/// # A band of diagonals.
/// diagonals = np.array([[[1, 2, 3],  # Input shape: (2, 2, 3)
///                        [4, 5, 0]],
///                       [[6, 7, 9],
///                        [9, 1, 0]]])
/// tf.matrix_diag(diagonals, k = (-1, 0))
///   ==> [[[1, 0, 0],  # Output shape: (2, 3, 3)
///         [4, 2, 0],
///         [0, 5, 3]],
///        [[6, 0, 0],
///         [9, 7, 0],
///         [0, 1, 9]]]
/// 
/// # Rectangular matrix.
/// diagonal = np.array([1, 2])  # Input shape: (2)
/// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
///   ==> [[0, 0, 0, 0],  # Output shape: (3, 4)
///        [1, 0, 0, 0],
///        [0, 2, 0, 0]]
/// 
/// # Rectangular matrix with inferred num_cols and padding_value = 9.
/// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
///   ==> [[9, 9],  # Output shape: (3, 2)
///        [1, 9],
///        [9, 2]]
/// ```
class MatrixDiagV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a batched diagonal tensor with given batched diagonal values.
/// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
/// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
/// and `num_cols` specify the dimension of the innermost matrix of the output. If
/// both are not specified, the op assumes the innermost matrix is square and infers
/// its size from `k` and the innermost dimension of `diagonal`. If only one of them
/// is specified, the op assumes the unspecified value is the smallest possible
/// based on other criteria.
/// 
/// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
/// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
/// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
/// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
/// 
/// The second innermost dimension of `diagonal` has double meaning.
/// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
/// [I, J, ..., M], and the output tensor is:
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
///     padding_value                             ; otherwise
/// ```
/// 
/// Otherwise, `M` is treated as the number of diagonals for the matrix in the
/// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
///     padding_value                                     ; otherwise
/// ```
/// where `d = n - m`, `diag_index = [k] - d`, and
/// `index_in_diag = n - max(d, 0) + offset`.
/// 
/// `offset` is zero except when the alignment of the diagonal is to the right.
/// ```
/// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
///                                            and `d >= 0`) or
///                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
///                                            and `d <= 0`)
///          0                          ; otherwise
/// ```
/// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
/// 
/// For example:
/// 
/// ```
/// # The main diagonal.
/// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
///                      [5, 6, 7, 8]])
/// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
///                                [0, 2, 0, 0],
///                                [0, 0, 3, 0],
///                                [0, 0, 0, 4]],
///                               [[5, 0, 0, 0],
///                                [0, 6, 0, 0],
///                                [0, 0, 7, 0],
///                                [0, 0, 0, 8]]]
/// 
/// # A superdiagonal (per batch).
/// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
///                      [4, 5, 6]])
/// tf.matrix_diag(diagonal, k = 1)
///   ==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
///         [0, 0, 2, 0],
///         [0, 0, 0, 3],
///         [0, 0, 0, 0]],
///        [[0, 4, 0, 0],
///         [0, 0, 5, 0],
///         [0, 0, 0, 6],
///         [0, 0, 0, 0]]]
/// 
/// # A tridiagonal band (per batch).
/// diagonals = np.array([[[0, 8, 9],  # Input shape: (2, 2, 3)
///                        [1, 2, 3],
///                        [4, 5, 0]],
///                       [[0, 2, 3],
///                        [6, 7, 9],
///                        [9, 1, 0]]])
/// tf.matrix_diag(diagonals, k = (-1, 1))
///   ==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
///         [4, 2, 9],
///         [0, 5, 3]],
///        [[6, 2, 0],
///         [9, 7, 3],
///         [0, 1, 9]]]
/// 
/// # LEFT_RIGHT alignment.
/// diagonals = np.array([[[8, 9, 0],  # Input shape: (2, 2, 3)
///                        [1, 2, 3],
///                        [0, 4, 5]],
///                       [[2, 3, 0],
///                        [6, 7, 9],
///                        [0, 9, 1]]])
/// tf.matrix_diag(diagonals, k = (-1, 1), align="LEFT_RIGHT")
///   ==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
///         [4, 2, 9],
///         [0, 5, 3]],
///        [[6, 2, 0],
///         [9, 7, 3],
///         [0, 1, 9]]]
/// 
/// # Rectangular matrix.
/// diagonal = np.array([1, 2])  # Input shape: (2)
/// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
///   ==> [[0, 0, 0, 0],  # Output shape: (3, 4)
///        [1, 0, 0, 0],
///        [0, 2, 0, 0]]
/// 
/// # Rectangular matrix with inferred num_cols and padding_value = 9.
/// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
///   ==> [[9, 9],  # Output shape: (3, 2)
///        [1, 9],
///        [9, 2]]
/// 
/// ```
class MatrixDiagV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the inverse of one or more square invertible matrices or their adjoints (conjugate transposes).
/// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
/// form square matrices. The output is a tensor of the same shape as the input
/// containing the inverse for all input submatrices `[..., :, :]`.
/// 
/// The op uses LU decomposition with partial pivoting to compute the inverses.
/// 
/// If a matrix is not invertible there is no guarantee what the op does. It
/// may detect the condition and raise an exception or it may simply return a
/// garbage result.
class MatrixInverseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a batched matrix tensor with new batched diagonal values.
/// Given `input` and `diagonal`, this operation returns a tensor with the
/// same shape and values as `input`, except for the main diagonal of the
/// innermost matrices.  These will be overwritten by the values in `diagonal`.
/// 
/// The output is computed as follows:
/// 
/// Assume `input` has `k+1` dimensions `[I, J, K, ..., M, N]` and `diagonal` has
/// `k` dimensions `[I, J, K, ..., min(M, N)]`.  Then the output is a
/// tensor of rank `k+1` with dimensions `[I, J, K, ..., M, N]` where:
/// 
///   * `output[i, j, k, ..., m, n] = diagonal[i, j, k, ..., n]` for `m == n`.
///   * `output[i, j, k, ..., m, n] = input[i, j, k, ..., m, n]` for `m != n`.
class MatrixSetDiagOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a batched matrix tensor with new batched diagonal values.
/// Given `input` and `diagonal`, this operation returns a tensor with the
/// same shape and values as `input`, except for the specified diagonals of the
/// innermost matrices. These will be overwritten by the values in `diagonal`.
/// 
/// `input` has `r+1` dimensions `[I, J, ..., L, M, N]`. When `k` is scalar or
/// `k[0] == k[1]`, `diagonal` has `r` dimensions `[I, J, ..., L, max_diag_len]`.
/// Otherwise, it has `r+1` dimensions `[I, J, ..., L, num_diags, max_diag_len]`.
/// `num_diags` is the number of diagonals, `num_diags = k[1] - k[0] + 1`.
/// `max_diag_len` is the longest diagonal in the range `[k[0], k[1]]`,
/// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
/// 
/// The output is a tensor of rank `k+1` with dimensions `[I, J, ..., L, M, N]`.
/// If `k` is scalar or `k[0] == k[1]`:
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, n-max(k[1], 0)] ; if n - m == k[1]
///     input[i, j, ..., l, m, n]              ; otherwise
/// ```
/// 
/// Otherwise,
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
///     input[i, j, ..., l, m, n]                         ; otherwise
/// ```
/// where `d = n - m`, `diag_index = k[1] - d`, and `index_in_diag = n - max(d, 0)`.
/// 
/// For example:
/// 
/// ```
/// # The main diagonal.
/// input = np.array([[[7, 7, 7, 7],              # Input shape: (2, 3, 4)
///                    [7, 7, 7, 7],
///                    [7, 7, 7, 7]],
///                   [[7, 7, 7, 7],
///                    [7, 7, 7, 7],
///                    [7, 7, 7, 7]]])
/// diagonal = np.array([[1, 2, 3],               # Diagonal shape: (2, 3)
///                      [4, 5, 6]])
/// tf.matrix_set_diag(diagonal) ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
///                                    [7, 2, 7, 7],
///                                    [7, 7, 3, 7]],
///                                   [[4, 7, 7, 7],
///                                    [7, 5, 7, 7],
///                                    [7, 7, 6, 7]]]
/// 
/// # A superdiagonal (per batch).
/// tf.matrix_set_diag(diagonal, k = 1)
///   ==> [[[7, 1, 7, 7],  # Output shape: (2, 3, 4)
///         [7, 7, 2, 7],
///         [7, 7, 7, 3]],
///        [[7, 4, 7, 7],
///         [7, 7, 5, 7],
///         [7, 7, 7, 6]]]
/// 
/// # A band of diagonals.
/// diagonals = np.array([[[1, 2, 3],  # Diagonal shape: (2, 2, 3)
///                        [4, 5, 0]],
///                       [[6, 1, 2],
///                        [3, 4, 0]]])
/// tf.matrix_set_diag(diagonals, k = (-1, 0))
///   ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
///         [4, 2, 7, 7],
///         [0, 5, 3, 7]],
///        [[6, 7, 7, 7],
///         [3, 1, 7, 7],
///         [7, 4, 2, 7]]]
/// 
/// ```
class MatrixSetDiagV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a batched matrix tensor with new batched diagonal values.
/// Given `input` and `diagonal`, this operation returns a tensor with the
/// same shape and values as `input`, except for the specified diagonals of the
/// innermost matrices. These will be overwritten by the values in `diagonal`.
/// 
/// `input` has `r+1` dimensions `[I, J, ..., L, M, N]`. When `k` is scalar or
/// `k[0] == k[1]`, `diagonal` has `r` dimensions `[I, J, ..., L, max_diag_len]`.
/// Otherwise, it has `r+1` dimensions `[I, J, ..., L, num_diags, max_diag_len]`.
/// `num_diags` is the number of diagonals, `num_diags = k[1] - k[0] + 1`.
/// `max_diag_len` is the longest diagonal in the range `[k[0], k[1]]`,
/// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
/// 
/// The output is a tensor of rank `k+1` with dimensions `[I, J, ..., L, M, N]`.
/// If `k` is scalar or `k[0] == k[1]`:
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, n-max(k[1], 0)] ; if n - m == k[1]
///     input[i, j, ..., l, m, n]              ; otherwise
/// ```
/// 
/// Otherwise,
/// 
/// ```
/// output[i, j, ..., l, m, n]
///   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
///     input[i, j, ..., l, m, n]                         ; otherwise
/// ```
/// where `d = n - m`, `diag_index = k[1] - d`, and
/// `index_in_diag = n - max(d, 0) + offset`.
/// 
/// `offset` is zero except when the alignment of the diagonal is to the right.
/// ```
/// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
///                                            and `d >= 0`) or
///                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
///                                            and `d <= 0`)
///          0                          ; otherwise
/// ```
/// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
/// 
/// For example:
/// 
/// ```
/// # The main diagonal.
/// input = np.array([[[7, 7, 7, 7],              # Input shape: (2, 3, 4)
///                    [7, 7, 7, 7],
///                    [7, 7, 7, 7]],
///                   [[7, 7, 7, 7],
///                    [7, 7, 7, 7],
///                    [7, 7, 7, 7]]])
/// diagonal = np.array([[1, 2, 3],               # Diagonal shape: (2, 3)
///                      [4, 5, 6]])
/// tf.matrix_set_diag(input, diagonal)
///   ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
///         [7, 2, 7, 7],
///         [7, 7, 3, 7]],
///        [[4, 7, 7, 7],
///         [7, 5, 7, 7],
///         [7, 7, 6, 7]]]
/// 
/// # A superdiagonal (per batch).
/// tf.matrix_set_diag(input, diagonal, k = 1)
///   ==> [[[7, 1, 7, 7],  # Output shape: (2, 3, 4)
///         [7, 7, 2, 7],
///         [7, 7, 7, 3]],
///        [[7, 4, 7, 7],
///         [7, 7, 5, 7],
///         [7, 7, 7, 6]]]
/// 
/// # A band of diagonals.
/// diagonals = np.array([[[0, 9, 1],  # Diagonal shape: (2, 4, 3)
///                        [6, 5, 8],
///                        [1, 2, 3],
///                        [4, 5, 0]],
///                       [[0, 1, 2],
///                        [5, 6, 4],
///                        [6, 1, 2],
///                        [3, 4, 0]]])
/// tf.matrix_set_diag(input, diagonals, k = (-1, 2))
///   ==> [[[1, 6, 9, 7],  # Output shape: (2, 3, 4)
///         [4, 2, 5, 1],
///         [7, 5, 3, 8]],
///        [[6, 5, 1, 7],
///         [3, 1, 6, 2],
///         [7, 4, 2, 4]]]
/// 
/// # LEFT_RIGHT alignment.
/// diagonals = np.array([[[9, 1, 0],  # Diagonal shape: (2, 4, 3)
///                        [6, 5, 8],
///                        [1, 2, 3],
///                        [0, 4, 5]],
///                       [[1, 2, 0],
///                        [5, 6, 4],
///                        [6, 1, 2],
///                        [0, 3, 4]]])
/// tf.matrix_set_diag(input, diagonals, k = (-1, 2), align="LEFT_RIGHT")
///   ==> [[[1, 6, 9, 7],  # Output shape: (2, 3, 4)
///         [4, 2, 5, 1],
///         [7, 5, 3, 8]],
///        [[6, 5, 1, 7],
///         [3, 1, 6, 2],
///         [7, 4, 2, 4]]]
/// 
/// ```
class MatrixSetDiagV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Solves systems of linear equations.
/// `Matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
/// form square matrices. `Rhs` is a tensor of shape `[..., M, K]`. The `output` is
/// a tensor shape `[..., M, K]`.  If `adjoint` is `False` then each output matrix
/// satisfies `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
/// If `adjoint` is `True` then each output matrix satisfies
/// `adjoint(matrix[..., :, :]) * output[..., :, :] = rhs[..., :, :]`.
class MatrixSolveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Solves systems of linear equations with upper or lower triangular matrices by backsubstitution.
/// `matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions form
/// square matrices. If `lower` is `True` then the strictly upper triangular part
/// of each inner-most matrix is assumed to be zero and not accessed.
/// If `lower` is False then the strictly lower triangular part of each inner-most
/// matrix is assumed to be zero and not accessed.
/// `rhs` is a tensor of shape `[..., M, N]`.
/// 
/// The output is a tensor of shape `[..., M, N]`. If `adjoint` is
/// `True` then the innermost matrices in `output` satisfy matrix equations
/// `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
/// If `adjoint` is `False` then the strictly then the  innermost matrices in
/// `output` satisfy matrix equations
/// `adjoint(matrix[..., i, k]) * output[..., k, j] = rhs[..., i, j]`.
/// 
/// Note, the batch shapes for the inputs only need to broadcast.
/// 
/// Example:
/// ```python
/// 
/// a = tf.constant([[3,  0,  0,  0],
///                  [2,  1,  0,  0],
///                  [1,  0,  1,  0],
///                  [1,  1,  1,  1]], dtype=tf.float32)
/// 
/// b = tf.constant([[4],
///                  [2],
///                  [4],
///                  [2]], dtype=tf.float32)
/// 
/// x = tf.linalg.triangular_solve(a, b, lower=True)
/// x
/// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
/// # array([[ 1.3333334 ],
/// #        [-0.66666675],
/// #        [ 2.6666665 ],
/// #        [-1.3333331 ]], dtype=float32)>
/// 
/// # in python3 one can use `a@x`
/// tf.matmul(a, x)
/// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
/// # array([[4.       ],
/// #        [2.       ],
/// #        [4.       ],
/// #        [1.9999999]], dtype=float32)>
/// ```
class MatrixTriangularSolveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class MaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes second-order gradients of the maxpooling function.
class MaxPool3DGradGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients of 3D max pooling function.
class MaxPool3DGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs 3D max pooling on the input.
class MaxPool3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes second-order gradients of the maxpooling function.
class MaxPoolGradGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes second-order gradients of the maxpooling function.
class MaxPoolGradGradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients of the maxpooling function.
class MaxPoolGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients of the maxpooling function.
class MaxPoolGradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs max pooling on the input.
class MaxPoolOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs max pooling on the input.
class MaxPoolV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the max of x and y (i.e. x > y ? x : y) element-wise.
/// *NOTE*: `Maximum` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class MaximumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class MeanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Merges summaries.
/// This op creates a
/// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
/// protocol buffer that contains the union of all the values in the input
/// summaries.
/// 
/// When the Op is run, it reports an `InvalidArgument` error if multiple values
/// in the summaries to merge use the same tag.
class MergeSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// V2 format specific: merges the metadata files of sharded checkpoints.  The
/// result is one logical checkpoint, with one physical metadata file and renamed
/// data files.
/// 
/// Intended for "grouping" multiple checkpoints in a sharded checkpoint setup.
/// 
/// If delete_old_dirs is true, attempts to delete recursively the dirname of each
/// path in the input checkpoint_prefixes.  This is useful when those paths are non
/// user-facing temporary locations.
/// 
/// If allow_missing_files is true, merges the checkpoint prefixes as long as
/// at least one file exists. Otherwise, if no files exist, an error will be thrown.
/// The default value for allow_missing_files is false.
class MergeV2CheckpointsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class MinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the min of x and y (i.e. x < y ? x : y) element-wise.
/// *NOTE*: `Minimum` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class MinimumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gradient op for `MirrorPad` op. This op folds a mirror-padded tensor.
/// This operation folds the padded areas of `input` by `MirrorPad` according to the
/// `paddings` you specify. `paddings` must be the same as `paddings` argument
/// given to the corresponding `MirrorPad` op.
/// 
/// The folded size of each dimension D of the output is:
/// 
/// `input.dim_size(D) - paddings(D, 0) - paddings(D, 1)`
/// 
/// For example:
/// 
/// ```
/// # 't' is [[1, 2, 3], [4, 5, 6], [7, 8, 9]].
/// # 'paddings' is [[0, 1]], [0, 1]].
/// # 'mode' is SYMMETRIC.
/// # rank of 't' is 2.
/// pad(t, paddings) ==> [[ 1,  5]
///                       [11, 28]]
/// ```
class MirrorPadGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pads a tensor with mirrored values.
/// This operation pads a `input` with mirrored values according to the `paddings`
/// you specify. `paddings` is an integer tensor with shape `[n, 2]`, where n is
/// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
/// how many values to add before the contents of `input` in that dimension, and
/// `paddings[D, 1]` indicates how many values to add after the contents of `input`
/// in that dimension. Both `paddings[D, 0]` and `paddings[D, 1]` must be no greater
/// than `input.dim_size(D)` (or `input.dim_size(D) - 1`) if `copy_border` is true
/// (if false, respectively).
/// 
/// The padded size of each dimension D of the output is:
/// 
/// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
/// 
/// For example:
/// 
/// ```
/// # 't' is [[1, 2, 3], [4, 5, 6]].
/// # 'paddings' is [[1, 1]], [2, 2]].
/// # 'mode' is SYMMETRIC.
/// # rank of 't' is 2.
/// pad(t, paddings) ==> [[2, 1, 1, 2, 3, 3, 2]
///                       [2, 1, 1, 2, 3, 3, 2]
///                       [5, 4, 4, 5, 6, 6, 5]
///                       [5, 4, 4, 5, 6, 6, 5]]
/// ```
class MirrorPadOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a handle to an in-scope variable.
/// Used by internal passes for temporary representation of local state, which will
/// be eventually removed.
class MlirLocalVarOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps an arbitrary MLIR computation expressed as a module with a main() function.
/// This operation does not have an associated kernel and is not intended to be
/// executed in a regular TensorFlow session. Instead it is intended to be used for
/// testing or for special case where a user intends to pass custom MLIR computation
/// through a TensorFlow graph with the intent of having custom tooling processing
/// it downstream (when targeting a different environment, like TensorFlow lite for
/// example).
/// The MLIR module is expected to have a main() function that will be used as an
/// entry point. The inputs to the operations will be passed as argument to the
/// main() function and the returned values of the main function mapped to the
/// outputs.
/// Example usage:
/// 
/// ```
/// import tensorflow as tf
/// from tensorflow.compiler.mlir.tensorflow.gen_mlir_passthrough_op import mlir_passthrough_op
/// 
/// mlir_module = '''python
/// func @main(%arg0 : tensor<10xf32>, %arg1 : tensor<10xf32>) -> tensor<10x10xf32> {
///    %add = "magic.op"(%arg0, %arg1) : (tensor<10xf32>, tensor<10xf32>) -> tensor<10x10xf32>
///    return %ret : tensor<10x10xf32>
/// }
/// '''
/// 
/// @tf.function
/// def foo(x, y):
///   return mlir_passthrough_op([x, y], mlir_module, Toutputs=[tf.float32])
/// 
/// graph_def = foo.get_concrete_function(tf.TensorSpec([10], tf.float32), tf.TensorSpec([10], tf.float32)).graph.as_graph_def()
/// ```
class MlirPassthroughOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise remainder of division. This emulates C semantics in that
/// the result here is consistent with a truncating divide. E.g.
/// `tf.truncatediv(x, y) * y + truncate_mod(x, y) = x`.
/// 
/// *NOTE*: `Mod` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class ModOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Identity transformation that models performance.
/// Identity transformation that models performance.
class ModelDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x * y element-wise. Returns zero if y is zero, even if x if infinite or NaN.
/// *NOTE*: `MulNoNan` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class MulNoNanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x * y element-wise.
/// *NOTE*: `Multiply` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class MulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Generates a MultiDeviceIterator resource from its provided string handle.
class MultiDeviceIteratorFromStringHandleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gets next element for the provided shard number.
class MultiDeviceIteratorGetNextFromShardOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Initializes the multi device iterator with the given dataset.
class MultiDeviceIteratorInitOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a MultiDeviceIterator resource.
class MultiDeviceIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Produces a string handle for the given MultiDeviceIterator.
class MultiDeviceIteratorToStringHandleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Draws samples from a multinomial distribution.
class MultinomialOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates an empty hash table that uses tensors as the backing store.
/// It uses "open addressing" with quadratic reprobing to resolve
/// collisions.
/// 
/// This op creates a mutable hash table, specifying the type of its keys and
/// values. Each value must be a scalar. Data can be inserted into the table using
/// the insert operations. It does not support the initialization operation.
class MutableDenseHashTableV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates an empty hash table.
/// This op creates a mutable hash table, specifying the type of its keys and
/// values. Each value must be a vector. Data can be inserted into the table using
/// the insert operations. It does not support the initialization operation.
class MutableHashTableOfTensorsV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates an empty hash table.
/// This op creates a mutable hash table, specifying the type of its keys and
/// values. Each value must be a scalar. Data can be inserted into the table using
/// the insert operations. It does not support the initialization operation.
class MutableHashTableV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs a tensor containing the reduction across all input tensors.
/// Outputs a tensor containing the reduction across all input tensors passed to ops
/// within the same `shared_name.
/// 
/// The graph should be constructed so if one op runs with shared_name value `c`,
/// then `num_devices` ops will run with shared_name value `c`.  Failure to do so
/// will cause the graph execution to fail to complete.
/// 
/// input: the input to the reduction
/// data: the value of the reduction across all `num_devices` devices.
/// reduction: the reduction operation to perform.
/// num_devices: The number of devices participating in this reduction.
/// shared_name: Identifier that shared between ops of the same reduction.
class NcclAllReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class NdtriOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes numerical negative value element-wise.
/// I.e., \\(y = -x\\).
class NegOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the next representable value of `x1` in the direction of `x2`, element-wise.
/// This operation returns the same result as the C++ std::nextafter function.
/// 
/// It can also return a subnormal number.
/// 
/// @compatibility(cpp)
/// Equivalent to C++ std::nextafter function.
/// @end_compatibility
class NextAfterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Does nothing. Only useful as a placeholder for control edges.
class NoOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Greedily selects a subset of bounding boxes in descending order of score,
/// pruning away boxes that have high intersection-over-union (IOU) overlap
/// with previously selected boxes.  Bounding boxes with score less than
/// `score_threshold` are removed.  Bounding boxes are supplied as
/// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
/// diagonal pair of box corners and the coordinates can be provided as normalized
/// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
/// is agnostic to where the origin is in the coordinate system and more
/// generally is invariant to orthogonal transformations and translations
/// of the coordinate system; thus translating or reflections of the coordinate
/// system result in the same boxes being selected by the algorithm.
/// The output of this operation is a set of integers indexing into the input
/// collection of bounding boxes representing the selected boxes.  The bounding
/// box coordinates corresponding to the selected indices can then be obtained
/// using the `tf.gather operation`.  For example:
///   selected_indices = tf.image.non_max_suppression_v2(
///       boxes, scores, max_output_size, iou_threshold, score_threshold)
///   selected_boxes = tf.gather(boxes, selected_indices)
class NonMaxSuppressionV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Greedily selects a subset of bounding boxes in descending order of score,
/// pruning away boxes that have high intersection-over-union (IOU) overlap
/// with previously selected boxes.  Bounding boxes with score less than
/// `score_threshold` are removed.  Bounding boxes are supplied as
/// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
/// diagonal pair of box corners and the coordinates can be provided as normalized
/// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
/// is agnostic to where the origin is in the coordinate system and more
/// generally is invariant to orthogonal transformations and translations
/// of the coordinate system; thus translating or reflections of the coordinate
/// system result in the same boxes being selected by the algorithm.
/// The output of this operation is a set of integers indexing into the input
/// collection of bounding boxes representing the selected boxes.  The bounding
/// box coordinates corresponding to the selected indices can then be obtained
/// using the `tf.gather operation`.  For example:
///   selected_indices = tf.image.non_max_suppression_v2(
///       boxes, scores, max_output_size, iou_threshold, score_threshold)
///   selected_boxes = tf.gather(boxes, selected_indices)
class NonMaxSuppressionV4Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Greedily selects a subset of bounding boxes in descending order of score,
/// pruning away boxes that have high intersection-over-union (IOU) overlap
/// with previously selected boxes.  Bounding boxes with score less than
/// `score_threshold` are removed.  Bounding boxes are supplied as
/// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
/// diagonal pair of box corners and the coordinates can be provided as normalized
/// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
/// is agnostic to where the origin is in the coordinate system and more
/// generally is invariant to orthogonal transformations and translations
/// of the coordinate system; thus translating or reflections of the coordinate
/// system result in the same boxes being selected by the algorithm.
/// The output of this operation is a set of integers indexing into the input
/// collection of bounding boxes representing the selected boxes.  The bounding
/// box coordinates corresponding to the selected indices can then be obtained
/// using the `tf.gather operation`.  For example:
///   selected_indices = tf.image.non_max_suppression_v2(
///       boxes, scores, max_output_size, iou_threshold, score_threshold)
///   selected_boxes = tf.gather(boxes, selected_indices)
/// This op also supports a Soft-NMS (with Gaussian weighting) mode (c.f.
/// Bodla et al, https://arxiv.org/abs/1704.04503) where boxes reduce the score
/// of other overlapping boxes instead of directly causing them to be pruned.
/// To enable this Soft-NMS mode, set the `soft_nms_sigma` parameter to be
/// larger than 0.
class NonMaxSuppressionV5Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the truth value of (x != y) element-wise.
/// *NOTE*: `NotEqual` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class NotEqualOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a one-hot tensor.
/// The locations represented by indices in `indices` take value `on_value`,
/// while all other locations take value `off_value`.
/// 
/// If the input `indices` is rank `N`, the output will have rank `N+1`,
/// The new axis is created at dimension `axis` (default: the new axis is
/// appended at the end).
/// 
/// If `indices` is a scalar the output shape will be a vector of length `depth`.
/// 
/// If `indices` is a vector of length `features`, the output shape will be:
/// ```
///   features x depth if axis == -1
///   depth x features if axis == 0
/// ```
/// 
/// If `indices` is a matrix (batch) with shape `[batch, features]`,
/// the output shape will be:
/// ```
///   batch x features x depth if axis == -1
///   batch x depth x features if axis == 1
///   depth x batch x features if axis == 0
/// ```
/// 
/// 
/// Examples
/// =========
/// 
/// Suppose that
/// ```
///   indices = [0, 2, -1, 1]
///   depth = 3
///   on_value = 5.0
///   off_value = 0.0
///   axis = -1
/// ```
/// 
/// Then output is `[4 x 3]`:
/// ```
/// output =
///   [5.0 0.0 0.0]  // one_hot(0)
///   [0.0 0.0 5.0]  // one_hot(2)
///   [0.0 0.0 0.0]  // one_hot(-1)
///   [0.0 5.0 0.0]  // one_hot(1)
/// ```
/// 
/// Suppose that
/// ```
///   indices = [0, 2, -1, 1]
///   depth = 3
///   on_value = 0.0
///   off_value = 3.0
///   axis = 0
/// ```
/// 
/// Then output is `[3 x 4]`:
/// ```
/// output =
///   [0.0 3.0 3.0 3.0]
///   [3.0 3.0 3.0 0.0]
///   [3.0 3.0 3.0 3.0]
///   [3.0 0.0 3.0 3.0]
/// //  ^                one_hot(0)
/// //      ^            one_hot(2)
/// //          ^        one_hot(-1)
/// //              ^    one_hot(1)
/// ```
/// 
/// Suppose that
/// ```
///   indices = [[0, 2], [1, -1]]
///   depth = 3
///   on_value = 1.0
///   off_value = 0.0
///   axis = -1
/// ```
/// 
/// Then output is `[2 x 2 x 3]`:
/// ```
/// output =
///   [
///     [1.0, 0.0, 0.0]  // one_hot(0)
///     [0.0, 0.0, 1.0]  // one_hot(2)
///   ][
///     [0.0, 1.0, 0.0]  // one_hot(1)
///     [0.0, 0.0, 0.0]  // one_hot(-1)
///   ]
/// ```
class OneHotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Makes a "one-shot" iterator that can be iterated only once.
/// A one-shot iterator bundles the logic for defining the dataset and
/// the state of the iterator in a single op, which allows simple input
/// pipelines to be defined without an additional initialization
/// ("MakeIterator") step.
/// 
/// One-shot iterators have the following limitations:
/// 
/// * They do not support parameterization: all logic for creating the underlying
///   dataset must be bundled in the `dataset_factory` function.
/// * They are not resettable. Once a one-shot iterator reaches the end of its
///   underlying dataset, subsequent "IteratorGetNext" operations on that
///   iterator will always produce an `OutOfRange` error.
/// 
/// For greater flexibility, use "Iterator" and "MakeIterator" to define
/// an iterator using an arbitrary subgraph, which may capture tensors
/// (including fed values) as parameters, and which may be reset multiple
/// times by rerunning "MakeIterator".
class OneShotIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a tensor of ones with the same shape and type as x.
class OnesLikeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset by applying related optimizations to `input_dataset`.
/// Creates a dataset by applying related optimizations to `input_dataset`.
class OptimizeDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Constructs an Optional variant from a tuple of tensors.
class OptionalFromValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the value stored in an Optional variant or raises an error if none exists.
class OptionalGetValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns true if and only if the given Optional variant has a value.
class OptionalHasValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates an Optional variant with no value.
class OptionalNoneOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Enqueue a Tensor on the computation outfeed.
class OutfeedEnqueueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Enqueue multiple Tensor values on the computation outfeed.
class OutfeedEnqueueTupleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Packs a list of `N` rank-`R` tensors into one rank-`(R+1)` tensor.
/// Packs the `N` tensors in `values` into a tensor with rank one higher than each
/// tensor in `values`, by packing them along the `axis` dimension.
/// Given a list of tensors of shape `(A, B, C)`;
/// 
/// if `axis == 0` then the `output` tensor will have the shape `(N, A, B, C)`.
/// if `axis == 1` then the `output` tensor will have the shape `(A, N, B, C)`.
/// Etc.
/// 
/// For example:
/// 
/// ```
/// # 'x' is [1, 4]
/// # 'y' is [2, 5]
/// # 'z' is [3, 6]
/// pack([x, y, z]) => [[1, 4], [2, 5], [3, 6]]  # Pack along first dim.
/// pack([x, y, z], axis=1) => [[1, 2, 3], [4, 5, 6]]
/// ```
/// 
/// This is the opposite of `unpack`.
class PackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pads a tensor with zeros.
/// This operation pads a `input` with zeros according to the `paddings` you
/// specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is the
/// rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
/// how many zeros to add before the contents of `input` in that dimension, and
/// `paddings[D, 1]` indicates how many zeros to add after the contents of `input`
/// in that dimension.
/// 
/// The padded size of each dimension D of the output is:
/// 
/// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
/// 
/// For example:
/// 
/// ```
/// # 't' is [[1, 1], [2, 2]]
/// # 'paddings' is [[1, 1], [2, 2]]
/// # rank of 't' is 2
/// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
///                       [0, 0, 1, 1, 0, 0]
///                       [0, 0, 2, 2, 0, 0]
///                       [0, 0, 0, 0, 0, 0]]
/// ```
class PadOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pads a tensor.
/// This operation pads `input` according to the `paddings` and `constant_values`
/// you specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is
/// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
/// how many padding values to add before the contents of `input` in that dimension,
/// and `paddings[D, 1]` indicates how many padding values to add after the contents
/// of `input` in that dimension. `constant_values` is a scalar tensor of the same
/// type as `input` that indicates the value to use for padding `input`.
/// 
/// The padded size of each dimension D of the output is:
/// 
/// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
/// 
/// For example:
/// 
/// ```
/// # 't' is [[1, 1], [2, 2]]
/// # 'paddings' is [[1, 1], [2, 2]]
/// # 'constant_values' is 0
/// # rank of 't' is 2
/// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
///                       [0, 0, 1, 1, 0, 0]
///                       [0, 0, 2, 2, 0, 0]
///                       [0, 0, 0, 0, 0, 0]]
/// ```
class PadV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Interleave the values from the `data` tensors into a single tensor.
/// Builds a merged tensor such that
/// 
/// ```python
///     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
/// ```
/// 
/// For example, if each `indices[m]` is scalar or vector, we have
/// 
/// ```python
///     # Scalar indices:
///     merged[indices[m], ...] = data[m][...]
/// 
///     # Vector indices:
///     merged[indices[m][i], ...] = data[m][i, ...]
/// ```
/// 
/// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
/// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
/// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
/// `constant`, the output shape is
/// 
///     merged.shape = [max(indices)] + constant
/// 
/// Values may be merged in parallel, so if an index appears in both `indices[m][i]`
/// and `indices[n][j]`, the result may be invalid. This differs from the normal
/// DynamicStitch operator that defines the behavior in that case.
/// 
/// For example:
/// 
/// ```python
///     indices[0] = 6
///     indices[1] = [4, 1]
///     indices[2] = [[5, 2], [0, 3]]
///     data[0] = [61, 62]
///     data[1] = [[41, 42], [11, 12]]
///     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
///     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
///               [51, 52], [61, 62]]
/// ```
/// 
/// This method can be used to merge partitions created by `dynamic_partition`
/// as illustrated on the following example:
/// 
/// ```python
///     # Apply function (increments x_i) on elements for which a certain condition
///     # apply (x_i != -1 in this example).
///     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
///     condition_mask=tf.not_equal(x,tf.constant(-1.))
///     partitioned_data = tf.dynamic_partition(
///         x, tf.cast(condition_mask, tf.int32) , 2)
///     partitioned_data[1] = partitioned_data[1] + 1.0
///     condition_indices = tf.dynamic_partition(
///         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
///     x = tf.dynamic_stitch(condition_indices, partitioned_data)
///     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
///     # unchanged.
/// ```
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
/// </div>
class ParallelDynamicStitchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that applies `f` to the outputs of `input_dataset`.
/// Unlike a "MapDataset", which applies `f` sequentially, this dataset invokes up
/// to `num_parallel_calls` copies of `f` in parallel.
class ParallelMapDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that applies `f` to the outputs of `input_dataset`.
/// Unlike a "MapDataset", which applies `f` sequentially, this dataset invokes up
/// to `num_parallel_calls` copies of `f` in parallel.
class ParallelMapDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a normal distribution. The parameters may each be a
/// scalar which applies to the entire output, or a vector of length shape[0] which
/// stores the parameters for each batch.
class ParameterizedTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Transforms a vector of tf.Example protos (as strings) into typed tensors.
class ParseExampleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Transforms a vector of tf.Example protos (as strings) into typed tensors.
class ParseExampleV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// returns `f(inputs)`, where `f`'s body is placed and partitioned.
/// Asynchronously executes a function, potentially across multiple devices but
/// within a single process. The kernel places and partitions a given function's
/// underlying graph, and executes each of the partitioned subgraphs as a function.
class PartitionedCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder op
/// Inserts a placeholder for a tensor that will be always fed.
class PlaceholderOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder op
/// A placeholder op that passes through input when its output is not fed.
class PlaceholderWithDefaultOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the polygamma function \\(\psi^{(n)}(x)\\).
/// The polygamma function is defined as:
/// 
/// 
/// \\(\psi^{(a)}(x) = \frac{d^a}{dx^a} \psi(x)\\)
/// 
/// where \\(\psi(x)\\) is the digamma function.
/// The polygamma function is defined only for non-negative integer orders \\a\\.
class PolygammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes element-wise population count (a.k.a. popcount, bitsum, bitcount).
/// For each entry in `x`, calculates the number of `1` (on) bits in the binary
/// representation of that entry.
/// 
/// **NOTE**: It is more efficient to first `tf.bitcast` your tensors into
/// `int32` or `int64` and perform the bitcount on the result, than to feed in
/// 8- or 16-bit inputs and then aggregate the resulting counts.
class PopulationCountOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the power of one value to another.
/// Given a tensor `x` and a tensor `y`, this operation computes \\(x^y\\) for
/// corresponding elements in `x` and `y`. For example:
/// 
/// ```
/// # tensor 'x' is [[2, 2]], [3, 3]]
/// # tensor 'y' is [[8, 16], [2, 3]]
/// tf.pow(x, y) ==> [[256, 65536], [9, 27]]
/// ```
class PowOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that asynchronously prefetches elements from `input_dataset`.
class PrefetchDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An identity op that triggers an error if a gradient is requested.
/// When executed in a graph, this op outputs its input tensor as-is.
/// 
/// When building ops to compute gradients, the TensorFlow gradient system
/// will return an error when trying to lookup the gradient of this op,
/// because no gradient must ever be registered for this function.  This
/// op exists to prevent subtle bugs from silently returning unimplemented
/// gradients in some corner cases.
class PreventGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Prints a list of tensors.
/// Passes `input` through to `output` and prints `data` when evaluating.
class PrintOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Prints a string scalar.
/// Prints a string scalar to the desired output_stream.
class PrintV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class ProdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the QR decompositions of one or more matrices.
/// Computes the QR decomposition of each inner matrix in `tensor` such that
/// `tensor[..., :, :] = q[..., :, :] * r[..., :,:])`
/// 
/// Currently, the gradient for the QR decomposition is well-defined only when
/// the first `P` columns of the inner matrix are linearly independent, where
/// `P` is the minimum of `M` and `N`, the 2 inner-most dimmensions of `tensor`.
/// 
/// ```python
/// # a is a tensor.
/// # q is a tensor of orthonormal matrices.
/// # r is a tensor of upper triangular matrices.
/// q, r = qr(a)
/// q_full, r_full = qr(a, full_matrices=True)
/// ```
class QrOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Use QuantizeAndDequantizeV2 instead.
class QuantizeAndDequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantizes then dequantizes a tensor.
/// This op simulates the precision loss from the quantized forward pass by:
/// 
/// 1. Quantizing the tensor to fixed point numbers, which should match the target
///    quantization method when it is used in inference.
/// 2. Dequantizing it back to floating point numbers for the following ops, most
///    likely matmul.
/// 
/// There are different ways to quantize. This version uses only scaling, so 0.0
/// maps to 0.
/// 
/// From the specified 'num_bits' in the quantized output type, it determines
/// minimum and maximum representable quantized values.
/// 
/// e.g.
/// 
/// *   [-128, 127] for signed, num_bits = 8, or
/// *   [0, 255] for unsigned, num_bits = 8.
/// 
/// If range_given == False, the initial input_min, input_max will be determined
/// automatically as the minimum and maximum values in the input tensor, otherwise
/// the specified values of input_min, input_max are used.
/// 
/// Note: If the input_min, input_max are specified, they do not need to equal the
/// actual minimum and maximum values in the tensor. e.g. in some cases it may be
/// beneficial to specify these values such that the low probability extremes of the
/// input distribution are clipped.
/// 
/// This op determines the maximum scale_factor that would map the initial
/// [input_min, input_max] range to a range that lies within the representable
/// quantized range.
/// 
/// It determines the scale from one of input_min and input_max, then updates the
/// other one to maximize the representable range.
/// 
/// e.g.
/// 
/// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
///     5.0]: it would use a scale_factor of -128 / -10.0 = 12.8 In this case, it
///     would update input_max to be 127 / 12.8 = 9.921875
/// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
///     10.0]: it would use a scale_factor of 127 / 10.0 = 12.7 In this case, it
///     would update input_min to be 128.0 / 12.7 = -10.07874
/// *   if the output is unsigned, input_min is forced to be 0, and only the
///     specified input_max is used.
/// 
/// After determining the scale_factor and updating the input range, it applies the
/// following to each value in the 'input' tensor.
/// 
/// output = round(clamp(value, input_min, input_max) * scale_factor) / scale_factor.
/// 
/// The above round function rounds the value based on the given round_mode.
class QuantizeAndDequantizeV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantizes then dequantizes a tensor.
/// This is almost identical to QuantizeAndDequantizeV2, except that num_bits is a
/// tensor, so its value can change during training.
class QuantizeAndDequantizeV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantizes then dequantizes a tensor.
/// This is almost identical to QuantizeAndDequantizeV2, except that it returns a
/// gradient of 1 for inputs that are within the quantization range, or 0 otherwise.
class QuantizeAndDequantizeV4Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Quantize the 'input' tensor of type float to 'output' tensor of type 'T'.
/// [min_range, max_range] are scalar floats that specify the range for
/// the 'input' data. The 'mode' attribute controls exactly which calculations are
/// used to convert the float values to their quantized equivalents.  The
/// 'round_mode' attribute controls which rounding tie-breaking algorithm is used
/// when rounding float values to their quantized equivalents.
/// 
/// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
/// 
/// ```
/// out[i] = (in[i] - min_range) * range(T) / (max_range - min_range)
/// if T == qint8: out[i] -= (range(T) + 1) / 2.0
/// ```
/// 
/// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
/// 
/// *MIN_COMBINED Mode Example*
/// 
/// Assume the input is type float and has a possible range of [0.0, 6.0] and the
/// output type is quint8 ([0, 255]). The min_range and max_range values should be
/// specified as 0.0 and 6.0. Quantizing from float to quint8 will multiply each
/// value of the input by 255/6 and cast to quint8.
/// 
/// If the output type was qint8 ([-128, 127]), the operation will additionally
/// subtract each value by 128 prior to casting, so that the range of values aligns
/// with the range of qint8.
/// 
/// If the mode is 'MIN_FIRST', then this approach is used:
/// 
/// ```
/// num_discrete_values = 1 << (# of bits in T)
/// range_adjust = num_discrete_values / (num_discrete_values - 1)
/// range = (range_max - range_min) * range_adjust
/// range_scale = num_discrete_values / range
/// quantized = round(input * range_scale) - round(range_min * range_scale) +
///   numeric_limits<T>::min()
/// quantized = max(quantized, numeric_limits<T>::min())
/// quantized = min(quantized, numeric_limits<T>::max())
/// ```
/// 
/// The biggest difference between this and MIN_COMBINED is that the minimum range
/// is rounded first, before it's subtracted from the rounded value. With
/// MIN_COMBINED, a small bias is introduced where repeated iterations of quantizing
/// and dequantizing will introduce a larger and larger error.
/// 
/// *SCALED mode Example*
/// 
/// `SCALED` mode matches the quantization approach used in
/// `QuantizeAndDequantize{V2|V3}`.
/// 
/// If the mode is `SCALED`, the quantization is performed by multiplying each
/// input value by a scaling_factor.
/// The scaling_factor is determined from `min_range` and `max_range` to be as large
/// as possible such that the range from `min_range` to `max_range` is representable
/// within values of type T.
/// 
/// ```c++
/// 
///   const int min_T = std::numeric_limits<T>::min();
///   const int max_T = std::numeric_limits<T>::max();
///   const float max_float = std::numeric_limits<float>::max();
/// 
///   const float scale_factor_from_min_side =
///       (min_T * min_range > 0) ? min_T / min_range : max_float;
///   const float scale_factor_from_max_side =
///       (max_T * max_range > 0) ? max_T / max_range : max_float;
/// 
///   const float scale_factor = std::min(scale_factor_from_min_side,
///                                       scale_factor_from_max_side);
/// ```
/// 
/// We next use the scale_factor to adjust min_range and max_range as follows:
/// 
/// ```c++
///       min_range = min_T / scale_factor;
///       max_range = max_T / scale_factor;
/// ```
/// 
/// 
/// e.g. if T = qint8, and initially min_range = -10, and max_range = 9, we would
/// compare -128/-10.0 = 12.8 to 127/9.0 = 14.11, and set scaling_factor = 12.8
/// In this case, min_range would remain -10, but max_range would be adjusted to
/// 127 / 12.8 = 9.921875
/// 
/// So we will quantize input values in the range (-10, 9.921875) to (-128, 127).
/// 
/// The input tensor can now be quantized by clipping values to the range
/// `min_range` to `max_range`, then multiplying by scale_factor as follows:
/// 
/// ```c++
/// result = round(min(max_range, max(min_range, input)) * scale_factor)
/// ```
/// 
/// The adjusted `min_range` and `max_range` are returned as outputs 2 and 3 of
/// this operation. These outputs should be used as the range for any further
/// calculations.
/// 
/// 
/// *narrow_range (bool) attribute*
/// 
/// If true, we do not use the minimum quantized value.
/// i.e. for int8 the quantized output, it would be restricted to the range
/// -127..127 instead of the full -128..127 range.
/// This is provided for compatibility with certain inference backends.
/// (Only applies to SCALED mode)
/// 
/// 
/// *axis (int) attribute*
/// 
/// An optional `axis` attribute can specify a dimension index of the input tensor,
/// such that quantization ranges will be calculated and applied separately for each
/// slice of the tensor along that dimension. This is useful for per-channel
/// quantization.
/// 
/// If axis is specified, min_range and max_range
/// 
/// if `axis`=None, per-tensor quantization is performed as normal.
/// 
/// 
/// *ensure_minimum_range (float) attribute*
/// 
/// Ensures the minimum quantization range is at least this value.
/// The legacy default value for this is 0.01, but it is strongly suggested to
/// set it to 0 for new uses.
class QuantizeV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Dequeues a tuple of one or more tensors from the given queue.
/// This operation has k outputs, where k is the number of components
/// in the tuples stored in the given queue, and output i is the ith
/// component of the dequeued tuple.
/// 
/// N.B. If the queue is empty, this operation will block until an element
/// has been dequeued (or 'timeout_ms' elapses, if specified).
class QueueDequeueV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// 2D real-valued fast Fourier transform.
/// Computes the 2-dimensional discrete Fourier transform of a real-valued signal
/// over the inner-most 2 dimensions of `input`.
/// 
/// Since the DFT of a real signal is Hermitian-symmetric, `RFFT2D` only returns the
/// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
/// of `output`: the zero-frequency term, followed by the `fft_length / 2`
/// positive-frequency terms.
/// 
/// Along each axis `RFFT2D` is computed on, if `fft_length` is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class RFFT2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// 3D real-valued fast Fourier transform.
/// Computes the 3-dimensional discrete Fourier transform of a real-valued signal
/// over the inner-most 3 dimensions of `input`.
/// 
/// Since the DFT of a real signal is Hermitian-symmetric, `RFFT3D` only returns the
/// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
/// of `output`: the zero-frequency term, followed by the `fft_length / 2`
/// positive-frequency terms.
/// 
/// Along each axis `RFFT3D` is computed on, if `fft_length` is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class RFFT3DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Real-valued fast Fourier transform.
/// Computes the 1-dimensional discrete Fourier transform of a real-valued signal
/// over the inner-most dimension of `input`.
/// 
/// Since the DFT of a real signal is Hermitian-symmetric, `RFFT` only returns the
/// `fft_length / 2 + 1` unique components of the FFT: the zero-frequency term,
/// followed by the `fft_length / 2` positive-frequency terms.
/// 
/// Along the axis `RFFT` is computed on, if `fft_length` is smaller than the
/// corresponding dimension of `input`, the dimension is cropped. If it is larger,
/// the dimension is padded with zeros.
class RFFTOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts one or more images from RGB to HSV.
/// Outputs a tensor of the same shape as the `images` tensor, containing the HSV
/// value of the pixels. The output is only well defined if the value in `images`
/// are in `[0,1]`.
/// 
/// `output[..., 0]` contains hue, `output[..., 1]` contains saturation, and
/// `output[..., 2]` contains value. All HSV values are in `[0,1]`. A hue of 0
/// corresponds to pure red, hue 1/3 is pure green, and 2/3 is pure blue.
/// 
/// Usage Example:
/// 
/// >>> blue_image = tf.stack([
/// ...    tf.zeros([5,5]),
/// ...    tf.zeros([5,5]),
/// ...    tf.ones([5,5])],
/// ...    axis=-1)
/// >>> blue_hsv_image = tf.image.rgb_to_hsv(blue_image)
/// >>> blue_hsv_image[0,0].numpy()
/// array([0.6666667, 1. , 1. ], dtype=float32)
class RGBToHSVOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather ragged slices from `params` axis `0` according to `indices`.
/// Outputs a `RaggedTensor` output composed from `output_dense_values` and
/// `output_nested_splits`, such that:
/// 
/// ```python
/// output.shape = indices.shape + params.shape[1:]
/// output.ragged_rank = indices.shape.ndims + params.ragged_rank
/// output[i...j, d0...dn] = params[indices[i...j], d0...dn]
/// ```
/// 
/// where
/// 
/// * `params =
///    ragged.from_nested_row_splits(params_dense_values, params_nested_splits)`
///    provides the values that should be gathered.
/// * `indices` ia a dense tensor with dtype `int32` or `int64`, indicating which
///    values should be gathered.
/// * `output =
///    ragged.from_nested_row_splits(output_dense_values, output_nested_splits)`
///    is the output tensor.
/// 
/// (Note: This c++ op is used to implement the higher-level python
/// `tf.ragged.gather` op, which also supports ragged indices.)
class RaggedGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a `RaggedTensor` containing the specified sequences of numbers.
/// Returns a `RaggedTensor` `result` composed from `rt_dense_values` and
/// `rt_nested_splits`, such that
/// `result[i] = range(starts[i], limits[i], deltas[i])`.
/// 
/// ```python
/// (rt_nested_splits, rt_dense_values) = ragged_range(
///       starts=[2, 5, 8], limits=[3, 5, 12], deltas=1)
/// result = tf.ragged.from_row_splits(rt_dense_values, rt_nested_splits)
/// print(result)
/// <tf.RaggedTensor [[2], [], [8, 9, 10, 11]] >
/// ```
/// 
/// The input tensors `starts`, `limits`, and `deltas` may be scalars or vectors.
/// The vector inputs must all have the same size.  Scalar inputs are broadcast
/// to match the size of the vector inputs.
class RaggedRangeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the derivative of a Gamma random sample w.r.t. `alpha`.
class RandomGammaGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from the Gamma distribution(s) described by alpha.
/// This op uses the algorithm by Marsaglia et al. to acquire samples via
/// transformation-rejection from pairs of uniform and normal random variables.
/// See http://dl.acm.org/citation.cfm?id=358414
class RandomGammaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Use RandomPoissonV2 instead.
class RandomPoissonOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from the Poisson distribution(s) described by rate.
/// This op uses two algorithms, depending on rate. If rate >= 10, then
/// the algorithm by Hormann is used to acquire samples via
/// transformation-rejection.
/// See http://www.sciencedirect.com/science/article/pii/0167668793909974.
/// 
/// Otherwise, Knuth's algorithm is used to acquire samples via multiplying uniform
/// random variables.
/// See Donald E. Knuth (1969). Seminumerical Algorithms. The Art of Computer
/// Programming, Volume 2. Addison Wesley
class RandomPoissonV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Randomly shuffles a tensor along its first dimension.
/// The tensor is shuffled along dimension 0, such that each `value[j]` is mapped
///   to one and only one `output[i]`. For example, a mapping that might occur for a
///   3x2 tensor is:
/// 
/// ```
/// [[1, 2],       [[5, 6],
///  [3, 4],  ==>   [1, 2],
///  [5, 6]]        [3, 4]]
/// ```
class RandomShuffleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
class RandomStandardNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random integers from a uniform distribution.
/// The generated values are uniform integers in the range `[minval, maxval)`.
/// The lower bound `minval` is included in the range, while the upper bound
/// `maxval` is excluded.
/// 
/// The random integers are slightly biased unless `maxval - minval` is an exact
/// power of two.  The bias is small for values of `maxval - minval` significantly
/// smaller than the range of the output (either `2^32` or `2^64`).
class RandomUniformIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
class RandomUniformOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset with a range of values. Corresponds to python's xrange.
class RangeDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a sequence of numbers.
/// This operation creates a sequence of numbers that begins at `start` and
/// extends by increments of `delta` up to but not including `limit`.
/// 
/// For example:
/// 
/// ```
/// # 'start' is 3
/// # 'limit' is 18
/// # 'delta' is 3
/// tf.range(start, limit, delta) ==> [3, 6, 9, 12, 15]
/// ```
class RangeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the rank of a tensor.
/// This operation returns an integer representing the rank of `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
/// # shape of tensor 't' is [2, 2, 3]
/// rank(t) ==> 3
/// ```
/// 
/// **Note**: The rank of a tensor is not the same as the rank of a matrix. The rank
/// of a tensor is the number of indices required to uniquely select each element
/// of the tensor. Rank is also known as "order", "degree", or "ndims."
class RankOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reads and outputs the entire contents of the input filename.
class ReadFileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reads the value of a variable.
/// The tensor returned by this operation is immutable.
/// 
/// The value returned by this operation is guaranteed to be influenced by all the
/// writes on which this operation depends directly or indirectly, and to not be
/// influenced by any of the writes which depend directly or indirectly on this
/// operation.
class ReadVariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x / y element-wise for real types.
/// If `x` and `y` are reals, this will return the floating-point division.
/// 
/// *NOTE*: `Div` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class RealDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the real part of a complex number.
/// Given a tensor `input` of complex numbers, this operation returns a tensor of
/// type `float` that is the real part of each element in `input`. All elements in
/// `input` must be complex numbers of the form \\(a + bj\\), where *a* is the real
///  part returned by this operation and *b* is the imaginary part.
/// 
/// For example:
/// 
/// ```
/// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
/// tf.real(input) ==> [-2.25, 3.25]
/// ```
class RealOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the inverse of `x` wrt its input.
/// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
/// is the corresponding input gradient.
class ReciprocalGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the reciprocal of x element-wise.
/// I.e., \\(y = 1 / x\\).
class ReciprocalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives the named tensor from send_device on recv_device.
class RecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that receives embedding activations on the TPU.
/// The TPU system performs the embedding lookups and aggregations specified by
/// the arguments to TPUEmbeddingEnqueue(Integer/Sparse/SparseTensor)Batch. The
/// results of these aggregations are visible to the Tensorflow Graph as the
/// outputs of a RecvTPUEmbeddingActivations op. This op returns a list containing
/// one Tensor of activations per table specified in the model. There can be at
/// most one RecvTPUEmbeddingActivations op in the TPU graph.
class RecvTPUEmbeddingActivationsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reduces the input dataset to a singleton using a reduce function.
class ReduceDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Joins a string Tensor across the given dimensions.
/// Computes the string join across dimensions in the given string Tensor of shape
/// `[\\(d_0, d_1, ..., d_{n-1}\\)]`.  Returns a new Tensor created by joining the input
/// strings with the given separator (default: empty string).  Negative indices are
/// counted backwards from the end, with `-1` being equivalent to `n - 1`.  If
/// indices are not specified, joins across all dimensions beginning from `n - 1`
/// through `0`.
/// 
/// For example:
/// 
/// ```python
/// # tensor `a` is [["a", "b"], ["c", "d"]]
/// tf.reduce_join(a, 0) ==> ["ac", "bd"]
/// tf.reduce_join(a, 1) ==> ["ab", "cd"]
/// tf.reduce_join(a, -2) = tf.reduce_join(a, 0) ==> ["ac", "bd"]
/// tf.reduce_join(a, -1) = tf.reduce_join(a, 1) ==> ["ab", "cd"]
/// tf.reduce_join(a, 0, keep_dims=True) ==> [["ac", "bd"]]
/// tf.reduce_join(a, 1, keep_dims=True) ==> [["ab"], ["cd"]]
/// tf.reduce_join(a, 0, separator=".") ==> ["a.c", "b.d"]
/// tf.reduce_join(a, [0, 1]) ==> "acbd"
/// tf.reduce_join(a, [1, 0]) ==> "abcd"
/// tf.reduce_join(a, []) ==> [["a", "b"], ["c", "d"]]
/// tf.reduce_join(a) = tf.reduce_join(a, [1, 0]) ==> "abcd"
/// ```
class ReduceJoinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear 6 gradients for a Relu6 operation.
class Relu6GradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear 6: `min(max(features, 0), 6)`.
class Relu6Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear gradients for a Relu operation.
class ReluGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes rectified linear: `max(features, 0)`.
/// See: https://en.wikipedia.org/wiki/Rectifier_(neural_networks)
/// Example usage:
/// >>> tf.nn.relu([-2., 0., 3.]).numpy()
/// array([0., 0., 3.], dtype=float32)
class ReluOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Runs function `f` on a remote device indicated by `target`.
class RemoteCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that emits the outputs of `input_dataset` `count` times.
class RepeatDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reshapes a tensor.
/// Given `tensor`, this operation returns a tensor that has the same values
/// as `tensor` with shape `shape`.
/// 
/// If one component of 1-D tensor `shape` is the special value -1, the size of that
/// dimension is computed so that the total size remains constant.  In particular, a
/// `shape` of `[-1]` flattens into 1-D.  At most one component of `shape` may be
/// unknown.
/// 
/// The `shape` must be 1-D and the operation returns a tensor with shape
/// `shape` filled with the values of `tensor`. In this case, the number of elements
/// implied by `shape` must be the same as the number of elements in `tensor`.
/// 
/// It is an error if `shape` is not 1-D.
/// 
/// For example:
/// 
/// ```
/// # tensor 't' is [1, 2, 3, 4, 5, 6, 7, 8, 9]
/// # tensor 't' has shape [9]
/// reshape(t, [3, 3]) ==> [[1, 2, 3],
///                         [4, 5, 6],
///                         [7, 8, 9]]
/// 
/// # tensor 't' is [[[1, 1], [2, 2]],
/// #                [[3, 3], [4, 4]]]
/// # tensor 't' has shape [2, 2, 2]
/// reshape(t, [2, 4]) ==> [[1, 1, 2, 2],
///                         [3, 3, 4, 4]]
/// 
/// # tensor 't' is [[[1, 1, 1],
/// #                 [2, 2, 2]],
/// #                [[3, 3, 3],
/// #                 [4, 4, 4]],
/// #                [[5, 5, 5],
/// #                 [6, 6, 6]]]
/// # tensor 't' has shape [3, 2, 3]
/// # pass '[-1]' to flatten 't'
/// reshape(t, [-1]) ==> [1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6]
/// 
/// # -1 can also be used to infer the shape
/// 
/// # -1 is inferred to be 9:
/// reshape(t, [2, -1]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
///                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
/// # -1 is inferred to be 2:
/// reshape(t, [-1, 9]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
///                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
/// # -1 is inferred to be 3:
/// reshape(t, [ 2, -1, 3]) ==> [[[1, 1, 1],
///                               [2, 2, 2],
///                               [3, 3, 3]],
///                              [[4, 4, 4],
///                               [5, 5, 5],
///                               [6, 6, 6]]]
/// 
/// # tensor 't' is [7]
/// # shape `[]` reshapes to a scalar
/// reshape(t, []) ==> 7
/// ```
class ReshapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of bilinear interpolation.
class ResizeBilinearGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Resize `images` to `size` using bilinear interpolation.
/// Input images can be of different types but output images are always float.
class ResizeBilinearOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of nearest neighbor interpolation.
class ResizeNearestNeighborGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Resize `images` to `size` using nearest neighbor interpolation.
class ResizeNearestNeighborOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the AdaMax algorithm.
/// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
/// v_t <- max(beta2 * v_{t-1}, abs(g))
/// variable <- variable - learning_rate / (1 - beta1^t) * m_t / (v_t + epsilon)
class ResourceApplyAdaMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the adadelta scheme.
/// accum = rho() * accum + (1 - rho()) * grad.square();
/// update = (update_accum + epsilon).sqrt() * (accum + epsilon()).rsqrt() * grad;
/// update_accum = rho() * update_accum + (1 - rho()) * update.square();
/// var -= update;
class ResourceApplyAdadeltaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the proximal adagrad scheme.
class ResourceApplyAdagradDAOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the adagrad scheme.
/// accum += grad * grad
/// var -= lr * grad * (1 / sqrt(accum))
class ResourceApplyAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the adagrad scheme.
/// accum += grad * grad
/// var -= lr * grad * (1 / (sqrt(accum) + epsilon))
class ResourceApplyAdagradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the Adam algorithm.
/// $$\text{lr}_t := \mathrm{lr} \cdot \frac{\sqrt{1 - \beta_2^t}}{1 - \beta_1^t}$$
/// $$m_t := \beta_1 \cdot m_{t-1} + (1 - \beta_1) \cdot g$$
/// $$v_t := \beta_2 \cdot v_{t-1} + (1 - \beta_2) \cdot g^2$$
/// $$\text{var} := \begin{cases} \text{var} - (m_t \beta_1 + g \cdot (1 - \beta_1))\cdot\text{lr}_t/(\sqrt{v_t} + \epsilon), &\text{if use_nesterov}\\\\  \text{var} - m_t \cdot \text{lr}_t /(\sqrt{v_t} + \epsilon), &\text{otherwise} \end{cases}$$
class ResourceApplyAdamOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the AddSign update.
/// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
/// update <- (alpha + sign_decay * sign(g) *sign(m)) * g
/// variable <- variable - lr_t * update
class ResourceApplyAddSignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the centered RMSProp algorithm.
/// The centered RMSProp algorithm uses an estimate of the centered second moment
/// (i.e., the variance) for normalization, as opposed to regular RMSProp, which
/// uses the (uncentered) second moment. This often helps with training, but is
/// slightly more expensive in terms of computation and memory.
/// 
/// Note that in dense implementation of this algorithm, mg, ms, and mom will
/// update even if the grad is zero, but in this sparse implementation, mg, ms,
/// and mom will not update in iterations during which the grad is zero.
/// 
/// mean_square = decay * mean_square + (1-decay) * gradient ** 2
/// mean_grad = decay * mean_grad + (1-decay) * gradient
/// 
/// Delta = learning_rate * gradient / sqrt(mean_square + epsilon - mean_grad ** 2)
/// 
/// mg <- rho * mg_{t-1} + (1-rho) * grad
/// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
/// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms - mg * mg + epsilon)
/// var <- var - mom
class ResourceApplyCenteredRMSPropOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the Ftrl-proximal scheme.
/// accum_new = accum + grad * grad
/// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
/// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
/// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
/// accum = accum_new
class ResourceApplyFtrlOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the Ftrl-proximal scheme.
/// accum_new = accum + grad * grad
/// grad_with_shrinkage = grad + 2 * l2_shrinkage * var
/// linear += grad_with_shrinkage +
///     (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
/// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
/// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
/// accum = accum_new
class ResourceApplyFtrlV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' by subtracting 'alpha' * 'delta' from it.
class ResourceApplyGradientDescentOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the momentum scheme.
/// Set use_nesterov = True if you want to use Nesterov momentum.
/// 
/// accum = accum * momentum - lr * grad
/// var += accum
class ResourceApplyKerasMomentumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the momentum scheme.
/// Set use_nesterov = True if you want to use Nesterov momentum.
/// 
/// accum = accum * momentum + grad
/// var -= lr * accum
class ResourceApplyMomentumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the AddSign update.
/// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
/// update <- exp(logbase * sign_decay * sign(g) * sign(m_t)) * g
/// variable <- variable - lr_t * update
class ResourceApplyPowerSignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' and '*accum' according to FOBOS with Adagrad learning rate.
/// accum += grad * grad
/// prox_v = var - lr * grad * (1 / sqrt(accum))
/// var = sign(prox_v)/(1+lr*l2) * max{|prox_v|-lr*l1,0}
class ResourceApplyProximalAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' as FOBOS algorithm with fixed learning rate.
/// prox_v = var - alpha * delta
/// var = sign(prox_v)/(1+alpha*l2) * max{|prox_v|-alpha*l1,0}
class ResourceApplyProximalGradientDescentOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update '*var' according to the RMSProp algorithm.
/// Note that in dense implementation of this algorithm, ms and mom will
/// update even if the grad is zero, but in this sparse implementation, ms
/// and mom will not update in iterations during which the grad is zero.
/// 
/// mean_square = decay * mean_square + (1-decay) * gradient ** 2
/// Delta = learning_rate * gradient / sqrt(mean_square + epsilon)
/// 
/// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
/// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
/// var <- var - mom
class ResourceApplyRMSPropOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// GatherNd on a resource.
/// This op reads the variable referenced by the first argument, and
/// then performs a GatherNd operation on it.
class ResourceGatherNdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather slices from the variable pointed to by `resource` according to `indices`.
/// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
/// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
/// 
/// ```python
///     # Scalar indices
///     output[:, ..., :] = params[indices, :, ... :]
/// 
///     # Vector indices
///     output[i, :, ..., :] = params[indices[i], :, ... :]
/// 
///     # Higher rank indices
///     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
/// ```
class ResourceGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds sparse updates to the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] += updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] += updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] += updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions add.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Divides sparse updates into the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] /= updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] /= updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] /= updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions multiply.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reduces sparse updates into the variable referenced by `resource` using the `max` operation.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] = max(ref[indices, ...], updates[...])
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] = max(ref[indices[i], ...], updates[i, ...])
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] = max(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions are combined.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reduces sparse updates into the variable referenced by `resource` using the `min` operation.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] = min(ref[indices, ...], updates[...])
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] = min(ref[indices[i], ...], updates[i, ...])
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] = min(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions are combined.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiplies sparse updates into the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] *= updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] *= updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] *= updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions multiply.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies sparse addition to individual values or slices in a Variable.
/// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
/// 
/// `indices` must be integer tensor, containing indices into `ref`.
/// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
/// 
/// The innermost dimension of `indices` (with length `K`) corresponds to
/// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
/// dimension of `ref`.
/// 
/// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
/// 
/// ```
/// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
/// ```
/// 
/// For example, say we want to add 4 scattered elements to a rank-1 tensor to
/// 8 elements. In Python, that addition would look like this:
/// 
/// ```python
/// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
/// indices = tf.constant([[4], [3], [1], [7]])
/// updates = tf.constant([9, 10, 11, 12])
/// add = tf.scatter_nd_add(ref, indices, updates)
/// with tf.Session() as sess:
///   print sess.run(add)
/// ```
/// 
/// The resulting update to ref would look like this:
/// 
///     [1, 13, 3, 14, 14, 6, 7, 20]
/// 
/// See `tf.scatter_nd` for more details about how to make updates to
/// slices.
class ResourceScatterNdAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies sparse subtraction to individual values or slices in a Variable.
/// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
/// 
/// `indices` must be integer tensor, containing indices into `ref`.
/// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
/// 
/// The innermost dimension of `indices` (with length `K`) corresponds to
/// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
/// dimension of `ref`.
/// 
/// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
/// 
/// ```
/// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
/// ```
/// 
/// For example, say we want to subtract 4 scattered elements from a rank-1 tensor
/// with 8 elements. In Python, that subtraction would look like this:
/// 
/// ```python
/// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
/// indices = tf.constant([[4], [3], [1], [7]])
/// updates = tf.constant([9, 10, 11, 12])
/// sub = tf.scatter_nd_sub(ref, indices, updates)
/// with tf.Session() as sess:
///   print sess.run(sub)
/// ```
/// 
/// The resulting update to ref would look like this:
/// 
///     [1, -9, 3, -6, -4, 6, 7, -4]
/// 
/// See `tf.scatter_nd` for more details about how to make updates to
/// slices.
class ResourceScatterNdSubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies sparse `updates` to individual values or slices within a given
/// variable according to `indices`.
/// 
/// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
/// 
/// `indices` must be integer tensor, containing indices into `ref`.
/// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
/// 
/// The innermost dimension of `indices` (with length `K`) corresponds to
/// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
/// dimension of `ref`.
/// 
/// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
/// 
/// ```
/// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]].
/// ```
/// 
/// For example, say we want to update 4 scattered elements to a rank-1 tensor to
/// 8 elements. In Python, that update would look like this:
/// 
/// ```python
///     ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8])
///     indices = tf.constant([[4], [3], [1] ,[7]])
///     updates = tf.constant([9, 10, 11, 12])
///     update = tf.scatter_nd_update(ref, indices, updates)
///     with tf.Session() as sess:
///       print sess.run(update)
/// ```
/// 
/// The resulting update to ref would look like this:
/// 
///     [1, 11, 3, 10, 9, 6, 7, 12]
/// 
/// See `tf.scatter_nd` for more details about how to make updates to
/// slices.
class ResourceScatterNdUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Subtracts sparse updates from the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] -= updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] -= updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] -= updates[i, ..., j, ...]
/// 
/// Duplicate entries are handled correctly: if multiple `indices` reference
/// the same location, their contributions add.
/// 
/// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
/// </div>
class ResourceScatterSubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assigns sparse updates to the variable referenced by `resource`.
/// This operation computes
/// 
///     # Scalar indices
///     ref[indices, ...] = updates[...]
/// 
///     # Vector indices (for each i)
///     ref[indices[i], ...] = updates[i, ...]
/// 
///     # High rank indices (for each i, ..., j)
///     ref[indices[i, ..., j], ...] = updates[i, ..., j, ...]
class ResourceScatterUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update relevant entries in '*var' and '*accum' according to the adagrad scheme.
/// That is for rows we have grad for, we update var and accum as follows:
/// accum += grad * grad
/// var -= lr * grad * (1 / sqrt(accum))
class ResourceSparseApplyAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update relevant entries in '*var' and '*accum' according to the adagrad scheme.
/// That is for rows we have grad for, we update var and accum as follows:
/// accum += grad * grad
/// var -= lr * grad * (1 / sqrt(accum))
class ResourceSparseApplyAdagradV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Update relevant entries in '*var' according to the Ftrl-proximal scheme.
/// That is for rows we have grad for, we update var, accum and linear as follows:
/// accum_new = accum + grad * grad
/// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
/// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
/// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
/// accum = accum_new
class ResourceSparseApplyFtrlOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assign `value` to the sliced l-value reference of `ref`.
/// The values of `value` are assigned to the positions in the variable
/// `ref` that are selected by the slice parameters. The slice parameters
/// `begin, `end`, `strides`, etc. work exactly as in `StridedSlice`.
/// 
/// NOTE this op currently does not support broadcasting and so `value`'s
/// shape must be exactly the shape produced by the slice of `ref`.
class ResourceStridedSliceAssignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Restores a tensor from checkpoint files.
/// Reads a tensor stored in one or several files. If there are several files (for
/// instance because a tensor was saved as slices), `file_pattern` may contain
/// wildcard symbols (`*` and `?`) in the filename portion only, not in the
/// directory portion.
/// 
/// If a `file_pattern` matches several files, `preferred_shard` can be used to hint
/// in which file the requested tensor is likely to be found. This op will first
/// open the file at index `preferred_shard` in the list of matching files and try
/// to restore tensors from that file.  Only if some tensors or tensor slices are
/// not found in that first file, then the Op opens all the files. Setting
/// `preferred_shard` to match the value passed as the `shard` input
/// of a matching `Save` Op may speed up Restore.  This attribute only affects
/// performance, not correctness.  The default value -1 means files are processed in
/// order.
/// 
/// See also `RestoreSlice`.
class RestoreOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Restores tensors from a V2 checkpoint.
/// For backward compatibility with the V1 format, this Op currently allows
/// restoring from a V1 checkpoint as well:
///   - This Op first attempts to find the V2 index file pointed to by "prefix", and
///     if found proceed to read it as a V2 checkpoint;
///   - Otherwise the V1 read path is invoked.
/// Relying on this behavior is not recommended, as the ability to fall back to read
/// V1 might be deprecated and eventually removed.
/// 
/// By default, restores the named tensors in full.  If the caller wishes to restore
/// specific slices of stored tensors, "shape_and_slices" should be non-empty
/// strings and correspondingly well-formed.
/// 
/// Callers must ensure all the named tensors are indeed stored in the checkpoint.
class RestoreV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingADAMParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve ADAM embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingADAMParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingAdadeltaParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve Adadelta embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingAdadeltaParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingAdagradParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve Adagrad embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingAdagradParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve centered RMSProp embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingCenteredRMSPropParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingFTRLParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve FTRL embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingFTRLParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve MDL Adagrad Light embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingMDLAdagradLightParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingMomentumParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve Momentum embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingMomentumParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve proximal Adagrad embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingProximalAdagradParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingProximalYogiParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingProximalYogiParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve RMSProp embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingRMSPropParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RetrieveTPUEmbeddingStochasticGradientDescentParametersGradAccumDebugOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Retrieve SGD embedding parameters.
/// An op that retrieves optimization parameters from embedding to host
/// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
/// the correct embedding table configuration. For example, this op is
/// used to retrieve updated parameters before saving a checkpoint.
class RetrieveTPUEmbeddingStochasticGradientDescentParametersOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reverses specific dimensions of a tensor.
/// Given a `tensor`, and a `bool` tensor `dims` representing the dimensions
/// of `tensor`, this operation reverses each dimension i of `tensor` where
/// `dims[i]` is `True`.
/// 
/// `tensor` can have up to 8 dimensions. The number of dimensions
/// of `tensor` must equal the number of elements in `dims`. In other words:
/// 
/// `rank(tensor) = size(dims)`
/// 
/// For example:
/// 
/// ```
/// # tensor 't' is [[[[ 0,  1,  2,  3],
/// #                  [ 4,  5,  6,  7],
/// #                  [ 8,  9, 10, 11]],
/// #                 [[12, 13, 14, 15],
/// #                  [16, 17, 18, 19],
/// #                  [20, 21, 22, 23]]]]
/// # tensor 't' shape is [1, 2, 3, 4]
/// 
/// # 'dims' is [False, False, False, True]
/// reverse(t, dims) ==> [[[[ 3,  2,  1,  0],
///                         [ 7,  6,  5,  4],
///                         [ 11, 10, 9, 8]],
///                        [[15, 14, 13, 12],
///                         [19, 18, 17, 16],
///                         [23, 22, 21, 20]]]]
/// 
/// # 'dims' is [False, True, False, False]
/// reverse(t, dims) ==> [[[[12, 13, 14, 15],
///                         [16, 17, 18, 19],
///                         [20, 21, 22, 23]
///                        [[ 0,  1,  2,  3],
///                         [ 4,  5,  6,  7],
///                         [ 8,  9, 10, 11]]]]
/// 
/// # 'dims' is [False, False, True, False]
/// reverse(t, dims) ==> [[[[8, 9, 10, 11],
///                         [4, 5, 6, 7],
///                         [0, 1, 2, 3]]
///                        [[20, 21, 22, 23],
///                         [16, 17, 18, 19],
///                         [12, 13, 14, 15]]]]
/// ```
class ReverseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reverses variable length slices.
/// This op first slices `input` along the dimension `batch_dim`, and for each
/// slice `i`, reverses the first `seq_lengths[i]` elements along
/// the dimension `seq_dim`.
/// 
/// The elements of `seq_lengths` must obey `seq_lengths[i] <= input.dims[seq_dim]`,
/// and `seq_lengths` must be a vector of length `input.dims[batch_dim]`.
/// 
/// The output slice `i` along dimension `batch_dim` is then given by input
/// slice `i`, with the first `seq_lengths[i]` slices along dimension
/// `seq_dim` reversed.
/// 
/// For example:
/// 
/// ```
/// # Given this:
/// batch_dim = 0
/// seq_dim = 1
/// input.dims = (4, 8, ...)
/// seq_lengths = [7, 2, 3, 5]
/// 
/// # then slices of input are reversed on seq_dim, but only up to seq_lengths:
/// output[0, 0:7, :, ...] = input[0, 7:0:-1, :, ...]
/// output[1, 0:2, :, ...] = input[1, 2:0:-1, :, ...]
/// output[2, 0:3, :, ...] = input[2, 3:0:-1, :, ...]
/// output[3, 0:5, :, ...] = input[3, 5:0:-1, :, ...]
/// 
/// # while entries past seq_lens are copied through:
/// output[0, 7:, :, ...] = input[0, 7:, :, ...]
/// output[1, 2:, :, ...] = input[1, 2:, :, ...]
/// output[2, 3:, :, ...] = input[2, 3:, :, ...]
/// output[3, 2:, :, ...] = input[3, 2:, :, ...]
/// ```
/// 
/// In contrast, if:
/// 
/// ```
/// # Given this:
/// batch_dim = 2
/// seq_dim = 0
/// input.dims = (8, ?, 4, ...)
/// seq_lengths = [7, 2, 3, 5]
/// 
/// # then slices of input are reversed on seq_dim, but only up to seq_lengths:
/// output[0:7, :, 0, :, ...] = input[7:0:-1, :, 0, :, ...]
/// output[0:2, :, 1, :, ...] = input[2:0:-1, :, 1, :, ...]
/// output[0:3, :, 2, :, ...] = input[3:0:-1, :, 2, :, ...]
/// output[0:5, :, 3, :, ...] = input[5:0:-1, :, 3, :, ...]
/// 
/// # while entries past seq_lens are copied through:
/// output[7:, :, 0, :, ...] = input[7:, :, 0, :, ...]
/// output[2:, :, 1, :, ...] = input[2:, :, 1, :, ...]
/// output[3:, :, 2, :, ...] = input[3:, :, 2, :, ...]
/// output[2:, :, 3, :, ...] = input[2:, :, 3, :, ...]
/// ```
class ReverseSequenceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reverses specific dimensions of a tensor.
/// Given a `tensor`, and a `int32` tensor `axis` representing the set of
/// dimensions of `tensor` to reverse. This operation reverses each dimension
/// `i` for which there exists `j` s.t. `axis[j] == i`.
/// 
/// `tensor` can have up to 8 dimensions. The number of dimensions specified
/// in `axis` may be 0 or more entries. If an index is specified more than
/// once, a InvalidArgument error is raised.
/// 
/// For example:
/// 
/// ```
/// # tensor 't' is [[[[ 0,  1,  2,  3],
/// #                  [ 4,  5,  6,  7],
/// #                  [ 8,  9, 10, 11]],
/// #                 [[12, 13, 14, 15],
/// #                  [16, 17, 18, 19],
/// #                  [20, 21, 22, 23]]]]
/// # tensor 't' shape is [1, 2, 3, 4]
/// 
/// # 'dims' is [3] or 'dims' is [-1]
/// reverse(t, dims) ==> [[[[ 3,  2,  1,  0],
///                         [ 7,  6,  5,  4],
///                         [ 11, 10, 9, 8]],
///                        [[15, 14, 13, 12],
///                         [19, 18, 17, 16],
///                         [23, 22, 21, 20]]]]
/// 
/// # 'dims' is '[1]' (or 'dims' is '[-3]')
/// reverse(t, dims) ==> [[[[12, 13, 14, 15],
///                         [16, 17, 18, 19],
///                         [20, 21, 22, 23]
///                        [[ 0,  1,  2,  3],
///                         [ 4,  5,  6,  7],
///                         [ 8,  9, 10, 11]]]]
/// 
/// # 'dims' is '[2]' (or 'dims' is '[-2]')
/// reverse(t, dims) ==> [[[[8, 9, 10, 11],
///                         [4, 5, 6, 7],
///                         [0, 1, 2, 3]]
///                        [[20, 21, 22, 23],
///                         [16, 17, 18, 19],
///                         [12, 13, 14, 15]]]]
/// ```
class ReverseV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Elementwise computes the bitwise right-shift of `x` and `y`.
/// Performs a logical shift for unsigned integer types, and an arithmetic shift
/// for signed integer types.
/// 
/// If `y` is negative, or greater than or equal to than the width of `x` in bits
/// the result is implementation defined.
/// 
/// Example:
/// 
/// ```python
/// import tensorflow as tf
/// from tensorflow.python.ops import bitwise_ops
/// import numpy as np
/// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64]
/// 
/// for dtype in dtype_list:
///   lhs = tf.constant([-1, -5, -3, -14], dtype=dtype)
///   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
/// 
///   right_shift_result = bitwise_ops.right_shift(lhs, rhs)
/// 
///   print(right_shift_result)
/// 
/// # This will print:
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int8)
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int16)
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int32)
/// # tf.Tensor([-1 -5 -1 -1], shape=(4,), dtype=int64)
/// 
/// lhs = np.array([-2, 64, 101, 32], dtype=np.int8)
/// rhs = np.array([-1, -5, -3, -14], dtype=np.int8)
/// bitwise_ops.right_shift(lhs, rhs)
/// # <tf.Tensor: shape=(4,), dtype=int8, numpy=array([ -2,  64, 101,  32], dtype=int8)>
/// ```
class RightShiftOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise integer closest to x.
/// If the result is midway between two representable values,
/// the even representable is chosen.
/// For example:
/// 
/// ```
/// rint(-1.5) ==> -2.0
/// rint(0.5000001) ==> 1.0
/// rint([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0]) ==> [-2., -2., -0., 0., 2., 2., 2.]
/// ```
class RintOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x + y element-wise.
/// *NOTE*: `RiscAdd` does not supports broadcasting.
/// 
/// Given two input tensors, the `tf.risc_add` operation computes the sum for every element in the tensor.
/// 
/// Both input and output have a range `(-inf, inf)`.
class RiscAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class RiscDotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Advance the counter of a counter-based RNG.
/// The state of the RNG after
/// `rng_read_and_skip(n)` will be the same as that after `uniform([n])`
/// (or any other distribution). The actual increment added to the
/// counter is an unspecified implementation choice.
/// 
/// In the case that the input algorithm is RNG_ALG_AUTO_SELECT, the counter in the state needs to be of size int64[2], the current maximal counter size among algorithms. In this case, this op will manage the counter as if it is an 128-bit integer with layout [lower_64bits, higher_64bits]. If an algorithm needs less than 128 bits for the counter, it should use the left portion of the int64[2]. In this way, the int64[2] is compatible with all current RNG algorithms (Philox, ThreeFry and xla::RandomAlgorithm::RNG_DEFAULT). Downstream RNG ops can thus use this counter with any RNG algorithm.
class RngReadAndSkipOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Rolls the elements of a tensor along an axis.
/// The elements are shifted positively (towards larger indices) by the offset of
/// `shift` along the dimension of `axis`. Negative `shift` values will shift
/// elements in the opposite direction. Elements that roll passed the last position
/// will wrap around to the first and vice versa. Multiple shifts along multiple
/// axes may be specified.
/// 
/// For example:
/// 
/// ```
/// # 't' is [0, 1, 2, 3, 4]
/// roll(t, shift=2, axis=0) ==> [3, 4, 0, 1, 2]
/// 
/// # shifting along multiple dimensions
/// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
/// roll(t, shift=[1, -2], axis=[0, 1]) ==> [[7, 8, 9, 5, 6], [2, 3, 4, 0, 1]]
/// 
/// # shifting along the same axis multiple times
/// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
/// roll(t, shift=[2, -3], axis=[1, 1]) ==> [[1, 2, 3, 4, 0], [6, 7, 8, 9, 5]]
/// ```
class RollOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Rounds the values of a tensor to the nearest integer, element-wise.
/// Rounds half to even.  Also known as bankers rounding. If you want to round
/// according to the current system rounding mode use std::cint.
class RoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the rsqrt of `x` wrt its input.
/// Specifically, `grad = dy * -0.5 * y^3`, where `y = rsqrt(x)`, and `dy`
/// is the corresponding input gradient.
class RsqrtGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes reciprocal of square root of x element-wise.
/// I.e., \\(y = 1 / \sqrt{x}\\).
class RsqrtOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Saves the input tensors to disk.
/// The size of `tensor_names` must match the number of tensors in `data`. `data[i]`
/// is written to `filename` with name `tensor_names[i]`.
/// 
/// See also `SaveSlices`.
class SaveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Saves input tensors slices to disk.
/// This is like `Save` except that tensors can be listed in the saved file as being
/// a slice of a larger tensor.  `shapes_and_slices` specifies the shape of the
/// larger tensor and the slice that this tensor covers. `shapes_and_slices` must
/// have as many elements as `tensor_names`.
/// 
/// Elements of the `shapes_and_slices` input must either be:
/// 
/// *  The empty string, in which case the corresponding tensor is
///    saved normally.
/// *  A string of the form `dim0 dim1 ... dimN-1 slice-spec` where the
///    `dimI` are the dimensions of the larger tensor and `slice-spec`
///    specifies what part is covered by the tensor to save.
/// 
/// `slice-spec` itself is a `:`-separated list: `slice0:slice1:...:sliceN-1`
/// where each `sliceI` is either:
/// 
/// *  The string `-` meaning that the slice covers all indices of this dimension
/// *  `start,length` where `start` and `length` are integers.  In that
///    case the slice covers `length` indices starting at `start`.
/// 
/// See also `Save`.
class SaveSlicesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Saves tensors in V2 checkpoint format.
/// By default, saves the named tensors in full.  If the caller wishes to save
/// specific slices of full tensors, "shape_and_slices" should be non-empty strings
/// and correspondingly well-formed.
class SaveV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatters `updates` into a tensor of shape `shape` according to `indices`.
/// Scatter sparse `updates` according to individual values at the specified
/// `indices`. This op returns an output tensor with the `shape` you specify. This
/// op is the inverse of the `tf.gather_nd` operator which extracts values or slices
/// from a given tensor.
/// 
/// This operation is similar to `tf.tensor_scatter_nd_add`, except that the tensor
/// is zero-initialized. Calling `tf.scatter_nd(indices, updates, shape)`
/// is identical to calling
/// `tf.tensor_scatter_nd_add(tf.zeros(shape, updates.dtype), indices, updates)`
/// 
/// If `indices` contains duplicates, the associated `updates` are accumulated
/// (summed) into the output tensor.
/// 
/// **WARNING**: For floating-point data types, the output may be nondeterministic.
/// This is because the order in which the updates are applied is nondeterministic
/// and when floating-point numbers are added in different orders the resulting
/// numerical approximation error can be slightly different. However, the output
/// will be deterministic if op determinism is enabled via
/// `tf.config.experimental.enable_op_determinism`.
/// 
/// `indices` is an integer tensor containing indices into the output tensor. The
/// last dimension of `indices` can be at most the rank of `shape`:
/// 
///     indices.shape[-1] <= shape.rank
/// 
/// The last dimension of `indices` corresponds to indices of elements
/// (if `indices.shape[-1] = shape.rank`) or slices
/// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
/// `shape`.
/// 
/// `updates` is a tensor with shape:
/// 
///     indices.shape[:-1] + shape[indices.shape[-1]:]
/// 
/// The simplest form of the scatter op is to insert individual elements in
/// a tensor by index. Consider an example where you want to insert 4 scattered
/// elements in a rank-1 tensor with 8 elements.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd1.png" alt>
/// </div>
/// 
/// In Python, this scatter operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[4], [3], [1], [7]])
///     updates = tf.constant([9, 10, 11, 12])
///     shape = tf.constant([8])
///     scatter = tf.scatter_nd(indices, updates, shape)
///     print(scatter)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [0, 11, 0, 10, 9, 0, 0, 12]
/// 
/// You can also insert entire slices of a higher rank tensor all at once. For
/// example, you can insert two slices in the first dimension of a rank-3 tensor
/// with two matrices of new values.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd2.png" alt>
/// </div>
/// 
/// In Python, this scatter operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[1], [3]])
///     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]],
///                            [[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]]])
///     shape = tf.constant([4, 4, 4])
///     scatter = tf.scatter_nd(indices, updates, shape)
///     print(scatter)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [[[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]],
///      [[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
///      [[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]],
///      [[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]]]
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore the bad indices; supported on both CPU and GPU.
class ScatterNdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the max is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMax.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_max(c, tf.constant([0, 0, 1])).numpy()
/// array([[4, 3, 3, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the maximum is empty for a given segment ID `i`, it outputs the smallest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::lowest()`.
/// 
/// Note: That this op is currently only supported with jit_compile=True.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// The only difference with SegmentMax is the additional input  `num_segments`.
/// This helps in evaluating the output shape in compile time.
/// `num_segments` should be consistent with segment_ids.
/// e.g. Max(segment_ids) should be equal to `num_segments` - 1 for a 1-d segment_ids
/// With inconsistent num_segments, the op still runs. only difference is,
/// the output takes the size of num_segments irrespective of size of segment_ids and data.
/// for num_segments less than expected output size, the last elements are ignored
/// for num_segments more than the expected output size, last elements are assigned
/// smallest possible value for the specific numeric type.
/// 
/// For example:
/// 
/// >>> @tf.function(jit_compile=True)
/// ... def test(c):
/// ...   return tf.raw_ops.SegmentMaxV2(data=c, segment_ids=tf.constant([0, 0, 1]), num_segments=2)
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> test(c).numpy()
/// array([[4, 3, 3, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMaxV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \frac{\sum_j data_j}{N}\\) where `mean` is
/// over `j` such that `segment_ids[j] == i` and `N` is the total number of
/// values summed.
/// 
/// If the mean is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as a smaller following index when computing the numerator
/// of the mean.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMean.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1.0,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_mean(c, tf.constant([0, 0, 1])).numpy()
/// array([[2.5, 2.5, 2.5, 2.5],
///        [5., 6., 7., 8.]], dtype=float32)
class SegmentMeanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the min is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMin.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_min(c, tf.constant([0, 0, 1])).numpy()
/// array([[1, 2, 2, 1],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the minimum is empty for a given segment ID `i`, it outputs the largest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::max()`.
/// 
/// Note: That this op is currently only supported with jit_compile=True.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// The only difference with SegmentMin is the additional input  `num_segments`.
/// This helps in evaluating the output shape in compile time.
/// `num_segments` should be consistent with segment_ids.
/// e.g. Max(segment_ids) should be equal to `num_segments` - 1 for a 1-d segment_ids
/// With inconsistent num_segments, the op still runs. only difference is,
/// the output takes the size of num_segments irrespective of size of segment_ids and data.
/// for num_segments less than expected output size, the last elements are ignored
/// for num_segments more than the expected output size, last elements are assigned
/// the largest possible value for the specific numeric type.
/// 
/// For example:
/// 
/// >>> @tf.function(jit_compile=True)
/// ... def test(c):
/// ...   return tf.raw_ops.SegmentMinV2(data=c, segment_ids=tf.constant([0, 0, 1]), num_segments=2)
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> test(c).numpy()
/// array([[1, 2, 2, 1],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentMinV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \prod_j data_j\\) where the product is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the product is empty for a given segment ID `i`, `output[i] = 1`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentProd.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_prod(c, tf.constant([0, 0, 1])).numpy()
/// array([[4, 6, 6, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentProdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \prod_j data_j\\) where the product is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the product is empty for a given segment ID `i`, `output[i] = 1`.
/// 
/// Note: That this op is currently only supported with jit_compile=True.
/// 
/// The only difference with SegmentProd is the additional input  `num_segments`.
/// This helps in evaluating the output shape in compile time.
/// `num_segments` should be consistent with segment_ids.
/// e.g. Max(segment_ids) - 1 should be equal to `num_segments` for a 1-d segment_ids
/// With inconsistent num_segments, the op still runs. only difference is,
/// the output takes the size of num_segments irrespective of size of segment_ids and data.
/// for num_segments less than expected output size, the last elements are ignored
/// for num_segments more than the expected output size, last elements are assigned 1.
/// 
/// For example:
/// 
/// >>> @tf.function(jit_compile=True)
/// ... def test(c):
/// ...   return tf.raw_ops.SegmentProdV2(data=c, segment_ids=tf.constant([0, 0, 1]), num_segments=2)
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> test(c).numpy()
/// array([[4, 6, 6, 4],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentProdV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \sum_j data_j\\) where sum is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be sorted,
/// and an error is thrown for indices that are not increasing. On GPU, this
/// does not throw an error for unsorted indices. On GPU, out-of-order indices
/// result in safe but unspecified behavior, which may include treating
/// out-of-order indices as the same as a smaller following index.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentSum.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
/// >>> tf.math.segment_sum(c, tf.constant([0, 0, 1])).numpy()
/// array([[5, 5, 5, 5],
///        [5, 6, 7, 8]], dtype=int32)
class SegmentSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output_i = \sum_j data_j\\) where sum is over `j` such
/// that `segment_ids[j] == i`.
/// 
/// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
/// 
/// Note that this op is currently only supported with jit_compile=True.
/// </div>
class SegmentSumV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Selects elements from `x` or `y`, depending on `condition`.
/// The `x`, and `y` tensors must all have the same shape, and the
/// output will also have that shape.
/// 
/// The `condition` tensor must be a scalar if `x` and `y` are scalars.
/// If `x` and `y` are vectors or higher rank, then `condition` must be either a
/// scalar, a vector with size matching the first dimension of `x`, or must have
/// the same shape as `x`.
/// 
/// The `condition` tensor acts as a mask that chooses, based on the value at each
/// element, whether the corresponding element / row in the output should be
/// taken from `x` (if true) or `y` (if false).
/// 
/// If `condition` is a vector and `x` and `y` are higher rank matrices, then
/// it chooses which row (outer dimension) to copy from `x` and `y`.
/// If `condition` has the same shape as `x` and `y`, then it chooses which
/// element to copy from `x` and `y`.
/// 
/// For example:
/// 
/// ```python
/// # 'condition' tensor is [[True,  False]
/// #                        [False, True]]
/// # 't' is [[1, 2],
/// #         [3, 4]]
/// # 'e' is [[5, 6],
/// #         [7, 8]]
/// select(condition, t, e)  # => [[1, 6], [7, 4]]
/// 
/// 
/// # 'condition' tensor is [True, False]
/// # 't' is [[1, 2],
/// #         [3, 4]]
/// # 'e' is [[5, 6],
/// #         [7, 8]]
/// select(condition, t, e) ==> [[1, 2],
///                              [7, 8]]
/// 
/// ```
class SelectOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class SelectV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the eigen decomposition of one or more square self-adjoint matrices.
/// Computes the eigenvalues and (optionally) eigenvectors of each inner matrix in
/// `input` such that `input[..., :, :] = v[..., :, :] * diag(e[..., :])`. The eigenvalues
/// are sorted in non-decreasing order.
/// 
/// ```python
/// # a is a tensor.
/// # e is a tensor of eigenvalues.
/// # v is a tensor of eigenvectors.
/// e, v = self_adjoint_eig(a)
/// e = self_adjoint_eig(a, compute_v=False)
/// ```
class SelfAdjointEigV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for the scaled exponential linear (Selu) operation.
class SeluGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes scaled exponential linear: `scale * alpha * (exp(features) - 1)`
/// if < 0, `scale * features` otherwise.
/// 
/// To be used together with
/// `initializer = tf.variance_scaling_initializer(factor=1.0, mode='FAN_IN')`.
/// For correct dropout, use `tf.contrib.nn.alpha_dropout`.
/// 
/// See [Self-Normalizing Neural Networks](https://arxiv.org/abs/1706.02515)
class SeluOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sends the named tensor from send_device to recv_device.
class SendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs gradient updates of embedding tables.
class SendTPUEmbeddingGradientsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts the given `resource_handle` representing an iterator to a variant tensor.
class SerializeIteratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Serialize a `SparseTensor` into a `[3]` `Tensor` object.
class SerializeSparseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op used to indicate to the compiler and runtime the static bounds of a tensor.
/// The information passed through this op can possibly be used by the compiler and
/// runtime to perform certain optimizations such as more efficient DMAs. The
/// bounds passed via this op should be considered advisory only, and depending on
/// the implementation, might do nothing and simply be an identity
/// 
/// `input`: The tensor that has dynamic dimensions.
/// `static_shape`: The static shape of the tensor, corresponds to the maximum bounds of each dimension.
/// `output` is the input tensor with no changes done to it.
/// 
/// Example usage:
/// 
/// def tpu_call(args):
///   def model_fn(args):
///     # do something with dynamic tensor
/// 
///   @function.Defun(capture_resource_var_by_value=False)
///   def tpu_subgraph():
///       return tf.tpu.rewrite(model_fn, args)
/// 
///   return tf.raw_ops.TPUPartitionedCall(
///       args=tpu_subgraph.captured_inputs,
///       Tout=[o.type for o in tpu_subgraph.definition.signature.output_arg],
///       f=tpu_subgraph,
///       device_ordinal=[0])
/// 
/// static_shape = tf.placeholder(tf.int32, shape=([3]), name='static_size')
/// 
/// w = tf.Variable(tf.constant([[1.0], [2.0], [3.0]]), name='w')
/// 
/// w_dyn = tf.SetDynamicDimensionBounds(w, static_size])
/// tpu_call([w_dyn])
class SetStaticDimensionBoundsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns shape of tensors.
/// This operation returns N 1-D integer tensors representing shape of `input[i]s`.
class ShapeNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the shape of a tensor.
/// This operation returns a 1-D integer tensor representing the shape of `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
/// shape(t) ==> [2, 2, 3]
/// ```
class ShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Generate a sharded filename. The filename is printf formatted as
/// %s-%05d-of-%05d, basename, shard, num_shards.
class ShardedFilenameOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ShuffleAndRepeatDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ShuffleDatasetV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class ShuffleDatasetV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Shuts down a running distributed TPU system.
/// The op returns an error if no system is running.
class ShutdownDistributedTPUOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that shuts down the TPU system.
class ShutdownTPUSystemOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient of the sigmoid of `x` wrt its input.
/// Specifically, `grad = dy * y * (1 - y)`, where `y = sigmoid(x)`, and
/// `dy` is the corresponding input gradient.
class SigmoidGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes sigmoid of `x` element-wise.
/// Specifically, `y = 1 / (1 + exp(-x))`.
class SigmoidOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns an element-wise indication of the sign of a number.
/// `y = sign(x) = -1` if `x < 0`; 0 if `x == 0`; 1 if `x > 0`.
/// 
/// For complex numbers, `y = sign(x) = x / |x|` if `x != 0`, otherwise `y = 0`.
/// 
/// Example usage:
/// >>> tf.math.sign([0., 2., -3.])
/// <tf.Tensor: shape=(3,), dtype=float32, numpy=array([ 0.,  1., -1.], dtype=float32)>
class SignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes sine of x element-wise.
/// Given an input tensor, this function computes sine of every
///   element in the tensor. Input range is `(-inf, inf)` and
///   output range is `[-1,1]`.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10, float("inf")])
///   tf.math.sin(x) ==> [nan -0.4121185 -0.47942555 0.84147096 0.9320391 -0.87329733 -0.54402107 nan]
///   ```
class SinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes hyperbolic sine of x element-wise.
/// Given an input tensor, this function computes hyperbolic sine of every
///   element in the tensor. Input range is `[-inf,inf]` and output range
///   is `[-inf,inf]`.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
///   tf.math.sinh(x) ==> [-inf -4.0515420e+03 -5.2109528e-01 1.1752012e+00 1.5094614e+00 3.6268604e+00 1.1013232e+04 inf]
///   ```
class SinhOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the size of a tensor.
/// This operation returns an integer representing the number of elements in
/// `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1,, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]]
/// size(t) ==> 12
/// ```
class SizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return a slice from 'input'.
/// The output tensor is a tensor with dimensions described by 'size'
/// whose values are extracted from 'input' starting at the offsets in
/// 'begin'.
/// 
/// *Requirements*:
///   0 <= begin[i] <= begin[i] + size[i] <= Di  for i in [0, n)
class SliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a copy of the input tensor.
class SnapshotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softmax cross entropy cost and gradients to backpropagate.
/// Inputs are the logits, not probabilities.
class SoftmaxCrossEntropyWithLogitsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softmax activations.
/// For each batch `i` and class `j` we have
/// 
///     $$softmax[i, j] = exp(logits[i, j]) / sum_j(exp(logits[i, j]))$$
class SoftmaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softplus gradients for a softplus operation.
class SoftplusGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class SoftplusOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softsign gradients for a softsign operation.
class SoftsignGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softsign: `features / (abs(features) + 1)`.
class SoftsignOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which sorts each COO tensors in the list by which SparseCore the id will go to. This op should be used along with the ConvertToSparseCoreCsrWrappedCooTensorOp.
class SortListOfSparseCoreCooTensorsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// SpaceToBatch for N-D tensors of type T.
/// This operation divides "spatial" dimensions `[1, ..., M]` of the input into a
/// grid of blocks of shape `block_shape`, and interleaves these blocks with the
/// "batch" dimension (0) such that in the output, the spatial dimensions
/// `[1, ..., M]` correspond to the position within the grid, and the batch
/// dimension combines both the position within a spatial block and the original
/// batch position.  Prior to division into blocks, the spatial dimensions of the
/// input are optionally zero padded according to `paddings`. See below for a
/// precise description.
/// 
/// This operation is equivalent to the following steps:
/// 
/// 1. Zero-pad the start and end of dimensions `[1, ..., M]` of the
///    input according to `paddings` to produce `padded` of shape `padded_shape`.
/// 
/// 2. Reshape `padded` to `reshaped_padded` of shape:
/// 
///      [batch] +
///      [padded_shape[1] / block_shape[0],
///        block_shape[0],
///       ...,
///       padded_shape[M] / block_shape[M-1],
///       block_shape[M-1]] +
///      remaining_shape
/// 
/// 3. Permute dimensions of `reshaped_padded` to produce
///    `permuted_reshaped_padded` of shape:
/// 
///      block_shape +
///      [batch] +
///      [padded_shape[1] / block_shape[0],
///       ...,
///       padded_shape[M] / block_shape[M-1]] +
///      remaining_shape
/// 
/// 4. Reshape `permuted_reshaped_padded` to flatten `block_shape` into the batch
///    dimension, producing an output tensor of shape:
/// 
///      [batch * prod(block_shape)] +
///      [padded_shape[1] / block_shape[0],
///       ...,
///       padded_shape[M] / block_shape[M-1]] +
///      remaining_shape
/// 
/// Some examples:
/// 
/// (1) For the following input of shape `[1, 2, 2, 1]`, `block_shape = [2, 2]`, and
///     `paddings = [[0, 0], [0, 0]]`:
/// 
/// ```
/// x = [[[[1], [2]], [[3], [4]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 1]` and value:
/// 
/// ```
/// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
/// ```
/// 
/// (2) For the following input of shape `[1, 2, 2, 3]`, `block_shape = [2, 2]`, and
///     `paddings = [[0, 0], [0, 0]]`:
/// 
/// ```
/// x = [[[[1, 2, 3], [4, 5, 6]],
///       [[7, 8, 9], [10, 11, 12]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 3]` and value:
/// 
/// ```
/// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
/// ```
/// 
/// (3) For the following input of shape `[1, 4, 4, 1]`, `block_shape = [2, 2]`, and
///     `paddings = [[0, 0], [0, 0]]`:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]],
///       [[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[4, 2, 2, 1]` and value:
/// 
/// ```
/// x = [[[[1], [3]], [[9], [11]]],
///      [[[2], [4]], [[10], [12]]],
///      [[[5], [7]], [[13], [15]]],
///      [[[6], [8]], [[14], [16]]]]
/// ```
/// 
/// (4) For the following input of shape `[2, 2, 4, 1]`, block_shape = `[2, 2]`, and
///     paddings = `[[0, 0], [2, 0]]`:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]]],
///      [[[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[8, 1, 3, 1]` and value:
/// 
/// ```
/// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
///      [[[0], [2], [4]]], [[[0], [10], [12]]],
///      [[[0], [5], [7]]], [[[0], [13], [15]]],
///      [[[0], [6], [8]]], [[[0], [14], [16]]]]
/// ```
/// 
/// Among others, this operation is useful for reducing atrous convolution into
/// regular convolution.
class SpaceToBatchNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// SpaceToBatch for 4-D tensors of type T.
/// This is a legacy version of the more general SpaceToBatchND.
/// 
/// Zero-pads and then rearranges (permutes) blocks of spatial data into batch.
/// More specifically, this op outputs a copy of the input tensor where values from
/// the `height` and `width` dimensions are moved to the `batch` dimension. After
/// the zero-padding, both `height` and `width` of the input must be divisible by the
/// block size.
/// 
/// The attr `block_size` must be greater than one. It indicates the block size.
/// 
///   * Non-overlapping blocks of size `block_size x block size` in the height and
///     width dimensions are rearranged into the batch dimension at each location.
///   * The batch of the output tensor is `batch * block_size * block_size`.
///   * Both height_pad and width_pad must be divisible by block_size.
/// 
/// The shape of the output will be:
/// 
///     [batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
///      depth]
/// 
/// Some examples:
/// 
/// (1) For the following input of shape `[1, 2, 2, 1]` and block_size of 2:
/// 
/// ```
/// x = [[[[1], [2]], [[3], [4]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 1]` and value:
/// 
/// ```
/// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
/// ```
/// 
/// (2) For the following input of shape `[1, 2, 2, 3]` and block_size of 2:
/// 
/// ```
/// x = [[[[1, 2, 3], [4, 5, 6]],
///       [[7, 8, 9], [10, 11, 12]]]]
/// ```
/// 
/// The output tensor has shape `[4, 1, 1, 3]` and value:
/// 
/// ```
/// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
/// ```
/// 
/// (3) For the following input of shape `[1, 4, 4, 1]` and block_size of 2:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]],
///       [[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[4, 2, 2, 1]` and value:
/// 
/// ```
/// x = [[[[1], [3]], [[9], [11]]],
///      [[[2], [4]], [[10], [12]]],
///      [[[5], [7]], [[13], [15]]],
///      [[[6], [8]], [[14], [16]]]]
/// ```
/// 
/// (4) For the following input of shape `[2, 2, 4, 1]` and block_size of 2:
/// 
/// ```
/// x = [[[[1],   [2],  [3],  [4]],
///       [[5],   [6],  [7],  [8]]],
///      [[[9],  [10], [11],  [12]],
///       [[13], [14], [15],  [16]]]]
/// ```
/// 
/// The output tensor has shape `[8, 1, 2, 1]` and value:
/// 
/// ```
/// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
///      [[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
/// ```
/// 
/// Among others, this operation is useful for reducing atrous convolution into
/// regular convolution.
class SpaceToBatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// SpaceToDepth for tensors of type T.
/// Rearranges blocks of spatial data, into depth. More specifically,
/// this op outputs a copy of the input tensor where values from the `height`
/// and `width` dimensions are moved to the `depth` dimension.
/// The attr `block_size` indicates the input block size.
/// 
///   * Non-overlapping blocks of size `block_size x block size` are rearranged
///     into depth at each location.
///   * The depth of the output tensor is `block_size * block_size * input_depth`.
///   * The Y, X coordinates within each block of the input become the high order
///     component of the output channel index.
///   * The input tensor's height and width must be divisible by block_size.
/// 
/// The `data_format` attr specifies the layout of the input and output tensors
/// with the following options:
///   "NHWC": `[ batch, height, width, channels ]`
///   "NCHW": `[ batch, channels, height, width ]`
///   "NCHW_VECT_C":
///       `qint8 [ batch, channels / 4, height, width, 4 ]`
/// 
/// It is useful to consider the operation as transforming a 6-D Tensor.
/// e.g. for data_format = NHWC,
///      Each element in the input tensor can be specified via 6 coordinates,
///      ordered by decreasing memory layout significance as:
///      n,oY,bY,oX,bX,iC  (where n=batch index, oX, oY means X or Y coordinates
///                         within the output image, bX, bY means coordinates
///                         within the input block, iC means input channels).
///      The output would be a transpose to the following layout:
///      n,oY,oX,bY,bX,iC
/// 
/// This operation is useful for resizing the activations between convolutions
/// (but keeping all data), e.g. instead of pooling. It is also useful for training
/// purely convolutional models.
/// 
/// For example, given an input of shape `[1, 2, 2, 1]`, data_format = "NHWC" and
/// block_size = 2:
/// 
/// ```
/// x = [[[[1], [2]],
///       [[3], [4]]]]
/// ```
/// 
/// This operation will output a tensor of shape `[1, 1, 1, 4]`:
/// 
/// ```
/// [[[[1, 2, 3, 4]]]]
/// ```
/// 
/// Here, the input has a batch of 1 and each batch element has shape `[2, 2, 1]`,
/// the corresponding output will have a single element (i.e. width and height are
/// both 1) and will have a depth of 4 channels (1 * block_size * block_size).
/// The output element shape is `[1, 1, 4]`.
/// 
/// For an input tensor with larger depth, here of shape `[1, 2, 2, 3]`, e.g.
/// 
/// ```
/// x = [[[[1, 2, 3], [4, 5, 6]],
///       [[7, 8, 9], [10, 11, 12]]]]
/// ```
/// 
/// This operation, for block_size of 2, will return the following tensor of shape
/// `[1, 1, 1, 12]`
/// 
/// ```
/// [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
/// ```
/// 
/// Similarly, for the following input of shape `[1 4 4 1]`, and a block size of 2:
/// 
/// ```
/// x = [[[[1],   [2],  [5],  [6]],
///       [[3],   [4],  [7],  [8]],
///       [[9],  [10], [13],  [14]],
///       [[11], [12], [15],  [16]]]]
/// ```
/// 
/// the operator will return the following tensor of shape `[1 2 2 4]`:
/// 
/// ```
/// x = [[[[1, 2, 3, 4],
///        [5, 6, 7, 8]],
///       [[9, 10, 11, 12],
///        [13, 14, 15, 16]]]]
/// ```
class SpaceToDepthOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds two `SparseTensor` objects to produce another `SparseTensor`.
/// The input `SparseTensor` objects' indices are assumed ordered in standard
/// lexicographic order.  If this is not the case, before this step run
/// `SparseReorder` to restore index ordering.
/// 
/// By default, if two values sum to zero at some index, the output `SparseTensor`
/// would still include that particular location in its index, storing a zero in the
/// corresponding value slot.  To override this, callers can specify `thresh`,
/// indicating that if the sum has a magnitude strictly smaller than `thresh`, its
/// corresponding value and index would then not be included.  In particular,
/// `thresh == 0` (default) means everything is kept and actual thresholding happens
/// only for a positive value.
/// 
/// In the following shapes, `nnz` is the count after taking `thresh` into account.
class SparseAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Fills empty rows in the input 2-D `SparseTensor` with a default value.
/// The input `SparseTensor` is represented via the tuple of inputs
/// (`indices`, `values`, `dense_shape`).  The output `SparseTensor` has the
/// same `dense_shape` but with indices `output_indices` and values
/// `output_values`.
/// 
/// This op inserts a single entry for every row that doesn't have any values.
/// The index is created as `[row, 0, ..., 0]` and the inserted value
/// is `default_value`.
/// 
/// For example, suppose `sp_input` has shape `[5, 6]` and non-empty values:
/// 
///     [0, 1]: a
///     [0, 3]: b
///     [2, 0]: c
///     [3, 1]: d
/// 
/// Rows 1 and 4 are empty, so the output will be of shape `[5, 6]` with values:
/// 
///     [0, 1]: a
///     [0, 3]: b
///     [1, 0]: default_value
///     [2, 0]: c
///     [3, 1]: d
///     [4, 0]: default_value
/// 
/// The output `SparseTensor` will be in row-major order and will have the
/// same shape as the input.
/// 
/// This op also returns an indicator vector shaped `[dense_shape[0]]` such that
/// 
///     empty_row_indicator[i] = True iff row i was an empty row.
/// 
/// And a reverse index map vector shaped `[indices.shape[0]]` that is used during
/// backpropagation,
/// 
///     reverse_index_map[j] = out_j s.t. indices[j, :] == output_indices[out_j, :]
class SparseFillEmptyRowsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiply matrix "a" by matrix "b".
/// The inputs must be two-dimensional matrices and the inner dimension of "a" must
/// match the outer dimension of "b". Both "a" and "b" must be `Tensor`s not
/// `SparseTensor`s.  This op is optimized for the case where at least one of "a" or
/// "b" is sparse, in the sense that they have a large proportion of zero values.
/// The breakeven for using this versus a dense matrix multiply on one platform was
/// 30% zero values in the sparse matrix.
/// 
/// The gradient computation of this operation will only take advantage of sparsity
/// in the input gradient when that gradient comes from a Relu.
class SparseMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum of elements across dimensions of a SparseTensor.
/// This Op takes a SparseTensor and is the sparse counterpart to
/// `tf.reduce_sum()`.  In particular, this Op also returns a dense `Tensor`
/// instead of a sparse one.
/// 
/// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
/// with length 1.
/// 
/// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
/// with a single element is returned.  Additionally, the axes can be negative,
/// which are interpreted according to the indexing rules in Python.
class SparseReduceSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Reshapes a SparseTensor to represent values in a new dense shape.
/// This operation has the same semantics as reshape on the represented dense
/// tensor.  The `input_indices` are recomputed based on the requested `new_shape`.
/// 
/// If one component of `new_shape` is the special value -1, the size of that
/// dimension is computed so that the total dense size remains constant.  At
/// most one component of `new_shape` can be -1.  The number of dense elements
/// implied by `new_shape` must be the same as the number of dense elements
/// originally implied by `input_shape`.
/// 
/// Reshaping does not affect the order of values in the SparseTensor.
/// 
/// If the input tensor has rank `R_in` and `N` non-empty values, and `new_shape`
/// has length `R_out`, then `input_indices` has shape `[N, R_in]`,
/// `input_shape` has length `R_in`, `output_indices` has shape `[N, R_out]`, and
/// `output_shape` has length `R_out`.
class SparseReshapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for SparseSegmentMean.
/// Returns tensor "output" with same shape as grad, except for dimension 0 whose
/// value is output_dim0.
class SparseSegmentMeanGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean along sparse segments of a tensor.
/// See `tf.sparse.segment_sum` for usage examples.
/// 
/// Like `SegmentMean`, but `segment_ids` can have rank less than `data`'s first
/// dimension, selecting a subset of dimension 0, specified by `indices`.
class SparseSegmentMeanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the mean along sparse segments of a tensor.
/// Like `SparseSegmentMean`, but allows missing ids in `segment_ids`. If an id is
/// missing, the `output` tensor at that position will be zeroed.
/// 
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
class SparseSegmentMeanWithNumSegmentsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes gradients for SparseSegmentSqrtN.
/// Returns tensor "output" with same shape as grad, except for dimension 0 whose
/// value is output_dim0.
class SparseSegmentSqrtNGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along sparse segments of a tensor divided by the sqrt of N.
/// N is the size of the segment being reduced.
/// 
/// See `tf.sparse.segment_sum` for usage examples.
class SparseSegmentSqrtNOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along sparse segments of a tensor divided by the sqrt of N.
/// N is the size of the segment being reduced.
/// 
/// Like `SparseSegmentSqrtN`, but allows missing ids in `segment_ids`. If an id is
/// missing, the `output` tensor at that position will be zeroed.
/// 
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
class SparseSegmentSqrtNWithNumSegmentsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along sparse segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Like `SegmentSum`, but `segment_ids` can have rank less than `data`'s first
/// dimension, selecting a subset of dimension 0, specified by `indices`.
/// 
/// For example:
/// 
/// ```python
/// c = tf.constant([[1,2,3,4], [-1,-2,-3,-4], [5,6,7,8]])
/// 
/// # Select two rows, one segment.
/// tf.sparse_segment_sum(c, tf.constant([0, 1]), tf.constant([0, 0]))
/// # => [[0 0 0 0]]
/// 
/// # Select two rows, two segment.
/// tf.sparse_segment_sum(c, tf.constant([0, 1]), tf.constant([0, 1]))
/// # => [[ 1  2  3  4]
/// #     [-1 -2 -3 -4]]
/// 
/// # Select all rows, two segments.
/// tf.sparse_segment_sum(c, tf.constant([0, 1, 2]), tf.constant([0, 0, 1]))
/// # => [[0 0 0 0]
/// #     [5 6 7 8]]
/// 
/// # Which is equivalent to:
/// tf.segment_sum(c, tf.constant([0, 0, 1]))
/// ```
class SparseSegmentSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes softmax cross entropy cost and gradients to backpropagate.
/// Unlike `SoftmaxCrossEntropyWithLogits`, this operation does not accept
/// a matrix of label probabilities, but rather a single label per row
/// of features.  This label is considered to have probability 1.0 for the
/// given row.
/// 
/// Inputs are the logits, not probabilities.
class SparseSoftmaxCrossEntropyWithLogitsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Multiply SparseTensor (of rank 2) "A" by dense matrix "B".
/// No validity checking is performed on the indices of A.  However, the following
/// input format is recommended for optimal behavior:
/// 
/// if adjoint_a == false:
///   A should be sorted in lexicographically increasing order.  Use SparseReorder
///   if you're not sure.
/// if adjoint_a == true:
///   A should be sorted in order of increasing dimension 1 (i.e., "column major"
///   order instead of "row major" order).
class SparseTensorDenseMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts a sparse representation into a dense tensor.
/// Builds an array `dense` with shape `output_shape` such that
/// 
/// ```
/// # If sparse_indices is scalar
/// dense[i] = (i == sparse_indices ? sparse_values : default_value)
/// 
/// # If sparse_indices is a vector, then for each i
/// dense[sparse_indices[i]] = sparse_values[i]
/// 
/// # If sparse_indices is an n by d matrix, then for each i in [0, n)
/// dense[sparse_indices[i][0], ..., sparse_indices[i][d-1]] = sparse_values[i]
/// ```
/// 
/// All other values in `dense` are set to `default_value`.  If `sparse_values` is a
/// scalar, all sparse indices are set to this single value.
/// 
/// Indices should be sorted in lexicographic order, and indices must not
/// contain any repeats. If `validate_indices` is true, these properties
/// are checked during execution.
class SparseToDenseOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Splits a tensor into `num_split` tensors along one dimension.
class SplitOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Splits a tensor into `num_split` tensors along one dimension.
class SplitVOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the sqrt of `x` wrt its input.
/// Specifically, `grad = dy * 0.5 / y`, where `y = sqrt(x)`, and `dy`
/// is the corresponding input gradient.
class SqrtGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes square root of x element-wise.
/// I.e., \\(y = \sqrt{x} = x^{1/2}\\).
class SqrtOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes square of x element-wise.
/// I.e., \\(y = x * x = x^2\\).
class SquareOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns conj(x - y)(x - y) element-wise.
/// *NOTE*: `SquaredDifference` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class SquaredDifferenceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Removes dimensions of size 1 from the shape of a tensor.
/// Given a tensor `input`, this operation returns a tensor of the same type with
/// all dimensions of size 1 removed. If you don't want to remove all size 1
/// dimensions, you can remove specific size 1 dimensions by specifying
/// `axis`.
/// 
/// For example:
/// 
/// ```
/// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
/// shape(squeeze(t)) ==> [2, 3]
/// ```
/// 
/// Or, to remove specific size 1 dimensions:
/// 
/// ```
/// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
/// shape(squeeze(t, [2, 4])) ==> [1, 2, 3, 1]
/// ```
class SqueezeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Delete the stack from its resource container.
class StackCloseV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Pop the element at the top of the stack.
class StackPopV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Push an element onto the stack.
class StackPushV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A stack that produces elements in first-in last-out order.
class StackV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// returns `f(inputs)`, where `f`'s body is placed and partitioned.
/// Asynchronously executes a function, potentially across multiple devices but
/// within a single process. The kernel places and partitions a given function's
/// underlying graph, and executes each of the partitioned subgraphs as a function.
class StatefulPartitionedCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
class StatefulStandardNormalV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
class StatefulTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random integers from a uniform distribution.
/// The generated values are uniform integers covering the whole range of `dtype`.
class StatefulUniformFullIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random integers from a uniform distribution.
/// The generated values are uniform integers in the range `[minval, maxval)`.
/// The lower bound `minval` is included in the range, while the upper bound
/// `maxval` is excluded.
/// 
/// The random integers are slightly biased unless `maxval - minval` is an exact
/// power of two.  The bias is small for values of `maxval - minval` significantly
/// smaller than the range of the output (either `2^32` or `2^64`).
class StatefulUniformIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
class StatefulUniformOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Draws samples from a multinomial distribution.
class StatelessMultinomialOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class StatelessParameterizedTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random numbers from a binomial distribution.
/// Outputs random values from a binomial distribution.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, `counts`, and `probs`.
class StatelessRandomBinomialOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random numbers from a gamma distribution.
/// Outputs random values from a gamma distribution.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, and `alpha`.
class StatelessRandomGammaV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Picks the best counter-based RNG algorithm based on device.
/// This op picks the best counter-based RNG algorithm based on device.
class StatelessRandomGetAlgOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Picks the best algorithm based on device, and scrambles seed into key and counter.
/// This op picks the best counter-based RNG algorithm based on device, and scrambles a shape-[2] seed into a key and a counter, both needed by the counter-based algorithm. The scrambling is opaque but approximately satisfies the property that different seed results in different key/counter pair (which will in turn result in different random numbers).
class StatelessRandomGetKeyCounterAlgOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scrambles seed into key and counter, using the best algorithm based on device.
/// This op scrambles a shape-[2] seed into a key and a counter, both needed by counter-based RNG algorithms. The scrambing uses the best algorithm based on device. The scrambling is opaque but approximately satisfies the property that different seed results in different key/counter pair (which will in turn result in different random numbers).
class StatelessRandomGetKeyCounterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessRandomNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a normal distribution.
/// The generated values will have mean 0 and standard deviation 1.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessRandomNormalV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random numbers from a Poisson distribution.
/// Outputs random values from a Poisson distribution.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, and `lam`.
class StatelessRandomPoissonOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values are uniform integers covering the whole range of `dtype`.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessRandomUniformFullIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values are uniform integers covering the whole range of `dtype`.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessRandomUniformFullIntV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[minval, maxval)`.
/// 
/// The outputs are a deterministic function of `shape`, `seed`, `minval`, and `maxval`.
class StatelessRandomUniformIntOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random integers from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[minval, maxval)`.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter`, `alg`, `minval` and `maxval`.
class StatelessRandomUniformIntV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessRandomUniformOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom random values from a uniform distribution.
/// The generated values follow a uniform distribution in the range `[0, 1)`. The
/// lower bound 0 is included in the range, while the upper bound 1 is excluded.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessRandomUniformV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
/// 
/// The outputs are a deterministic function of `shape` and `seed`.
class StatelessTruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs deterministic pseudorandom values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
/// 
/// The outputs are a deterministic function of `shape`, `key`, `counter` and `alg`.
class StatelessTruncatedNormalV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Check if the input matches the regex pattern.
/// The input is a string tensor of any shape. The pattern is the
/// regular expression to be matched with every element of the input tensor.
/// The boolean values (True or False) of the output tensor indicate
/// if the input matches the regex pattern provided.
/// 
/// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
class StaticRegexFullMatchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Stops gradient computation.
/// When executed in a graph, this op outputs its input tensor as-is.
/// 
/// When building ops to compute gradients, this op prevents the contribution of
/// its inputs to be taken into account.  Normally, the gradient generator adds ops
/// to a graph to compute the derivatives of a specified 'loss' by recursively
/// finding out inputs that contributed to its computation.  If you insert this op
/// in the graph it inputs are masked from the gradient generator.  They are not
/// taken into account for computing gradients.
/// 
/// This is useful any time you want to compute a value with TensorFlow but need
/// to pretend that the value was a constant. For example, the softmax function
/// for a vector x can be written as
/// 
/// ```python
/// 
///   def softmax(x):
///     numerator = tf.exp(x)
///     denominator = tf.reduce_sum(numerator)
///     return numerator / denominator
/// ```
/// 
/// This however is susceptible to overflow if the values in x are large. An
/// alternative more stable way is to subtract the maximum of x from each of the
/// values.
/// 
/// ```python
/// 
///   def stable_softmax(x):
///     z = x - tf.reduce_max(x)
///     numerator = tf.exp(z)
///     denominator = tf.reduce_sum(numerator)
///     return numerator / denominator
/// ```
/// 
/// However, when we backprop through the softmax to x, we dont want to backprop
/// through the `tf.reduce_max(x)` (if the max values are not unique then the
/// gradient could flow to the wrong input) calculation and treat that as a
/// constant. Therefore, we should write this out as
/// 
/// ```python
/// 
///   def stable_softmax(x):
///     z = x - tf.stop_gradient(tf.reduce_max(x))
///     numerator = tf.exp(z)
///     denominator = tf.reduce_sum(numerator)
///     return numerator / denominator
/// ```
/// 
/// Some other examples include:
/// 
/// *  The *EM* algorithm where the *M-step* should not involve backpropagation
///    through the output of the *E-step*.
/// *  Contrastive divergence training of Boltzmann machines where, when
///    differentiating the energy function, the training must not backpropagate
///    through the graph that generated the samples from the model.
/// *  Adversarial training, where no backprop should happen through the adversarial
///    example generation process.
class StopGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Store the number of IDs and unique IDs in an FDO table.
class StoreMinibatchStatisticsInFdoOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the gradient of `StridedSlice`.
/// Since `StridedSlice` cuts out pieces of its `input` which is size
/// `shape`, its gradient will have the same shape (which is passed here
/// as `shape`). The gradient will be zero in any element that the slice
/// does not select.
/// 
/// Arguments are the same as StridedSliceGrad with the exception that
/// `dy` is the input gradient to be propagated and `shape` is the
/// shape of `StridedSlice`'s `input`.
class StridedSliceGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Return a strided slice from `input`.
/// Note, most python users will want to use the Python `Tensor.__getitem__`
/// or `Variable.__getitem__` rather than this op directly.
/// 
/// The goal of this op is to produce a new tensor with a subset of
/// the elements from the `n` dimensional `input` tensor. The subset is chosen using
/// a sequence of `m` sparse range specifications encoded into the arguments
/// of this function. Note, in some cases
/// `m` could be equal to `n`, but this need not be the case. Each
/// range specification entry can be one of the following:
/// 
/// - An ellipsis (...). Ellipses are used to imply zero or more
///   dimensions of full-dimension selection and are produced using
///   `ellipsis_mask`. For example, `foo[...]` is the identity slice.
/// 
/// - A new axis. This is used to insert a new shape=1 dimension and is
///   produced using `new_axis_mask`. For example, `foo[:, ...]` where
///   `foo` is shape `(3, 4)` produces a `(1, 3, 4)` tensor.
/// 
/// 
/// - A range `begin:end:stride`. This is used to specify how much to choose from
///   a given dimension. `stride` can be any integer but 0.  `begin` is an integer
///   which represents the index of the first value to select while `end` represents
///   the index of the last value to select. The number of values selected in each
///   dimension is `end - begin` if `stride > 0` and `begin - end` if `stride < 0`.
///   `begin` and `end` can be negative where `-1` is the last element, `-2` is
///   the second to last. `begin_mask` controls whether to replace the explicitly
///   given `begin` with an implicit effective value of `0` if `stride > 0` and
///   `-1` if `stride < 0`. `end_mask` is analogous but produces the number
///   required to create the largest open interval. For example, given a shape
///   `(3,)` tensor `foo[:]`, the effective `begin` and `end` are `0` and `3`. Do
///   not assume this is equivalent to `foo[0:-1]` which has an effective `begin`
///   and `end` of `0` and `2`. Another example is `foo[-2::-1]` which reverses the
///   first dimension of a tensor while dropping the last two (in the original
///   order elements). For example `foo = [1,2,3,4]; foo[-2::-1]` is `[4,3]`.
/// 
/// - A single index. This is used to keep only elements that have a given
///   index. For example (`foo[2, :]` on a shape `(5,6)` tensor produces a
///   shape `(6,)` tensor. This is encoded in `begin` and `end` and
///   `shrink_axis_mask`.
/// 
/// Each conceptual range specification is encoded in the op's argument. This
/// encoding is best understand by considering a non-trivial example. In
/// particular,
/// `foo[1, 2:4, None, ..., :-3:-1, :]` will be encoded as
/// 
/// ```
/// begin = [1, 2, x, x, 0, x] # x denotes don't care (usually 0)
/// end = [2, 4, x, x, -3, x]
/// strides = [1, 1, x, x, -1, 1]
/// begin_mask = 1<<4 | 1<<5 = 48
/// end_mask = 1<<5 = 32
/// ellipsis_mask = 1<<3 = 8
/// new_axis_mask = 1<<2 = 4
/// shrink_axis_mask = 1<<0 = 1
/// ```
/// 
/// In this case if `foo.shape` is (5, 5, 5, 5, 5, 5) the final shape of
/// the slice becomes (2, 1, 5, 5, 2, 5).
/// Let us walk step by step through each argument specification.
/// 
/// 1.  The first argument in the example slice is turned into `begin = 1` and
/// `end = begin + 1 = 2`. To disambiguate from the original spec `2:4` we
/// also set the appropriate bit in `shrink_axis_mask`.
/// 
/// 2. `2:4` is contributes 2, 4, 1 to begin, end, and stride. All masks have
/// zero bits contributed.
/// 
/// 3. None is a synonym for `tf.newaxis`. This means insert a dimension of size 1
/// dimension in the final shape. Dummy values are contributed to begin,
/// end and stride, while the new_axis_mask bit is set.
/// 
/// 4. `...` grab the full ranges from as many dimensions as needed to
/// fully specify a slice for every dimension of the input shape.
/// 
/// 5. `:-3:-1` shows the use of negative indices. A negative index `i` associated
/// with a dimension that has shape `s` is converted to a positive index
/// `s + i`. So `-1` becomes `s-1` (i.e. the last element). This conversion
/// is done internally so begin, end and strides receive x, -3, and -1.
/// The appropriate begin_mask bit is set to indicate the start range is the
/// full range (ignoring the x).
/// 
/// 6. `:` indicates that the entire contents of the corresponding dimension
/// is selected. This is equivalent to `::` or `0::1`. begin, end, and strides
/// receive 0, 0, and 1, respectively. The appropriate bits in `begin_mask` and
/// `end_mask` are also set.
/// 
/// *Requirements*:
///   `0 != strides[i] for i in [0, m)`
///   `ellipsis_mask must be a power of two (only one ellipsis)`
class StridedSliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Formats a string template using a list of tensors.
/// Formats a string template using a list of tensors, pretty-printing tensor summaries.
class StringFormatOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Joins the strings in the given list of string tensors into one tensor;
/// with the given separator (default is an empty separator).
/// 
/// Examples:
/// 
/// >>> s = ["hello", "world", "tensorflow"]
/// >>> tf.strings.join(s, " ")
/// <tf.Tensor: shape=(), dtype=string, numpy=b'hello world tensorflow'>
class StringJoinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Strip leading and trailing whitespaces from the Tensor.
/// Examples:
/// 
/// >>> tf.strings.strip(["\nTensorFlow", "     The python library    "]).numpy()
/// array([b'TensorFlow', b'The python library'], dtype=object)
class StringStripOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts each string in the input Tensor to its hash mod by a number of buckets.
/// The hash function is deterministic on the content of the string within the
/// process and will never change. However, it is not suitable for cryptography.
/// This function may be used when CPU time is scarce and inputs are trusted or
/// unimportant. There is a risk of adversaries constructing inputs that all hash
/// to the same bucket. To prevent this problem, use a strong hash function with
/// `tf.string_to_hash_bucket_strong`.
/// 
/// Examples:
/// 
/// >>> tf.strings.to_hash_bucket_fast(["Hello", "TensorFlow", "2.x"], 3).numpy()
/// array([0, 2, 2])
class StringToHashBucketFastOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x - y element-wise.
/// *NOTE*: `Subtract` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class SubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum of elements across dimensions of a tensor.
/// Reduces `input` along the dimensions given in `axis`. Unless
/// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
/// `axis`. If `keep_dims` is true, the reduced dimensions are
/// retained with length 1.
class SumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a handle to be used to access a summary writer.
/// The summary writer is an in-graph resource which can be used by ops to write
/// summaries to event files.
/// 
/// writer: the summary writer resource. Scalar handle.
class SummaryWriterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the singular value decompositions of one or more matrices.
/// Computes the SVD of each inner matrix in `input` such that
/// `input[..., :, :] = u[..., :, :] * diag(s[..., :, :]) * transpose(v[..., :, :])`
/// 
/// ```python
/// # a is a tensor containing a batch of matrices.
/// # s is a tensor of singular values for each matrix.
/// # u is the tensor containing the left singular vectors for each matrix.
/// # v is the tensor containing the right singular vectors for each matrix.
/// s, u, v = svd(a)
/// s, _, _ = svd(a, compute_uv=False)
/// ```
class SvdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient function for function f via backpropagation.
class SymbolicGradientOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder op which takes the output of TPUCopyWithDynamicShapeOp and pass
/// them to the following tpu ops.
/// This op serves as an annotation for the dynamic shaped tensor and will be
/// removed during the bridge rewrite.
class TPUAnnotateTensorsWithDynamicShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the result of a TPU compilation.
/// This operation returns the result of a TPU compilation as a serialized
/// CompilationResultProto, which holds a status and an error message if an error
/// occurred during compilation.
class TPUCompilationResultOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that compiles a computation in MLIR into a TPU program, and loads and executes it on a TPU device.
/// For the internal use of the TPU compiler.
/// 
/// 'static_shapes' are tensors specifying the maximum dimension sizes for the tensors specified in `dynamic_operands`.
/// 'args' are inputs to the TPU computation.
/// 'operands_with_static_shape' are the indices of the operands that have a maximal static shape specified.
/// 'mlir_module' is a serialized MLIR module with a `main` function that contains
/// target computation.
/// 'metadata' is a serialized TPUCompileMetadataProto describing the shapes and
/// types of the inputs to the computation, as well as a mapping onto the TPU pod
/// topology.
/// 'producer_name' is a string describing the name of the framework that add support for running this portion of the model on TPUs.
class TPUCompileMlirAndExecuteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Asserts that compilation succeeded.
/// This op produces no output and closes the device during failure to ensure all
/// pending device interactions fail.
/// 
/// 'compilation_status' is a serialized CompilationResultProto.
class TPUCompileSucceededAssertOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that copies host tensors to device with bounded dynamic shape support.
/// This op copies the padded tensor on cpu to TPU without the padded data. `tensors`
/// is a list of cpu tensors with padded data. `unpadded_sizes` is a list of shape
/// tensors which describes unpadded size of each dimension for each cpu tensor.
/// The size of the `unpadded_sizes` should be the same as `tensors`. They are both
/// on host. `tpu_tensors` are list of tpu device tensors without the padded data.
/// `tpu_tensors` also has the same size of the `tensors` and the shapes of
/// `tpu_tensors` are determined by the `unpadded_sizes`.
class TPUCopyWithDynamicShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that copies host tensor to device with specified layout.
/// For internal use only.
class TPUCopyWithLayoutOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Generates a zero-valued tensor for use as a dummy input to a TPU.
/// For the internal use of the TF2XLA bridge in the XLA Broadcast pass. This op
class TPUDummyInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op enabling differentiation of TPU Embeddings.
/// This op simply returns its first input, which is assumed to have been sliced
/// from the Tensors returned by TPUEmbeddingDequeueActivations. The presence of
/// this op, and its first argument being a trainable Variable, enables automatic
/// differentiation of graphs containing embeddings via the TPU Embedding Python
/// libraries.
class TPUEmbeddingActivationsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that executes a program with optional in-place variable updates.
/// It (optionally) reads device variables, loads and executes a TPU program on a
/// TPU device, and then (optionally) in-place updates variables using the program
/// outputs, as specified in attributes device_var_reads_indices (program input
/// indices from directly reading variables) and device_var_updates_indices (program
/// output indices used to update variables, -1 means no-update/read-only). Such
/// program outputs are consumed by these variables will not appear in the op
/// output. For the internal use of the distributed TPU compiler.
class TPUExecuteAndUpdateVariablesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that loads and executes a TPU program on a TPU device.
/// For the internal use of the distributed TPU compiler.
class TPUExecuteOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that retrieves the layout of an input or output determined by TPUCompile.
/// For internal use only.
class TPUGetLayoutOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A TPU core selector Op.
/// This Op produces a set of TPU cores (for warm-up) or a single TPU core
/// (for regular inference) to execute the TPU program on. The output is
/// consumed by TPUPartitionedCall.
class TPUOrdinalSelectorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Calls a function placed on a specified TPU device.
class TPUPartitionedCallOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that groups a list of partitioned inputs together. This op
class TPUPartitionedInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that groups a list of partitioned inputs together. Supports ND sharding.
class TPUPartitionedInputV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that demultiplexes a tensor to be sharded by XLA to a list of partitioned
/// outputs outside the XLA computation.
class TPUPartitionedOutputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that demultiplexes a tensor to be sharded by XLA to a list of partitioned
/// outputs outside the XLA computation. Supports ND sharding.
class TPUPartitionedOutputV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Metadata indicating how the TPU computation should be replicated.
/// This operation holds the metadata common to operations of a `tpu.replicate()` computation subgraph.
class TPUReplicateMetadataOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Connects N inputs to an N-way replicated TPU computation.
/// This operation holds a replicated input to a `tpu.replicate()` computation subgraph.
/// Each replicated input has the same shape and type alongside the output.
/// 
/// For example:
/// ```
/// %a = "tf.opA"()
/// %b = "tf.opB"()
/// %replicated_input = "tf.TPUReplicatedInput"(%a, %b)
/// %computation = "tf.Computation"(%replicated_input)
/// ```
/// The above computation has a replicated input of two replicas.
class TPUReplicatedInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Connects N outputs from an N-way replicated TPU computation.
/// This operation holds a replicated output from a `tpu.replicate()` computation subgraph.
/// Each replicated output has the same shape and type alongside the input.
/// 
/// For example:
/// ```
/// %computation = "tf.Computation"()
/// %replicated_output:2 = "tf.TPUReplicatedOutput"(%computation)
/// ```
/// The above computation has a replicated output of two replicas.
class TPUReplicatedOutputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Op that reshards on-device TPU variables to specified state.
/// Op that reshards on-device TPU variables to specified state. Internal use only.
/// 
/// The sharding state is represented as the key of the compilation that generated
/// the sharding/unsharding programs along with the main program. new_format_key
/// specifies the desired state, and format_state_var is the current state of the
/// variables.
class TPUReshardVariablesOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Round-robin load balancing on TPU cores.
/// A load balancing op that round-robins among TPU cores.
/// 
/// This op round-robins between the integers in [0, NumTPUCoresVisiblePerHost]. It
/// is useful for interfacing with TensorFlow ops that take as input a TPU core on
/// which to execute computations, such as `TPUPartitionedCall`.
/// 
/// device_ordinal: An integer in [0, NumTPUCoresVisiblePerHost].
class TPURoundRobinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that contains `count` elements from the `input_dataset`.
class TakeDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that stops iteration when predicate` is false.
/// The `predicate` function must return a scalar boolean and accept the
/// following arguments:
/// 
/// * One tensor for each component of an element of `input_dataset`.
/// * One tensor for each value in `other_arguments`.
class TakeWhileDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes tan of x element-wise.
/// Given an input tensor, this function computes tangent of every
///   element in the tensor. Input range is `(-inf, inf)` and
///   output range is `(-inf, inf)`. If input lies outside the boundary, `nan`
///   is returned.
/// 
///   ```python
///   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10000, float("inf")])
///   tf.math.tan(x) ==> [nan 0.45231566 -0.5463025 1.5574077 2.572152 -1.7925274 0.32097113 nan]
///   ```
class TanOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the gradient for the tanh of `x` wrt its input.
/// Specifically, `grad = dy * (1 - y*y)`, where `y = tanh(x)`, and `dy`
/// is the corresponding input gradient.
class TanhGradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes hyperbolic tangent of `x` element-wise.
/// Given an input tensor, this function computes hyperbolic tangent of every
///   element in the tensor. Input range is `[-inf, inf]` and
///   output range is `[-1,1]`.
/// 
///   >>> x = tf.constant([-float("inf"), -5, -0.5, 1, 1.2, 2, 3, float("inf")])
///   >>> tf.math.tanh(x)
///   <tf.Tensor: shape=(8,), dtype=float32, numpy=
///   array([-1.0, -0.99990916, -0.46211717,  0.7615942 ,  0.8336547 ,
///           0.9640276 ,  0.9950547 ,  1.0], dtype=float32)>
class TanhOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Delete the TensorArray from its resource container.
/// This enables the user to close and release the resource in the middle
/// of a step/run.
class TensorArrayCloseV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concat the elements from the TensorArray into value `value`.
/// Takes `T` elements of shapes
/// 
///   ```
///   (n0 x d0 x d1 x ...), (n1 x d0 x d1 x ...), ..., (n(T-1) x d0 x d1 x ...)
///   ```
/// 
/// and concatenates them into a Tensor of shape:
/// 
///   ```
///   (n0 + n1 + ... + n(T-1) x d0 x d1 x ...)
///   ```
/// 
/// All elements must have the same shape (excepting the first dimension).
class TensorArrayConcatV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Gather specific elements from the TensorArray into output `value`.
/// All elements selected by `indices` must have the same shape.
class TensorArrayGatherV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a TensorArray for storing the gradients of values in the given handle.
/// If the given TensorArray gradient already exists, returns a reference to it.
/// 
/// Locks the size of the original TensorArray by disabling its dynamic size flag.
/// 
/// **A note about the input flow_in:**
/// 
/// The handle flow_in forces the execution of the gradient lookup to occur
/// only after certain other operations have occurred.  For example, when
/// the forward TensorArray is dynamically sized, writes to this TensorArray
/// may resize the object.  The gradient TensorArray is statically sized based
/// on the size of the forward TensorArray when this operation executes.
/// Furthermore, the size of the forward TensorArray is frozen by this call.
/// As a result, the flow is used to ensure that the call to generate the gradient
/// TensorArray only happens after all writes are executed.
/// 
/// In the case of dynamically sized TensorArrays, gradient computation should
/// only be performed on read operations that have themselves been chained via
/// flow to occur only after all writes have executed. That way the final size
/// of the forward TensorArray is known when this operation is called.
/// 
/// **A note about the source attribute:**
/// 
/// TensorArray gradient calls use an accumulator TensorArray object.  If
/// multiple gradients are calculated and run in the same session, the multiple
/// gradient nodes may accidentally flow through the same accumulator TensorArray.
/// This double counts and generally breaks the TensorArray gradient flow.
/// 
/// The solution is to identify which gradient call this particular
/// TensorArray gradient is being called in.  This is performed by identifying
/// a unique string (e.g. "gradients", "gradients_1", ...) from the input
/// gradient Tensor's name.  This string is used as a suffix when creating
/// the TensorArray gradient object here (the attribute `source`).
/// 
/// The attribute `source` is added as a suffix to the forward TensorArray's
/// name when performing the creation / lookup, so that each separate gradient
/// calculation gets its own TensorArray accumulator.
class TensorArrayGradV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Read an element from the TensorArray into output `value`.
class TensorArrayReadV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatter the data from the input value into specific TensorArray elements.
/// `indices` must be a vector, its length must match the first dim of `value`.
class TensorArrayScatterV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Get the current size of the TensorArray.
class TensorArraySizeV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Split the data from the input value into TensorArray elements.
/// Assuming that `lengths` takes on values
/// 
///   ```
///   (n0, n1, ..., n(T-1))
///   ```
/// 
/// and that `value` has shape
/// 
///   ```
///   (n0 + n1 + ... + n(T-1) x d0 x d1 x ...),
///   ```
/// 
/// this splits values into a TensorArray with T tensors.
/// 
/// TensorArray index t will be the subtensor of values with starting position
/// 
///   ```
///   (n0 + n1 + ... + n(t-1), 0, 0, ...)
///   ```
/// 
/// and having size
/// 
///   ```
///   nt x d0 x d1 x ...
///   ```
class TensorArraySplitV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An array of Tensors of given size.
/// Write data via Write and read via Read or Pack.
class TensorArrayV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Push an element onto the tensor_array.
class TensorArrayWriteV3Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concats all tensors in the list along the 0th dimension.
/// Requires that all tensors have the same shape except the first dimension.
/// 
/// input_handle: The input list.
/// element_shape: The shape of the uninitialized elements in the list. If the first
///   dimension is not -1, it is assumed that all list elements have the same
///   leading dim.
/// leading_dims: The list of leading dims of uninitialized list elements. Used if
///   the leading dim of input_handle.element_shape or the element_shape input arg
///   is not already set.
/// tensor: The concated result.
/// lengths: Output tensor containing sizes of the 0th dimension of tensors in the list, used for computing the gradient.
class TensorListConcatV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// The shape of the elements of the given list, as a tensor.
/// input_handle: the list
///   element_shape: the shape of elements of the list
class TensorListElementShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a TensorList which, when stacked, has the value of `tensor`.
/// Each tensor in the result list corresponds to one row of the input tensor.
/// 
/// tensor: The input tensor.
/// output_handle: The list.
class TensorListFromTensorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a Tensor by indexing into the TensorList.
/// Each row in the produced Tensor corresponds to the element in the TensorList
/// specified by the given index (see `tf.gather`).
/// 
/// input_handle: The input tensor list.
/// indices: The indices used to index into the list.
/// values: The tensor.
class TensorListGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class TensorListGetItemOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the number of tensors in the input tensor list.
/// input_handle: the input list
/// length: the number of tensors in the list
class TensorListLengthOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the last element of the input list as well as a list with all but that element.
/// Fails if the list is empty.
/// 
/// input_handle: the input list
/// tensor: the withdrawn last element of the list
/// element_dtype: the type of elements in the list
/// element_shape: the shape of the output tensor
class TensorListPopBackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a list which has the passed-in `Tensor` as last element and the other elements of the given list in `input_handle`.
/// tensor: The tensor to put on the list.
/// input_handle: The old list.
/// output_handle: A list with the elements of the old list followed by tensor.
/// element_dtype: the type of elements in the list.
/// element_shape: a shape compatible with that of elements in the list.
class TensorListPushBackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// List of the given size with empty elements.
/// element_shape: the shape of the future elements of the list
/// num_elements: the number of elements to reserve
/// handle: the output list
/// element_dtype: the desired type of elements in the list.
class TensorListReserveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Resizes the list.
/// input_handle: the input list
/// size: size of the output list
class TensorListResizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatters tensor at indices in an input list.
/// Each member of the TensorList corresponds to one row of the input tensor,
/// specified by the given index (see `tf.gather`).
/// 
/// input_handle: The list to scatter into.
/// tensor: The input tensor.
/// indices: The indices used to index into the list.
/// output_handle: The TensorList.
class TensorListScatterIntoExistingListOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class TensorListSetItemOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Stacks all tensors in the list.
/// Requires that all tensors have the same shape.
/// 
/// input_handle: the input list
/// tensor: the gathered result
/// num_elements: optional. If not -1, the number of elements in the list.
class TensorListStackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Adds sparse `updates` to an existing tensor according to `indices`.
/// This operation creates a new tensor by adding sparse `updates` to the passed
/// in `tensor`.
/// This operation is very similar to `tf.compat.v1.scatter_nd_add`, except that the
/// updates are added onto an existing tensor (as opposed to a variable). If the
/// memory for the existing tensor cannot be re-used, a copy is made and updated.
/// 
/// `indices` is an integer tensor containing indices into a new tensor of shape
/// `tensor.shape`.  The last dimension of `indices` can be at most the rank of
/// `tensor.shape`:
/// 
/// ```
/// indices.shape[-1] <= tensor.shape.rank
/// ```
/// 
/// The last dimension of `indices` corresponds to indices into elements
/// (if `indices.shape[-1] = tensor.shape.rank`) or slices
/// (if `indices.shape[-1] < tensor.shape.rank`) along dimension
/// `indices.shape[-1]` of `tensor.shape`.  `updates` is a tensor with shape
/// 
/// ```
/// indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
/// ```
/// 
/// The simplest form of `tensor_scatter_nd_add` is to add individual elements to a
/// tensor by index. For example, say we want to add 4 elements in a rank-1
/// tensor with 8 elements.
/// 
/// In Python, this scatter add operation would look like this:
/// 
/// >>> indices = tf.constant([[4], [3], [1], [7]])
/// >>> updates = tf.constant([9, 10, 11, 12])
/// >>> tensor = tf.ones([8], dtype=tf.int32)
/// >>> updated = tf.tensor_scatter_nd_add(tensor, indices, updates)
/// >>> updated
/// <tf.Tensor: shape=(8,), dtype=int32,
/// numpy=array([ 1, 12,  1, 11, 10,  1,  1, 13], dtype=int32)>
/// 
/// We can also, insert entire slices of a higher rank tensor all at once. For
/// example, if we wanted to insert two slices in the first dimension of a
/// rank-3 tensor with two matrices of new values.
/// 
/// In Python, this scatter add operation would look like this:
/// 
/// >>> indices = tf.constant([[0], [2]])
/// >>> updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
/// ...                         [7, 7, 7, 7], [8, 8, 8, 8]],
/// ...                        [[5, 5, 5, 5], [6, 6, 6, 6],
/// ...                         [7, 7, 7, 7], [8, 8, 8, 8]]])
/// >>> tensor = tf.ones([4, 4, 4],dtype=tf.int32)
/// >>> updated = tf.tensor_scatter_nd_add(tensor, indices, updates)
/// >>> updated
/// <tf.Tensor: shape=(4, 4, 4), dtype=int32,
/// numpy=array([[[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
///              [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
///              [[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
///              [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]], dtype=int32)>
/// 
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore the bad indices; supported on both CPU and GPU.
class TensorScatterAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Apply a sparse update to a tensor taking the element-wise maximum.
/// Returns a new tensor copied from `tensor` whose values are element-wise maximum between
/// tensor and updates according to the indices.
/// 
/// >>> tensor = [0, 0, 0, 0, 0, 0, 0, 0]
/// >>> indices = [[1], [4], [5]]
/// >>> updates = [1, -1, 1]
/// >>> tf.tensor_scatter_nd_max(tensor, indices, updates).numpy()
/// array([0, 1, 0, 0, 0, 1, 0, 0], dtype=int32)
/// 
/// Refer to `tf.tensor_scatter_nd_update` for more details.
class TensorScatterMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class TensorScatterMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Subtracts sparse `updates` from an existing tensor according to `indices`.
/// This operation creates a new tensor by subtracting sparse `updates` from the
/// passed in `tensor`.
/// This operation is very similar to `tf.scatter_nd_sub`, except that the updates
/// are subtracted from an existing tensor (as opposed to a variable). If the memory
/// for the existing tensor cannot be re-used, a copy is made and updated.
/// 
/// `indices` is an integer tensor containing indices into a new tensor of shape
/// `shape`.  The last dimension of `indices` can be at most the rank of `shape`:
/// 
///     indices.shape[-1] <= shape.rank
/// 
/// The last dimension of `indices` corresponds to indices into elements
/// (if `indices.shape[-1] = shape.rank`) or slices
/// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
/// `shape`.  `updates` is a tensor with shape
/// 
///     indices.shape[:-1] + shape[indices.shape[-1]:]
/// 
/// The simplest form of tensor_scatter_sub is to subtract individual elements
/// from a tensor by index. For example, say we want to insert 4 scattered elements
/// in a rank-1 tensor with 8 elements.
/// 
/// In Python, this scatter subtract operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[4], [3], [1], [7]])
///     updates = tf.constant([9, 10, 11, 12])
///     tensor = tf.ones([8], dtype=tf.int32)
///     updated = tf.tensor_scatter_nd_sub(tensor, indices, updates)
///     print(updated)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [1, -10, 1, -9, -8, 1, 1, -11]
/// 
/// We can also, insert entire slices of a higher rank tensor all at once. For
/// example, if we wanted to insert two slices in the first dimension of a
/// rank-3 tensor with two matrices of new values.
/// 
/// In Python, this scatter add operation would look like this:
/// 
/// ```python
///     indices = tf.constant([[0], [2]])
///     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]],
///                            [[5, 5, 5, 5], [6, 6, 6, 6],
///                             [7, 7, 7, 7], [8, 8, 8, 8]]])
///     tensor = tf.ones([4, 4, 4],dtype=tf.int32)
///     updated = tf.tensor_scatter_nd_sub(tensor, indices, updates)
///     print(updated)
/// ```
/// 
/// The resulting tensor would look like this:
/// 
///     [[[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
///      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
///      [[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
///      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
/// 
/// Note that on CPU, if an out of bound index is found, an error is returned.
/// On GPU, if an out of bound index is found, the index is ignored.
class TensorScatterSubOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Scatter `updates` into an existing tensor according to `indices`.
/// This operation creates a new tensor by applying sparse `updates` to the passed
/// in `tensor`.
/// This operation is very similar to `tf.scatter_nd`, except that the updates are
/// scattered onto an existing tensor (as opposed to a zero-tensor). If the memory
/// for the existing tensor cannot be re-used, a copy is made and updated.
/// 
/// If `indices` contains duplicates, then we pick the last update for the index.
/// 
/// **WARNING**: There are some GPU specific semantics for this operation.
/// - If an out of bound index is found, the index is ignored.
/// - The order in which updates are applied is nondeterministic, so the output
/// will be nondeterministic if `indices` contains duplicates.
/// 
/// `indices` is an integer tensor containing indices into a new tensor of shape
/// `shape`.
/// 
/// * `indices` must have at least 2 axes: `(num_updates, index_depth)`.
/// * The last axis of `indices` is how deep to index into `tensor` so  this index
///   depth must be less than the rank of `tensor`: `indices.shape[-1] <= tensor.ndim`
/// 
/// if `indices.shape[-1] = tensor.rank` this Op indexes and updates scalar elements.
/// if `indices.shape[-1] < tensor.rank` it indexes and updates slices of the input
/// `tensor`.
/// 
/// Each `update` has a rank of `tensor.rank - indices.shape[-1]`.
/// The overall shape of `updates` is:
/// 
/// ```
/// indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
/// ```
/// 
/// If `indices` contains any out-of-bound indices, depending on
/// `bad_indices_policy`, the op will either return an error or ignore the
/// out-of-bound indices. `bad_indices_policy` can be one of the following values:
/// 1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
///    historically on CPU and GPU we handle errors in different ways, and for
///    backward compatibility we keep the default behavior.
/// 2. "ERROR": raises error; GPU does not support this value.
/// 3. "IGNORE": ignore the bad indices; supported on both CPU and GPU.
/// 
/// For usage examples see the python [tf.tensor_scatter_nd_update](
/// https://www.tensorflow.org/api_docs/python/tf/tensor_scatter_nd_update) function
class TensorScatterUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a dataset that emits each dim-0 slice of `components` once.
class TensorSliceDatasetOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Assign `value` to the sliced l-value reference of `input`.
/// The values of `value` are assigned to the positions in the tensor `input` that
/// are selected by the slice parameters. The slice parameters `begin` `end`
/// `strides` etc. work exactly as in `StridedSlice`.
/// 
/// NOTE this op currently does not support broadcasting and so `value`'s shape
/// must be exactly the shape produced by the slice of `input`.
class TensorStridedSliceUpdateOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Constructs a tensor by tiling a given tensor.
/// This operation creates a new tensor by replicating `input` `multiples` times.
/// The output tensor's i'th dimension has `input.dims(i) * multiples[i]` elements,
/// and the values of `input` are replicated `multiples[i]` times along the 'i'th
/// dimension. For example, tiling `[a b c d]` by `[2]` produces
/// `[a b c d a b c d]`.
/// 
/// >>> a = tf.constant([[1,2,3],[4,5,6]], tf.int32)
/// >>> b = tf.constant([1,2], tf.int32)
/// >>> tf.tile(a, b)
/// <tf.Tensor: shape=(2, 6), dtype=int32, numpy=
/// array([[1, 2, 3, 1, 2, 3],
///        [4, 5, 6, 4, 5, 6]], dtype=int32)>
/// >>> c = tf.constant([2,1], tf.int32)
/// >>> tf.tile(a, c)
/// <tf.Tensor: shape=(4, 3), dtype=int32, numpy=
/// array([[1, 2, 3],
///        [4, 5, 6],
///        [1, 2, 3],
///        [4, 5, 6]], dtype=int32)>
/// >>> d = tf.constant([2,2], tf.int32)
/// >>> tf.tile(a, d)
/// <tf.Tensor: shape=(4, 6), dtype=int32, numpy=
/// array([[1, 2, 3, 1, 2, 3],
///        [4, 5, 6, 4, 5, 6],
///        [1, 2, 3, 1, 2, 3],
///        [4, 5, 6, 4, 5, 6]], dtype=int32)>
class TileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Provides the time since epoch in seconds.
/// Returns the timestamp as a `float64` for seconds since the Unix epoch.
/// 
/// Common usages include:
/// * Logging
/// * Providing a random number seed
/// * Debugging graph execution
/// * Generating timing information, mainly through comparison of timestamps
/// 
/// Note: In graph mode, the timestamp is computed when the op is executed,
/// not when it is added to the graph.  In eager mode, the timestamp is computed
/// when the op is eagerly executed.
class TimestampOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts a tensor to a scalar predicate.
/// Converts a tensor to a scalar predicate with the following rules:
/// 
/// - For 0D tensors, truthiness is determined by comparing against a "zero"
///   value. For numerical types it is the obvious zero. For strings it is the
///   empty string.
/// 
/// - For >0D tensors, truthiness is determined by looking at the number of
///   elements. If has zero elements, then the result is false. Otherwise the
///   result is true.
/// 
/// This matches the behavior of If and While for determining if a tensor counts
/// as true/false for a branch condition.
class ToBoolOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the TopK unique values in the array in sorted order.
/// The running time is proportional to the product of K and the input
/// size. Sorting the whole array is more efficient for sufficiently large
/// values of K. The median-of-medians algorithm is probably faster, but
/// difficult to implement efficiently in XLA. If there are fewer than K
/// unique numbers (not NANs), the results are padded with negative
/// infinity. NaNs are never returned. Subnormal numbers are flushed to
/// zero. If an element appears at multiple indices, the highest index is
/// returned. If a TopK element never appears in the input due to padding
/// values, the indices are padded with negative one. If a padding value
/// appears in the input and padding is needed, the highest index of the
/// padding value will be returned. The semantics are not the same as
/// kth_order_statistic.
class TopKUniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Finds values and indices of the `k` largest elements for the last dimension.
/// If the input is a vector (rank-1), finds the `k` largest entries in the vector
/// and outputs their values and indices as vectors.  Thus `values[j]` is the
/// `j`-th largest entry in `input`, and its index is `indices[j]`.
/// 
/// For matrices (resp. higher rank input), computes the top `k` entries in each
/// row (resp. vector along the last dimension).  Thus,
/// 
///     values.shape = indices.shape = input.shape[:-1] + [k]
/// 
/// If two elements are equal, the lower-index element appears first.
class TopKV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the TopK values in the array in sorted order.
/// This is a combination of MakeUnique and TopKUnique. The returned top-K will
/// have its lower bits replaced by iota, thus it will be close to the original
/// value but not exactly the same. The running time is proportional to the product
/// of K and the input size. NaNs are never returned. Subnormal numbers are flushed
/// to zero.
class TopKWithUniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Shuffle dimensions of x according to a permutation.
/// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
///   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
class TransposeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Calculate product with tridiagonal matrix.
/// Calculates product of two matrices, where left matrix is a tridiagonal matrix.
class TridiagonalMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Solves tridiagonal systems of equations.
/// Solves tridiagonal systems of equations.
///   Supports batch dimensions and multiple right-hand sides per each left-hand
///   side.
///   On CPU, solution is computed via Gaussian elimination with or without partial
///   pivoting, depending on `partial_pivoting` attribute. On GPU, Nvidia's cuSPARSE
///   library is used: https://docs.nvidia.com/cuda/cusparse/index.html#gtsv
///   Partial pivoting is not yet supported by XLA backends.
class TridiagonalSolveOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns x / y element-wise, rounded towards zero.
/// Truncation designates that negative numbers will round fractional quantities
/// toward zero. I.e. -7 / 5 = -1. This matches C semantics but it is different
/// than Python semantics. See `FloorDiv` for a division function that matches
/// Python Semantics.
/// 
/// *NOTE*: `TruncateDiv` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class TruncateDivOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns element-wise remainder of division. This emulates C semantics in that
/// the result here is consistent with a truncating divide. E.g. `truncate(x / y) *
/// y + truncate_mod(x, y) = x`.
/// 
/// *NOTE*: `TruncateMod` supports broadcasting. More about broadcasting
/// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
class TruncateModOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs random values from a truncated normal distribution.
/// The generated values follow a normal distribution with mean 0 and standard
/// deviation 1, except that values whose magnitude is more than 2 standard
/// deviations from the mean are dropped and re-picked.
class TruncatedNormalOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Uncompresses a compressed dataset element.
class UncompressElementOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform dequantization on the quantized Tensor `input`.
/// Given quantized `input` which was quantized using `scales` and `zero_points`, performs dequantization using the formula:
/// dequantized_data = (quantized_data - zero_point) * scale.
class UniformDequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantization on Tensor `input`.
/// Given `input`, `scales` and `zero_points`, performs quantization using the formula:
/// quantized_data = floor(input_data * (1.0f / scale) + 0.5f) + zero_point
class UniformQuantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantized add of quantized Tensor `lhs` and quantized Tensor `rhs` to make quantized `output`.
/// Given quantized `lhs` and quantized `rhs`, performs quantized add on `lhs` and `rhs` to make quantized `output`.
/// 
/// `UniformQuantizedAdd` follows Numpy broadcasting rules.
/// The two input array shapes are compared element-wise.
/// Starting with the trailing dimensions, the two dimensions either have to be equal or one of them needs to be 1.
/// 
/// `lhs` and `rhs` must be quantized Tensor, where data value is quantized using the formula:
/// ```
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val)
/// ```
/// `output` is also quantized, using the same formula.
/// 
/// If `lhs` and `output` is both per-axis quantized, the quantization axis must match.
/// Also, if `rhs` and `output` is both per-axis quantized, the quantization axis must match.
/// *Match* means the axis must match when adding, regarding the broadcasting.
/// i.e. For both operands `lhs` and `rhs`,
/// if `operand.quantization_axis` >= 0 and `output.quantization_axis` >= 0,
/// `operand.dims` - `operand.quantization_axis` must be equal to `output.dims` - `output.quantization_axis`.
class UniformQuantizedAddOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform clip by value on the quantized Tensor `operand`.
/// Given quantized `operand` which was quantized using `scales` and `zero_points`, performs clip by value using `min` and `max` values.
/// If quantization_axis is -1 (per-tensor quantized), the entire operand is clipped using scalar min, max.
/// Otherwise (per-channel quantized), the clipping is also done per-channel.
class UniformQuantizedClipByValueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform hybrid quantized convolution of float Tensor `lhs` and quantized Tensor `rhs`.
/// Given float `lhs` and quantized `rhs`, internally performs quantization on `lhs`,
/// and then performs quantized convolution on quantized `lhs` and `rhs`.
/// 
/// The internal quantization on `lhs` is a quantization to `Trhs`, dynamic range,
/// per-batch (per-axis along axis `dimension_numbers.input_batch_dimension`), asymmetric,
/// and not narrow range (the range is [Trhs_MIN, Trhs_MAX]).
/// 
/// `lhs` and `rhs` must be Tensors of same rank, and meet following shape conditions.
/// - lhs_feature % feature_group_count == 0
/// - lhs_feature % rhs_input_feature == 0
/// - lhs_feature / feature_group_count == rhs_input_feature
/// - rhs_output_feature % feature_group_count == 0
/// - lhs_batch % batch_group_count == 0
/// - rhs_output_feature % batch_group_count == 0
/// 
/// `rhs` must be quantized Tensor, where its data value is quantized using the formula:
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val).
class UniformQuantizedConvolutionHybridOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantized convolution of quantized Tensor `lhs` and quantized Tensor `rhs`. to make quantized `output`.
/// Given quantized `lhs` and quantized `rhs`, performs quantized dot on `lhs` and `rhs` to make quantized `output`.
/// 
/// `lhs` and `rhs` must be Tensors of same rank, and meet following shape conditions.
/// - `lhs_feature` % `feature_group_count` == 0
/// - `lhs_feature` % `rhs_input_feature` == 0
/// - `lhs_feature` / `feature_group_count` == `rhs_input_feature`
/// - `rhs_output_feature` % `feature_group_count` == 0
/// - `lhs_batch` % `batch_group_count` == 0
/// - `rhs_output_feature` % `batch_group_count` == 0
/// 
/// `lhs` and `rhs` must be quantized Tensor, where data value is quantized using the formula:
/// ```
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val)
/// ```
/// `output` is also quantized, using the same formula.
/// If `rhs` is per-tensor quantized, `output` must be also per-tensor quantized.
class UniformQuantizedConvolutionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform hybrid quantized dot of float Tensor `lhs` and quantized Tensor `rhs`.
/// Given float `lhs` and quantized `rhs`, internally performs quantization on `lhs`, and then performs quantized dot on quantized lhs and `rhs`.
/// The internal quantization on `lhs` is a quantization to qint8, dynamic range, per-batch (per-axis along axis 0), asymmetric, and not narrow range (the range is [-128, 127]).
/// `lhs` and `rhs` must be 2D Tensors and the lhs.dim_size(1) must match rhs.dim_size(0).
/// `rhs` must be quantized Tensor, where its data value is quantized using the formula:
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val).
class UniformQuantizedDotHybridOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Perform quantized dot of quantized Tensor `lhs` and quantized Tensor `rhs` to make quantized `output`.
/// Given quantized `lhs` and quantized `rhs`, performs quantized dot on `lhs` and `rhs` to make quantized `output`.
/// `lhs` and `rhs` must be 2D Tensors and the lhs.dim_size(1) must match rhs.dim_size(0).
/// `lhs` and `rhs` must be quantized Tensor, where data value is quantized using the formula:
/// quantized_data = clip(original_data / scale + zero_point, quantization_min_val, quantization_max_val).
/// `output` is also quantized, using the same formula.
/// If `rhs` is per-tensor quantized, `output` must be also per-tensor quantized.
class UniformQuantizedDotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Given quantized tensor `input`, requantize it with new quantization parameters.
/// Given quantized tensor `input`, which was quantized using {input_scales, input_zero_points, input_quantization_axis, input_quantization_min_val, input_quantization_max_val},
/// requantize it to a tensor, which is quantized using {output_scales, output_zero_points, output_quantization_axis, output_quantization_min_val, output_quantization_max_val}.
/// The requantization is done by using the formula:
/// output_quantized_data = clip(
///   (input_quantized_data - input_zero_point) * (input_scale / output_scale) + output_zero_point,
///   output_quantization_min_val,
///   output_quantization_max_val)
/// 
/// Per-tensor and per-axis quantization supported cases are followings:
/// * per-tensor -> per-tensor
/// * per-tensor -> per-axis
/// * per-axis -> per-axis where input_quantization_axis equals output_quantization_axis.
/// i.e. At least one among input_quantization_axis and output_quantization_axis must be -1, or two must be equal.
class UniformRequantizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Finds unique elements in a 1-D tensor.
/// This operation returns a tensor `y` containing all of the unique elements of `x`
/// sorted in the same order that they occur in `x`; `x` does not need to be sorted.
/// This operation also returns a tensor `idx` the same size as `x` that contains
/// the index of each value of `x` in the unique output `y`. In other words:
/// 
/// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
/// 
/// Examples:
/// 
/// ```
/// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
/// y, idx = unique(x)
/// y ==> [1, 2, 4, 7, 8]
/// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
/// ```
/// 
/// ```
/// # tensor 'x' is [4, 5, 1, 2, 3, 3, 4, 5]
/// y, idx = unique(x)
/// y ==> [4, 5, 1, 2, 3]
/// idx ==> [0, 1, 2, 3, 4, 4, 0, 1]
/// ```
class UniqueOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Finds unique elements along an axis of a tensor.
/// This operation either returns a tensor `y` containing unique elements
/// along the `axis` of a tensor. The returned unique elements is sorted
/// in the same order as they occur along `axis` in `x`.
/// This operation also returns a tensor `idx` that is the same size as
/// the number of the elements in `x` along the `axis` dimension. It
/// contains the index in the unique output `y`.
/// In other words, for an `1-D` tensor `x` with `axis = None:
/// 
/// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
/// 
/// For example:
/// 
/// ```
/// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
/// y, idx = unique(x)
/// y ==> [1, 2, 4, 7, 8]
/// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
/// ```
/// 
/// For an `2-D` tensor `x` with `axis = 0`:
/// 
/// ```
/// # tensor 'x' is [[1, 0, 0],
/// #                [1, 0, 0],
/// #                [2, 0, 0]]
/// y, idx = unique(x, axis=0)
/// y ==> [[1, 0, 0],
///        [2, 0, 0]]
/// idx ==> [0, 0, 1]
/// ```
/// 
/// For an `2-D` tensor `x` with `axis = 1`:
/// 
/// ```
/// # tensor 'x' is [[1, 0, 0],
/// #                [1, 0, 0],
/// #                [2, 0, 0]]
/// y, idx = unique(x, axis=1)
/// y ==> [[1, 0],
///        [1, 0],
///        [2, 0]]
/// idx ==> [0, 1, 1]
/// ```
class UniqueV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Unpacks a given dimension of a rank-`R` tensor into `num` rank-`(R-1)` tensors.
/// Unpacks `num` tensors from `value` by chipping it along the `axis` dimension.
/// For example, given a tensor of shape `(A, B, C, D)`;
/// 
/// If `axis == 0` then the i'th tensor in `output` is the slice `value[i, :, :, :]`
///   and each tensor in `output` will have shape `(B, C, D)`. (Note that the
///   dimension unpacked along is gone, unlike `split`).
/// 
/// If `axis == 1` then the i'th tensor in `output` is the slice `value[:, i, :, :]`
///   and each tensor in `output` will have shape `(A, C, D)`.
/// Etc.
/// 
/// This is the opposite of `pack`.
class UnpackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the maximum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// This operator is similar to `tf.math.unsorted_segment_sum`,
/// Instead of computing the sum over segments, it computes the maximum such that:
/// 
/// \\(output_i = \max_{j...} data[j...]\\) where max is over tuples `j...` such
/// that `segment_ids[j...] == i`.
/// 
/// If the maximum is empty for a given segment ID `i`, it outputs the smallest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::lowest()`.
/// 
/// If the given segment ID `i` is negative, then the corresponding value is
/// dropped, and will not be included in the result.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentMax.png" alt>
/// </div>
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
/// >>> tf.math.unsorted_segment_max(c, tf.constant([0, 1, 0]), num_segments=2).numpy()
/// array([[4, 3, 3, 4],
///        [5,  6, 7, 8]], dtype=int32)
class UnsortedSegmentMaxOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the minimum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// This operator is similar to `tf.math.unsorted_segment_sum`,
/// Instead of computing the sum over segments, it computes the minimum such that:
/// 
/// \\(output_i = \min_{j...} data_[j...]\\) where min is over tuples `j...` such
/// that `segment_ids[j...] == i`.
/// 
/// If the minimum is empty for a given segment ID `i`, it outputs the largest
/// possible value for the specific numeric type,
/// `output[i] = numeric_limits<T>::max()`.
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
/// >>> tf.math.unsorted_segment_min(c, tf.constant([0, 1, 0]), num_segments=2).numpy()
/// array([[1, 2, 2, 1],
///        [5, 6, 7, 8]], dtype=int32)
/// 
/// If the given segment ID `i` is negative, then the corresponding value is
/// dropped, and will not be included in the result.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
class UnsortedSegmentMinOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the product along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// This operator is similar to `tf.math.unsorted_segment_sum`,
/// Instead of computing the sum over segments, it computes the product of all
/// entries belonging to a segment such that:
/// 
/// \\(output_i = \prod_{j...} data[j...]\\) where the product is over tuples
/// `j...` such that `segment_ids[j...] == i`.
/// 
/// For example:
/// 
/// >>> c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
/// >>> tf.math.unsorted_segment_prod(c, tf.constant([0, 1, 0]), num_segments=2).numpy()
/// array([[4, 6, 6, 4],
///        [5, 6, 7, 8]], dtype=int32)
/// 
/// If there is no entry for a given segment ID `i`, it outputs 1.
/// 
/// If the given segment ID `i` is negative, then the corresponding value is
/// dropped, and will not be included in the result.
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
class UnsortedSegmentProdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the sum along segments of a tensor.
/// Read
/// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
/// for an explanation of segments.
/// 
/// Computes a tensor such that
/// \\(output[i] = \sum_{j...} data[j...]\\) where the sum is over tuples `j...` such
/// that `segment_ids[j...] == i`.  Unlike `SegmentSum`, `segment_ids`
/// need not be sorted and need not cover all values in the full
/// range of valid values.
/// 
/// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
/// If the given segment ID `i` is negative, the value is dropped and will not be
/// added to the sum of the segment.
/// 
/// `num_segments` should equal the number of distinct segment IDs.
/// 
/// Caution: On CPU, values in `segment_ids` are always validated to be less than
/// `num_segments`, and an error is thrown for out-of-bound indices. On GPU, this
/// does not throw an error for out-of-bound indices. On Gpu, out-of-bound indices
/// result in safe but unspecified behavior, which may include ignoring
/// out-of-bound indices or outputting a tensor with a 0 stored in the first
/// dimension of its shape if `num_segments` is 0.
/// 
/// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
/// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentSum.png" alt>
/// </div>
/// 
/// >>> c = [[1,2,3,4], [5,6,7,8], [4,3,2,1]]
/// >>> tf.math.unsorted_segment_sum(c, [0, 1, 0], num_segments=2).numpy()
/// array([[5, 5, 5, 5],
///        [5, 6, 7, 8]], dtype=int32)
class UnsortedSegmentSumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Applies upper_bound(sorted_search_values, values) along each row.
/// Each set of rows with the same index in (sorted_inputs, values) is treated
/// independently.  The resulting row is the equivalent of calling
/// `np.searchsorted(sorted_inputs, values, side='right')`.
/// 
/// The result is not a global index to the entire
/// `Tensor`, but rather just the index in the last dimension.
/// 
/// A 2-D example:
///   sorted_sequence = [[0, 3, 9, 9, 10],
///                      [1, 2, 3, 4, 5]]
///   values = [[2, 4, 9],
///             [0, 2, 6]]
/// 
///   result = UpperBound(sorted_sequence, values)
/// 
///   result == [[1, 2, 4],
///              [0, 2, 5]]
class UpperBoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Creates a handle to a Variable resource from its name.
/// container: the container this variable is placed in.
/// shared_name: the name by which this variable is referred to.
/// dtype and shape: attributes representing the data type and shape held in the
///   variable.
/// 
/// Example:
///     resource_variable_ops.var_handle_op(
///           dtype=dtypes.int32, shape=[8, 16], container="foo", shared_name="bar")
///   returns a handle for a variable with name "bar" in container "foo", and the
///   variable holds a tensor of shape [8, 16] and dtype int32.
class VarHandleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Checks whether a resource handle-based variable has been initialized.
class VarIsInitializedOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Use VariableV2 instead.
class VariableOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns the shape of the variable pointed to by `resource`.
/// This operation returns a 1-D integer tensor representing the shape of `input`.
/// 
/// For example:
/// 
/// ```
/// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
/// shape(t) ==> [2, 2, 3]
/// ```
class VariableShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Holds state in the form of a tensor that persists across steps.
/// Outputs a ref to the tensor state so it may be read or modified.
/// TODO(zhifengc/mrry): Adds a pointer to a more detail document
/// about sharing states in tensorflow.
class VariableV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns locations of nonzero / true values in a tensor.
/// This operation returns the coordinates of true elements in `condition`. The
/// coordinates are returned in a 2-D tensor where the first dimension (rows)
/// represents the number of true elements, and the second dimension (columns)
/// represents the coordinates of the true elements. Keep in mind, the shape of
/// the output tensor can vary depending on how many true values there are in
/// `condition`. Indices are output in row-major order.
/// 
/// For example:
/// 
/// ```
/// # 'input' tensor is [[True, False]
/// #                    [True, False]]
/// # 'input' has two true values, so output has two coordinates.
/// # 'input' has rank of 2, so coordinates have two indices.
/// where(input) ==> [[0, 0],
///                   [1, 0]]
/// 
/// # `condition` tensor is [[[True, False]
/// #                     [True, False]]
/// #                    [[False, True]
/// #                     [False, True]]
/// #                    [[False, False]
/// #                     [False, True]]]
/// # 'input' has 5 true values, so output has 5 coordinates.
/// # 'input' has rank of 3, so coordinates have three indices.
/// where(input) ==> [[0, 0, 0],
///                   [0, 1, 0],
///                   [1, 0, 1],
///                   [1, 1, 1],
///                   [2, 1, 1]]
/// 
/// # `condition` tensor is [[[1.5,  0.0]
/// #                     [-0.5, 0.0]]
/// #                    [[0.0,  0.25]
/// #                     [0.0,  0.75]]
/// #                    [[0.0,  0.0]
/// #                     [0.0,  0.01]]]
/// # 'input' has 5 nonzero values, so output has 5 coordinates.
/// # 'input' has rank of 3, so coordinates have three indices.
/// where(input) ==> [[0, 0, 0],
///                   [0, 1, 0],
///                   [1, 0, 1],
///                   [1, 1, 1],
///                   [2, 1, 1]]
/// 
/// # `condition` tensor is [[[1.5 + 0.0j, 0.0  + 0.0j]
/// #                     [0.0 + 0.5j, 0.0  + 0.0j]]
/// #                    [[0.0 + 0.0j, 0.25 + 1.5j]
/// #                     [0.0 + 0.0j, 0.75 + 0.0j]]
/// #                    [[0.0 + 0.0j, 0.0  + 0.0j]
/// #                     [0.0 + 0.0j, 0.01 + 0.0j]]]
/// # 'input' has 5 nonzero magnitude values, so output has 5 coordinates.
/// # 'input' has rank of 3, so coordinates have three indices.
/// where(input) ==> [[0, 0, 0],
///                   [0, 1, 0],
///                   [1, 0, 1],
///                   [1, 1, 1],
///                   [2, 1, 1]]
/// ```
class WhereOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// output = input; While (Cond(output)) { output = Body(output) }
/// output = input; While (Cond(output)) { output = Body(output) }
/// 
/// input: A list of input tensors whose types are T.
/// output: A list of output tensors whose types are T.
/// cond: A function that takes 'input' and returns a tensor.  If the tensor is
///     a scalar of non-boolean, the scalar is converted to a boolean
///     according to the following rule: if the scalar is a numerical
///     value, non-zero means True and zero means False; if the scalar is
///     a string, non-empty means True and empty means False. If the
///     tensor is not a scalar, non-emptiness means True and False
///     otherwise.
/// body: A function that takes a list of tensors and returns another
///       list of tensors. Both lists have the same types as specified
///       by T.
class WhileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// while operation
/// The tf.WhileRegion op represents a while loop using 2 regions and a set of
///   iteration variables. The iteration variables maintained by this Op have the
///   same types as the inputs. The Op executes a while loop described by the
///   following pseudo code:
/// 
///   ```
///      func WhileRegionOp(inputs) {
///        iteration_vars = inputs;
///        while (cond(iteration_vars)) {
///            iteration_vars = body(iteration_vars);
///        }
///        return iteration_vars;
///      }
///   ```
/// 
///   `cond` is the condition region and `body` is the body region. Both these
///   regions accept the current value of the iteration variables as inputs.
/// 
///   The condition region yields a tensor<i1> which, if false, will exit the loop.
///   It can also, optionally and additionally, yield the iteration variables, which
///   must be unchanged.
/// 
///   The body region always has to yield the (possibly updated) iteration variables.
/// 
///   The iteration variables are initialized to the Op input, and the results of the
///   tf.WhileRegion op are the final values of the iteration variables.
/// 
///   This implies that the operand and result types for tf.WhileRegion should be
///   the same. Note that the condition and body regions can implicitly capture
///   loop invariant values directly. In canonical form, iteration variables that
///   pass through the loop body unmodified are converted to implicitly captured
///   references to their values outside the loop.
class WhileRegionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with audio.
/// The summary has up to `max_outputs` summary values containing audio. The
/// audio is built from `tensor` which must be 3-D with shape `[batch_size,
/// frames, channels]` or 2-D with shape `[batch_size, frames]`. The values are
/// assumed to be in the range of `[-1.0, 1.0]` with a sample rate of `sample_rate`.
/// 
/// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
/// build the `tag` of the summary values:
/// 
/// *  If `max_outputs` is 1, the summary value tag is '*tag*/audio'.
/// *  If `max_outputs` is greater than 1, the summary value tags are
///    generated sequentially as '*tag*/audio/0', '*tag*/audio/1', etc.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Scalar. Used to build the `tag` attribute of the summary values.
/// tensor: 2-D of shape `[batch_size, frames]`.
/// sample_rate: The sample rate of the signal in hertz.
/// max_outputs: Max number of batch elements to generate audio for.
class WriteAudioSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `GraphDef` protocol buffer to a `SummaryWriter`.
/// writer: Handle of `SummaryWriter`.
/// step: The step to write the summary for.
/// tensor: A scalar string of the serialized tf.GraphDef proto.
class WriteGraphSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a histogram summary.
/// The generated
/// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
/// has one summary value containing a histogram for `values`.
/// 
/// This op reports an `InvalidArgument` error if any value is not finite.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Scalar.  Tag to use for the `Summary.Value`.
/// values: Any shape. Values to use to build the histogram.
class WriteHistogramSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with images.
/// The summary has up to `max_images` summary values containing images. The
/// images are built from `tensor` which must be 4-D with shape `[batch_size,
/// height, width, channels]` and where `channels` can be:
/// 
/// *  1: `tensor` is interpreted as Grayscale.
/// *  3: `tensor` is interpreted as RGB.
/// *  4: `tensor` is interpreted as RGBA.
/// 
/// The images have the same number of channels as the input tensor. For float
/// input, the values are normalized one image at a time to fit in the range
/// `[0, 255]`.  `uint8` values are unchanged.  The op uses two different
/// normalization algorithms:
/// 
/// *  If the input values are all positive, they are rescaled so the largest one
///    is 255.
/// 
/// *  If any input value is negative, the values are shifted so input value 0.0
///    is at 127.  They are then rescaled so that either the smallest value is 0,
///    or the largest one is 255.
/// 
/// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
/// build the `tag` of the summary values:
/// 
/// *  If `max_images` is 1, the summary value tag is '*tag*/image'.
/// *  If `max_images` is greater than 1, the summary value tags are
///    generated sequentially as '*tag*/image/0', '*tag*/image/1', etc.
/// 
/// The `bad_color` argument is the color to use in the generated images for
/// non-finite input values.  It is a `unit8` 1-D tensor of length `channels`.
/// Each element must be in the range `[0, 255]` (It represents the value of a
/// pixel in the output image).  Non-finite values in the input tensor are
/// replaced by this tensor in the output image.  The default value is the color
/// red.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Scalar. Used to build the `tag` attribute of the summary values.
/// tensor: 4-D of shape `[batch_size, height, width, channels]` where
///   `channels` is 1, 3, or 4.
/// max_images: Max number of batch elements to generate images for.
/// bad_color: Color to use for pixels with non-finite values.
class WriteImageSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with serialized string `Summary` protocol buffers.
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tensor: A tensor holding one or more serialized `Summary` protobufs to write.
class WriteRawProtoSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes a `Summary` protocol buffer with scalar values.
/// The input `tag` and `value` must have the scalars.
/// 
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tag: Tag for the summary.
/// value: Value for the summary.
class WriteScalarSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Outputs a `Summary` protocol buffer with a tensor.
/// writer: A handle to a summary writer.
/// step: The step to write the summary for.
/// tensor: A tensor to serialize.
/// tag: The summary's tag.
/// summary_metadata: Serialized SummaryMetadata protocol buffer containing
///  plugin-related metadata for this summary.
class WriteSummaryOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Writes the given predictions into a RecordIO file using a previously
/// initialized global TrainingPredictionWriter. The predictions are transformed
/// into a PredictionData proto before they are written to the file.
class WriteTrainingPredictionsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if x == 0, and x / y otherwise, elementwise.
class XdivyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA AllReduce operator
/// documented at https://www.tensorflow.org/xla/operation_semantics#allreduce.
class XlaAllReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Helper operator for performing XLA-style broadcasts
/// Broadcasts `lhs` and `rhs` to the same rank, by adding size 1 dimensions to
/// whichever of `lhs` and `rhs` has the lower rank, using XLA's broadcasting rules
/// for binary operators.
class XlaBroadcastHelperOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Invokes a StableHLO module.
/// This op is used with JAX native serialization in a TensorFlow context with
/// stability guarantees.
class XlaCallModuleOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Operator that connects the output of an XLA computation to other consumer graph nodes.
class XlaClusterOutputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Concats input tensor across all dimensions.
/// An op which merges slices the input tensor based on the given num_splits
/// attribute, strips paddings optionally, and returns the merged tensor without
/// paddings.
/// 
/// This op may be generated via the TPU bridge.
/// 
/// For example, with `input` tensor:
/// ```
/// [[0, 1],
///  [4, 5]]
/// [[2, 3],
///  [6, 7]]
/// [[8, 9],
///  [12, 13]]
/// [[10, 11],
///  [14, 15]]
/// ```
/// `num_splits`:
/// ```
/// [2, 2]
/// ```
/// and `paddings`:
/// ```
/// [1, 1]
/// ```
/// the expected `outputs` is:
/// ```
/// [[0, 1, 2],
///  [4, 5, 6],
///  [8, 9, 10]]
/// ```
class XlaConcatNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ConvGeneralDilated operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
/// .
class XlaConvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ConvGeneralDilated operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
/// .
class XlaConvV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Emits an HLO `CustomCall` operation with multiple outputs.
/// As opposed to `XlaCustomCall`, this operation supports multiple outputs.
/// 
/// See `CustomCall` specification at
///   https://tensorflow.org/xla/operation_semantics#customcall,
/// and `mhlo.custom_call` specification at
///   https://tensorflow.org/mlir/hlo_ops#mhlocustom_call_mlirmhlocustomcallop.
class XlaCustomCallV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DotGeneral operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dotgeneral
/// .
class XlaDotOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DotGeneral operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dotgeneral
/// .
class XlaDotV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DynamicSlice operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dynamicslice
/// .
/// 
/// DynamicSlice extracts a sub-array from the input array at dynamic
/// start_indices. The size of the slice in each dimension is passed in
/// size_indices, which specify the end point of exclusive slice intervals in each
/// dimension -- [start, start + size). The shape of start_indices must have rank 1,
/// with dimension size equal to the rank of operand.
class XlaDynamicSliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA DynamicUpdateSlice operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#dynamicupdateslice
/// .
/// 
/// XlaDynamicUpdateSlice generates a result which is the value of the `input`
/// operand, with a slice update overwritten at `indices`. The shape of `update`
/// determines the shape of the sub-array of the result which is updated. The shape
/// of indices must be rank == 1, with dimension size equal to the rank of `input`.
/// 
/// Handling of out-of-bounds slice indices is implementation-defined.
class XlaDynamicUpdateSliceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which supports basic einsum op with 2 inputs and 1 output.
/// This op has better TPU performance since it doesn't have explicitly reshape and
/// transpose operations as tf.einsum does.
class XlaEinsumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Gather operator documented at
/// https://www.tensorflow.org/xla/operation_semantics#gather
class XlaGatherOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A pseudo-op to represent host-side computation in an XLA program.
class XlaHostComputeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Sort operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#sort
/// .
/// 
/// Sorts a tensor. Currently only sorts in ascending order are supported.
class XlaKeyValueSortOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XLA Launch Op. For use by the XLA JIT only.
class XlaLaunchOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XLA Launch Op. For use by the XLA JIT only.
class XlaLaunchV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA OptimizationBarrier operator.
/// Documented at https://www.tensorflow.org/xla/operation_semantics#optimizationbarrier.
class XlaOptimizationBarrierOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Pad operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#pad
/// .
class XlaPadOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op to receive a tensor from the host.
/// output: the tensor that will be received from the host.
/// Toutput: element type for output.
/// shape: shape for output.
/// key: A unique identifier for this region used to match up host transfers.
class XlaRecvFromHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives the named tensor from another XLA computation. Wraps the XLA Recv
/// operator documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#recv .
class XlaRecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that receives embedding activations on the TPU.
/// The TPU system performs the embedding lookups and aggregations. The results of
/// these aggregations are visible to the Tensorflow Graph as the outputs of a
/// XlaRecvTPUEmbeddingActivations Op. This op returns a list containing one
/// Tensor of activations per table specified in the model.
class XlaRecvTPUEmbeddingActivationsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives deduplication data (indices and weights) from the embedding core.
/// The deduplication data is a Tensor with type=DT_VARIANT. The tensor itself is an
/// XLA nested tuple containing N elements (where N is the ratio of the number of
/// embedding to tensor cores per TPU chip). Each element of the nested tuple is a
/// tuple of rank 1 tensors. Each tensor either contains indices (DT_UINT32) for
/// embedding lookup on the TensorCore or weights (DT_FLOAT) to apply to the output
/// of the embedding lookup operation.
class XlaRecvTPUEmbeddingDeduplicationDataOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Reduce operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#reduce .
class XlaReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ReducePrecision operator
/// documented at https://www.tensorflow.org/xla/operation_semantics#reduceprecision.
class XlaReducePrecisionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ReduceScatter operator
/// documented at https://www.tensorflow.org/xla/operation_semantics#reducescatter.
class XlaReduceScatterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA ReduceWindow operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#reducewindow .
class XlaReduceWindowOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Inverse of XlaSetDynamicDimensionSize.
/// Make an xla bounded dynamic dimension into a static dimension. The bound of the
/// size of dimension `dim_index` becomes the static dimension size.
class XlaRemoveDynamicDimensionSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Replica ID.
class XlaReplicaIdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Stateless PRNG bit generator.
/// Wraps the XLA RngBitGenerator operator, documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#rngbitgenerator.
class XlaRngBitGeneratorOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Scatter operator documented at
/// https://www.tensorflow.org/xla/operation_semantics#scatter.
class XlaScatterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA SelectAndScatter operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#selectandscatter
/// .
class XlaSelectAndScatterOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the eigen decomposition of a batch of self-adjoint matrices
/// (Note: Only real inputs are supported).
/// 
/// Computes the eigenvalues and eigenvectors of the innermost N-by-N matrices in
/// tensor such that tensor[...,:,:] * v[..., :,i] = e[..., i] * v[...,:,i], for
/// i=0...N-1.
class XlaSelfAdjointEigOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sends the named tensor to another XLA computation. Wraps the XLA Send operator
/// documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#send .
class XlaSendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op that performs gradient updates of embedding tables.
/// The gradients argument is a TensorList having the same length and shapes as the
/// return value of XlaRecvTPUEmbeddingActivations, but contains gradients of the
/// model's loss with respect to the embedding activations. The embedding tables are
/// updated from these gradients via the optimizer specified in the
/// TPUEmbeddingConfiguration proto given to tpu.initialize_system.
class XlaSendTPUEmbeddingGradientsOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op to send a tensor to the host.
/// input: the tensor that will be sent to the host.
/// Tinput: element type for input.
/// key: A unique identifier for this region used to match up host transfers.
class XlaSendToHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Set a bound for the given input value as a hint to Xla compiler,
/// returns the same value.
class XlaSetBoundOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Make a static dimension into a xla bounded dynamic dimension.
/// The current static dimension size will become the bound and the second
///         operand becomes the dynamic size of the dimension.
class XlaSetDynamicDimensionSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op which shards the input based on the given sharding attribute.
/// 
/// Since TF runtime still relies on V1 sharding but the compiler requires V2
/// Sharding to support the new partitioner Shardy, when the op can reach both the
/// compiler and the runtime, we record V1 sharding attribute in _XlaSharding and V2
/// sharding attribute in _XlaShardingV2, and verify that they are equivalent when
/// they both exist and _XlaShardingV2 is used.
class XlaShardingOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Sort operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#sort
/// .
/// 
/// Sorts a tensor. Currently only sorts in ascending order are supported.
class XlaSortOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XlaSparseActivationsUnstackOp attempts to fuse transpose, relayout,
///     conversion, stacking and optionally interleaving of the embedding
///     activations, while also offloading this work to SparseCore.
/// 
///     The op assumes its operand is in SparseCore layout, while also being F32.
///     The output is a tuple of tensors in TensorCore layout, in any data type.
class XlaSparseActivationsUnstackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreAdagradMomentumOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreAdagradOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreAdamOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreFtrlOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseCoreSgdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithAdagradAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithAdagradMomentumAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithAdamAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithFtrlAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op back-propagates the activation gradients to the embedding table and the combiner weights.
class XlaSparseDenseMatmulCustomCombinerOnTcGradWithSgdAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// This op looks up the embedding vectors on SparseCores and performs the given combiner computation on TensorCores.
class XlaSparseDenseMatmulCustomCombinerOnTcWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the custom optimizer per-row update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithSgdAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the SGD optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithSgdAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// aaa
class XlaSparseDenseMatmulWithCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulWithStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XlaSparseGradientsStackOp attempts to fuse transpose, relayout, conversion,
///     unstacking and optionally interleaving of the embedding gradients, while
///     also offloading this work to SparseCore.
/// 
///     The op assumes its operands are in TensoreCore layout and in any data type.
///     The output is in SparseCore layout and is expected to be F32.
class XlaSparseGradientsStackOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Splits input tensor across all dimensions.
/// An op which slices the input tensor based on the given num_splits attribute,
/// pads slices optionally, and returned the slices. Slices are returned in
/// row-major order.
/// 
/// This op may be generated via the TPU bridge.
/// 
/// For example, with `input` tensor:
/// ```
/// [[0, 1, 2],
///  [3, 4, 5],
///  [6, 7, 8]]
/// ```
/// `num_splits`:
/// ```
/// [2, 2]
/// ```
/// and `paddings`:
/// ```
/// [1, 1]
/// ```
/// the expected `outputs` is:
/// ```
/// [[0, 1],
///  [3, 4]]
/// [[2, 0],
///  [5, 0]]
/// [[6, 7],
///  [0, 0]]
/// [[8, 0],
///  [0, 0]]
/// ```
class XlaSplitNDOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op used by XLA SPMD partitioner to switch from automatic partitioning to
/// manual partitioning. It annotates the input (full-shape, to be automatically
/// partitioned) with the same sharding used by manual partitioning, and outputs a
/// shard-shaped tensor to be consumed by later manually-partitioned ops. If the
/// shape is not evenly partitionable, the padding region will be masked with 0s.
/// The conversion can happen partially in subgroups, by specifying the dim
/// attribute, where only that dim will be converted.
class XlaSpmdFullToShardShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// An op used by XLA SPMD partitioner to switch from manual partitioning to
/// automatic partitioning. It converts the shard-shaped, manually partitioned input
/// into full-shaped tensor to be partitioned automatically with the same sharding
/// used by manual partitioning. The conversion can happen partially in subgroups,
/// by specifying the dim attribute, where only that dim will be converted.
class XlaSpmdShardToFullShapeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Computes the eigen decomposition of a batch of self-adjoint matrices
/// (Note: Only real inputs are supported).
/// 
/// Computes the eigenvalues and eigenvectors of the innermost M-by-N matrices in
/// tensor such that tensor[...,:,:] = u[..., :, :] * Diag(s[..., :]) * Transpose(v[...,:,:]).
class XlaSvdOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the variadic XLA Reduce operator.
/// Semantics are documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#variadic_reduce.
/// 
/// This version is limited to operands of the same dtype.
/// XlaVariadicReduceV2 is a version that supports heterogeneous operands.
class XlaVariadicReduceOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the variadic XLA Reduce operator.
/// Semantics are documented at
///  https://www.tensorflow.org/performance/xla/operation_semantics#variadic_reduce.
/// 
/// This is an expanded version of XlaVariadicReduce, with support for
/// operands of different dtypes, and improved shape inference.
class XlaVariadicReduceV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Wraps the XLA Sort operator, documented at
/// https://www.tensorflow.org/performance/xla/operation_semantics#sort
/// .
/// 
/// Sorts one or more tensors, with support for custom comparator, dimension, and
/// is_stable attributes.
class XlaVariadicSortOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if x == 0, and x * log1p(y) otherwise, elementwise.
class Xlog1pyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns 0 if x == 0, and x * log(y) otherwise, elementwise.
class XlogyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Yield operation
/// The "yield" operation represents a return operation within the conditional
///     and body of structured control flow (e.g., if and while). The operation
///     takes a variable number of operands and produces no results. The number and
///     types of inputs must match the signature of the operation that contains the
///     region.
class YieldOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Returns a tensor of zeros with the same shape and type as x.
class ZerosLikeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compute the Hurwitz zeta function \\(\zeta(x, q)\\).
/// The Hurwitz zeta function is defined as:
/// 
/// 
/// \\(\zeta(x, q) = \sum_{n=0}^{\infty} (q + n)^{-x}\\)
class ZetaOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts an array of tensors to a list of tensors.
class _ArrayToListOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class _EagerConstOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Internal FusedBatchNorm operation: reserved for internal use.
/// Do not invoke this operator directly in Python. A fusion optimization is
/// expected to create these operators.
class _FusedBatchNormExOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs a convolution followed by a specified series of operations.
/// The inputs to the convolution are `input` and `filter`. The series of operations
/// that follows is specified by the `fused_ops` attribute, which is a list of TF op
/// names specified as strings (e.g. "Relu"). They are performed in order, where the
/// (first) input to each op is the output of the preceding op. The first input and
/// the output of each fused_op must be of type T.
/// 
/// Currently supported fused_op combinations are: [X] and [X,A], where X is one of
/// {"BiasAdd","FusedBatchNorm"} and A is one of {"Elu","Relu","Relu6"}.
/// 
/// * The first input to op X is the Conv2D result, and the additional input(s) to X
/// are specified by `args`.
/// * If there is an op A specified, the output of op X is the input to op A, and op
/// A produces the _FusedConv2D output. Otherwise, op X produces the _FusedConv2D
/// output.
/// 
/// *NOTE*: Do not invoke this operator directly in Python. Grappler is expected to
/// create these operators.
class _FusedConv2DOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Performs a MatMul followed by a specified series of operations.
/// The inputs to the MatMul are specified by `a` and `b`. The series of operations
/// that follows is specified by the `fused_ops` attribute, which is a list of TF op
/// names specified as strings (e.g. "Relu"). They are performed in order, where the
/// (first) input to each op is the output of the preceding op. The first input and
/// the output of each fused_op must be of type T.
/// 
/// Currently supported fused_op combinations are: ["BiasAdd"] and ["BiasAdd",A],
/// where A is one of {"Elu","Relu","Relu6"}.
/// 
/// * The first input to BiasAdd is the MatMul result, and the additional BiasAdd
/// input is specified by `args`.
/// * If there is an op A specified, the output of the BiasAdd is the input to op A,
/// and op A produces the _FusedConv2D output. Otherwise, the BiasAdd produces the
/// _FusedConv2D output.
/// 
/// *NOTE*: Do not invoke this operator directly in Python. Grappler is
/// expected to create these operators.
class _FusedMatMulOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives the named tensor from send_device on recv_device.
/// _HostRecv produces its output on host memory whereas _Recv produces its
/// output on device memory.
class _HostRecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sends the named tensor from send_device to recv_device.
/// _HostSend requires its input on host memory whereas _Send requires its
/// input on device memory.
class _HostSendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Internal op for testing only
class _InternalTestMustExecuteTrait_;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Internal op for testing only
class _InternalTestNonResourceValueSideEffects_;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Converts a list of tensors to an array of tensors.
class _ListToArrayOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Receives the named tensor from send_device on recv_device.
class _RecvOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Sends the named tensor from send_device to recv_device.
class _SendOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Compiles a computations for execution on one or more TPU devices.
/// For the internal use of the distributed TPU compiler.
/// 
/// 'mlir_module' is a serialized MLIR module with a `main` function that contains
/// target computation.
/// 'dynamic_shapes' contains dynamic shapes of arguments whose shapes were not
/// known statically at TPUReplication rewrite time.
/// 'metadata' is a serialized TPUCompileMetadataProto describing the shapes and
/// types of the inputs to the computation, as well as a mapping onto the TPU pod
/// topology.
/// 'program' output is a string key that is passed to the TPUExecute op and used to
/// look up the program in the compilation cache.
class _TPUCompileMlirOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder for a device ordinal that depends on its tf_device.replicate ancestor.
/// This op must have a tf_device.replicate ancestor. The ancestor replica_id and
/// logical_core attribute correspond to a TPU core. This op maps the TPU core to a
/// device_ordinal, where the device ordinal is the index of the core relative to
/// its host.
/// 
/// The replicate_to_island pass removes and flattens tf_device.replicate, so it
/// converts this op to the constant index of the core relative to its host.
class _TPUDeviceOrdinalPlaceholderOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// *NOTE*: Do not invoke this operator directly in Python. Graph rewrite pass is
/// expected to create these operators.
class _UnaryOpsCompositionOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// Placeholder program key (compilation cache key) of a XLA `program`.
/// This op can be used when certain rewrite passes materialize ops that require a
/// program key but the _TPUCompileMlir or _XlaCompile op has not been added yet.
/// Subsequent rewrite passes must replace this op with `program` output.
class _XlaCompileMlirPlaceholderProgramKeyOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XLA Compile Op. For use by the XLA JIT only.
/// Compiles a TensorFlow function into an XLA LocalExecutable and returns a key
/// that _XlaRun can use to look up the LocalExecutable and execute it.
class _XlaCompileOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A pseudo-op to represent host-side computation in an XLA program.
class _XlaHostComputeMlirOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A placeholder op to receive values from a running XLA computation.
class _XlaRecvAtHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A placeholder op to receive values from a running XLA computation with support for a runtime device ordinal.
class _XlaRecvAtHostV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// XLA Run Op. For use by the XLA JIT only.
/// Executes a TensorFlow function previously compiled into a LocalExecutable by an
/// _XlaCompile op.
class _XlaRunOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A placeholder op to send values to a running XLA computation.
class _XlaSendFromHostOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A placeholder op to send values to a running XLA computation with support for a runtime device ordinal.
class _XlaSendFromHostV2Op;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithAdagradAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Adagrad optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithAdagradAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Adagrad momentumoptimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithAdagradMomentumAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithAdamAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Adam optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithAdamAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
class XlaSparseDenseMatmulGradWithFtrlAndCsrInputOp;
} // namespace TF
} // namespace mlir
namespace mlir {
namespace TF {
/// A XLA op which performs the Ftrl optimizer update for the dense-sparse matrix multiplication.
class XlaSparseDenseMatmulGradWithFtrlAndStaticBufferSizeOp;
} // namespace TF
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AbsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AbsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AbsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Abs", odsAttrs.getContext());
  }

  AbsOpGenericAdaptorBase(AbsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AbsOpGenericAdaptor : public detail::AbsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AbsOpGenericAdaptorBase;
public:
  AbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AbsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AbsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AbsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AbsOpGenericAdaptor(RangeT values, const AbsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AbsOp, typename = std::enable_if_t<std::is_same_v<LateInst, AbsOp>>>
  AbsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AbsOpAdaptor : public AbsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AbsOpGenericAdaptor::AbsOpGenericAdaptor;
  AbsOpAdaptor(AbsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AbsOp : public ::mlir::Op<AbsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::IsIdempotent, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AbsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AbsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Abs");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AbsOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AcosOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AcosOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AcosOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Acos", odsAttrs.getContext());
  }

  AcosOpGenericAdaptorBase(AcosOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AcosOpGenericAdaptor : public detail::AcosOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AcosOpGenericAdaptorBase;
public:
  AcosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AcosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AcosOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AcosOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AcosOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AcosOpGenericAdaptor(RangeT values, const AcosOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AcosOp, typename = std::enable_if_t<std::is_same_v<LateInst, AcosOp>>>
  AcosOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AcosOpAdaptor : public AcosOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AcosOpGenericAdaptor::AcosOpGenericAdaptor;
  AcosOpAdaptor(AcosOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AcosOp : public ::mlir::Op<AcosOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AcosOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AcosOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Acos");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AcosOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AcoshOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AcoshOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AcoshOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Acosh", odsAttrs.getContext());
  }

  AcoshOpGenericAdaptorBase(AcoshOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AcoshOpGenericAdaptor : public detail::AcoshOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AcoshOpGenericAdaptorBase;
public:
  AcoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AcoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AcoshOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AcoshOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AcoshOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AcoshOpGenericAdaptor(RangeT values, const AcoshOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AcoshOp, typename = std::enable_if_t<std::is_same_v<LateInst, AcoshOp>>>
  AcoshOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AcoshOpAdaptor : public AcoshOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AcoshOpGenericAdaptor::AcoshOpGenericAdaptor;
  AcoshOpAdaptor(AcoshOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AcoshOp : public ::mlir::Op<AcoshOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AcoshOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AcoshOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Acosh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AcoshOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AddNOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AddNOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddNOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AddN", odsAttrs.getContext());
  }

  AddNOpGenericAdaptorBase(AddNOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AddNOpGenericAdaptor : public detail::AddNOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddNOpGenericAdaptorBase;
public:
  AddNOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddNOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddNOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddNOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddNOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddNOpGenericAdaptor(RangeT values, const AddNOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddNOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddNOp>>>
  AddNOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInputs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddNOpAdaptor : public AddNOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddNOpGenericAdaptor::AddNOpGenericAdaptor;
  AddNOpAdaptor(AddNOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddNOp : public ::mlir::Op<AddNOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsCommutative, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddNOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddNOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("N"), ::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AddN");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInputs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSum() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  size_t getN();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type sum, ::mlir::ValueRange inputs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AddNOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AddOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AddOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Add", odsAttrs.getContext());
  }

  AddOpGenericAdaptorBase(AddOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AddOpGenericAdaptor : public detail::AddOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddOpGenericAdaptorBase;
public:
  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddOpGenericAdaptor(RangeT values, const AddOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddOp>>>
  AddOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddOpAdaptor : public AddOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddOpGenericAdaptor::AddOpGenericAdaptor;
  AddOpAdaptor(AddOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddOp : public ::mlir::Op<AddOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::OpTrait::TF::LayoutAgnostic, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Add");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AddOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AddV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AddV2OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AddV2", odsAttrs.getContext());
  }

  AddV2OpGenericAdaptorBase(AddV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AddV2OpGenericAdaptor : public detail::AddV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddV2OpGenericAdaptorBase;
public:
  AddV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddV2OpGenericAdaptor(RangeT values, const AddV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, AddV2Op>>>
  AddV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddV2OpAdaptor : public AddV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddV2OpGenericAdaptor::AddV2OpGenericAdaptor;
  AddV2OpAdaptor(AddV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddV2Op : public ::mlir::Op<AddV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsCommutative, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::OpTrait::TF::CwiseBinary, ::mlir::OpTrait::TF::LayoutAgnostic, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AddV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AddV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AdjustContrastv2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AdjustContrastv2OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AdjustContrastv2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AdjustContrastv2", odsAttrs.getContext());
  }

  AdjustContrastv2OpGenericAdaptorBase(AdjustContrastv2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AdjustContrastv2OpGenericAdaptor : public detail::AdjustContrastv2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AdjustContrastv2OpGenericAdaptorBase;
public:
  AdjustContrastv2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AdjustContrastv2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AdjustContrastv2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AdjustContrastv2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AdjustContrastv2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AdjustContrastv2OpGenericAdaptor(RangeT values, const AdjustContrastv2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AdjustContrastv2Op, typename = std::enable_if_t<std::is_same_v<LateInst, AdjustContrastv2Op>>>
  AdjustContrastv2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getImages() {
    return (*getODSOperands(0).begin());
  }

  ValueT getContrastFactor() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AdjustContrastv2OpAdaptor : public AdjustContrastv2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using AdjustContrastv2OpGenericAdaptor::AdjustContrastv2OpGenericAdaptor;
  AdjustContrastv2OpAdaptor(AdjustContrastv2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AdjustContrastv2Op : public ::mlir::Op<AdjustContrastv2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AdjustContrastv2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AdjustContrastv2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AdjustContrastv2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getImages() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getContrastFactor() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getImagesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getContrastFactorMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value images, ::mlir::Value contrast_factor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value images, ::mlir::Value contrast_factor);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AdjustContrastv2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AdjustHueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AdjustHueOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AdjustHueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AdjustHue", odsAttrs.getContext());
  }

  AdjustHueOpGenericAdaptorBase(AdjustHueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AdjustHueOpGenericAdaptor : public detail::AdjustHueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AdjustHueOpGenericAdaptorBase;
public:
  AdjustHueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AdjustHueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AdjustHueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AdjustHueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AdjustHueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AdjustHueOpGenericAdaptor(RangeT values, const AdjustHueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AdjustHueOp, typename = std::enable_if_t<std::is_same_v<LateInst, AdjustHueOp>>>
  AdjustHueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getImages() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDelta() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AdjustHueOpAdaptor : public AdjustHueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AdjustHueOpGenericAdaptor::AdjustHueOpGenericAdaptor;
  AdjustHueOpAdaptor(AdjustHueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AdjustHueOp : public ::mlir::Op<AdjustHueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AdjustHueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AdjustHueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AdjustHue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getImages() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDelta() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getImagesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDeltaMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value images, ::mlir::Value delta);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value images, ::mlir::Value delta);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AdjustHueOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AdjustSaturationOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AdjustSaturationOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AdjustSaturationOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AdjustSaturation", odsAttrs.getContext());
  }

  AdjustSaturationOpGenericAdaptorBase(AdjustSaturationOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AdjustSaturationOpGenericAdaptor : public detail::AdjustSaturationOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AdjustSaturationOpGenericAdaptorBase;
public:
  AdjustSaturationOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AdjustSaturationOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AdjustSaturationOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AdjustSaturationOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AdjustSaturationOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AdjustSaturationOpGenericAdaptor(RangeT values, const AdjustSaturationOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AdjustSaturationOp, typename = std::enable_if_t<std::is_same_v<LateInst, AdjustSaturationOp>>>
  AdjustSaturationOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getImages() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AdjustSaturationOpAdaptor : public AdjustSaturationOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AdjustSaturationOpGenericAdaptor::AdjustSaturationOpGenericAdaptor;
  AdjustSaturationOpAdaptor(AdjustSaturationOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AdjustSaturationOp : public ::mlir::Op<AdjustSaturationOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AdjustSaturationOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AdjustSaturationOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AdjustSaturation");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getImages() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getImagesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value images, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value images, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AdjustSaturationOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AllOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllOpGenericAdaptorBase {
public:
  struct Properties {
    using keep_dimsTy = ::mlir::BoolAttr;
    keep_dimsTy keep_dims;

    auto getKeepDims() const {
      auto &propStorage = this->keep_dims;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setKeepDims(const ::mlir::BoolAttr &propValue) {
      this->keep_dims = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.keep_dims == this->keep_dims &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.All", odsAttrs.getContext());
  }

  AllOpGenericAdaptorBase(AllOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getKeepDimsAttr();
  bool getKeepDims();
};
} // namespace detail
template <typename RangeT>
class AllOpGenericAdaptor : public detail::AllOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllOpGenericAdaptorBase;
public:
  AllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AllOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllOpGenericAdaptor(RangeT values, const AllOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllOp>>>
  AllOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getReductionIndices() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllOpAdaptor : public AllOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllOpGenericAdaptor::AllOpGenericAdaptor;
  AllOpAdaptor(AllOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllOp : public ::mlir::Op<AllOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tidx"), ::llvm::StringRef("keep_dims")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getKeepDimsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getKeepDimsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.All");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getReductionIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReductionIndicesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getKeepDimsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().keep_dims);
  }

  bool getKeepDims();
  ::mlir::Type getTidx();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKeepDimsAttr(::mlir::BoolAttr attr) {
    getProperties().keep_dims = attr;
  }

  void setKeepDims(::std::optional<bool> attrValue);
  ::mlir::Attribute removeKeepDimsAttr() {
      auto attr = getProperties().keep_dims;
      getProperties().keep_dims = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/::mlir::BoolAttr keep_dims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/::mlir::BoolAttr keep_dims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/bool keep_dims = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/bool keep_dims = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AllOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AllToAllOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AllToAllOpGenericAdaptorBase {
public:
  struct Properties {
    using concat_dimensionTy = ::mlir::IntegerAttr;
    concat_dimensionTy concat_dimension;

    auto getConcatDimension() const {
      auto &propStorage = this->concat_dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setConcatDimension(const ::mlir::IntegerAttr &propValue) {
      this->concat_dimension = propValue;
    }
    using split_countTy = ::mlir::IntegerAttr;
    split_countTy split_count;

    auto getSplitCount() const {
      auto &propStorage = this->split_count;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSplitCount(const ::mlir::IntegerAttr &propValue) {
      this->split_count = propValue;
    }
    using split_dimensionTy = ::mlir::IntegerAttr;
    split_dimensionTy split_dimension;

    auto getSplitDimension() const {
      auto &propStorage = this->split_dimension;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSplitDimension(const ::mlir::IntegerAttr &propValue) {
      this->split_dimension = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.concat_dimension == this->concat_dimension &&
        rhs.split_count == this->split_count &&
        rhs.split_dimension == this->split_dimension &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllToAllOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AllToAll", odsAttrs.getContext());
  }

  AllToAllOpGenericAdaptorBase(AllToAllOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getConcatDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().concat_dimension);
    return attr;
  }

  uint64_t getConcatDimension();
  ::mlir::IntegerAttr getSplitDimensionAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_dimension);
    return attr;
  }

  uint64_t getSplitDimension();
  ::mlir::IntegerAttr getSplitCountAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_count);
    return attr;
  }

  uint64_t getSplitCount();
};
} // namespace detail
template <typename RangeT>
class AllToAllOpGenericAdaptor : public detail::AllToAllOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllToAllOpGenericAdaptorBase;
public:
  AllToAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllToAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllToAllOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllToAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AllToAllOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllToAllOpGenericAdaptor(RangeT values, const AllToAllOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllToAllOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllToAllOp>>>
  AllToAllOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getGroupAssignment() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllToAllOpAdaptor : public AllToAllOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllToAllOpGenericAdaptor::AllToAllOpGenericAdaptor;
  AllToAllOpAdaptor(AllToAllOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllToAllOp : public ::mlir::Op<AllToAllOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::NoConstantFold, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllToAllOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllToAllOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("concat_dimension"), ::llvm::StringRef("split_count"), ::llvm::StringRef("split_dimension")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getConcatDimensionAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getConcatDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSplitCountAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSplitCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSplitDimensionAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSplitDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AllToAll");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getGroupAssignment() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGroupAssignmentMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getConcatDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().concat_dimension);
  }

  uint64_t getConcatDimension();
  ::mlir::IntegerAttr getSplitDimensionAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_dimension);
  }

  uint64_t getSplitDimension();
  ::mlir::IntegerAttr getSplitCountAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().split_count);
  }

  uint64_t getSplitCount();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setConcatDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().concat_dimension = attr;
  }

  void setConcatDimension(uint64_t attrValue);
  void setSplitDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().split_dimension = attr;
  }

  void setSplitDimension(uint64_t attrValue);
  void setSplitCountAttr(::mlir::IntegerAttr attr) {
    getProperties().split_count = attr;
  }

  void setSplitCount(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value group_assignment, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr split_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value group_assignment, ::mlir::IntegerAttr concat_dimension, ::mlir::IntegerAttr split_dimension, ::mlir::IntegerAttr split_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value group_assignment, uint64_t concat_dimension, uint64_t split_dimension, uint64_t split_count);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value group_assignment, uint64_t concat_dimension, uint64_t split_dimension, uint64_t split_count);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AllToAllOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AngleOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AngleOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AngleOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Angle", odsAttrs.getContext());
  }

  AngleOpGenericAdaptorBase(AngleOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AngleOpGenericAdaptor : public detail::AngleOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AngleOpGenericAdaptorBase;
public:
  AngleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AngleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AngleOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AngleOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AngleOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AngleOpGenericAdaptor(RangeT values, const AngleOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AngleOp, typename = std::enable_if_t<std::is_same_v<LateInst, AngleOp>>>
  AngleOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AngleOpAdaptor : public AngleOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AngleOpGenericAdaptor::AngleOpGenericAdaptor;
  AngleOpAdaptor(AngleOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AngleOp : public ::mlir::Op<AngleOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AngleOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AngleOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tout")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getToutAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getToutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Angle");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTout();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AngleOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousIteratorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousIteratorOpGenericAdaptorBase {
public:
  struct Properties {
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousIteratorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousIterator", odsAttrs.getContext());
  }

  AnonymousIteratorOpGenericAdaptorBase(AnonymousIteratorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
};
} // namespace detail
template <typename RangeT>
class AnonymousIteratorOpGenericAdaptor : public detail::AnonymousIteratorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousIteratorOpGenericAdaptorBase;
public:
  AnonymousIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousIteratorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousIteratorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousIteratorOpGenericAdaptor(RangeT values, const AnonymousIteratorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousIteratorOp, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousIteratorOp>>>
  AnonymousIteratorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousIteratorOpAdaptor : public AnonymousIteratorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousIteratorOpGenericAdaptor::AnonymousIteratorOpGenericAdaptor;
  AnonymousIteratorOpAdaptor(AnonymousIteratorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousIteratorOp : public ::mlir::Op<AnonymousIteratorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousIteratorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousIteratorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousIterator");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousIteratorOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousIteratorV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousIteratorV2OpGenericAdaptorBase {
public:
  struct Properties {
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousIteratorV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousIteratorV2", odsAttrs.getContext());
  }

  AnonymousIteratorV2OpGenericAdaptorBase(AnonymousIteratorV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
};
} // namespace detail
template <typename RangeT>
class AnonymousIteratorV2OpGenericAdaptor : public detail::AnonymousIteratorV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousIteratorV2OpGenericAdaptorBase;
public:
  AnonymousIteratorV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousIteratorV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousIteratorV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousIteratorV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousIteratorV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousIteratorV2OpGenericAdaptor(RangeT values, const AnonymousIteratorV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousIteratorV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousIteratorV2Op>>>
  AnonymousIteratorV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousIteratorV2OpAdaptor : public AnonymousIteratorV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousIteratorV2OpGenericAdaptor::AnonymousIteratorV2OpGenericAdaptor;
  AnonymousIteratorV2OpAdaptor(AnonymousIteratorV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousIteratorV2Op : public ::mlir::Op<AnonymousIteratorV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::OpAsmOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousIteratorV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousIteratorV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousIteratorV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDeleter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Type deleter, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousIteratorV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousIteratorV3Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousIteratorV3OpGenericAdaptorBase {
public:
  struct Properties {
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousIteratorV3OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousIteratorV3", odsAttrs.getContext());
  }

  AnonymousIteratorV3OpGenericAdaptorBase(AnonymousIteratorV3Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
};
} // namespace detail
template <typename RangeT>
class AnonymousIteratorV3OpGenericAdaptor : public detail::AnonymousIteratorV3OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousIteratorV3OpGenericAdaptorBase;
public:
  AnonymousIteratorV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousIteratorV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousIteratorV3OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousIteratorV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousIteratorV3OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousIteratorV3OpGenericAdaptor(RangeT values, const AnonymousIteratorV3OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousIteratorV3Op, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousIteratorV3Op>>>
  AnonymousIteratorV3OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousIteratorV3OpAdaptor : public AnonymousIteratorV3OpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousIteratorV3OpGenericAdaptor::AnonymousIteratorV3OpGenericAdaptor;
  AnonymousIteratorV3OpAdaptor(AnonymousIteratorV3Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousIteratorV3Op : public ::mlir::Op<AnonymousIteratorV3Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousIteratorV3OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousIteratorV3OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousIteratorV3");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousIteratorV3Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousMemoryCacheOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousMemoryCacheOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousMemoryCacheOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousMemoryCache", odsAttrs.getContext());
  }

  AnonymousMemoryCacheOpGenericAdaptorBase(AnonymousMemoryCacheOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AnonymousMemoryCacheOpGenericAdaptor : public detail::AnonymousMemoryCacheOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousMemoryCacheOpGenericAdaptorBase;
public:
  AnonymousMemoryCacheOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousMemoryCacheOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousMemoryCacheOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousMemoryCacheOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousMemoryCacheOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousMemoryCacheOpGenericAdaptor(RangeT values, const AnonymousMemoryCacheOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousMemoryCacheOp, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousMemoryCacheOp>>>
  AnonymousMemoryCacheOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousMemoryCacheOpAdaptor : public AnonymousMemoryCacheOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousMemoryCacheOpGenericAdaptor::AnonymousMemoryCacheOpGenericAdaptor;
  AnonymousMemoryCacheOpAdaptor(AnonymousMemoryCacheOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousMemoryCacheOp : public ::mlir::Op<AnonymousMemoryCacheOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::OpAsmOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousMemoryCacheOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousMemoryCacheOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousMemoryCache");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDeleter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Type deleter);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousMemoryCacheOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousMultiDeviceIteratorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousMultiDeviceIteratorOpGenericAdaptorBase {
public:
  struct Properties {
    using devicesTy = ::mlir::ArrayAttr;
    devicesTy devices;

    auto getDevices() const {
      auto &propStorage = this->devices;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDevices(const ::mlir::ArrayAttr &propValue) {
      this->devices = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.devices == this->devices &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousMultiDeviceIteratorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousMultiDeviceIterator", odsAttrs.getContext());
  }

  AnonymousMultiDeviceIteratorOpGenericAdaptorBase(AnonymousMultiDeviceIteratorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getDevicesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().devices);
    return attr;
  }

  ::mlir::ArrayAttr getDevices();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
};
} // namespace detail
template <typename RangeT>
class AnonymousMultiDeviceIteratorOpGenericAdaptor : public detail::AnonymousMultiDeviceIteratorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousMultiDeviceIteratorOpGenericAdaptorBase;
public:
  AnonymousMultiDeviceIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousMultiDeviceIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousMultiDeviceIteratorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousMultiDeviceIteratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousMultiDeviceIteratorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousMultiDeviceIteratorOpGenericAdaptor(RangeT values, const AnonymousMultiDeviceIteratorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousMultiDeviceIteratorOp, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousMultiDeviceIteratorOp>>>
  AnonymousMultiDeviceIteratorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousMultiDeviceIteratorOpAdaptor : public AnonymousMultiDeviceIteratorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousMultiDeviceIteratorOpGenericAdaptor::AnonymousMultiDeviceIteratorOpGenericAdaptor;
  AnonymousMultiDeviceIteratorOpAdaptor(AnonymousMultiDeviceIteratorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousMultiDeviceIteratorOp : public ::mlir::Op<AnonymousMultiDeviceIteratorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::OpAsmOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousMultiDeviceIteratorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousMultiDeviceIteratorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("devices"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDevicesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDevicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousMultiDeviceIterator");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDeleter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getDevicesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().devices);
  }

  ::mlir::ArrayAttr getDevices();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  void setDevicesAttr(::mlir::ArrayAttr attr) {
    getProperties().devices = attr;
  }

  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Type deleter, ::mlir::ArrayAttr devices, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr devices, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousMultiDeviceIteratorOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousMultiDeviceIteratorV3Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousMultiDeviceIteratorV3OpGenericAdaptorBase {
public:
  struct Properties {
    using devicesTy = ::mlir::ArrayAttr;
    devicesTy devices;

    auto getDevices() const {
      auto &propStorage = this->devices;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDevices(const ::mlir::ArrayAttr &propValue) {
      this->devices = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.devices == this->devices &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousMultiDeviceIteratorV3OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousMultiDeviceIteratorV3", odsAttrs.getContext());
  }

  AnonymousMultiDeviceIteratorV3OpGenericAdaptorBase(AnonymousMultiDeviceIteratorV3Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getDevicesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().devices);
    return attr;
  }

  ::mlir::ArrayAttr getDevices();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
};
} // namespace detail
template <typename RangeT>
class AnonymousMultiDeviceIteratorV3OpGenericAdaptor : public detail::AnonymousMultiDeviceIteratorV3OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousMultiDeviceIteratorV3OpGenericAdaptorBase;
public:
  AnonymousMultiDeviceIteratorV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousMultiDeviceIteratorV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousMultiDeviceIteratorV3OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousMultiDeviceIteratorV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousMultiDeviceIteratorV3OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousMultiDeviceIteratorV3OpGenericAdaptor(RangeT values, const AnonymousMultiDeviceIteratorV3OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousMultiDeviceIteratorV3Op, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousMultiDeviceIteratorV3Op>>>
  AnonymousMultiDeviceIteratorV3OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousMultiDeviceIteratorV3OpAdaptor : public AnonymousMultiDeviceIteratorV3OpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousMultiDeviceIteratorV3OpGenericAdaptor::AnonymousMultiDeviceIteratorV3OpGenericAdaptor;
  AnonymousMultiDeviceIteratorV3OpAdaptor(AnonymousMultiDeviceIteratorV3Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousMultiDeviceIteratorV3Op : public ::mlir::Op<AnonymousMultiDeviceIteratorV3Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousMultiDeviceIteratorV3OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousMultiDeviceIteratorV3OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("devices"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDevicesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDevicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousMultiDeviceIteratorV3");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getDevicesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().devices);
  }

  ::mlir::ArrayAttr getDevices();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  void setDevicesAttr(::mlir::ArrayAttr attr) {
    getProperties().devices = attr;
  }

  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::ArrayAttr devices, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr devices, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousMultiDeviceIteratorV3Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousRandomSeedGeneratorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousRandomSeedGeneratorOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousRandomSeedGeneratorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousRandomSeedGenerator", odsAttrs.getContext());
  }

  AnonymousRandomSeedGeneratorOpGenericAdaptorBase(AnonymousRandomSeedGeneratorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AnonymousRandomSeedGeneratorOpGenericAdaptor : public detail::AnonymousRandomSeedGeneratorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousRandomSeedGeneratorOpGenericAdaptorBase;
public:
  AnonymousRandomSeedGeneratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousRandomSeedGeneratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousRandomSeedGeneratorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousRandomSeedGeneratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousRandomSeedGeneratorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousRandomSeedGeneratorOpGenericAdaptor(RangeT values, const AnonymousRandomSeedGeneratorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousRandomSeedGeneratorOp, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousRandomSeedGeneratorOp>>>
  AnonymousRandomSeedGeneratorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSeed() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed2() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousRandomSeedGeneratorOpAdaptor : public AnonymousRandomSeedGeneratorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousRandomSeedGeneratorOpGenericAdaptor::AnonymousRandomSeedGeneratorOpGenericAdaptor;
  AnonymousRandomSeedGeneratorOpAdaptor(AnonymousRandomSeedGeneratorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousRandomSeedGeneratorOp : public ::mlir::Op<AnonymousRandomSeedGeneratorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::OpAsmOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousRandomSeedGeneratorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousRandomSeedGeneratorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousRandomSeedGenerator");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getSeed2() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeed2Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDeleter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Type deleter, ::mlir::Value seed, ::mlir::Value seed2);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value seed, ::mlir::Value seed2);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousRandomSeedGeneratorOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnonymousSeedGeneratorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnonymousSeedGeneratorOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnonymousSeedGeneratorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AnonymousSeedGenerator", odsAttrs.getContext());
  }

  AnonymousSeedGeneratorOpGenericAdaptorBase(AnonymousSeedGeneratorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AnonymousSeedGeneratorOpGenericAdaptor : public detail::AnonymousSeedGeneratorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnonymousSeedGeneratorOpGenericAdaptorBase;
public:
  AnonymousSeedGeneratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnonymousSeedGeneratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnonymousSeedGeneratorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnonymousSeedGeneratorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnonymousSeedGeneratorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnonymousSeedGeneratorOpGenericAdaptor(RangeT values, const AnonymousSeedGeneratorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnonymousSeedGeneratorOp, typename = std::enable_if_t<std::is_same_v<LateInst, AnonymousSeedGeneratorOp>>>
  AnonymousSeedGeneratorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSeed() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSeed2() {
    return (*getODSOperands(1).begin());
  }

  ValueT getReshuffle() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnonymousSeedGeneratorOpAdaptor : public AnonymousSeedGeneratorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnonymousSeedGeneratorOpGenericAdaptor::AnonymousSeedGeneratorOpGenericAdaptor;
  AnonymousSeedGeneratorOpAdaptor(AnonymousSeedGeneratorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnonymousSeedGeneratorOp : public ::mlir::Op<AnonymousSeedGeneratorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ResourceHandleAllocatorInterface::Trait, ::mlir::OpTrait::TF::UniqueResourceAllocation, ::mlir::OpAsmOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnonymousSeedGeneratorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnonymousSeedGeneratorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AnonymousSeedGenerator");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getSeed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getSeed2() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getReshuffle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSeedMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSeed2Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReshuffleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDeleter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Type deleter, ::mlir::Value seed, ::mlir::Value seed2, ::mlir::Value reshuffle);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value seed, ::mlir::Value seed2, ::mlir::Value reshuffle);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnonymousSeedGeneratorOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AnyOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AnyOpGenericAdaptorBase {
public:
  struct Properties {
    using keep_dimsTy = ::mlir::BoolAttr;
    keep_dimsTy keep_dims;

    auto getKeepDims() const {
      auto &propStorage = this->keep_dims;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setKeepDims(const ::mlir::BoolAttr &propValue) {
      this->keep_dims = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.keep_dims == this->keep_dims &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AnyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Any", odsAttrs.getContext());
  }

  AnyOpGenericAdaptorBase(AnyOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getKeepDimsAttr();
  bool getKeepDims();
};
} // namespace detail
template <typename RangeT>
class AnyOpGenericAdaptor : public detail::AnyOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AnyOpGenericAdaptorBase;
public:
  AnyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AnyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AnyOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AnyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AnyOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AnyOpGenericAdaptor(RangeT values, const AnyOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AnyOp, typename = std::enable_if_t<std::is_same_v<LateInst, AnyOp>>>
  AnyOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getReductionIndices() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AnyOpAdaptor : public AnyOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AnyOpGenericAdaptor::AnyOpGenericAdaptor;
  AnyOpAdaptor(AnyOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AnyOp : public ::mlir::Op<AnyOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AnyOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AnyOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tidx"), ::llvm::StringRef("keep_dims")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getKeepDimsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getKeepDimsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Any");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getReductionIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReductionIndicesMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getKeepDimsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().keep_dims);
  }

  bool getKeepDims();
  ::mlir::Type getTidx();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKeepDimsAttr(::mlir::BoolAttr attr) {
    getProperties().keep_dims = attr;
  }

  void setKeepDims(::std::optional<bool> attrValue);
  ::mlir::Attribute removeKeepDimsAttr() {
      auto attr = getProperties().keep_dims;
      getProperties().keep_dims = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/::mlir::BoolAttr keep_dims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/::mlir::BoolAttr keep_dims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/bool keep_dims = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value reduction_indices, /*optional*/bool keep_dims = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AnyOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ApproxTopKOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ApproxTopKOpGenericAdaptorBase {
public:
  struct Properties {
    using aggregate_to_topkTy = ::mlir::BoolAttr;
    aggregate_to_topkTy aggregate_to_topk;

    auto getAggregateToTopk() const {
      auto &propStorage = this->aggregate_to_topk;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAggregateToTopk(const ::mlir::BoolAttr &propValue) {
      this->aggregate_to_topk = propValue;
    }
    using is_max_kTy = ::mlir::BoolAttr;
    is_max_kTy is_max_k;

    auto getIsMaxK() const {
      auto &propStorage = this->is_max_k;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setIsMaxK(const ::mlir::BoolAttr &propValue) {
      this->is_max_k = propValue;
    }
    using kTy = ::mlir::IntegerAttr;
    kTy k;

    auto getK() const {
      auto &propStorage = this->k;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setK(const ::mlir::IntegerAttr &propValue) {
      this->k = propValue;
    }
    using recall_targetTy = ::mlir::FloatAttr;
    recall_targetTy recall_target;

    auto getRecallTarget() const {
      auto &propStorage = this->recall_target;
      return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(propStorage);
    }
    void setRecallTarget(const ::mlir::FloatAttr &propValue) {
      this->recall_target = propValue;
    }
    using reduction_dimensionTy = ::mlir::IntegerAttr;
    reduction_dimensionTy reduction_dimension;

    auto getReductionDimension() const {
      auto &propStorage = this->reduction_dimension;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setReductionDimension(const ::mlir::IntegerAttr &propValue) {
      this->reduction_dimension = propValue;
    }
    using reduction_input_size_overrideTy = ::mlir::IntegerAttr;
    reduction_input_size_overrideTy reduction_input_size_override;

    auto getReductionInputSizeOverride() const {
      auto &propStorage = this->reduction_input_size_override;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setReductionInputSizeOverride(const ::mlir::IntegerAttr &propValue) {
      this->reduction_input_size_override = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.aggregate_to_topk == this->aggregate_to_topk &&
        rhs.is_max_k == this->is_max_k &&
        rhs.k == this->k &&
        rhs.recall_target == this->recall_target &&
        rhs.reduction_dimension == this->reduction_dimension &&
        rhs.reduction_input_size_override == this->reduction_input_size_override &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ApproxTopKOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ApproxTopK", odsAttrs.getContext());
  }

  ApproxTopKOpGenericAdaptorBase(ApproxTopKOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getKAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
    return attr;
  }

  uint64_t getK();
  ::mlir::IntegerAttr getReductionDimensionAttr();
  uint64_t getReductionDimension();
  ::mlir::FloatAttr getRecallTargetAttr();
  ::llvm::APFloat getRecallTarget();
  ::mlir::BoolAttr getIsMaxKAttr();
  bool getIsMaxK();
  ::mlir::IntegerAttr getReductionInputSizeOverrideAttr();
  uint64_t getReductionInputSizeOverride();
  ::mlir::BoolAttr getAggregateToTopkAttr();
  bool getAggregateToTopk();
};
} // namespace detail
template <typename RangeT>
class ApproxTopKOpGenericAdaptor : public detail::ApproxTopKOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ApproxTopKOpGenericAdaptorBase;
public:
  ApproxTopKOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ApproxTopKOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ApproxTopKOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ApproxTopKOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ApproxTopKOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ApproxTopKOpGenericAdaptor(RangeT values, const ApproxTopKOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ApproxTopKOp, typename = std::enable_if_t<std::is_same_v<LateInst, ApproxTopKOp>>>
  ApproxTopKOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ApproxTopKOpAdaptor : public ApproxTopKOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ApproxTopKOpGenericAdaptor::ApproxTopKOpGenericAdaptor;
  ApproxTopKOpAdaptor(ApproxTopKOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ApproxTopKOp : public ::mlir::Op<ApproxTopKOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ApproxTopKOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ApproxTopKOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("aggregate_to_topk"), ::llvm::StringRef("is_max_k"), ::llvm::StringRef("k"), ::llvm::StringRef("recall_target"), ::llvm::StringRef("reduction_dimension"), ::llvm::StringRef("reduction_input_size_override")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAggregateToTopkAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAggregateToTopkAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getIsMaxKAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getIsMaxKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getKAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRecallTargetAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRecallTargetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getReductionDimensionAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getReductionDimensionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getReductionInputSizeOverrideAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getReductionInputSizeOverrideAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ApproxTopK");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getIndices() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getKAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().k);
  }

  uint64_t getK();
  ::mlir::IntegerAttr getReductionDimensionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().reduction_dimension);
  }

  uint64_t getReductionDimension();
  ::mlir::FloatAttr getRecallTargetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(getProperties().recall_target);
  }

  ::llvm::APFloat getRecallTarget();
  ::mlir::BoolAttr getIsMaxKAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().is_max_k);
  }

  bool getIsMaxK();
  ::mlir::IntegerAttr getReductionInputSizeOverrideAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().reduction_input_size_override);
  }

  uint64_t getReductionInputSizeOverride();
  ::mlir::BoolAttr getAggregateToTopkAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().aggregate_to_topk);
  }

  bool getAggregateToTopk();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKAttr(::mlir::IntegerAttr attr) {
    getProperties().k = attr;
  }

  void setK(uint64_t attrValue);
  void setReductionDimensionAttr(::mlir::IntegerAttr attr) {
    getProperties().reduction_dimension = attr;
  }

  void setReductionDimension(::std::optional<uint64_t> attrValue);
  void setRecallTargetAttr(::mlir::FloatAttr attr) {
    getProperties().recall_target = attr;
  }

  void setRecallTarget(::std::optional<::llvm::APFloat> attrValue);
  void setIsMaxKAttr(::mlir::BoolAttr attr) {
    getProperties().is_max_k = attr;
  }

  void setIsMaxK(::std::optional<bool> attrValue);
  void setReductionInputSizeOverrideAttr(::mlir::IntegerAttr attr) {
    getProperties().reduction_input_size_override = attr;
  }

  void setReductionInputSizeOverride(::std::optional<uint64_t> attrValue);
  void setAggregateToTopkAttr(::mlir::BoolAttr attr) {
    getProperties().aggregate_to_topk = attr;
  }

  void setAggregateToTopk(::std::optional<bool> attrValue);
  ::mlir::Attribute removeReductionDimensionAttr() {
      auto attr = getProperties().reduction_dimension;
      getProperties().reduction_dimension = {};
      return attr;
  }

  ::mlir::Attribute removeRecallTargetAttr() {
      auto attr = getProperties().recall_target;
      getProperties().recall_target = {};
      return attr;
  }

  ::mlir::Attribute removeIsMaxKAttr() {
      auto attr = getProperties().is_max_k;
      getProperties().is_max_k = {};
      return attr;
  }

  ::mlir::Attribute removeReductionInputSizeOverrideAttr() {
      auto attr = getProperties().reduction_input_size_override;
      getProperties().reduction_input_size_override = {};
      return attr;
  }

  ::mlir::Attribute removeAggregateToTopkAttr() {
      auto attr = getProperties().aggregate_to_topk;
      getProperties().aggregate_to_topk = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type values, ::mlir::Type indices, ::mlir::Value input, ::mlir::IntegerAttr k, /*optional*/::mlir::IntegerAttr reduction_dimension, /*optional*/::mlir::FloatAttr recall_target, /*optional*/::mlir::BoolAttr is_max_k = nullptr, /*optional*/::mlir::IntegerAttr reduction_input_size_override = nullptr, /*optional*/::mlir::BoolAttr aggregate_to_topk = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::IntegerAttr k, /*optional*/::mlir::IntegerAttr reduction_dimension, /*optional*/::mlir::FloatAttr recall_target, /*optional*/::mlir::BoolAttr is_max_k = nullptr, /*optional*/::mlir::IntegerAttr reduction_input_size_override = nullptr, /*optional*/::mlir::BoolAttr aggregate_to_topk = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type values, ::mlir::Type indices, ::mlir::Value input, uint64_t k, /*optional*/uint64_t reduction_dimension, /*optional*/::llvm::APFloat recall_target, /*optional*/bool is_max_k = true, /*optional*/uint64_t reduction_input_size_override = -1, /*optional*/bool aggregate_to_topk = true);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, uint64_t k, /*optional*/uint64_t reduction_dimension, /*optional*/::llvm::APFloat recall_target, /*optional*/bool is_max_k = true, /*optional*/uint64_t reduction_input_size_override = -1, /*optional*/bool aggregate_to_topk = true);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ApproxTopKOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ApproximateEqualOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ApproximateEqualOpGenericAdaptorBase {
public:
  struct Properties {
    using toleranceTy = ::mlir::FloatAttr;
    toleranceTy tolerance;

    auto getTolerance() const {
      auto &propStorage = this->tolerance;
      return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(propStorage);
    }
    void setTolerance(const ::mlir::FloatAttr &propValue) {
      this->tolerance = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.tolerance == this->tolerance &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ApproximateEqualOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ApproximateEqual", odsAttrs.getContext());
  }

  ApproximateEqualOpGenericAdaptorBase(ApproximateEqualOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FloatAttr getToleranceAttr();
  ::llvm::APFloat getTolerance();
};
} // namespace detail
template <typename RangeT>
class ApproximateEqualOpGenericAdaptor : public detail::ApproximateEqualOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ApproximateEqualOpGenericAdaptorBase;
public:
  ApproximateEqualOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ApproximateEqualOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ApproximateEqualOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ApproximateEqualOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ApproximateEqualOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ApproximateEqualOpGenericAdaptor(RangeT values, const ApproximateEqualOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ApproximateEqualOp, typename = std::enable_if_t<std::is_same_v<LateInst, ApproximateEqualOp>>>
  ApproximateEqualOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ApproximateEqualOpAdaptor : public ApproximateEqualOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ApproximateEqualOpGenericAdaptor::ApproximateEqualOpGenericAdaptor;
  ApproximateEqualOpAdaptor(ApproximateEqualOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ApproximateEqualOp : public ::mlir::Op<ApproximateEqualOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsCommutative, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ApproximateEqualOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ApproximateEqualOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("tolerance")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getToleranceAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getToleranceAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ApproximateEqual");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FloatAttr getToleranceAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FloatAttr>(getProperties().tolerance);
  }

  ::llvm::APFloat getTolerance();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setToleranceAttr(::mlir::FloatAttr attr) {
    getProperties().tolerance = attr;
  }

  void setTolerance(::std::optional<::llvm::APFloat> attrValue);
  ::mlir::Attribute removeToleranceAttr() {
      auto attr = getProperties().tolerance;
      getProperties().tolerance = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::FloatAttr tolerance);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::FloatAttr tolerance);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value x, ::mlir::Value y, /*optional*/::llvm::APFloat tolerance);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/::llvm::APFloat tolerance);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ApproximateEqualOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ArgMaxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ArgMaxOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArgMaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ArgMax", odsAttrs.getContext());
  }

  ArgMaxOpGenericAdaptorBase(ArgMaxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ArgMaxOpGenericAdaptor : public detail::ArgMaxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArgMaxOpGenericAdaptorBase;
public:
  ArgMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArgMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArgMaxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArgMaxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ArgMaxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArgMaxOpGenericAdaptor(RangeT values, const ArgMaxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArgMaxOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArgMaxOp>>>
  ArgMaxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDimension() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArgMaxOpAdaptor : public ArgMaxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArgMaxOpGenericAdaptor::ArgMaxOpGenericAdaptor;
  ArgMaxOpAdaptor(ArgMaxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArgMaxOp : public ::mlir::Op<ArgMaxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArgMaxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArgMaxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tidx"), ::llvm::StringRef("output_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ArgMax");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDimension() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDimensionMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTidx();
  ::mlir::Type getOutputType();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value dimension);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ArgMaxOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::ArgMinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ArgMinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArgMinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.ArgMin", odsAttrs.getContext());
  }

  ArgMinOpGenericAdaptorBase(ArgMinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ArgMinOpGenericAdaptor : public detail::ArgMinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArgMinOpGenericAdaptorBase;
public:
  ArgMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArgMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArgMinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArgMinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ArgMinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArgMinOpGenericAdaptor(RangeT values, const ArgMinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArgMinOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArgMinOp>>>
  ArgMinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDimension() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArgMinOpAdaptor : public ArgMinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArgMinOpGenericAdaptor::ArgMinOpGenericAdaptor;
  ArgMinOpAdaptor(ArgMinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArgMinOp : public ::mlir::Op<ArgMinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArgMinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArgMinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tidx"), ::llvm::StringRef("output_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.ArgMin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDimension() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDimensionMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTidx();
  ::mlir::Type getOutputType();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value dimension);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value dimension);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::ArgMinOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AsStringOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AsStringOpGenericAdaptorBase {
public:
  struct Properties {
    using fillTy = ::mlir::StringAttr;
    fillTy fill;

    auto getFill() const {
      auto &propStorage = this->fill;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setFill(const ::mlir::StringAttr &propValue) {
      this->fill = propValue;
    }
    using precisionTy = ::mlir::IntegerAttr;
    precisionTy precision;

    auto getPrecision() const {
      auto &propStorage = this->precision;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setPrecision(const ::mlir::IntegerAttr &propValue) {
      this->precision = propValue;
    }
    using scientificTy = ::mlir::BoolAttr;
    scientificTy scientific;

    auto getScientific() const {
      auto &propStorage = this->scientific;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setScientific(const ::mlir::BoolAttr &propValue) {
      this->scientific = propValue;
    }
    using shortestTy = ::mlir::BoolAttr;
    shortestTy shortest;

    auto getShortest() const {
      auto &propStorage = this->shortest;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setShortest(const ::mlir::BoolAttr &propValue) {
      this->shortest = propValue;
    }
    using widthTy = ::mlir::IntegerAttr;
    widthTy width;

    auto getWidth() const {
      auto &propStorage = this->width;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setWidth(const ::mlir::IntegerAttr &propValue) {
      this->width = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fill == this->fill &&
        rhs.precision == this->precision &&
        rhs.scientific == this->scientific &&
        rhs.shortest == this->shortest &&
        rhs.width == this->width &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AsStringOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AsString", odsAttrs.getContext());
  }

  AsStringOpGenericAdaptorBase(AsStringOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getPrecisionAttr();
  uint64_t getPrecision();
  ::mlir::BoolAttr getScientificAttr();
  bool getScientific();
  ::mlir::BoolAttr getShortestAttr();
  bool getShortest();
  ::mlir::IntegerAttr getWidthAttr();
  uint64_t getWidth();
  ::mlir::StringAttr getFillAttr();
  ::llvm::StringRef getFill();
};
} // namespace detail
template <typename RangeT>
class AsStringOpGenericAdaptor : public detail::AsStringOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AsStringOpGenericAdaptorBase;
public:
  AsStringOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AsStringOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AsStringOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AsStringOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AsStringOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AsStringOpGenericAdaptor(RangeT values, const AsStringOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AsStringOp, typename = std::enable_if_t<std::is_same_v<LateInst, AsStringOp>>>
  AsStringOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AsStringOpAdaptor : public AsStringOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AsStringOpGenericAdaptor::AsStringOpGenericAdaptor;
  AsStringOpAdaptor(AsStringOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AsStringOp : public ::mlir::Op<AsStringOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AsStringOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AsStringOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("fill"), ::llvm::StringRef("precision"), ::llvm::StringRef("scientific"), ::llvm::StringRef("shortest"), ::llvm::StringRef("width")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFillAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFillAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPrecisionAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPrecisionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getScientificAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getScientificAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getShortestAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getShortestAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getWidthAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getWidthAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AsString");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getPrecisionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().precision);
  }

  uint64_t getPrecision();
  ::mlir::BoolAttr getScientificAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().scientific);
  }

  bool getScientific();
  ::mlir::BoolAttr getShortestAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().shortest);
  }

  bool getShortest();
  ::mlir::IntegerAttr getWidthAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().width);
  }

  uint64_t getWidth();
  ::mlir::StringAttr getFillAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().fill);
  }

  ::llvm::StringRef getFill();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setPrecisionAttr(::mlir::IntegerAttr attr) {
    getProperties().precision = attr;
  }

  void setPrecision(::std::optional<uint64_t> attrValue);
  void setScientificAttr(::mlir::BoolAttr attr) {
    getProperties().scientific = attr;
  }

  void setScientific(::std::optional<bool> attrValue);
  void setShortestAttr(::mlir::BoolAttr attr) {
    getProperties().shortest = attr;
  }

  void setShortest(::std::optional<bool> attrValue);
  void setWidthAttr(::mlir::IntegerAttr attr) {
    getProperties().width = attr;
  }

  void setWidth(::std::optional<uint64_t> attrValue);
  void setFillAttr(::mlir::StringAttr attr) {
    getProperties().fill = attr;
  }

  void setFill(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removePrecisionAttr() {
      auto attr = getProperties().precision;
      getProperties().precision = {};
      return attr;
  }

  ::mlir::Attribute removeScientificAttr() {
      auto attr = getProperties().scientific;
      getProperties().scientific = {};
      return attr;
  }

  ::mlir::Attribute removeShortestAttr() {
      auto attr = getProperties().shortest;
      getProperties().shortest = {};
      return attr;
  }

  ::mlir::Attribute removeWidthAttr() {
      auto attr = getProperties().width;
      getProperties().width = {};
      return attr;
  }

  ::mlir::Attribute removeFillAttr() {
      auto attr = getProperties().fill;
      getProperties().fill = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, /*optional*/::mlir::IntegerAttr precision, /*optional*/::mlir::BoolAttr scientific = nullptr, /*optional*/::mlir::BoolAttr shortest = nullptr, /*optional*/::mlir::IntegerAttr width = nullptr, /*optional*/::mlir::StringAttr fill = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/::mlir::IntegerAttr precision, /*optional*/::mlir::BoolAttr scientific = nullptr, /*optional*/::mlir::BoolAttr shortest = nullptr, /*optional*/::mlir::IntegerAttr width = nullptr, /*optional*/::mlir::StringAttr fill = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, /*optional*/uint64_t precision = -1, /*optional*/bool scientific = false, /*optional*/bool shortest = false, /*optional*/uint64_t width = -1, /*optional*/::llvm::StringRef fill = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, /*optional*/uint64_t precision = -1, /*optional*/bool scientific = false, /*optional*/bool shortest = false, /*optional*/uint64_t width = -1, /*optional*/::llvm::StringRef fill = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AsStringOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AsinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AsinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AsinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Asin", odsAttrs.getContext());
  }

  AsinOpGenericAdaptorBase(AsinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AsinOpGenericAdaptor : public detail::AsinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AsinOpGenericAdaptorBase;
public:
  AsinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AsinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AsinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AsinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AsinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AsinOpGenericAdaptor(RangeT values, const AsinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AsinOp, typename = std::enable_if_t<std::is_same_v<LateInst, AsinOp>>>
  AsinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AsinOpAdaptor : public AsinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AsinOpGenericAdaptor::AsinOpGenericAdaptor;
  AsinOpAdaptor(AsinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AsinOp : public ::mlir::Op<AsinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AsinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AsinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Asin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AsinOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AsinhOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AsinhOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AsinhOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Asinh", odsAttrs.getContext());
  }

  AsinhOpGenericAdaptorBase(AsinhOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AsinhOpGenericAdaptor : public detail::AsinhOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AsinhOpGenericAdaptorBase;
public:
  AsinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AsinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AsinhOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AsinhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AsinhOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AsinhOpGenericAdaptor(RangeT values, const AsinhOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AsinhOp, typename = std::enable_if_t<std::is_same_v<LateInst, AsinhOp>>>
  AsinhOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AsinhOpAdaptor : public AsinhOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AsinhOpGenericAdaptor::AsinhOpGenericAdaptor;
  AsinhOpAdaptor(AsinhOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AsinhOp : public ::mlir::Op<AsinhOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AsinhOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AsinhOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Asinh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AsinhOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AssertOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AssertOpGenericAdaptorBase {
public:
  struct Properties {
    using summarizeTy = ::mlir::IntegerAttr;
    summarizeTy summarize;

    auto getSummarize() const {
      auto &propStorage = this->summarize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSummarize(const ::mlir::IntegerAttr &propValue) {
      this->summarize = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.summarize == this->summarize &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AssertOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Assert", odsAttrs.getContext());
  }

  AssertOpGenericAdaptorBase(AssertOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSummarizeAttr();
  uint64_t getSummarize();
};
} // namespace detail
template <typename RangeT>
class AssertOpGenericAdaptor : public detail::AssertOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AssertOpGenericAdaptorBase;
public:
  AssertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AssertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AssertOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AssertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AssertOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AssertOpGenericAdaptor(RangeT values, const AssertOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AssertOp, typename = std::enable_if_t<std::is_same_v<LateInst, AssertOp>>>
  AssertOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getCondition() {
    return (*getODSOperands(0).begin());
  }

  RangeT getData() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AssertOpAdaptor : public AssertOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AssertOpGenericAdaptor::AssertOpGenericAdaptor;
  AssertOpAdaptor(AssertOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AssertOp : public ::mlir::Op<AssertOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AssertOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AssertOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("summarize")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSummarizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSummarizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Assert");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getCondition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getData() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getConditionMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDataMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSummarizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().summarize);
  }

  uint64_t getSummarize();
  mlir::OperandElementTypeRange getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setSummarizeAttr(::mlir::IntegerAttr attr) {
    getProperties().summarize = attr;
  }

  void setSummarize(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeSummarizeAttr() {
      auto attr = getProperties().summarize;
      getProperties().summarize = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::mlir::ValueRange data, /*optional*/::mlir::IntegerAttr summarize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange data, /*optional*/::mlir::IntegerAttr summarize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::mlir::ValueRange data, /*optional*/uint64_t summarize = 3);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange data, /*optional*/uint64_t summarize = 3);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AssertOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AssignAddVariableOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AssignAddVariableOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AssignAddVariableOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AssignAddVariableOp", odsAttrs.getContext());
  }

  AssignAddVariableOpGenericAdaptorBase(AssignAddVariableOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AssignAddVariableOpGenericAdaptor : public detail::AssignAddVariableOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AssignAddVariableOpGenericAdaptorBase;
public:
  AssignAddVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AssignAddVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AssignAddVariableOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AssignAddVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AssignAddVariableOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AssignAddVariableOpGenericAdaptor(RangeT values, const AssignAddVariableOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AssignAddVariableOp, typename = std::enable_if_t<std::is_same_v<LateInst, AssignAddVariableOp>>>
  AssignAddVariableOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getResource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AssignAddVariableOpAdaptor : public AssignAddVariableOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AssignAddVariableOpGenericAdaptor::AssignAddVariableOpGenericAdaptor;
  AssignAddVariableOpAdaptor(AssignAddVariableOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AssignAddVariableOp : public ::mlir::Op<AssignAddVariableOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::DerivedAttributeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AssignAddVariableOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AssignAddVariableOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AssignAddVariableOp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getResourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value resource, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value resource, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AssignAddVariableOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AssignOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AssignOpGenericAdaptorBase {
public:
  struct Properties {
    using use_lockingTy = ::mlir::BoolAttr;
    use_lockingTy use_locking;

    auto getUseLocking() const {
      auto &propStorage = this->use_locking;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setUseLocking(const ::mlir::BoolAttr &propValue) {
      this->use_locking = propValue;
    }
    using validate_shapeTy = ::mlir::BoolAttr;
    validate_shapeTy validate_shape;

    auto getValidateShape() const {
      auto &propStorage = this->validate_shape;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setValidateShape(const ::mlir::BoolAttr &propValue) {
      this->validate_shape = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.use_locking == this->use_locking &&
        rhs.validate_shape == this->validate_shape &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AssignOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Assign", odsAttrs.getContext());
  }

  AssignOpGenericAdaptorBase(AssignOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getValidateShapeAttr();
  bool getValidateShape();
  ::mlir::BoolAttr getUseLockingAttr();
  bool getUseLocking();
};
} // namespace detail
template <typename RangeT>
class AssignOpGenericAdaptor : public detail::AssignOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AssignOpGenericAdaptorBase;
public:
  AssignOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AssignOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AssignOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AssignOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AssignOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AssignOpGenericAdaptor(RangeT values, const AssignOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AssignOp, typename = std::enable_if_t<std::is_same_v<LateInst, AssignOp>>>
  AssignOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getRef() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AssignOpAdaptor : public AssignOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AssignOpGenericAdaptor::AssignOpGenericAdaptor;
  AssignOpAdaptor(AssignOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AssignOp : public ::mlir::Op<AssignOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AssignOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AssignOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("use_locking"), ::llvm::StringRef("validate_shape")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getUseLockingAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getUseLockingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getValidateShapeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getValidateShapeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Assign");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getRef() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getRefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutputRef() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getValidateShapeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().validate_shape);
  }

  bool getValidateShape();
  ::mlir::BoolAttr getUseLockingAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().use_locking);
  }

  bool getUseLocking();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setValidateShapeAttr(::mlir::BoolAttr attr) {
    getProperties().validate_shape = attr;
  }

  void setValidateShape(::std::optional<bool> attrValue);
  void setUseLockingAttr(::mlir::BoolAttr attr) {
    getProperties().use_locking = attr;
  }

  void setUseLocking(::std::optional<bool> attrValue);
  ::mlir::Attribute removeValidateShapeAttr() {
      auto attr = getProperties().validate_shape;
      getProperties().validate_shape = {};
      return attr;
  }

  ::mlir::Attribute removeUseLockingAttr() {
      auto attr = getProperties().use_locking;
      getProperties().use_locking = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output_ref, ::mlir::Value ref, ::mlir::Value value, /*optional*/::mlir::BoolAttr validate_shape, /*optional*/::mlir::BoolAttr use_locking = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::Value value, /*optional*/::mlir::BoolAttr validate_shape, /*optional*/::mlir::BoolAttr use_locking = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output_ref, ::mlir::Value ref, ::mlir::Value value, /*optional*/bool validate_shape = true, /*optional*/bool use_locking = true);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::Value value, /*optional*/bool validate_shape = true, /*optional*/bool use_locking = true);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AssignOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AssignSubVariableOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AssignSubVariableOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AssignSubVariableOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AssignSubVariableOp", odsAttrs.getContext());
  }

  AssignSubVariableOpGenericAdaptorBase(AssignSubVariableOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AssignSubVariableOpGenericAdaptor : public detail::AssignSubVariableOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AssignSubVariableOpGenericAdaptorBase;
public:
  AssignSubVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AssignSubVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AssignSubVariableOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AssignSubVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AssignSubVariableOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AssignSubVariableOpGenericAdaptor(RangeT values, const AssignSubVariableOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AssignSubVariableOp, typename = std::enable_if_t<std::is_same_v<LateInst, AssignSubVariableOp>>>
  AssignSubVariableOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getResource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AssignSubVariableOpAdaptor : public AssignSubVariableOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AssignSubVariableOpGenericAdaptor::AssignSubVariableOpGenericAdaptor;
  AssignSubVariableOpAdaptor(AssignSubVariableOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AssignSubVariableOp : public ::mlir::Op<AssignSubVariableOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::DerivedAttributeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AssignSubVariableOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AssignSubVariableOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AssignSubVariableOp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getResourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value resource, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value resource, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AssignSubVariableOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AssignVariableOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AssignVariableOpGenericAdaptorBase {
public:
  struct Properties {
    using validate_shapeTy = ::mlir::BoolAttr;
    validate_shapeTy validate_shape;

    auto getValidateShape() const {
      auto &propStorage = this->validate_shape;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setValidateShape(const ::mlir::BoolAttr &propValue) {
      this->validate_shape = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.validate_shape == this->validate_shape &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AssignVariableOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AssignVariableOp", odsAttrs.getContext());
  }

  AssignVariableOpGenericAdaptorBase(AssignVariableOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getValidateShapeAttr();
  bool getValidateShape();
};
} // namespace detail
template <typename RangeT>
class AssignVariableOpGenericAdaptor : public detail::AssignVariableOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AssignVariableOpGenericAdaptorBase;
public:
  AssignVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AssignVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AssignVariableOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AssignVariableOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AssignVariableOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AssignVariableOpGenericAdaptor(RangeT values, const AssignVariableOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AssignVariableOp, typename = std::enable_if_t<std::is_same_v<LateInst, AssignVariableOp>>>
  AssignVariableOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getResource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AssignVariableOpAdaptor : public AssignVariableOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AssignVariableOpGenericAdaptor::AssignVariableOpGenericAdaptor;
  AssignVariableOpAdaptor(AssignVariableOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AssignVariableOp : public ::mlir::Op<AssignVariableOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AssignVariableOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AssignVariableOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dtype"), ::llvm::StringRef("validate_shape")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDtypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDtypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getValidateShapeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getValidateShapeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AssignVariableOp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getResourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getValidateShapeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().validate_shape);
  }

  bool getValidateShape();
  ::mlir::Type getDtype();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setValidateShapeAttr(::mlir::BoolAttr attr) {
    getProperties().validate_shape = attr;
  }

  void setValidateShape(::std::optional<bool> attrValue);
  ::mlir::Attribute removeValidateShapeAttr() {
      auto attr = getProperties().validate_shape;
      getProperties().validate_shape = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value resource, ::mlir::Value value, /*optional*/::mlir::BoolAttr validate_shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value resource, ::mlir::Value value, /*optional*/::mlir::BoolAttr validate_shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value resource, ::mlir::Value value, /*optional*/bool validate_shape = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value resource, ::mlir::Value value, /*optional*/bool validate_shape = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AssignVariableOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::Atan2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class Atan2OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  Atan2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Atan2", odsAttrs.getContext());
  }

  Atan2OpGenericAdaptorBase(Atan2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class Atan2OpGenericAdaptor : public detail::Atan2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::Atan2OpGenericAdaptorBase;
public:
  Atan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  Atan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : Atan2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  Atan2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : Atan2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  Atan2OpGenericAdaptor(RangeT values, const Atan2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = Atan2Op, typename = std::enable_if_t<std::is_same_v<LateInst, Atan2Op>>>
  Atan2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getY() {
    return (*getODSOperands(0).begin());
  }

  ValueT getX() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class Atan2OpAdaptor : public Atan2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using Atan2OpGenericAdaptor::Atan2OpGenericAdaptor;
  Atan2OpAdaptor(Atan2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class Atan2Op : public ::mlir::Op<Atan2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ResultsBroadcastableShape, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = Atan2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = Atan2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Atan2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getZ() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value x, Value y);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type z, ::mlir::Value y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::Atan2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AtanOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtanOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtanOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Atan", odsAttrs.getContext());
  }

  AtanOpGenericAdaptorBase(AtanOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AtanOpGenericAdaptor : public detail::AtanOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtanOpGenericAdaptorBase;
public:
  AtanOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtanOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtanOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtanOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtanOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtanOpGenericAdaptor(RangeT values, const AtanOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtanOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtanOp>>>
  AtanOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtanOpAdaptor : public AtanOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtanOpGenericAdaptor::AtanOpGenericAdaptor;
  AtanOpAdaptor(AtanOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtanOp : public ::mlir::Op<AtanOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtanOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtanOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Atan");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AtanOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AtanhOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtanhOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtanhOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.Atanh", odsAttrs.getContext());
  }

  AtanhOpGenericAdaptorBase(AtanhOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AtanhOpGenericAdaptor : public detail::AtanhOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtanhOpGenericAdaptorBase;
public:
  AtanhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtanhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtanhOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtanhOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtanhOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtanhOpGenericAdaptor(RangeT values, const AtanhOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtanhOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtanhOp>>>
  AtanhOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtanhOpAdaptor : public AtanhOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtanhOpGenericAdaptor::AtanhOpGenericAdaptor;
  AtanhOpAdaptor(AtanhOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtanhOp : public ::mlir::Op<AtanhOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtanhOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtanhOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.Atanh");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AtanhOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AvgPool3DGradOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AvgPool3DGradOpGenericAdaptorBase {
public:
  struct Properties {
    using data_formatTy = ::mlir::StringAttr;
    data_formatTy data_format;

    auto getDataFormat() const {
      auto &propStorage = this->data_format;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDataFormat(const ::mlir::StringAttr &propValue) {
      this->data_format = propValue;
    }
    using ksizeTy = ::mlir::ArrayAttr;
    ksizeTy ksize;

    auto getKsize() const {
      auto &propStorage = this->ksize;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setKsize(const ::mlir::ArrayAttr &propValue) {
      this->ksize = propValue;
    }
    using paddingTy = ::mlir::StringAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setPadding(const ::mlir::StringAttr &propValue) {
      this->padding = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_format == this->data_format &&
        rhs.ksize == this->ksize &&
        rhs.padding == this->padding &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AvgPool3DGradOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AvgPool3DGrad", odsAttrs.getContext());
  }

  AvgPool3DGradOpGenericAdaptorBase(AvgPool3DGradOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getKsizeAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
    return attr;
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
    return attr;
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr();
  ::llvm::StringRef getDataFormat();
};
} // namespace detail
template <typename RangeT>
class AvgPool3DGradOpGenericAdaptor : public detail::AvgPool3DGradOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AvgPool3DGradOpGenericAdaptorBase;
public:
  AvgPool3DGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AvgPool3DGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AvgPool3DGradOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AvgPool3DGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AvgPool3DGradOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AvgPool3DGradOpGenericAdaptor(RangeT values, const AvgPool3DGradOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AvgPool3DGradOp, typename = std::enable_if_t<std::is_same_v<LateInst, AvgPool3DGradOp>>>
  AvgPool3DGradOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOrigInputShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getGrad() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AvgPool3DGradOpAdaptor : public AvgPool3DGradOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AvgPool3DGradOpGenericAdaptor::AvgPool3DGradOpGenericAdaptor;
  AvgPool3DGradOpAdaptor(AvgPool3DGradOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AvgPool3DGradOp : public ::mlir::Op<AvgPool3DGradOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AvgPool3DGradOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AvgPool3DGradOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("data_format"), ::llvm::StringRef("ksize"), ::llvm::StringRef("padding"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDataFormatAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDataFormatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKsizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKsizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AvgPool3DGrad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOrigInputShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getGrad() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOrigInputShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGradMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getKsizeAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().data_format);
  }

  ::llvm::StringRef getDataFormat();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKsizeAttr(::mlir::ArrayAttr attr) {
    getProperties().ksize = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setPaddingAttr(::mlir::StringAttr attr) {
    getProperties().padding = attr;
  }

  void setPadding(::llvm::StringRef attrValue);
  void setDataFormatAttr(::mlir::StringAttr attr) {
    getProperties().data_format = attr;
  }

  void setDataFormat(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeDataFormatAttr() {
      auto attr = getProperties().data_format;
      getProperties().data_format = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NDHWC");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NDHWC");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AvgPool3DGradOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AvgPool3DOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AvgPool3DOpGenericAdaptorBase {
public:
  struct Properties {
    using data_formatTy = ::mlir::StringAttr;
    data_formatTy data_format;

    auto getDataFormat() const {
      auto &propStorage = this->data_format;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDataFormat(const ::mlir::StringAttr &propValue) {
      this->data_format = propValue;
    }
    using ksizeTy = ::mlir::ArrayAttr;
    ksizeTy ksize;

    auto getKsize() const {
      auto &propStorage = this->ksize;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setKsize(const ::mlir::ArrayAttr &propValue) {
      this->ksize = propValue;
    }
    using paddingTy = ::mlir::StringAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setPadding(const ::mlir::StringAttr &propValue) {
      this->padding = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_format == this->data_format &&
        rhs.ksize == this->ksize &&
        rhs.padding == this->padding &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AvgPool3DOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AvgPool3D", odsAttrs.getContext());
  }

  AvgPool3DOpGenericAdaptorBase(AvgPool3DOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getKsizeAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
    return attr;
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
    return attr;
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr();
  ::llvm::StringRef getDataFormat();
};
} // namespace detail
template <typename RangeT>
class AvgPool3DOpGenericAdaptor : public detail::AvgPool3DOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AvgPool3DOpGenericAdaptorBase;
public:
  AvgPool3DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AvgPool3DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AvgPool3DOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AvgPool3DOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AvgPool3DOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AvgPool3DOpGenericAdaptor(RangeT values, const AvgPool3DOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AvgPool3DOp, typename = std::enable_if_t<std::is_same_v<LateInst, AvgPool3DOp>>>
  AvgPool3DOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AvgPool3DOpAdaptor : public AvgPool3DOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AvgPool3DOpGenericAdaptor::AvgPool3DOpGenericAdaptor;
  AvgPool3DOpAdaptor(AvgPool3DOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AvgPool3DOp : public ::mlir::Op<AvgPool3DOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AvgPool3DOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AvgPool3DOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("data_format"), ::llvm::StringRef("ksize"), ::llvm::StringRef("padding"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDataFormatAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDataFormatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKsizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKsizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AvgPool3D");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getKsizeAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().data_format);
  }

  ::llvm::StringRef getDataFormat();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKsizeAttr(::mlir::ArrayAttr attr) {
    getProperties().ksize = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setPaddingAttr(::mlir::StringAttr attr) {
    getProperties().padding = attr;
  }

  void setPadding(::llvm::StringRef attrValue);
  void setDataFormatAttr(::mlir::StringAttr attr) {
    getProperties().data_format = attr;
  }

  void setDataFormat(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeDataFormatAttr() {
      auto attr = getProperties().data_format;
      getProperties().data_format = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NDHWC");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NDHWC");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AvgPool3DOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AvgPoolGradOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AvgPoolGradOpGenericAdaptorBase {
public:
  struct Properties {
    using data_formatTy = ::mlir::StringAttr;
    data_formatTy data_format;

    auto getDataFormat() const {
      auto &propStorage = this->data_format;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDataFormat(const ::mlir::StringAttr &propValue) {
      this->data_format = propValue;
    }
    using ksizeTy = ::mlir::ArrayAttr;
    ksizeTy ksize;

    auto getKsize() const {
      auto &propStorage = this->ksize;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setKsize(const ::mlir::ArrayAttr &propValue) {
      this->ksize = propValue;
    }
    using paddingTy = ::mlir::StringAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setPadding(const ::mlir::StringAttr &propValue) {
      this->padding = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_format == this->data_format &&
        rhs.ksize == this->ksize &&
        rhs.padding == this->padding &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AvgPoolGradOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AvgPoolGrad", odsAttrs.getContext());
  }

  AvgPoolGradOpGenericAdaptorBase(AvgPoolGradOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getKsizeAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
    return attr;
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
    return attr;
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr();
  ::llvm::StringRef getDataFormat();
};
} // namespace detail
template <typename RangeT>
class AvgPoolGradOpGenericAdaptor : public detail::AvgPoolGradOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AvgPoolGradOpGenericAdaptorBase;
public:
  AvgPoolGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AvgPoolGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AvgPoolGradOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AvgPoolGradOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AvgPoolGradOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AvgPoolGradOpGenericAdaptor(RangeT values, const AvgPoolGradOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AvgPoolGradOp, typename = std::enable_if_t<std::is_same_v<LateInst, AvgPoolGradOp>>>
  AvgPoolGradOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOrigInputShape() {
    return (*getODSOperands(0).begin());
  }

  ValueT getGrad() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AvgPoolGradOpAdaptor : public AvgPoolGradOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AvgPoolGradOpGenericAdaptor::AvgPoolGradOpGenericAdaptor;
  AvgPoolGradOpAdaptor(AvgPoolGradOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AvgPoolGradOp : public ::mlir::Op<AvgPoolGradOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AvgPoolGradOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AvgPoolGradOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("data_format"), ::llvm::StringRef("ksize"), ::llvm::StringRef("padding"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDataFormatAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDataFormatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKsizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKsizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AvgPoolGrad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOrigInputShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getGrad() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getOrigInputShapeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGradMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getKsizeAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().data_format);
  }

  ::llvm::StringRef getDataFormat();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKsizeAttr(::mlir::ArrayAttr attr) {
    getProperties().ksize = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setPaddingAttr(::mlir::StringAttr attr) {
    getProperties().padding = attr;
  }

  void setPadding(::llvm::StringRef attrValue);
  void setDataFormatAttr(::mlir::StringAttr attr) {
    getProperties().data_format = attr;
  }

  void setDataFormat(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeDataFormatAttr() {
      auto attr = getProperties().data_format;
      getProperties().data_format = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NHWC");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value orig_input_shape, ::mlir::Value grad, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NHWC");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AvgPoolGradOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::AvgPoolOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AvgPoolOpGenericAdaptorBase {
public:
  struct Properties {
    using data_formatTy = ::mlir::StringAttr;
    data_formatTy data_format;

    auto getDataFormat() const {
      auto &propStorage = this->data_format;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDataFormat(const ::mlir::StringAttr &propValue) {
      this->data_format = propValue;
    }
    using ksizeTy = ::mlir::ArrayAttr;
    ksizeTy ksize;

    auto getKsize() const {
      auto &propStorage = this->ksize;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setKsize(const ::mlir::ArrayAttr &propValue) {
      this->ksize = propValue;
    }
    using paddingTy = ::mlir::StringAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setPadding(const ::mlir::StringAttr &propValue) {
      this->padding = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_format == this->data_format &&
        rhs.ksize == this->ksize &&
        rhs.padding == this->padding &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AvgPoolOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.AvgPool", odsAttrs.getContext());
  }

  AvgPoolOpGenericAdaptorBase(AvgPoolOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getKsizeAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
    return attr;
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
    return attr;
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr();
  ::llvm::StringRef getDataFormat();
};
} // namespace detail
template <typename RangeT>
class AvgPoolOpGenericAdaptor : public detail::AvgPoolOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AvgPoolOpGenericAdaptorBase;
public:
  AvgPoolOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AvgPoolOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AvgPoolOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AvgPoolOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AvgPoolOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AvgPoolOpGenericAdaptor(RangeT values, const AvgPoolOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AvgPoolOp, typename = std::enable_if_t<std::is_same_v<LateInst, AvgPoolOp>>>
  AvgPoolOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AvgPoolOpAdaptor : public AvgPoolOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AvgPoolOpGenericAdaptor::AvgPoolOpGenericAdaptor;
  AvgPoolOpAdaptor(AvgPoolOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AvgPoolOp : public ::mlir::Op<AvgPoolOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AvgPoolOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AvgPoolOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("data_format"), ::llvm::StringRef("ksize"), ::llvm::StringRef("padding"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDataFormatAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDataFormatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getKsizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getKsizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.AvgPool");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getKsizeAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().ksize);
  }

  ::mlir::ArrayAttr getKsize();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::StringAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().padding);
  }

  ::llvm::StringRef getPadding();
  ::mlir::StringAttr getDataFormatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().data_format);
  }

  ::llvm::StringRef getDataFormat();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setKsizeAttr(::mlir::ArrayAttr attr) {
    getProperties().ksize = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setPaddingAttr(::mlir::StringAttr attr) {
    getProperties().padding = attr;
  }

  void setPadding(::llvm::StringRef attrValue);
  void setDataFormatAttr(::mlir::StringAttr attr) {
    getProperties().data_format = attr;
  }

  void setDataFormat(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeDataFormatAttr() {
      auto attr = getProperties().data_format;
      getProperties().data_format = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value value, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::mlir::StringAttr padding, /*optional*/::mlir::StringAttr data_format = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value value, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NHWC");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::ArrayAttr ksize, ::mlir::ArrayAttr strides, ::llvm::StringRef padding, /*optional*/::llvm::StringRef data_format = "NHWC");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::AvgPoolOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchDatasetV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchDatasetV2OpGenericAdaptorBase {
public:
  struct Properties {
    using metadataTy = ::mlir::StringAttr;
    metadataTy metadata;

    auto getMetadata() const {
      auto &propStorage = this->metadata;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMetadata(const ::mlir::StringAttr &propValue) {
      this->metadata = propValue;
    }
    using output_shapesTy = ::mlir::ArrayAttr;
    output_shapesTy output_shapes;

    auto getOutputShapes() const {
      auto &propStorage = this->output_shapes;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputShapes(const ::mlir::ArrayAttr &propValue) {
      this->output_shapes = propValue;
    }
    using output_typesTy = ::mlir::ArrayAttr;
    output_typesTy output_types;

    auto getOutputTypes() const {
      auto &propStorage = this->output_types;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOutputTypes(const ::mlir::ArrayAttr &propValue) {
      this->output_types = propValue;
    }
    using parallel_copyTy = ::mlir::BoolAttr;
    parallel_copyTy parallel_copy;

    auto getParallelCopy() const {
      auto &propStorage = this->parallel_copy;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setParallelCopy(const ::mlir::BoolAttr &propValue) {
      this->parallel_copy = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.metadata == this->metadata &&
        rhs.output_shapes == this->output_shapes &&
        rhs.output_types == this->output_types &&
        rhs.parallel_copy == this->parallel_copy &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchDatasetV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchDatasetV2", odsAttrs.getContext());
  }

  BatchDatasetV2OpGenericAdaptorBase(BatchDatasetV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getParallelCopyAttr();
  bool getParallelCopy();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
    return attr;
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
    return attr;
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::StringAttr getMetadataAttr();
  ::llvm::StringRef getMetadata();
};
} // namespace detail
template <typename RangeT>
class BatchDatasetV2OpGenericAdaptor : public detail::BatchDatasetV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchDatasetV2OpGenericAdaptorBase;
public:
  BatchDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchDatasetV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchDatasetV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchDatasetV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchDatasetV2OpGenericAdaptor(RangeT values, const BatchDatasetV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchDatasetV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, BatchDatasetV2Op>>>
  BatchDatasetV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInputDataset() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBatchSize() {
    return (*getODSOperands(1).begin());
  }

  ValueT getDropRemainder() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchDatasetV2OpAdaptor : public BatchDatasetV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchDatasetV2OpGenericAdaptor::BatchDatasetV2OpGenericAdaptor;
  BatchDatasetV2OpAdaptor(BatchDatasetV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchDatasetV2Op : public ::mlir::Op<BatchDatasetV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchDatasetV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchDatasetV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("metadata"), ::llvm::StringRef("output_shapes"), ::llvm::StringRef("output_types"), ::llvm::StringRef("parallel_copy")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMetadataAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMetadataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutputShapesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutputShapesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOutputTypesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getOutputTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getParallelCopyAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getParallelCopyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchDatasetV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInputDataset() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getBatchSize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getDropRemainder() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputDatasetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBatchSizeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDropRemainderMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getParallelCopyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().parallel_copy);
  }

  bool getParallelCopy();
  ::mlir::ArrayAttr getOutputTypesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_types);
  }

  ::mlir::ArrayAttr getOutputTypes();
  ::mlir::ArrayAttr getOutputShapesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().output_shapes);
  }

  ::mlir::ArrayAttr getOutputShapes();
  ::mlir::StringAttr getMetadataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().metadata);
  }

  ::llvm::StringRef getMetadata();
  void setParallelCopyAttr(::mlir::BoolAttr attr) {
    getProperties().parallel_copy = attr;
  }

  void setParallelCopy(::std::optional<bool> attrValue);
  void setOutputTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_types = attr;
  }

  void setOutputShapesAttr(::mlir::ArrayAttr attr) {
    getProperties().output_shapes = attr;
  }

  void setMetadataAttr(::mlir::StringAttr attr) {
    getProperties().metadata = attr;
  }

  void setMetadata(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeParallelCopyAttr() {
      auto attr = getProperties().parallel_copy;
      getProperties().parallel_copy = {};
      return attr;
  }

  ::mlir::Attribute removeMetadataAttr() {
      auto attr = getProperties().metadata;
      getProperties().metadata = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::Value batch_size, ::mlir::Value drop_remainder, /*optional*/::mlir::BoolAttr parallel_copy, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::StringAttr metadata);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::Value batch_size, ::mlir::Value drop_remainder, /*optional*/::mlir::BoolAttr parallel_copy, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::mlir::StringAttr metadata);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type handle, ::mlir::Value input_dataset, ::mlir::Value batch_size, ::mlir::Value drop_remainder, /*optional*/bool parallel_copy, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input_dataset, ::mlir::Value batch_size, ::mlir::Value drop_remainder, /*optional*/bool parallel_copy, ::mlir::ArrayAttr output_types, ::mlir::ArrayAttr output_shapes, /*optional*/::llvm::StringRef metadata = "");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchDatasetV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchFunctionOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchFunctionOpGenericAdaptorBase {
public:
  struct Properties {
    using allowed_batch_sizesTy = ::mlir::ArrayAttr;
    allowed_batch_sizesTy allowed_batch_sizes;

    auto getAllowedBatchSizes() const {
      auto &propStorage = this->allowed_batch_sizes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAllowedBatchSizes(const ::mlir::ArrayAttr &propValue) {
      this->allowed_batch_sizes = propValue;
    }
    using batch_padding_policyTy = ::mlir::StringAttr;
    batch_padding_policyTy batch_padding_policy;

    auto getBatchPaddingPolicy() const {
      auto &propStorage = this->batch_padding_policy;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setBatchPaddingPolicy(const ::mlir::StringAttr &propValue) {
      this->batch_padding_policy = propValue;
    }
    using batch_timeout_microsTy = ::mlir::IntegerAttr;
    batch_timeout_microsTy batch_timeout_micros;

    auto getBatchTimeoutMicros() const {
      auto &propStorage = this->batch_timeout_micros;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBatchTimeoutMicros(const ::mlir::IntegerAttr &propValue) {
      this->batch_timeout_micros = propValue;
    }
    using batching_queueTy = ::mlir::StringAttr;
    batching_queueTy batching_queue;

    auto getBatchingQueue() const {
      auto &propStorage = this->batching_queue;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setBatchingQueue(const ::mlir::StringAttr &propValue) {
      this->batching_queue = propValue;
    }
    using containerTy = ::mlir::StringAttr;
    containerTy container;

    auto getContainer() const {
      auto &propStorage = this->container;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setContainer(const ::mlir::StringAttr &propValue) {
      this->container = propValue;
    }
    using enable_large_batch_splittingTy = ::mlir::BoolAttr;
    enable_large_batch_splittingTy enable_large_batch_splitting;

    auto getEnableLargeBatchSplitting() const {
      auto &propStorage = this->enable_large_batch_splitting;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setEnableLargeBatchSplitting(const ::mlir::BoolAttr &propValue) {
      this->enable_large_batch_splitting = propValue;
    }
    using fTy = ::mlir::SymbolRefAttr;
    fTy f;

    auto getF() const {
      auto &propStorage = this->f;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setF(const ::mlir::SymbolRefAttr &propValue) {
      this->f = propValue;
    }
    using low_priority_allowed_batch_sizesTy = ::mlir::ArrayAttr;
    low_priority_allowed_batch_sizesTy low_priority_allowed_batch_sizes;

    auto getLowPriorityAllowedBatchSizes() const {
      auto &propStorage = this->low_priority_allowed_batch_sizes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setLowPriorityAllowedBatchSizes(const ::mlir::ArrayAttr &propValue) {
      this->low_priority_allowed_batch_sizes = propValue;
    }
    using low_priority_batch_timeout_microsTy = ::mlir::IntegerAttr;
    low_priority_batch_timeout_microsTy low_priority_batch_timeout_micros;

    auto getLowPriorityBatchTimeoutMicros() const {
      auto &propStorage = this->low_priority_batch_timeout_micros;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setLowPriorityBatchTimeoutMicros(const ::mlir::IntegerAttr &propValue) {
      this->low_priority_batch_timeout_micros = propValue;
    }
    using low_priority_max_batch_sizeTy = ::mlir::IntegerAttr;
    low_priority_max_batch_sizeTy low_priority_max_batch_size;

    auto getLowPriorityMaxBatchSize() const {
      auto &propStorage = this->low_priority_max_batch_size;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setLowPriorityMaxBatchSize(const ::mlir::IntegerAttr &propValue) {
      this->low_priority_max_batch_size = propValue;
    }
    using low_priority_max_enqueued_batchesTy = ::mlir::IntegerAttr;
    low_priority_max_enqueued_batchesTy low_priority_max_enqueued_batches;

    auto getLowPriorityMaxEnqueuedBatches() const {
      auto &propStorage = this->low_priority_max_enqueued_batches;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setLowPriorityMaxEnqueuedBatches(const ::mlir::IntegerAttr &propValue) {
      this->low_priority_max_enqueued_batches = propValue;
    }
    using max_batch_sizeTy = ::mlir::IntegerAttr;
    max_batch_sizeTy max_batch_size;

    auto getMaxBatchSize() const {
      auto &propStorage = this->max_batch_size;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setMaxBatchSize(const ::mlir::IntegerAttr &propValue) {
      this->max_batch_size = propValue;
    }
    using max_enqueued_batchesTy = ::mlir::IntegerAttr;
    max_enqueued_batchesTy max_enqueued_batches;

    auto getMaxEnqueuedBatches() const {
      auto &propStorage = this->max_enqueued_batches;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setMaxEnqueuedBatches(const ::mlir::IntegerAttr &propValue) {
      this->max_enqueued_batches = propValue;
    }
    using mixed_priority_policyTy = ::mlir::StringAttr;
    mixed_priority_policyTy mixed_priority_policy;

    auto getMixedPriorityPolicy() const {
      auto &propStorage = this->mixed_priority_policy;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setMixedPriorityPolicy(const ::mlir::StringAttr &propValue) {
      this->mixed_priority_policy = propValue;
    }
    using num_batch_threadsTy = ::mlir::IntegerAttr;
    num_batch_threadsTy num_batch_threads;

    auto getNumBatchThreads() const {
      auto &propStorage = this->num_batch_threads;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setNumBatchThreads(const ::mlir::IntegerAttr &propValue) {
      this->num_batch_threads = propValue;
    }
    using shared_nameTy = ::mlir::StringAttr;
    shared_nameTy shared_name;

    auto getSharedName() const {
      auto &propStorage = this->shared_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSharedName(const ::mlir::StringAttr &propValue) {
      this->shared_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.allowed_batch_sizes == this->allowed_batch_sizes &&
        rhs.batch_padding_policy == this->batch_padding_policy &&
        rhs.batch_timeout_micros == this->batch_timeout_micros &&
        rhs.batching_queue == this->batching_queue &&
        rhs.container == this->container &&
        rhs.enable_large_batch_splitting == this->enable_large_batch_splitting &&
        rhs.f == this->f &&
        rhs.low_priority_allowed_batch_sizes == this->low_priority_allowed_batch_sizes &&
        rhs.low_priority_batch_timeout_micros == this->low_priority_batch_timeout_micros &&
        rhs.low_priority_max_batch_size == this->low_priority_max_batch_size &&
        rhs.low_priority_max_enqueued_batches == this->low_priority_max_enqueued_batches &&
        rhs.max_batch_size == this->max_batch_size &&
        rhs.max_enqueued_batches == this->max_enqueued_batches &&
        rhs.mixed_priority_policy == this->mixed_priority_policy &&
        rhs.num_batch_threads == this->num_batch_threads &&
        rhs.shared_name == this->shared_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchFunctionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchFunction", odsAttrs.getContext());
  }

  BatchFunctionOpGenericAdaptorBase(BatchFunctionOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getFAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
    return attr;
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::IntegerAttr getNumBatchThreadsAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().num_batch_threads);
    return attr;
  }

  uint64_t getNumBatchThreads();
  ::mlir::IntegerAttr getMaxBatchSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().max_batch_size);
    return attr;
  }

  uint64_t getMaxBatchSize();
  ::mlir::IntegerAttr getBatchTimeoutMicrosAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().batch_timeout_micros);
    return attr;
  }

  uint64_t getBatchTimeoutMicros();
  ::mlir::IntegerAttr getMaxEnqueuedBatchesAttr();
  uint64_t getMaxEnqueuedBatches();
  ::mlir::ArrayAttr getAllowedBatchSizesAttr();
  ::mlir::ArrayAttr getAllowedBatchSizes();
  ::mlir::StringAttr getContainerAttr();
  ::llvm::StringRef getContainer();
  ::mlir::StringAttr getSharedNameAttr();
  ::llvm::StringRef getSharedName();
  ::mlir::StringAttr getBatchingQueueAttr();
  ::llvm::StringRef getBatchingQueue();
  ::mlir::IntegerAttr getLowPriorityMaxBatchSizeAttr();
  uint64_t getLowPriorityMaxBatchSize();
  ::mlir::IntegerAttr getLowPriorityBatchTimeoutMicrosAttr();
  uint64_t getLowPriorityBatchTimeoutMicros();
  ::mlir::ArrayAttr getLowPriorityAllowedBatchSizesAttr();
  ::mlir::ArrayAttr getLowPriorityAllowedBatchSizes();
  ::mlir::IntegerAttr getLowPriorityMaxEnqueuedBatchesAttr();
  uint64_t getLowPriorityMaxEnqueuedBatches();
  ::mlir::StringAttr getMixedPriorityPolicyAttr();
  ::llvm::StringRef getMixedPriorityPolicy();
  ::mlir::StringAttr getBatchPaddingPolicyAttr();
  ::llvm::StringRef getBatchPaddingPolicy();
  ::mlir::BoolAttr getEnableLargeBatchSplittingAttr();
  bool getEnableLargeBatchSplitting();
};
} // namespace detail
template <typename RangeT>
class BatchFunctionOpGenericAdaptor : public detail::BatchFunctionOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchFunctionOpGenericAdaptorBase;
public:
  BatchFunctionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchFunctionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchFunctionOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchFunctionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : BatchFunctionOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchFunctionOpGenericAdaptor(RangeT values, const BatchFunctionOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchFunctionOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchFunctionOp>>>
  BatchFunctionOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getInTensors() {
    return getODSOperands(0);
  }

  RangeT getCapturedTensors() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchFunctionOpAdaptor : public BatchFunctionOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchFunctionOpGenericAdaptor::BatchFunctionOpGenericAdaptor;
  BatchFunctionOpAdaptor(BatchFunctionOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchFunctionOp : public ::mlir::Op<BatchFunctionOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchFunctionOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchFunctionOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Tcaptured"), ::llvm::StringRef("Tin"), ::llvm::StringRef("Tout"), ::llvm::StringRef("allowed_batch_sizes"), ::llvm::StringRef("batch_padding_policy"), ::llvm::StringRef("batch_timeout_micros"), ::llvm::StringRef("batching_queue"), ::llvm::StringRef("container"), ::llvm::StringRef("enable_large_batch_splitting"), ::llvm::StringRef("f"), ::llvm::StringRef("low_priority_allowed_batch_sizes"), ::llvm::StringRef("low_priority_batch_timeout_micros"), ::llvm::StringRef("low_priority_max_batch_size"), ::llvm::StringRef("low_priority_max_enqueued_batches"), ::llvm::StringRef("max_batch_size"), ::llvm::StringRef("max_enqueued_batches"), ::llvm::StringRef("mixed_priority_policy"), ::llvm::StringRef("num_batch_threads"), ::llvm::StringRef("shared_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTcapturedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTcapturedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTinAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTinAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getToutAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getToutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getAllowedBatchSizesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getAllowedBatchSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getBatchPaddingPolicyAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getBatchPaddingPolicyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getBatchTimeoutMicrosAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getBatchTimeoutMicrosAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getBatchingQueueAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getBatchingQueueAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getContainerAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getContainerAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getEnableLargeBatchSplittingAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getEnableLargeBatchSplittingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getFAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getFAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getLowPriorityAllowedBatchSizesAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getLowPriorityAllowedBatchSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getLowPriorityBatchTimeoutMicrosAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getLowPriorityBatchTimeoutMicrosAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getLowPriorityMaxBatchSizeAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getLowPriorityMaxBatchSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getLowPriorityMaxEnqueuedBatchesAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getLowPriorityMaxEnqueuedBatchesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getMaxBatchSizeAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getMaxBatchSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getMaxEnqueuedBatchesAttrName() {
    return getAttributeNameForIndex(15);
  }

  static ::mlir::StringAttr getMaxEnqueuedBatchesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 15);
  }

  ::mlir::StringAttr getMixedPriorityPolicyAttrName() {
    return getAttributeNameForIndex(16);
  }

  static ::mlir::StringAttr getMixedPriorityPolicyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 16);
  }

  ::mlir::StringAttr getNumBatchThreadsAttrName() {
    return getAttributeNameForIndex(17);
  }

  static ::mlir::StringAttr getNumBatchThreadsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 17);
  }

  ::mlir::StringAttr getSharedNameAttrName() {
    return getAttributeNameForIndex(18);
  }

  static ::mlir::StringAttr getSharedNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 18);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchFunction");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getInTensors() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getCapturedTensors() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getInTensorsMutable();
  ::mlir::MutableOperandRange getCapturedTensorsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getOutTensors() {
    return getODSResults(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getFAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().f);
  }

  ::mlir::SymbolRefAttr getF();
  ::mlir::IntegerAttr getNumBatchThreadsAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().num_batch_threads);
  }

  uint64_t getNumBatchThreads();
  ::mlir::IntegerAttr getMaxBatchSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().max_batch_size);
  }

  uint64_t getMaxBatchSize();
  ::mlir::IntegerAttr getBatchTimeoutMicrosAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().batch_timeout_micros);
  }

  uint64_t getBatchTimeoutMicros();
  ::mlir::IntegerAttr getMaxEnqueuedBatchesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().max_enqueued_batches);
  }

  uint64_t getMaxEnqueuedBatches();
  ::mlir::ArrayAttr getAllowedBatchSizesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().allowed_batch_sizes);
  }

  ::mlir::ArrayAttr getAllowedBatchSizes();
  ::mlir::StringAttr getContainerAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().container);
  }

  ::llvm::StringRef getContainer();
  ::mlir::StringAttr getSharedNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().shared_name);
  }

  ::llvm::StringRef getSharedName();
  ::mlir::StringAttr getBatchingQueueAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().batching_queue);
  }

  ::llvm::StringRef getBatchingQueue();
  ::mlir::IntegerAttr getLowPriorityMaxBatchSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().low_priority_max_batch_size);
  }

  uint64_t getLowPriorityMaxBatchSize();
  ::mlir::IntegerAttr getLowPriorityBatchTimeoutMicrosAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().low_priority_batch_timeout_micros);
  }

  uint64_t getLowPriorityBatchTimeoutMicros();
  ::mlir::ArrayAttr getLowPriorityAllowedBatchSizesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().low_priority_allowed_batch_sizes);
  }

  ::mlir::ArrayAttr getLowPriorityAllowedBatchSizes();
  ::mlir::IntegerAttr getLowPriorityMaxEnqueuedBatchesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().low_priority_max_enqueued_batches);
  }

  uint64_t getLowPriorityMaxEnqueuedBatches();
  ::mlir::StringAttr getMixedPriorityPolicyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().mixed_priority_policy);
  }

  ::llvm::StringRef getMixedPriorityPolicy();
  ::mlir::StringAttr getBatchPaddingPolicyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().batch_padding_policy);
  }

  ::llvm::StringRef getBatchPaddingPolicy();
  ::mlir::BoolAttr getEnableLargeBatchSplittingAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().enable_large_batch_splitting);
  }

  bool getEnableLargeBatchSplitting();
  mlir::OperandElementTypeRange getTcaptured();
  mlir::OperandElementTypeRange getTin();
  mlir::ResultElementTypeRange getTout();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setFAttr(::mlir::SymbolRefAttr attr) {
    getProperties().f = attr;
  }

  void setNumBatchThreadsAttr(::mlir::IntegerAttr attr) {
    getProperties().num_batch_threads = attr;
  }

  void setNumBatchThreads(uint64_t attrValue);
  void setMaxBatchSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().max_batch_size = attr;
  }

  void setMaxBatchSize(uint64_t attrValue);
  void setBatchTimeoutMicrosAttr(::mlir::IntegerAttr attr) {
    getProperties().batch_timeout_micros = attr;
  }

  void setBatchTimeoutMicros(uint64_t attrValue);
  void setMaxEnqueuedBatchesAttr(::mlir::IntegerAttr attr) {
    getProperties().max_enqueued_batches = attr;
  }

  void setMaxEnqueuedBatches(::std::optional<uint64_t> attrValue);
  void setAllowedBatchSizesAttr(::mlir::ArrayAttr attr) {
    getProperties().allowed_batch_sizes = attr;
  }

  void setContainerAttr(::mlir::StringAttr attr) {
    getProperties().container = attr;
  }

  void setContainer(::std::optional<::llvm::StringRef> attrValue);
  void setSharedNameAttr(::mlir::StringAttr attr) {
    getProperties().shared_name = attr;
  }

  void setSharedName(::std::optional<::llvm::StringRef> attrValue);
  void setBatchingQueueAttr(::mlir::StringAttr attr) {
    getProperties().batching_queue = attr;
  }

  void setBatchingQueue(::std::optional<::llvm::StringRef> attrValue);
  void setLowPriorityMaxBatchSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().low_priority_max_batch_size = attr;
  }

  void setLowPriorityMaxBatchSize(::std::optional<uint64_t> attrValue);
  void setLowPriorityBatchTimeoutMicrosAttr(::mlir::IntegerAttr attr) {
    getProperties().low_priority_batch_timeout_micros = attr;
  }

  void setLowPriorityBatchTimeoutMicros(::std::optional<uint64_t> attrValue);
  void setLowPriorityAllowedBatchSizesAttr(::mlir::ArrayAttr attr) {
    getProperties().low_priority_allowed_batch_sizes = attr;
  }

  void setLowPriorityMaxEnqueuedBatchesAttr(::mlir::IntegerAttr attr) {
    getProperties().low_priority_max_enqueued_batches = attr;
  }

  void setLowPriorityMaxEnqueuedBatches(::std::optional<uint64_t> attrValue);
  void setMixedPriorityPolicyAttr(::mlir::StringAttr attr) {
    getProperties().mixed_priority_policy = attr;
  }

  void setMixedPriorityPolicy(::std::optional<::llvm::StringRef> attrValue);
  void setBatchPaddingPolicyAttr(::mlir::StringAttr attr) {
    getProperties().batch_padding_policy = attr;
  }

  void setBatchPaddingPolicy(::std::optional<::llvm::StringRef> attrValue);
  void setEnableLargeBatchSplittingAttr(::mlir::BoolAttr attr) {
    getProperties().enable_large_batch_splitting = attr;
  }

  void setEnableLargeBatchSplitting(::std::optional<bool> attrValue);
  ::mlir::Attribute removeMaxEnqueuedBatchesAttr() {
      auto attr = getProperties().max_enqueued_batches;
      getProperties().max_enqueued_batches = {};
      return attr;
  }

  ::mlir::Attribute removeAllowedBatchSizesAttr() {
      auto attr = getProperties().allowed_batch_sizes;
      getProperties().allowed_batch_sizes = {};
      return attr;
  }

  ::mlir::Attribute removeContainerAttr() {
      auto attr = getProperties().container;
      getProperties().container = {};
      return attr;
  }

  ::mlir::Attribute removeSharedNameAttr() {
      auto attr = getProperties().shared_name;
      getProperties().shared_name = {};
      return attr;
  }

  ::mlir::Attribute removeBatchingQueueAttr() {
      auto attr = getProperties().batching_queue;
      getProperties().batching_queue = {};
      return attr;
  }

  ::mlir::Attribute removeLowPriorityMaxBatchSizeAttr() {
      auto attr = getProperties().low_priority_max_batch_size;
      getProperties().low_priority_max_batch_size = {};
      return attr;
  }

  ::mlir::Attribute removeLowPriorityBatchTimeoutMicrosAttr() {
      auto attr = getProperties().low_priority_batch_timeout_micros;
      getProperties().low_priority_batch_timeout_micros = {};
      return attr;
  }

  ::mlir::Attribute removeLowPriorityAllowedBatchSizesAttr() {
      auto attr = getProperties().low_priority_allowed_batch_sizes;
      getProperties().low_priority_allowed_batch_sizes = {};
      return attr;
  }

  ::mlir::Attribute removeLowPriorityMaxEnqueuedBatchesAttr() {
      auto attr = getProperties().low_priority_max_enqueued_batches;
      getProperties().low_priority_max_enqueued_batches = {};
      return attr;
  }

  ::mlir::Attribute removeMixedPriorityPolicyAttr() {
      auto attr = getProperties().mixed_priority_policy;
      getProperties().mixed_priority_policy = {};
      return attr;
  }

  ::mlir::Attribute removeBatchPaddingPolicyAttr() {
      auto attr = getProperties().batch_padding_policy;
      getProperties().batch_padding_policy = {};
      return attr;
  }

  ::mlir::Attribute removeEnableLargeBatchSplittingAttr() {
      auto attr = getProperties().enable_large_batch_splitting;
      getProperties().enable_large_batch_splitting = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange out_tensors, ::mlir::ValueRange in_tensors, ::mlir::ValueRange captured_tensors, ::mlir::SymbolRefAttr f, ::mlir::IntegerAttr num_batch_threads, ::mlir::IntegerAttr max_batch_size, ::mlir::IntegerAttr batch_timeout_micros, /*optional*/::mlir::IntegerAttr max_enqueued_batches = nullptr, /*optional*/::mlir::ArrayAttr allowed_batch_sizes = nullptr, /*optional*/::mlir::StringAttr container = nullptr, /*optional*/::mlir::StringAttr shared_name = nullptr, /*optional*/::mlir::StringAttr batching_queue = nullptr, /*optional*/::mlir::IntegerAttr low_priority_max_batch_size = nullptr, /*optional*/::mlir::IntegerAttr low_priority_batch_timeout_micros = nullptr, /*optional*/::mlir::ArrayAttr low_priority_allowed_batch_sizes = nullptr, /*optional*/::mlir::IntegerAttr low_priority_max_enqueued_batches = nullptr, /*optional*/::mlir::StringAttr mixed_priority_policy = nullptr, /*optional*/::mlir::StringAttr batch_padding_policy = nullptr, /*optional*/::mlir::BoolAttr enable_large_batch_splitting = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange out_tensors, ::mlir::ValueRange in_tensors, ::mlir::ValueRange captured_tensors, ::mlir::SymbolRefAttr f, uint64_t num_batch_threads, uint64_t max_batch_size, uint64_t batch_timeout_micros, /*optional*/uint64_t max_enqueued_batches = 10, /*optional*/::mlir::ArrayAttr allowed_batch_sizes = nullptr, /*optional*/::llvm::StringRef container = "", /*optional*/::llvm::StringRef shared_name = "", /*optional*/::llvm::StringRef batching_queue = "", /*optional*/uint64_t low_priority_max_batch_size = 0, /*optional*/uint64_t low_priority_batch_timeout_micros = 0, /*optional*/::mlir::ArrayAttr low_priority_allowed_batch_sizes = nullptr, /*optional*/uint64_t low_priority_max_enqueued_batches = 0, /*optional*/::llvm::StringRef mixed_priority_policy = "low_priority_padding_with_max_batch_size", /*optional*/::llvm::StringRef batch_padding_policy = "PAD_UP", /*optional*/bool enable_large_batch_splitting = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 19 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Returns the callee of this operation.
  func::FuncOp func() {
    return SymbolTable::lookupNearestSymbolFrom<func::FuncOp>(*this, getF());
  }

  // Erases variable arguments from `batch_func_op`. `erase_indices` contains
  // the indices of the arguments to erase.
  void eraseArguments(const BitVector& erase_indices);

  // Gets the argument operands to the called function.
  operand_range getArgOperands() {
    // Merge `in_tensors` and `captured_tensors`. `operandSegmentSizes`
    // has two elements, so it will be merging two operand ranges (the two
    // variadic arguments). Attributes like `batch_timeout_micros` will not
    // make it to the return array.
    auto segment_sizes = getOperation()->getAttrOfType<DenseI32ArrayAttr>(getOperandSegmentSizeAttr());
    return OperandRangeRange(getOperands(), segment_sizes).join();
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchFunctionOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchMatMulOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchMatMulOpGenericAdaptorBase {
public:
  struct Properties {
    using adj_xTy = ::mlir::BoolAttr;
    adj_xTy adj_x;

    auto getAdjX() const {
      auto &propStorage = this->adj_x;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAdjX(const ::mlir::BoolAttr &propValue) {
      this->adj_x = propValue;
    }
    using adj_yTy = ::mlir::BoolAttr;
    adj_yTy adj_y;

    auto getAdjY() const {
      auto &propStorage = this->adj_y;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAdjY(const ::mlir::BoolAttr &propValue) {
      this->adj_y = propValue;
    }
    using grad_xTy = ::mlir::BoolAttr;
    grad_xTy grad_x;

    auto getGradX() const {
      auto &propStorage = this->grad_x;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setGradX(const ::mlir::BoolAttr &propValue) {
      this->grad_x = propValue;
    }
    using grad_yTy = ::mlir::BoolAttr;
    grad_yTy grad_y;

    auto getGradY() const {
      auto &propStorage = this->grad_y;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setGradY(const ::mlir::BoolAttr &propValue) {
      this->grad_y = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.adj_x == this->adj_x &&
        rhs.adj_y == this->adj_y &&
        rhs.grad_x == this->grad_x &&
        rhs.grad_y == this->grad_y &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchMatMulOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchMatMul", odsAttrs.getContext());
  }

  BatchMatMulOpGenericAdaptorBase(BatchMatMulOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getAdjXAttr();
  bool getAdjX();
  ::mlir::BoolAttr getAdjYAttr();
  bool getAdjY();
  ::mlir::BoolAttr getGradXAttr();
  bool getGradX();
  ::mlir::BoolAttr getGradYAttr();
  bool getGradY();
};
} // namespace detail
template <typename RangeT>
class BatchMatMulOpGenericAdaptor : public detail::BatchMatMulOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchMatMulOpGenericAdaptorBase;
public:
  BatchMatMulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchMatMulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchMatMulOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchMatMulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchMatMulOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchMatMulOpGenericAdaptor(RangeT values, const BatchMatMulOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchMatMulOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchMatMulOp>>>
  BatchMatMulOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchMatMulOpAdaptor : public BatchMatMulOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchMatMulOpGenericAdaptor::BatchMatMulOpGenericAdaptor;
  BatchMatMulOpAdaptor(BatchMatMulOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchMatMulOp : public ::mlir::Op<BatchMatMulOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchMatMulOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchMatMulOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("adj_x"), ::llvm::StringRef("adj_y"), ::llvm::StringRef("grad_x"), ::llvm::StringRef("grad_y")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAdjXAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAdjXAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAdjYAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAdjYAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getGradXAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getGradXAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getGradYAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getGradYAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchMatMul");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getAdjXAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().adj_x);
  }

  bool getAdjX();
  ::mlir::BoolAttr getAdjYAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().adj_y);
  }

  bool getAdjY();
  ::mlir::BoolAttr getGradXAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().grad_x);
  }

  bool getGradX();
  ::mlir::BoolAttr getGradYAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().grad_y);
  }

  bool getGradY();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setAdjXAttr(::mlir::BoolAttr attr) {
    getProperties().adj_x = attr;
  }

  void setAdjX(::std::optional<bool> attrValue);
  void setAdjYAttr(::mlir::BoolAttr attr) {
    getProperties().adj_y = attr;
  }

  void setAdjY(::std::optional<bool> attrValue);
  void setGradXAttr(::mlir::BoolAttr attr) {
    getProperties().grad_x = attr;
  }

  void setGradX(::std::optional<bool> attrValue);
  void setGradYAttr(::mlir::BoolAttr attr) {
    getProperties().grad_y = attr;
  }

  void setGradY(::std::optional<bool> attrValue);
  ::mlir::Attribute removeAdjXAttr() {
      auto attr = getProperties().adj_x;
      getProperties().adj_x = {};
      return attr;
  }

  ::mlir::Attribute removeAdjYAttr() {
      auto attr = getProperties().adj_y;
      getProperties().adj_y = {};
      return attr;
  }

  ::mlir::Attribute removeGradXAttr() {
      auto attr = getProperties().grad_x;
      getProperties().grad_x = {};
      return attr;
  }

  ::mlir::Attribute removeGradYAttr() {
      auto attr = getProperties().grad_y;
      getProperties().grad_y = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr adj_x, /*optional*/::mlir::BoolAttr adj_y = nullptr, /*optional*/::mlir::BoolAttr grad_x = nullptr, /*optional*/::mlir::BoolAttr grad_y = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr adj_x, /*optional*/::mlir::BoolAttr adj_y = nullptr, /*optional*/::mlir::BoolAttr grad_x = nullptr, /*optional*/::mlir::BoolAttr grad_y = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x, ::mlir::Value y, /*optional*/bool adj_x = false, /*optional*/bool adj_y = false, /*optional*/bool grad_x = false, /*optional*/bool grad_y = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/bool adj_x = false, /*optional*/bool adj_y = false, /*optional*/bool grad_x = false, /*optional*/bool grad_y = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchMatMulOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchMatMulV2Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchMatMulV2OpGenericAdaptorBase {
public:
  struct Properties {
    using adj_xTy = ::mlir::BoolAttr;
    adj_xTy adj_x;

    auto getAdjX() const {
      auto &propStorage = this->adj_x;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAdjX(const ::mlir::BoolAttr &propValue) {
      this->adj_x = propValue;
    }
    using adj_yTy = ::mlir::BoolAttr;
    adj_yTy adj_y;

    auto getAdjY() const {
      auto &propStorage = this->adj_y;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAdjY(const ::mlir::BoolAttr &propValue) {
      this->adj_y = propValue;
    }
    using grad_xTy = ::mlir::BoolAttr;
    grad_xTy grad_x;

    auto getGradX() const {
      auto &propStorage = this->grad_x;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setGradX(const ::mlir::BoolAttr &propValue) {
      this->grad_x = propValue;
    }
    using grad_yTy = ::mlir::BoolAttr;
    grad_yTy grad_y;

    auto getGradY() const {
      auto &propStorage = this->grad_y;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setGradY(const ::mlir::BoolAttr &propValue) {
      this->grad_y = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.adj_x == this->adj_x &&
        rhs.adj_y == this->adj_y &&
        rhs.grad_x == this->grad_x &&
        rhs.grad_y == this->grad_y &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchMatMulV2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchMatMulV2", odsAttrs.getContext());
  }

  BatchMatMulV2OpGenericAdaptorBase(BatchMatMulV2Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getAdjXAttr();
  bool getAdjX();
  ::mlir::BoolAttr getAdjYAttr();
  bool getAdjY();
  ::mlir::BoolAttr getGradXAttr();
  bool getGradX();
  ::mlir::BoolAttr getGradYAttr();
  bool getGradY();
};
} // namespace detail
template <typename RangeT>
class BatchMatMulV2OpGenericAdaptor : public detail::BatchMatMulV2OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchMatMulV2OpGenericAdaptorBase;
public:
  BatchMatMulV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchMatMulV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchMatMulV2OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchMatMulV2OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchMatMulV2OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchMatMulV2OpGenericAdaptor(RangeT values, const BatchMatMulV2OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchMatMulV2Op, typename = std::enable_if_t<std::is_same_v<LateInst, BatchMatMulV2Op>>>
  BatchMatMulV2OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchMatMulV2OpAdaptor : public BatchMatMulV2OpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchMatMulV2OpGenericAdaptor::BatchMatMulV2OpGenericAdaptor;
  BatchMatMulV2OpAdaptor(BatchMatMulV2Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchMatMulV2Op : public ::mlir::Op<BatchMatMulV2Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::TF::SameOperandsAndResultElementTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchMatMulV2OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchMatMulV2OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("adj_x"), ::llvm::StringRef("adj_y"), ::llvm::StringRef("grad_x"), ::llvm::StringRef("grad_y")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAdjXAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAdjXAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAdjYAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAdjYAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getGradXAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getGradXAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getGradYAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getGradYAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchMatMulV2");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getAdjXAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().adj_x);
  }

  bool getAdjX();
  ::mlir::BoolAttr getAdjYAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().adj_y);
  }

  bool getAdjY();
  ::mlir::BoolAttr getGradXAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().grad_x);
  }

  bool getGradX();
  ::mlir::BoolAttr getGradYAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().grad_y);
  }

  bool getGradY();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setAdjXAttr(::mlir::BoolAttr attr) {
    getProperties().adj_x = attr;
  }

  void setAdjX(::std::optional<bool> attrValue);
  void setAdjYAttr(::mlir::BoolAttr attr) {
    getProperties().adj_y = attr;
  }

  void setAdjY(::std::optional<bool> attrValue);
  void setGradXAttr(::mlir::BoolAttr attr) {
    getProperties().grad_x = attr;
  }

  void setGradX(::std::optional<bool> attrValue);
  void setGradYAttr(::mlir::BoolAttr attr) {
    getProperties().grad_y = attr;
  }

  void setGradY(::std::optional<bool> attrValue);
  ::mlir::Attribute removeAdjXAttr() {
      auto attr = getProperties().adj_x;
      getProperties().adj_x = {};
      return attr;
  }

  ::mlir::Attribute removeAdjYAttr() {
      auto attr = getProperties().adj_y;
      getProperties().adj_y = {};
      return attr;
  }

  ::mlir::Attribute removeGradXAttr() {
      auto attr = getProperties().grad_x;
      getProperties().grad_x = {};
      return attr;
  }

  ::mlir::Attribute removeGradYAttr() {
      auto attr = getProperties().grad_y;
      getProperties().grad_y = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr adj_x, /*optional*/::mlir::BoolAttr adj_y = nullptr, /*optional*/::mlir::BoolAttr grad_x = nullptr, /*optional*/::mlir::BoolAttr grad_y = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr adj_x, /*optional*/::mlir::BoolAttr adj_y = nullptr, /*optional*/::mlir::BoolAttr grad_x = nullptr, /*optional*/::mlir::BoolAttr grad_y = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x, ::mlir::Value y, /*optional*/bool adj_x = false, /*optional*/bool adj_y = false, /*optional*/bool grad_x = false, /*optional*/bool grad_y = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/bool adj_x = false, /*optional*/bool adj_y = false, /*optional*/bool grad_x = false, /*optional*/bool grad_y = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchMatMulV2Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchMatMulV3Op declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchMatMulV3OpGenericAdaptorBase {
public:
  struct Properties {
    using adj_xTy = ::mlir::BoolAttr;
    adj_xTy adj_x;

    auto getAdjX() const {
      auto &propStorage = this->adj_x;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAdjX(const ::mlir::BoolAttr &propValue) {
      this->adj_x = propValue;
    }
    using adj_yTy = ::mlir::BoolAttr;
    adj_yTy adj_y;

    auto getAdjY() const {
      auto &propStorage = this->adj_y;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setAdjY(const ::mlir::BoolAttr &propValue) {
      this->adj_y = propValue;
    }
    using grad_xTy = ::mlir::BoolAttr;
    grad_xTy grad_x;

    auto getGradX() const {
      auto &propStorage = this->grad_x;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setGradX(const ::mlir::BoolAttr &propValue) {
      this->grad_x = propValue;
    }
    using grad_yTy = ::mlir::BoolAttr;
    grad_yTy grad_y;

    auto getGradY() const {
      auto &propStorage = this->grad_y;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setGradY(const ::mlir::BoolAttr &propValue) {
      this->grad_y = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.adj_x == this->adj_x &&
        rhs.adj_y == this->adj_y &&
        rhs.grad_x == this->grad_x &&
        rhs.grad_y == this->grad_y &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchMatMulV3OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchMatMulV3", odsAttrs.getContext());
  }

  BatchMatMulV3OpGenericAdaptorBase(BatchMatMulV3Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getAdjXAttr();
  bool getAdjX();
  ::mlir::BoolAttr getAdjYAttr();
  bool getAdjY();
  ::mlir::BoolAttr getGradXAttr();
  bool getGradX();
  ::mlir::BoolAttr getGradYAttr();
  bool getGradY();
};
} // namespace detail
template <typename RangeT>
class BatchMatMulV3OpGenericAdaptor : public detail::BatchMatMulV3OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchMatMulV3OpGenericAdaptorBase;
public:
  BatchMatMulV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchMatMulV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchMatMulV3OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchMatMulV3OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchMatMulV3OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchMatMulV3OpGenericAdaptor(RangeT values, const BatchMatMulV3OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchMatMulV3Op, typename = std::enable_if_t<std::is_same_v<LateInst, BatchMatMulV3Op>>>
  BatchMatMulV3OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getY() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchMatMulV3OpAdaptor : public BatchMatMulV3OpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchMatMulV3OpGenericAdaptor::BatchMatMulV3OpGenericAdaptor;
  BatchMatMulV3OpAdaptor(BatchMatMulV3Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchMatMulV3Op : public ::mlir::Op<BatchMatMulV3Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchMatMulV3OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchMatMulV3OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("Ta"), ::llvm::StringRef("Tb"), ::llvm::StringRef("Tout"), ::llvm::StringRef("adj_x"), ::llvm::StringRef("adj_y"), ::llvm::StringRef("grad_x"), ::llvm::StringRef("grad_y")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTaAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTbAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTbAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getToutAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getToutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getAdjXAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getAdjXAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getAdjYAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getAdjYAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getGradXAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getGradXAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getGradYAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getGradYAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchMatMulV3");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getYMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getAdjXAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().adj_x);
  }

  bool getAdjX();
  ::mlir::BoolAttr getAdjYAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().adj_y);
  }

  bool getAdjY();
  ::mlir::BoolAttr getGradXAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().grad_x);
  }

  bool getGradX();
  ::mlir::BoolAttr getGradYAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().grad_y);
  }

  bool getGradY();
  ::mlir::Type getTa();
  ::mlir::Type getTb();
  ::mlir::Type getTout();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setAdjXAttr(::mlir::BoolAttr attr) {
    getProperties().adj_x = attr;
  }

  void setAdjX(::std::optional<bool> attrValue);
  void setAdjYAttr(::mlir::BoolAttr attr) {
    getProperties().adj_y = attr;
  }

  void setAdjY(::std::optional<bool> attrValue);
  void setGradXAttr(::mlir::BoolAttr attr) {
    getProperties().grad_x = attr;
  }

  void setGradX(::std::optional<bool> attrValue);
  void setGradYAttr(::mlir::BoolAttr attr) {
    getProperties().grad_y = attr;
  }

  void setGradY(::std::optional<bool> attrValue);
  ::mlir::Attribute removeAdjXAttr() {
      auto attr = getProperties().adj_x;
      getProperties().adj_x = {};
      return attr;
  }

  ::mlir::Attribute removeAdjYAttr() {
      auto attr = getProperties().adj_y;
      getProperties().adj_y = {};
      return attr;
  }

  ::mlir::Attribute removeGradXAttr() {
      auto attr = getProperties().grad_x;
      getProperties().grad_x = {};
      return attr;
  }

  ::mlir::Attribute removeGradYAttr() {
      auto attr = getProperties().grad_y;
      getProperties().grad_y = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr adj_x, /*optional*/::mlir::BoolAttr adj_y = nullptr, /*optional*/::mlir::BoolAttr grad_x = nullptr, /*optional*/::mlir::BoolAttr grad_y = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/::mlir::BoolAttr adj_x, /*optional*/::mlir::BoolAttr adj_y = nullptr, /*optional*/::mlir::BoolAttr grad_x = nullptr, /*optional*/::mlir::BoolAttr grad_y = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value x, ::mlir::Value y, /*optional*/bool adj_x = false, /*optional*/bool adj_y = false, /*optional*/bool grad_x = false, /*optional*/bool grad_y = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value y, /*optional*/bool adj_x = false, /*optional*/bool adj_y = false, /*optional*/bool grad_x = false, /*optional*/bool grad_y = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchMatMulV3Op)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchNormWithGlobalNormalizationOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchNormWithGlobalNormalizationOpGenericAdaptorBase {
public:
  struct Properties {
    using scale_after_normalizationTy = ::mlir::BoolAttr;
    scale_after_normalizationTy scale_after_normalization;

    auto getScaleAfterNormalization() const {
      auto &propStorage = this->scale_after_normalization;
      return ::llvm::cast<::mlir::BoolAttr>(propStorage);
    }
    void setScaleAfterNormalization(const ::mlir::BoolAttr &propValue) {
      this->scale_after_normalization = propValue;
    }
    using variance_epsilonTy = ::mlir::FloatAttr;
    variance_epsilonTy variance_epsilon;

    auto getVarianceEpsilon() const {
      auto &propStorage = this->variance_epsilon;
      return ::llvm::cast<::mlir::FloatAttr>(propStorage);
    }
    void setVarianceEpsilon(const ::mlir::FloatAttr &propValue) {
      this->variance_epsilon = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scale_after_normalization == this->scale_after_normalization &&
        rhs.variance_epsilon == this->variance_epsilon &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchNormWithGlobalNormalizationOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchNormWithGlobalNormalization", odsAttrs.getContext());
  }

  BatchNormWithGlobalNormalizationOpGenericAdaptorBase(BatchNormWithGlobalNormalizationOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FloatAttr getVarianceEpsilonAttr() {
    auto attr = ::llvm::cast<::mlir::FloatAttr>(getProperties().variance_epsilon);
    return attr;
  }

  ::llvm::APFloat getVarianceEpsilon();
  ::mlir::BoolAttr getScaleAfterNormalizationAttr() {
    auto attr = ::llvm::cast<::mlir::BoolAttr>(getProperties().scale_after_normalization);
    return attr;
  }

  bool getScaleAfterNormalization();
};
} // namespace detail
template <typename RangeT>
class BatchNormWithGlobalNormalizationOpGenericAdaptor : public detail::BatchNormWithGlobalNormalizationOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchNormWithGlobalNormalizationOpGenericAdaptorBase;
public:
  BatchNormWithGlobalNormalizationOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchNormWithGlobalNormalizationOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchNormWithGlobalNormalizationOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchNormWithGlobalNormalizationOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchNormWithGlobalNormalizationOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchNormWithGlobalNormalizationOpGenericAdaptor(RangeT values, const BatchNormWithGlobalNormalizationOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchNormWithGlobalNormalizationOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchNormWithGlobalNormalizationOp>>>
  BatchNormWithGlobalNormalizationOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getM() {
    return (*getODSOperands(1).begin());
  }

  ValueT getV() {
    return (*getODSOperands(2).begin());
  }

  ValueT getBeta() {
    return (*getODSOperands(3).begin());
  }

  ValueT getGamma() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchNormWithGlobalNormalizationOpAdaptor : public BatchNormWithGlobalNormalizationOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchNormWithGlobalNormalizationOpGenericAdaptor::BatchNormWithGlobalNormalizationOpGenericAdaptor;
  BatchNormWithGlobalNormalizationOpAdaptor(BatchNormWithGlobalNormalizationOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchNormWithGlobalNormalizationOp : public ::mlir::Op<BatchNormWithGlobalNormalizationOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchNormWithGlobalNormalizationOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchNormWithGlobalNormalizationOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("scale_after_normalization"), ::llvm::StringRef("variance_epsilon")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getScaleAfterNormalizationAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getScaleAfterNormalizationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getVarianceEpsilonAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getVarianceEpsilonAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchNormWithGlobalNormalization");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getM() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getV() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getBeta() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getGamma() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getVMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBetaMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getGammaMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FloatAttr getVarianceEpsilonAttr() {
    return ::llvm::cast<::mlir::FloatAttr>(getProperties().variance_epsilon);
  }

  ::llvm::APFloat getVarianceEpsilon();
  ::mlir::BoolAttr getScaleAfterNormalizationAttr() {
    return ::llvm::cast<::mlir::BoolAttr>(getProperties().scale_after_normalization);
  }

  bool getScaleAfterNormalization();
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setVarianceEpsilonAttr(::mlir::FloatAttr attr) {
    getProperties().variance_epsilon = attr;
  }

  void setVarianceEpsilon(::llvm::APFloat attrValue);
  void setScaleAfterNormalizationAttr(::mlir::BoolAttr attr) {
    getProperties().scale_after_normalization = attr;
  }

  void setScaleAfterNormalization(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value x, ::mlir::Value m, ::mlir::Value v, ::mlir::Value beta, ::mlir::Value gamma, ::mlir::FloatAttr variance_epsilon, ::mlir::BoolAttr scale_after_normalization);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value m, ::mlir::Value v, ::mlir::Value beta, ::mlir::Value gamma, ::mlir::FloatAttr variance_epsilon, ::mlir::BoolAttr scale_after_normalization);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value x, ::mlir::Value m, ::mlir::Value v, ::mlir::Value beta, ::mlir::Value gamma, ::llvm::APFloat variance_epsilon, bool scale_after_normalization);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value m, ::mlir::Value v, ::mlir::Value beta, ::mlir::Value gamma, ::llvm::APFloat variance_epsilon, bool scale_after_normalization);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchNormWithGlobalNormalizationOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchToSpaceNDOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchToSpaceNDOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchToSpaceNDOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchToSpaceND", odsAttrs.getContext());
  }

  BatchToSpaceNDOpGenericAdaptorBase(BatchToSpaceNDOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BatchToSpaceNDOpGenericAdaptor : public detail::BatchToSpaceNDOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchToSpaceNDOpGenericAdaptorBase;
public:
  BatchToSpaceNDOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchToSpaceNDOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchToSpaceNDOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchToSpaceNDOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchToSpaceNDOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchToSpaceNDOpGenericAdaptor(RangeT values, const BatchToSpaceNDOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchToSpaceNDOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchToSpaceNDOp>>>
  BatchToSpaceNDOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBlockShape() {
    return (*getODSOperands(1).begin());
  }

  ValueT getCrops() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchToSpaceNDOpAdaptor : public BatchToSpaceNDOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchToSpaceNDOpGenericAdaptor::BatchToSpaceNDOpGenericAdaptor;
  BatchToSpaceNDOpAdaptor(BatchToSpaceNDOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchToSpaceNDOp : public ::mlir::Op<BatchToSpaceNDOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchToSpaceNDOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchToSpaceNDOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tblock_shape"), ::llvm::StringRef("Tcrops")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTblockShapeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTblockShapeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTcropsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTcropsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchToSpaceND");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getBlockShape() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getCrops() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBlockShapeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCropsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  ::mlir::Type getTblockShape();
  ::mlir::Type getTcrops();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value block_shape, ::mlir::Value crops);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value block_shape, ::mlir::Value crops);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchToSpaceNDOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BatchToSpaceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BatchToSpaceOpGenericAdaptorBase {
public:
  struct Properties {
    using block_sizeTy = ::mlir::IntegerAttr;
    block_sizeTy block_size;

    auto getBlockSize() const {
      auto &propStorage = this->block_size;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->block_size = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.block_size == this->block_size &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BatchToSpaceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BatchToSpace", odsAttrs.getContext());
  }

  BatchToSpaceOpGenericAdaptorBase(BatchToSpaceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().block_size);
    return attr;
  }

  uint64_t getBlockSize();
};
} // namespace detail
template <typename RangeT>
class BatchToSpaceOpGenericAdaptor : public detail::BatchToSpaceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BatchToSpaceOpGenericAdaptorBase;
public:
  BatchToSpaceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BatchToSpaceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BatchToSpaceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BatchToSpaceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BatchToSpaceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BatchToSpaceOpGenericAdaptor(RangeT values, const BatchToSpaceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BatchToSpaceOp, typename = std::enable_if_t<std::is_same_v<LateInst, BatchToSpaceOp>>>
  BatchToSpaceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getCrops() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BatchToSpaceOpAdaptor : public BatchToSpaceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BatchToSpaceOpGenericAdaptor::BatchToSpaceOpGenericAdaptor;
  BatchToSpaceOpAdaptor(BatchToSpaceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BatchToSpaceOp : public ::mlir::Op<BatchToSpaceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BatchToSpaceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BatchToSpaceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T"), ::llvm::StringRef("Tidx"), ::llvm::StringRef("block_size")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTidxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTidxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BatchToSpace");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getCrops() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCropsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().block_size);
  }

  uint64_t getBlockSize();
  ::mlir::Type getT();
  ::mlir::Type getTidx();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().block_size = attr;
  }

  void setBlockSize(uint64_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value crops, ::mlir::IntegerAttr block_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value crops, ::mlir::IntegerAttr block_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::Value crops, uint64_t block_size);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value crops, uint64_t block_size);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BatchToSpaceOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BesselI0eOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BesselI0eOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BesselI0eOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BesselI0e", odsAttrs.getContext());
  }

  BesselI0eOpGenericAdaptorBase(BesselI0eOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BesselI0eOpGenericAdaptor : public detail::BesselI0eOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BesselI0eOpGenericAdaptorBase;
public:
  BesselI0eOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BesselI0eOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BesselI0eOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BesselI0eOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BesselI0eOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BesselI0eOpGenericAdaptor(RangeT values, const BesselI0eOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BesselI0eOp, typename = std::enable_if_t<std::is_same_v<LateInst, BesselI0eOp>>>
  BesselI0eOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BesselI0eOpAdaptor : public BesselI0eOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BesselI0eOpGenericAdaptor::BesselI0eOpGenericAdaptor;
  BesselI0eOpAdaptor(BesselI0eOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BesselI0eOp : public ::mlir::Op<BesselI0eOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BesselI0eOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BesselI0eOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("T")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tf.BesselI0e");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getY() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  ::mlir::Type getT();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type y, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult inferReturnTypeComponents(::mlir::MLIRContext*context, ::std::optional<::mlir::Location> location, ::mlir::ValueShapeRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::ShapedTypeComponents>&inferredReturnShapes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static bool isCompatibleReturnTypes(TypeRange inferred, TypeRange actual) {
    return ArraysAreCastCompatible(inferred, actual);
  }
};
} // namespace TF
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::TF::BesselI0eOp)

namespace mlir {
namespace TF {

//===----------------------------------------------------------------------===//
// ::mlir::TF::BesselI1eOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BesselI1eOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BesselI1eOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tf.BesselI1e", odsAttrs.getContext());
  }

  BesselI1eOpGenericAdaptorBase(BesselI1eOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class BesselI1eOpGenericAdaptor : public detail::BesselI1eOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BesselI1eOpGenericAdaptorBase;
public:
  BesselI1eOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BesselI1eOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BesselI1eOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BesselI1eOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BesselI1eOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BesselI1eOpGenericAdaptor(RangeT values, const BesselI1eOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BesselI1eOp, typename = std::enable_if_t<std::is_same_v<LateInst, BesselI1eOp>>>
  BesselI1eOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BesselI1eOpAdaptor : public BesselI1eOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BesselI1eOpGenericAdaptor::BesselI1eOpGenericAdaptor;
  BesselI1eOpAdaptor(BesselI1eOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BesselI1eOp : public ::mlir::Op<BesselI1eOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::TensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait, ::mlir::InferShapedTypeOpInterface::Trait, ::mlir::OpTrait::InferTensorType, ::mlir::OpTrait::TF::SameOperandsAndResultTypeResolveRef, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BesselI1eOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BesselI1eOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdapto