// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES.
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCUDACXX___ITERATOR_EMPTY_H
#define _LIBCUDACXX___ITERATOR_EMPTY_H

#include <cuda/std/detail/__config>

#if defined(_CCCL_IMPLICIT_SYSTEM_HEADER_GCC)
#  pragma GCC system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_CLANG)
#  pragma clang system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_MSVC)
#  pragma system_header
#endif // no system header

#include <cuda/std/cstddef>
#include <cuda/std/initializer_list>

_LIBCUDACXX_BEGIN_NAMESPACE_STD

#if _CCCL_STD_VER > 2011

template <class _Cont>
_CCCL_NODISCARD _LIBCUDACXX_HIDE_FROM_ABI constexpr auto
empty(const _Cont& __c) noexcept(noexcept(__c.empty())) -> decltype(__c.empty())
{
  return __c.empty();
}

template <class _Tp, size_t _Sz>
_CCCL_NODISCARD _LIBCUDACXX_HIDE_FROM_ABI constexpr bool empty(const _Tp (&)[_Sz]) noexcept
{
  return false;
}

template <class _Ep>
_CCCL_NODISCARD _LIBCUDACXX_HIDE_FROM_ABI constexpr bool empty(initializer_list<_Ep> __il) noexcept
{
  return __il.size() == 0;
}

#endif // _CCCL_STD_VER > 2017

_LIBCUDACXX_END_NAMESPACE_STD

#endif // _LIBCUDACXX___ITERATOR_EMPTY_H
